/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.UccSkuBatchAddRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuBatchAddRecordAbilityReqBO;
import com.tydic.dyc.agr.service.domainservice.AgrFlowCancelService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrFlowCancelReqBo;
import com.tydic.dyc.agr.service.domainservice.bo.AgrFlowCancelRspBo;
import com.tydic.dyc.atom.busicommon.api.DycUocGemiSendMessageAtomFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocSalOrdeDetailQryFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocSalOrdeDetailQryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocSalOrdeDetailQryFuncRspBO;
import com.tydic.dyc.atom.common.api.DycBusiProcessDeleteFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessDeleteFuncReqBO;
import com.tydic.dyc.atom.estore.api.DycUocEstoreCancelSaleOrderFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreCancelSaleOrderFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCandidatesBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocTaskBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.common.api.DycFlowCancelService;
import com.tydic.dyc.common.bo.DyCommonReceiverBo;
import com.tydic.dyc.common.bo.DycFlowCancelReqBO;
import com.tydic.dyc.common.bo.DycFlowCancelRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.common.UocQrySaleOrderListByApprovalService;
import com.tydic.dyc.oc.service.common.bo.UocQrySaleOrderListByApprovalReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQrySaleOrderListByApprovalRspBo;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderAndStopProcessService;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderService;
import com.tydic.dyc.oc.service.domainservice.UocProcInsTerminateDomainService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateDomainReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoReqBo;
import com.tydic.fsc.common.ability.api.FscFlowCancelAbilityService;
import com.tydic.fsc.common.ability.bo.FscFlowCancelReqBO;
import com.tydic.fsc.common.ability.bo.FscFlowCancelRspBO;
import com.tydic.osworkflow.ability.OsworkflowRuntimeProcInstHandleAbilityService;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleReqBO;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleRespBO;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.api.DycFlowCancelService"})
public class DycFlowCancelServiceImpl
implements DycFlowCancelService {
    private static final Logger log = LoggerFactory.getLogger(DycFlowCancelServiceImpl.class);
    private static final String CANCEL_DEC = "\u5ba1\u6279\u64a4\u9500\uff0c\u8ba2\u5355\u81ea\u52a8\u53d6\u6d88";
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private AgrFlowCancelService agrFlowCancelService;
    @Autowired
    private UccSkuBatchAddRecordAbilityService uccSkuBatchAddRecordAbilityService;
    @Autowired
    private UmcSendRevokeTodoService umcSendRevokeTodoService;
    @Autowired
    private DycUocGemiSendMessageAtomFunction dycUocGemiSendMessageAtomFunction;
    @Autowired
    private OsworkflowRuntimeProcInstHandleAbilityService osworkflowRuntimeProcInstHandleAbilityService;
    @Autowired
    private UocQrySaleOrderListByApprovalService uocQrySaleOrderListByApprovalService;
    @Autowired
    private UocCancelSaleOrderAndStopProcessService uocCancelSaleOrderAndStopProcessService;
    @Autowired
    private DycUocSalOrdeDetailQryFunction dycUocSalOrdeDetailQryFunction;
    @Autowired
    private DycUocEstoreCancelSaleOrderFunction dycUocEstoreCancelSaleOrderFunction;
    @Autowired
    private UocCancelSaleOrderService uocCancelSaleOrderService;
    @Autowired
    private DycBusiProcessDeleteFunction dycBusiProcessDeleteFunction;
    @Autowired
    private UocProcInsTerminateDomainService uocProcInsTerminateDomainService;
    @Autowired
    private FscFlowCancelAbilityService fscFlowCancelAbilityService;
    @Value(value="${releaseBudget:true}")
    private boolean releaseBudget;

    @Override
    @PostMapping(value={"cancelFlow"})
    public DycFlowCancelRspBO cancelFlow(@RequestBody DycFlowCancelReqBO dycFlowCancelReqBO) {
        this.validParam(dycFlowCancelReqBO);
        EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
        eacRuInstAbilityReqBO.setApproveInstId(dycFlowCancelReqBO.getAuditProcInstId());
        log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5ba1\u6279\u6d41\u7ec8\u6b62\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacRuInstAbilityReqBO));
        EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5ba1\u6279\u6d41\u7ec8\u6b62\u670d\u52a1\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacRuInstAbilityRspBO));
        if (!"0000".equals(eacRuInstAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u56de\u9000\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacRuInstAbilityRspBO.getRespCode() + "\u3011," + eacRuInstAbilityRspBO.getRespDesc());
        }
        if (!StringUtils.isEmpty((Object)dycFlowCancelReqBO.getBusiProcInstId())) {
            DeleteProcInstSingleReqBO deleteProcInstSingleReqBO = new DeleteProcInstSingleReqBO();
            deleteProcInstSingleReqBO.setProcInstId(dycFlowCancelReqBO.getBusiProcInstId());
            log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u4e1a\u52a1\u6d41\u7ec8\u6b62\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)deleteProcInstSingleReqBO));
            DeleteProcInstSingleRespBO deleteProcInstSingleRespBO = this.osworkflowRuntimeProcInstHandleAbilityService.deleteProcInstSingle(deleteProcInstSingleReqBO);
            log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u4e1a\u52a1\u6d41\u7ec8\u6b62\u670d\u52a1\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)deleteProcInstSingleRespBO));
        }
        List<DycUocTaskBO> cancelTaskInfos = this.invokeBusiCenter(dycFlowCancelReqBO);
        this.recallTodo(dycFlowCancelReqBO, cancelTaskInfos);
        this.sendMessage(cancelTaskInfos, dycFlowCancelReqBO);
        return new DycFlowCancelRspBO();
    }

    private void sendMessage(List<DycUocTaskBO> cancelTaskInfos, DycFlowCancelReqBO dycFlowCancelReqBO) {
        if (!CollectionUtils.isEmpty(cancelTaskInfos)) {
            ArrayList<DyCommonReceiverBo> receiverIdList = new ArrayList<DyCommonReceiverBo>();
            for (DycUocTaskBO DycUocTaskBO2 : cancelTaskInfos) {
                if (CollectionUtils.isEmpty((Collection)DycUocTaskBO2.getCandidates())) continue;
                for (DycUocCandidatesBO dycUocCandidatesBO : DycUocTaskBO2.getCandidates()) {
                    DyCommonReceiverBo bo = new DyCommonReceiverBo();
                    bo.setReceiverId(dycUocCandidatesBO.getCandidateId());
                    bo.setReceiverName(dycUocCandidatesBO.getCandidateName());
                    receiverIdList.add(bo);
                }
            }
            if (!CollectionUtils.isEmpty(receiverIdList)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("taskCode", "audit_proc_cancel");
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("objCode", dycFlowCancelReqBO.getObjCode());
                map.put("data", dataMap);
                map.put("sendId", dycFlowCancelReqBO.getUserId());
                map.put("sendName", dycFlowCancelReqBO.getName());
                map.put("receiverIdList", JSON.toJSONString(receiverIdList));
                try {
                    this.dycUocGemiSendMessageAtomFunction.sendMessage(map);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u901a\u77e5\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private void recallTodo(DycFlowCancelReqBO dycFlowCancelReqBO, List<DycUocTaskBO> cancelTaskInfos) {
        if (!CollectionUtils.isEmpty(cancelTaskInfos)) {
            for (DycUocTaskBO dycUocTaskBO : cancelTaskInfos) {
                if (dycUocTaskBO.getFinish() == null || !dycUocTaskBO.getFinish().equals(false)) continue;
                try {
                    UmcSendRevokeTodoReqBo umcSendRevokeTodoReqBo = new UmcSendRevokeTodoReqBo();
                    umcSendRevokeTodoReqBo.setBusiId(dycUocTaskBO.getTaskId());
                    umcSendRevokeTodoReqBo.setOperUserId("" + dycFlowCancelReqBO.getUserId());
                    umcSendRevokeTodoReqBo.setOperUserName(dycFlowCancelReqBO.getName());
                    this.umcSendRevokeTodoService.revokeTodo(umcSendRevokeTodoReqBo);
                }
                catch (Exception e) {
                    log.error("\u64a4\u56de\u5f85\u529e\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private List<DycUocTaskBO> invokeBusiCenter(DycFlowCancelReqBO dycFlowCancelReqBO) {
        List<Object> cancelTaskInfos = new ArrayList<DycUocTaskBO>();
        if (dycFlowCancelReqBO.getCenter().equals("AGR")) {
            AgrFlowCancelReqBo agrFlowCancelReqBo = (AgrFlowCancelReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)dycFlowCancelReqBO)), AgrFlowCancelReqBo.class);
            AgrFlowCancelRspBo agrFlowCancelRspBo = this.agrFlowCancelService.cancelFlow(agrFlowCancelReqBo);
            cancelTaskInfos = JSONArray.parseArray((String)JSON.toJSONString((Object)agrFlowCancelRspBo.getCancelTaskInfos()), DycUocTaskBO.class);
        }
        if (dycFlowCancelReqBO.getCenter().equals("UCC")) {
            this.skuRevoke(dycFlowCancelReqBO);
        }
        if (dycFlowCancelReqBO.getCenter().equals("UOC")) {
            this.cancelOrderList(dycFlowCancelReqBO);
        }
        if (dycFlowCancelReqBO.getCenter().equals("FSC")) {
            FscFlowCancelReqBO fscFlowCancelReqBO = (FscFlowCancelReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)dycFlowCancelReqBO)), FscFlowCancelReqBO.class);
            FscFlowCancelRspBO fscFlowCancelRspBO = this.fscFlowCancelAbilityService.cancelFlow(fscFlowCancelReqBO);
            cancelTaskInfos = JSONArray.parseArray((String)JSON.toJSONString((Object)fscFlowCancelRspBO.getCancelTaskInfos()), DycUocTaskBO.class);
        }
        return cancelTaskInfos;
    }

    private void cancelOrderList(DycFlowCancelReqBO dycFlowCancelReqBO) {
        UocQrySaleOrderListByApprovalReqBo orderListByApprovalReqBo = new UocQrySaleOrderListByApprovalReqBo();
        orderListByApprovalReqBo.setOrderId(dycFlowCancelReqBO.getOrderId());
        orderListByApprovalReqBo.setAuditOrderId(String.valueOf(dycFlowCancelReqBO.getObjId()));
        UocQrySaleOrderListByApprovalRspBo orderListByApprovalRspBo = this.uocQrySaleOrderListByApprovalService.qrySaleOrderList(orderListByApprovalReqBo);
        List uocSaleOrderBOS = orderListByApprovalRspBo.getUocSaleOrderList();
        uocSaleOrderBOS.forEach(obj -> {
            DycUocSalOrdeDetailQryFuncRspBO detailQryFuncRspBO = this.qrySalOrderDetail((UocSaleOrderBO)obj);
            this.cancelEsPreOrder(detailQryFuncRspBO);
            this.cancelSaleOrder(detailQryFuncRspBO, dycFlowCancelReqBO);
            DycBusiProcessDeleteFuncReqBO processDeleteFuncReqBO = new DycBusiProcessDeleteFuncReqBO();
            processDeleteFuncReqBO.setProcInstId(detailQryFuncRspBO.getProcInst().getProcInstId());
            this.dycBusiProcessDeleteFunction.deleteBusiProcess(processDeleteFuncReqBO);
            if (this.releaseBudget) {
                log.info("\u53d6\u6d88\u8ba2\u5355\u91ca\u653e\u9884\u7b97");
            }
            UocProcInsTerminateDomainReqBo uocProcInsTerminateDomainReqBo = new UocProcInsTerminateDomainReqBo();
            uocProcInsTerminateDomainReqBo.setOrderId(detailQryFuncRspBO.getOrderId());
            uocProcInsTerminateDomainReqBo.setObjId(detailQryFuncRspBO.getSaleOrderId());
            uocProcInsTerminateDomainReqBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocProcInsTerminateDomainReqBo.setTraceId(dycFlowCancelReqBO.getTraceId());
            uocProcInsTerminateDomainReqBo.setUserId(dycFlowCancelReqBO.getUserId());
            uocProcInsTerminateDomainReqBo.setName(dycFlowCancelReqBO.getName());
            this.uocProcInsTerminateDomainService.dealProcInsTerminate(uocProcInsTerminateDomainReqBo);
        });
    }

    private DycUocSalOrdeDetailQryFuncRspBO qrySalOrderDetail(UocSaleOrderBO reqBo) {
        DycUocSalOrdeDetailQryFuncReqBO detailQryFuncReqBO = new DycUocSalOrdeDetailQryFuncReqBO();
        detailQryFuncReqBO.setOrderId(Long.valueOf(reqBo.getOrderId()));
        detailQryFuncReqBO.setSaleOrderId(reqBo.getSaleOrderId());
        return this.dycUocSalOrdeDetailQryFunction.qrySalOrderDetail(detailQryFuncReqBO);
    }

    private void cancelSaleOrder(DycUocSalOrdeDetailQryFuncRspBO detailQryFuncRspBO, DycFlowCancelReqBO reqBo) {
        UocCancelSaleOrderServiceReqBo uocCancelSaleOrderServiceReqBo = new UocCancelSaleOrderServiceReqBo();
        uocCancelSaleOrderServiceReqBo.setCancelReason("\u9884\u7b97\u5360\u7528\u5931\u8d25\u81ea\u52a8\u53d6\u6d88\u8ba2\u5355");
        uocCancelSaleOrderServiceReqBo.setOrderId(Long.valueOf(detailQryFuncRspBO.getOrderId()));
        uocCancelSaleOrderServiceReqBo.setSaleOrderId(detailQryFuncRspBO.getSaleOrderId());
        uocCancelSaleOrderServiceReqBo.setTraceId(reqBo.getTraceId());
        uocCancelSaleOrderServiceReqBo.setUserId(reqBo.getUserId());
        uocCancelSaleOrderServiceReqBo.setName(reqBo.getName());
        this.uocCancelSaleOrderService.cancelSaleOrder(uocCancelSaleOrderServiceReqBo);
    }

    private void cancelEsPreOrder(DycUocSalOrdeDetailQryFuncRspBO detailQryFuncRspBO) {
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(detailQryFuncRspBO.getOrderSource())) {
            DycUocEstoreCancelSaleOrderFuncReqBO dycUocEstoreCancelSaleOrderFuncReqBO = new DycUocEstoreCancelSaleOrderFuncReqBO();
            dycUocEstoreCancelSaleOrderFuncReqBO.setSupplierNo(detailQryFuncRspBO.getUocGetSaleOrderDetailServiceRspStakeholderBo().getSupId());
            dycUocEstoreCancelSaleOrderFuncReqBO.setOutOrderId(detailQryFuncRspBO.getSaleOrderNoExt());
            log.info("\u53d6\u6d88\u7535\u5546\u8ba2\u5355\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)dycUocEstoreCancelSaleOrderFuncReqBO));
            this.dycUocEstoreCancelSaleOrderFunction.cancelSaleOrder(dycUocEstoreCancelSaleOrderFuncReqBO);
        }
    }

    private void skuRevoke(DycFlowCancelReqBO dycFlowCancelReqBO) {
        UccSkuBatchAddRecordAbilityReqBO uccSkuBatchAddRecordAbilityReqBO = new UccSkuBatchAddRecordAbilityReqBO();
        uccSkuBatchAddRecordAbilityReqBO.setUserId(dycFlowCancelReqBO.getUserId());
        uccSkuBatchAddRecordAbilityReqBO.setName(dycFlowCancelReqBO.getName());
        uccSkuBatchAddRecordAbilityReqBO.setOrgId(dycFlowCancelReqBO.getOrgId());
        uccSkuBatchAddRecordAbilityReqBO.setOrgName(dycFlowCancelReqBO.getOrgName());
        uccSkuBatchAddRecordAbilityReqBO.setCompanyId(dycFlowCancelReqBO.getCompanyId());
        uccSkuBatchAddRecordAbilityReqBO.setCompanyName(dycFlowCancelReqBO.getCompanyName());
        uccSkuBatchAddRecordAbilityReqBO.setObjType(dycFlowCancelReqBO.getObjType());
        uccSkuBatchAddRecordAbilityReqBO.setDealType(UccConstants.BatchDealType.REVOKE_TASK);
        ArrayList<UccSkuBatchAddRecordBO> uccSkuBatchAddRecordBOS = new ArrayList<UccSkuBatchAddRecordBO>();
        UccSkuBatchAddRecordBO uccSkuBatchAddRecordBO = new UccSkuBatchAddRecordBO();
        uccSkuBatchAddRecordBO.setObjId(dycFlowCancelReqBO.getOrderId());
        uccSkuBatchAddRecordBO.setObjJson(JSON.toJSONString((Object)((Object)dycFlowCancelReqBO)));
        uccSkuBatchAddRecordBOS.add(uccSkuBatchAddRecordBO);
        uccSkuBatchAddRecordAbilityReqBO.setBatchObjList(uccSkuBatchAddRecordBOS);
        this.uccSkuBatchAddRecordAbilityService.addSkuBatchDealRecord(uccSkuBatchAddRecordAbilityReqBO);
    }

    private void validParam(DycFlowCancelReqBO dycFlowCancelReqBO) {
        if (dycFlowCancelReqBO == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)dycFlowCancelReqBO.getOrderId())) {
            throw new BaseBusinessException("0001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)dycFlowCancelReqBO.getObjId())) {
            throw new BaseBusinessException("0001", "objId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)dycFlowCancelReqBO.getAuditProcInstId())) {
            throw new BaseBusinessException("0001", "auditProcInstId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)dycFlowCancelReqBO.getCenter())) {
            throw new BaseBusinessException("0001", "center\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

