/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.role.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.HanyuPinyinHelper;
import com.tydic.dyc.authority.service.role.AuthCreateRoleInfoService;
import com.tydic.dyc.authority.service.role.AuthGetRoleInfoListService;
import com.tydic.dyc.authority.service.role.bo.AuthCreateRoleInfoReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthCreateRoleInfoRspBo;
import com.tydic.dyc.authority.service.role.bo.AuthGetRoleInfoListReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthGetRoleInfoListRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.common.member.role.api.DycAuthCreateRoleInfoService;
import com.tydic.dyc.common.member.role.bo.DycAuthCreateRoleInfoReqBo;
import com.tydic.dyc.common.member.role.bo.DycAuthCreateRoleInfoRspBo;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.role.api.DycAuthCreateRoleInfoService"})
public class DycAuthCreateRoleInfoServiceImpl
implements DycAuthCreateRoleInfoService {
    @Autowired
    private AuthCreateRoleInfoService authCreateRoleInfoService;
    @Autowired
    private AuthGetRoleInfoListService authGetRoleInfoListService;

    @Override
    @PostMapping(value={"createRoleInfo"})
    public DycAuthCreateRoleInfoRspBo createRoleInfo(@RequestBody DycAuthCreateRoleInfoReqBo reqBo) {
        this.checkRoleName(reqBo);
        this.setAuthIdentity(reqBo);
        AuthCreateRoleInfoReqBo authReqBo = (AuthCreateRoleInfoReqBo)JUtil.js((Object)((Object)reqBo), AuthCreateRoleInfoReqBo.class);
        authReqBo.setOrgTreePath(reqBo.getOrgTreePathIn());
        authReqBo.setTenantId(reqBo.getTenantIdIn());
        authReqBo.setCreateOperId(reqBo.getUserIdIn());
        authReqBo.setCreateOperName(reqBo.getCustNameIn());
        Date now = new Date();
        authReqBo.setCreateTime(now);
        authReqBo.setUpdateOperId(reqBo.getUserIdIn());
        authReqBo.setUpdateOperName(reqBo.getCustNameIn());
        authReqBo.setUpdateTime(now);
        AuthCreateRoleInfoRspBo authRspBo = this.authCreateRoleInfoService.createRoleInfo(authReqBo);
        return (DycAuthCreateRoleInfoRspBo)((Object)JUtil.js((Object)authRspBo, DycAuthCreateRoleInfoRspBo.class));
    }

    private void setAuthIdentity(DycAuthCreateRoleInfoReqBo reqBo) {
        String authIdentity = reqBo.getAuthIdentity();
        if (StringUtils.isEmpty((Object)authIdentity)) {
            switch (reqBo.getRoleType()) {
                case "1": {
                    authIdentity = "tenant:" + reqBo.getTenantIdIn() + ":" + HanyuPinyinHelper.getPinyinString((String)reqBo.getRoleName());
                    break;
                }
                case "0": {
                    authIdentity = "manager:" + reqBo.getTenantIdIn() + ":" + HanyuPinyinHelper.getPinyinString((String)reqBo.getRoleName());
                    break;
                }
                case "2": {
                    authIdentity = "business:" + reqBo.getTenantIdIn() + ":" + HanyuPinyinHelper.getPinyinString((String)reqBo.getRoleName());
                    break;
                }
            }
            reqBo.setAuthIdentity(authIdentity);
        } else {
            AuthGetRoleInfoListReqBo listReqBoByAuthIdentity = new AuthGetRoleInfoListReqBo();
            listReqBoByAuthIdentity.setAuthIdentity(authIdentity);
            if (reqBo.getTenantIdIn() == null) {
                AuthGetRoleInfoListRspBo listRspBoByAuthIdentity = this.authGetRoleInfoListService.getroleInfoList(listReqBoByAuthIdentity);
                if (listRspBoByAuthIdentity != null && listRspBoByAuthIdentity.getRows().size() > 0) {
                    throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u6743\u9650\u6807\u5fd7\u91cd\u590d");
                }
            } else {
                listReqBoByAuthIdentity.setTenantId(reqBo.getTenantIdIn());
                AuthGetRoleInfoListRspBo listRspBoByAuthIdentity = this.authGetRoleInfoListService.getroleInfoList(listReqBoByAuthIdentity);
                if (listRspBoByAuthIdentity != null && listRspBoByAuthIdentity.getRows().size() > 0) {
                    throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u6743\u9650\u6807\u5fd7\u91cd\u590d");
                }
            }
        }
    }

    private void checkRoleName(DycAuthCreateRoleInfoReqBo reqBo) {
        AuthGetRoleInfoListReqBo listReqBo = new AuthGetRoleInfoListReqBo();
        listReqBo.setRoleNameExt(reqBo.getRoleName());
        listReqBo.setTenantId(reqBo.getTenantIdIn());
        AuthGetRoleInfoListRspBo listRspBo = this.authGetRoleInfoListService.getroleInfoList(listReqBo);
        if (listRspBo != null && listRspBo.getRows().size() > 0) {
            throw new ZTBusinessException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
    }
}

