/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.user.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.api.DycUmcCreatePlatformUsageFunction;
import com.tydic.dyc.atom.common.api.DycUmcCustSericeUsersAddFunction;
import com.tydic.dyc.atom.common.api.DycUmcCustServiceTenantAddFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycUmcCreatePlatformUsageFuncReqBo;
import com.tydic.dyc.atom.common.bo.DycUmcCustSericeUsersAddFuncReqBo;
import com.tydic.dyc.atom.common.bo.DycUmcCustServiceTenantAddFuncReqBo;
import com.tydic.dyc.atom.common.bo.DycUmcCustServiceUsersFuncBo;
import com.tydic.dyc.atom.common.member.user.api.DycUmcCheckUserExistFunction;
import com.tydic.dyc.atom.common.member.user.bo.DycUmcCheckUserExistFuncReqBo;
import com.tydic.dyc.atom.common.member.user.bo.DycUmcCheckUserExistFuncRspBo;
import com.tydic.dyc.authority.constants.AuthConstant;
import com.tydic.dyc.authority.service.domainservice.AuthEnterpriseUserRegisterService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseRegisterBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthUserRegisterInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgTagRelBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.base.utils.IdUtil;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.base.utils.SaltUtils;
import com.tydic.dyc.common.member.user.api.DycUmcUserOrEnterpriseRegisterService;
import com.tydic.dyc.common.member.user.bo.DycUmcUserOrEnterpriseRegisterReqBo;
import com.tydic.dyc.common.member.user.bo.DycUmcUserOrEnterpriseRegisterRspBo;
import com.tydic.dyc.common.member.vfcode.api.VerifyCodeService;
import com.tydic.dyc.common.member.vfcode.bo.VerifyCodeReqBo;
import com.tydic.dyc.common.member.vfcode.bo.VerifyCodeRspBo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.service.domainservice.UmcEnterpriseUserRegisterService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseRegisterApplyInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseRegisterInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterRspBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcRegisterAccountBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserRegisterApplyInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserRegisterInfoBo;
import com.tydic.dyc.umc.service.enterprise.UmcDycCheckEnterpriseExistService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDycCheckEnterpriseExistReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDycCheckEnterpriseExistRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseContactBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgTagRelBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseContactApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcOrgInfoApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcOrgTagRelApplyBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserTagRelBo;
import com.tydic.dyc.umc.service.userapply.bo.UmcCustInfoApplyBo;
import com.tydic.dyc.umc.service.userapply.bo.UmcUserRoleRelApplyBo;
import com.tydic.dyc.umc.service.userapply.bo.UmcUserTagRelApplyBo;
import com.tydic.osworkflow.ability.OsworkflowWhetherChartAbilityService;
import com.tydic.osworkflow.ability.bo.OsWorkFlowReqBO;
import com.tydic.osworkflow.ability.bo.OsWorkFlowRespBO;
import com.tydic.umc.security.utils.AesUtil;
import com.tydic.umc.security.utils.EncryptUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.user.api.DycUmcUserOrEnterpriseRegisterService"})
public class DycUmcUserOrEnterpriseRegisterServiceImpl
implements DycUmcUserOrEnterpriseRegisterService {
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${CHECK_EMAIL_CODE:false}")
    private Boolean CHECK_EMAIL_CODE;
    @Value(value="${CHECK_MOBILE_CODE:false}")
    private Boolean CHECK_MOBILE_CODE;
    @Autowired
    private DycUmcCheckUserExistFunction dycUmcCheckUserExistFunction;
    @Autowired
    private UmcDycCheckEnterpriseExistService umcDycCheckEnterpriseExistService;
    @Autowired
    private EncryptUtils encryptUtils;
    @Value(value="${register_default_parent_org:305775845729763332}")
    private Long register_default_parent_org;
    @Value(value="${register_default_parent_personal_org:305775845729763333}")
    private Long register_default_parent_personal_org;
    @Value(value="${register_default_enterprise_role:405395039912734721}")
    private String registerDefaultEnterpriseRole;
    @Value(value="${register_default_personal_role:405395039912734722}")
    private String registerDefaultPersonalRole;
    @Value(value="${register_default_role:}")
    private String registerDefaultRoleCommon;
    private static final String personal = "1";
    private static final String org = "2";
    @Value(value="${register_audit_flag:false}")
    private Boolean register_audit_flag;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Value(value="${password_eff:90}")
    private Integer password_eff;
    @Value(value="${SYS_CODE:DYC}")
    private String sys_code;
    @Value(value="${ext.regist.audit.key:supplier_baseinfo_audit}")
    private String extRegistAuditKey;
    @Value(value="${custServiceEnable:false}")
    private boolean custServiceEnable;
    private static final Long DEFAULT_ROLE_ID = 5L;
    @Autowired
    private DycUmcCustSericeUsersAddFunction dycUmcCustSericeUsersAddFunction;
    @Autowired
    private DycUmcCustServiceTenantAddFunction dycUmcCustServiceTenantAddFunction;
    @Autowired
    private DycUmcCreatePlatformUsageFunction dycUmcCreatePlatformUsageFunction;
    @Value(value="${emaiRegisterVfcode:login_vf_code_emaiRegisterVfcode}")
    private String emaiRegisterVfcode;
    @Value(value="${mobileRegistVfcode:login_vf_code_mobileRegistVfcode}")
    private String mobileRegistVfcode;
    @Autowired
    private VerifyCodeService verifyCodeService;
    private static final Long DEFAULT_TANENT_ID = 10000L;
    private static final String CS_USER_TYPE_NORMAL = "1";
    private static final String address = "1";
    private static final String person = "PERSON";
    @Value(value="${default.deliveryCenterId:1}")
    private Long deliveryCenterId;
    @Value(value="${supllier.regist.busiflowkey:supplier_regist}")
    private String supplierRegistBusiFlowKey;
    private static final String NEED_AUDIT_FLAG = "0";
    private static final String NO_AUDIT_FLAG = "1";
    @Autowired
    private DycBusiProcessStartFunction dycBusiProcessStartFunction;
    @Autowired
    private AuthEnterpriseUserRegisterService authEnterpriseUserRegisterService;
    @Autowired
    private UmcEnterpriseUserRegisterService umcEnterpriseUserRegisterService;
    @Autowired
    private OsworkflowWhetherChartAbilityService osworkflowWhetherChartAbilityService;
    private static final Integer ORG_DEEP = 3;
    private static final Long OPER_ID = 1L;
    private static final String OPER_NAME = "admin";
    private static final String CS_LABEL = "label";
    private static final String SUPPLIER_LABEL = "\u4f9b\u5e94\u5546";
    private static final String OPERATION_LABEL = "\u8fd0\u8425\u5355\u4f4d";

    @Override
    @PostMapping(value={"registerAccount"})
    public DycUmcUserOrEnterpriseRegisterRspBo registerAccount(@RequestBody DycUmcUserOrEnterpriseRegisterReqBo reqBo) {
        this.checkInitReq(reqBo);
        this.codeCheck(reqBo);
        this.checkUserInfo(reqBo);
        if (null == reqBo.getTenantId()) {
            reqBo.setTenantId(DEFAULT_TANENT_ID);
        }
        this.checkOrgExist(reqBo);
        String encrypt = this.encryptUtils.encryptByType(AesUtil.decryptStr((String)reqBo.getPasswd(), (String)this.ORIGINAL_KEY), this.encryptType);
        String salt = SaltUtils.getSerialNo((int)8);
        String pwd = this.encryptUtils.encryptByType(encrypt + salt, this.encryptType);
        boolean auditFlowExists = this.qryAuditFlow();
        AuthEnterpriseUserRegisterRspBo authEnterpriseUserRegisterRspBo = this.createOrgUserAuth(reqBo, pwd, salt, auditFlowExists);
        Long applyId = IdUtil.nextId();
        this.createEnterpriserUserInfo(reqBo, authEnterpriseUserRegisterRspBo.getOrgInfoBo(), authEnterpriseUserRegisterRspBo.getUserInfoBo(), applyId, pwd, auditFlowExists);
        this.startBusiProcess(applyId, authEnterpriseUserRegisterRspBo.getUserInfoBo(), authEnterpriseUserRegisterRspBo.getOrgInfoBo(), auditFlowExists);
        if (!auditFlowExists) {
            this.sendPlatformUsage(authEnterpriseUserRegisterRspBo.getUserInfoBo(), authEnterpriseUserRegisterRspBo.getOrgInfoBo());
        }
        this.syncCs(reqBo, authEnterpriseUserRegisterRspBo.getOrgInfoBo(), authEnterpriseUserRegisterRspBo.getUserInfoBo().getUserId());
        return this.getRsp(reqBo, authEnterpriseUserRegisterRspBo, auditFlowExists);
    }

    private void startBusiProcess(Long applyId, AuthUserInfoBo userInfoBo, AuthOrgInfoBo orgInfoBo, boolean auditFlowExists) {
        DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
        dycBusiProcessStartFuncReqBO.setProcDefKey(this.supplierRegistBusiFlowKey);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("applyId", applyId);
        variables.put("orderId", applyId);
        variables.put("auditObjId", applyId);
        variables.put("userId", userInfoBo.getUserId());
        variables.put("userName", userInfoBo.getCustInfo().getCustName());
        variables.put("name", userInfoBo.getCustInfo().getCustName());
        variables.put("orgName", orgInfoBo.getOrgName());
        variables.put("auditStartFlag", 1);
        if (auditFlowExists) {
            variables.put("auditFlag", 1);
        } else {
            variables.put("auditFlag", 0);
        }
        variables.put("auditCompleteFlag", 1);
        dycBusiProcessStartFuncReqBO.setVariables(variables);
        dycBusiProcessStartFuncReqBO.setSysCode(this.sys_code);
        dycBusiProcessStartFuncReqBO.setPartitonKey(String.valueOf(applyId));
        DycBusiProcessStartFuncRspBO dycBusiProcessStartFuncRspBO = this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
        if (!"0000".equals(dycBusiProcessStartFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u6ce8\u518c\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + dycBusiProcessStartFuncRspBO.getRespDesc());
        }
    }

    private DycUmcUserOrEnterpriseRegisterRspBo getRsp(DycUmcUserOrEnterpriseRegisterReqBo reqBo, AuthEnterpriseUserRegisterRspBo authCreateUserInfoRspBo, boolean auditFlowExists) {
        DycUmcUserOrEnterpriseRegisterRspBo rspBo = new DycUmcUserOrEnterpriseRegisterRspBo();
        rspBo.setUserId(authCreateUserInfoRspBo.getUserInfoBo().getUserId());
        rspBo.setCustId(authCreateUserInfoRspBo.getUserInfoBo().getCustId());
        rspBo.setOrgId(authCreateUserInfoRspBo.getUserInfoBo().getOrgId());
        rspBo.setRegAccount(reqBo.getRegAccount());
        rspBo.setAuditStatus("1");
        if (auditFlowExists) {
            rspBo.setAuditStatus(NEED_AUDIT_FLAG);
        }
        return rspBo;
    }

    public void checkInitReq(DycUmcUserOrEnterpriseRegisterReqBo reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRegisterType())) {
            throw new ZTBusinessException("\u6ce8\u518c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRegAccount())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPasswd())) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getConfirmPasswd())) {
            throw new ZTBusinessException("\u786e\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getMemName2())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgNameWeb())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAliasWeb())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgCodeWeb())) {
            throw new ZTBusinessException("\u7ec4\u7ec7\u673a\u6784\u7b80\u79f0\u9996\u5b57\u6bcd\u7f29\u5199\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getCertNo())) {
            throw new ZTBusinessException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getTradeCapacity())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u8d38\u6613\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getTradeType())) {
            throw new ZTBusinessException("\u884c\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getCertNo())) {
            throw new ZTBusinessException("\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRegEmail())) {
            throw new ZTBusinessException("\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(reqBo.getRegisterType()) && StringUtils.isBlank((CharSequence)reqBo.getEmailCheck())) {
            throw new ZTBusinessException("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRegMobile())) {
            throw new ZTBusinessException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getSmsCheck())) {
            throw new ZTBusinessException("\u624b\u673a\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void checkUserInfo(DycUmcUserOrEnterpriseRegisterReqBo reqBo) {
        if (!AesUtil.decryptStr((String)reqBo.getPasswd(), (String)this.ORIGINAL_KEY).equals(AesUtil.decryptStr((String)reqBo.getConfirmPasswd(), (String)this.ORIGINAL_KEY))) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u4e00\u81f4");
        }
        if (!StringUtils.isBlank((CharSequence)reqBo.getRegAccount())) {
            DycUmcCheckUserExistFuncReqBo umcCheckUserExistFuncReqBo = new DycUmcCheckUserExistFuncReqBo();
            umcCheckUserExistFuncReqBo.setRegAccount(reqBo.getRegAccount());
            DycUmcCheckUserExistFuncRspBo umcCheckUserExistFuncRspBo = this.dycUmcCheckUserExistFunction.checkAddUserExist(umcCheckUserExistFuncReqBo);
            if (umcCheckUserExistFuncRspBo.getIsExistFlag().equals("1")) {
                throw new ZTBusinessException("\u7528\u6237\u540d\u5df2\u5b58\u5728");
            }
        }
        if (!StringUtils.isBlank((CharSequence)reqBo.getRegMobile())) {
            DycUmcCheckUserExistFuncReqBo umcCheckUserExistFuncReqBo1 = new DycUmcCheckUserExistFuncReqBo();
            umcCheckUserExistFuncReqBo1.setRegMobile(reqBo.getRegMobile());
            DycUmcCheckUserExistFuncRspBo umcCheckUserExistFuncRspBo1 = this.dycUmcCheckUserExistFunction.checkAddUserExist(umcCheckUserExistFuncReqBo1);
            if (umcCheckUserExistFuncRspBo1.getIsExistFlag().equals("1")) {
                throw new ZTBusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a");
            }
        }
    }

    public void codeCheck(DycUmcUserOrEnterpriseRegisterReqBo reqBo) {
        VerifyCodeRspBo verifyCodeRspBo;
        VerifyCodeReqBo verifyCodeReqBo;
        if (this.CHECK_EMAIL_CODE.booleanValue() && org.equals(reqBo.getRegisterType())) {
            verifyCodeReqBo = new VerifyCodeReqBo();
            verifyCodeReqBo.setVerifyCode(reqBo.getEmailCheck());
            verifyCodeReqBo.setVerifyValue(reqBo.getRegEmail());
            verifyCodeReqBo.setBusiKey(this.emaiRegisterVfcode);
            verifyCodeRspBo = this.verifyCodeService.checkVerifyCodeForTemp(verifyCodeReqBo);
            if (!"0000".equals(verifyCodeRspBo.getRespCode())) {
                throw new ZTBusinessException("\u90ae\u7bb1" + verifyCodeRspBo.getRespDesc());
            }
        }
        if (this.CHECK_MOBILE_CODE.booleanValue()) {
            verifyCodeReqBo = new VerifyCodeReqBo();
            verifyCodeReqBo.setVerifyCode(reqBo.getSmsCheck());
            verifyCodeReqBo.setVerifyValue(reqBo.getRegMobile());
            verifyCodeReqBo.setBusiKey(this.mobileRegistVfcode);
            verifyCodeRspBo = this.verifyCodeService.checkVerifyCodeForTemp(verifyCodeReqBo);
            if (!"0000".equals(verifyCodeRspBo.getRespCode())) {
                throw new ZTBusinessException("\u624b\u673a" + verifyCodeRspBo.getRespDesc());
            }
        }
    }

    public void checkOrgExist(DycUmcUserOrEnterpriseRegisterReqBo reqBo) {
        UmcDycCheckEnterpriseExistReqBo existReqBo = new UmcDycCheckEnterpriseExistReqBo();
        existReqBo.setTenantId(reqBo.getTenantId());
        existReqBo.setOrgCode(reqBo.getOrgCodeWeb());
        existReqBo.setOrgName(reqBo.getOrgNameWeb());
        existReqBo.setCreditNo(reqBo.getOrgCertificateCode());
        UmcDycCheckEnterpriseExistRspBo rspBo = this.umcDycCheckEnterpriseExistService.checkEnterprise(existReqBo);
        if (!"0000".equals(rspBo.getRespCode())) {
            throw new ZTBusinessException("\u6821\u9a8c\u673a\u6784\u4fe1\u606f\u5931\u8d25");
        }
        Map map = rspBo.getMap();
        if (this.getValue(map, reqBo.getOrgNameWeb()) > 0) {
            throw new ZTBusinessException("\u673a\u6784\u5df2\u5b58\u5728");
        }
        if (this.getValue(map, reqBo.getCertNo()) > 0) {
            throw new ZTBusinessException("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728");
        }
        if (this.getValue(map, reqBo.getOrgCodeWeb()) > 0) {
            throw new ZTBusinessException("\u673a\u6784\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }

    private int getValue(Map<String, Integer> map, String str) {
        if (null == map.get(str)) {
            return 0;
        }
        return map.get(str);
    }

    public void createEnterpriserUserInfo(DycUmcUserOrEnterpriseRegisterReqBo reqBo, AuthOrgInfoBo orgInfoBo, AuthUserInfoBo userInfoBo, Long applyId, String pwd, boolean auditFlowExists) {
        Date now = new Date();
        ArrayList<UmcOrgTagRelApplyBo> orgTagRelApplyBos = new ArrayList<UmcOrgTagRelApplyBo>();
        UmcEnterpriseRegisterInfoBo umcEnterpriseRegisterInfoBo = this.buildEnterpriseInfo(reqBo, orgInfoBo, userInfoBo, applyId, now, orgTagRelApplyBos);
        UmcEnterpriseRegisterApplyInfoBo umcEnterpriseRegisterApplyInfoBo = this.buildEnterpriseApplyInfo(applyId, umcEnterpriseRegisterInfoBo, orgTagRelApplyBos, auditFlowExists);
        UmcUserRegisterInfoBo umcUserRegisterInfoBo = this.buildUserInfo(reqBo, orgInfoBo, userInfoBo, pwd, auditFlowExists);
        UmcUserRegisterApplyInfoBo umcUserRegisterApplyInfoBo = this.buildUserApplyInfo(applyId, umcUserRegisterInfoBo, auditFlowExists);
        this.registerUser(reqBo, userInfoBo, umcEnterpriseRegisterInfoBo, umcEnterpriseRegisterApplyInfoBo, umcUserRegisterInfoBo, umcUserRegisterApplyInfoBo, auditFlowExists);
    }

    private void registerUser(DycUmcUserOrEnterpriseRegisterReqBo reqBo, AuthUserInfoBo userInfoBo, UmcEnterpriseRegisterInfoBo umcEnterpriseRegisterInfoBo, UmcEnterpriseRegisterApplyInfoBo umcEnterpriseRegisterApplyInfoBo, UmcUserRegisterInfoBo umcUserRegisterInfoBo, UmcUserRegisterApplyInfoBo umcUserRegisterApplyInfoBo, boolean auditFlowExists) {
        UmcEnterpriseUserRegisterRspBo umcEnterpriseUserRegisterRspBo;
        UmcEnterpriseUserRegisterReqBo umcEnterpriseUserRegisterReqBo = new UmcEnterpriseUserRegisterReqBo();
        umcEnterpriseUserRegisterReqBo.setUmcEnterpriseRegisterInfoBo(umcEnterpriseRegisterInfoBo);
        umcEnterpriseUserRegisterReqBo.setUmcEnterpriseRegisterApplyInfoBo(umcEnterpriseRegisterApplyInfoBo);
        umcEnterpriseUserRegisterReqBo.setUmcUserRegisterInfoBo(umcUserRegisterInfoBo);
        umcEnterpriseUserRegisterReqBo.setUmcUserRegisterApplyInfoBo(umcUserRegisterApplyInfoBo);
        if (!auditFlowExists && "1".equals(reqBo.getRegisterType())) {
            umcEnterpriseUserRegisterReqBo.setUmcRegisterAccountBo(this.buildAccountInfo(userInfoBo, reqBo));
        }
        if (!"0000".equals((umcEnterpriseUserRegisterRspBo = this.umcEnterpriseUserRegisterService.dealEnterpriseUserRegister(umcEnterpriseUserRegisterReqBo)).getRespCode())) {
            throw new ZTBusinessException("\u6ce8\u518c\u4f1a\u5458\u4f01\u4e1a\u7528\u6237\u5931\u8d25");
        }
    }

    private UmcUserRegisterInfoBo buildUserInfo(DycUmcUserOrEnterpriseRegisterReqBo reqBo, AuthOrgInfoBo orgInfoBo, AuthUserInfoBo userInfoBo, String pwd, boolean auditFlowExists) {
        UmcUserRegisterInfoBo umcUserRegisterInfoBo = new UmcUserRegisterInfoBo();
        UmcCustInfoBo custInfoBo = new UmcCustInfoBo();
        Long userId = userInfoBo.getUserId();
        umcUserRegisterInfoBo.setUserId(userId);
        umcUserRegisterInfoBo.setCustId(userInfoBo.getCustId());
        umcUserRegisterInfoBo.setMainCustId(userInfoBo.getMainCustId());
        umcUserRegisterInfoBo.setTenantId(reqBo.getTenantId());
        umcUserRegisterInfoBo.setCompanyId(orgInfoBo.getOrgId());
        umcUserRegisterInfoBo.setOrgTreePath(orgInfoBo.getOrgTreePath());
        umcUserRegisterInfoBo.setOrgId(orgInfoBo.getOrgId());
        if ("1".equals(reqBo.getRegisterType())) {
            umcUserRegisterInfoBo.setUserType("1");
        } else if (org.equals(reqBo.getRegisterType())) {
            umcUserRegisterInfoBo.setUserType(org);
        } else {
            throw new ZTBusinessException("\u672a\u77e5\u7684\u6ce8\u518c\u7c7b\u578b");
        }
        umcUserRegisterInfoBo.setIsMain("1");
        umcUserRegisterInfoBo.setDelFlag(NEED_AUDIT_FLAG);
        umcUserRegisterInfoBo.setCreateOperId(userId);
        umcUserRegisterInfoBo.setCreateOperName(reqBo.getMemName2());
        umcUserRegisterInfoBo.setCreateTime(new Date());
        umcUserRegisterInfoBo.setStopStatus("01");
        custInfoBo.setCustId(userInfoBo.getCustId());
        custInfoBo.setStopStatus(umcUserRegisterInfoBo.getStopStatus());
        custInfoBo.setCustType(umcUserRegisterInfoBo.getUserType());
        custInfoBo.setRegAccount(reqBo.getRegAccount());
        custInfoBo.setRegMobile(reqBo.getRegMobile());
        custInfoBo.setRegEmail(reqBo.getRegEmail());
        custInfoBo.setCustStatus("1");
        custInfoBo.setPasswd(pwd);
        custInfoBo.setIsPasswdValid("1");
        custInfoBo.setCustName(reqBo.getMemName2());
        custInfoBo.setCertNo(reqBo.getCertNo());
        custInfoBo.setCertType(UmcCommConstant.CertType.ID_CARD);
        custInfoBo.setCompanyId(orgInfoBo.getOrgId());
        custInfoBo.setCreateOperId(userId);
        custInfoBo.setCreateOperName(reqBo.getMemName2());
        custInfoBo.setCreateTime(new Date());
        List<UmcUserTagRelBo> userTag = this.buildUserTag(reqBo, userId);
        List<UmcUserRoleRelBo> umcUserRoleRelBos = this.buildUserRole(reqBo, userId, auditFlowExists);
        umcUserRegisterInfoBo.setCustInfo(custInfoBo);
        umcUserRegisterInfoBo.setUserTagRelList(userTag);
        umcUserRegisterInfoBo.setUserRoleRelList(umcUserRoleRelBos);
        return umcUserRegisterInfoBo;
    }

    private UmcUserRegisterApplyInfoBo buildUserApplyInfo(Long applyId, UmcUserRegisterInfoBo umcUserRegisterInfoBo, boolean auditFlowExists) {
        UmcUserRegisterApplyInfoBo umcUserRegisterApplyInfoBo = new UmcUserRegisterApplyInfoBo();
        BeanUtils.copyProperties((Object)umcUserRegisterInfoBo, (Object)umcUserRegisterApplyInfoBo);
        UmcCustInfoApplyBo applyBo = new UmcCustInfoApplyBo();
        BeanUtils.copyProperties((Object)umcUserRegisterInfoBo.getCustInfo(), (Object)applyBo);
        applyBo.setApplyId(applyId);
        List applyBos = JUtil.jsl((List)umcUserRegisterInfoBo.getUserTagRelList(), UmcUserTagRelApplyBo.class);
        applyBos.forEach(UmcUserTagRelApplyBo2 -> UmcUserTagRelApplyBo2.setApplyId(applyId));
        List umcUserRoleRelApplyBos = JUtil.jsl((List)umcUserRegisterInfoBo.getUserRoleRelList(), UmcUserRoleRelApplyBo.class);
        umcUserRoleRelApplyBos.forEach(UmcUserRoleRelApplyBo2 -> UmcUserRoleRelApplyBo2.setApplyId(applyId));
        umcUserRegisterApplyInfoBo.setCustInfoApplyBo(applyBo);
        umcUserRegisterApplyInfoBo.setUserTagRelApplyBoList(applyBos);
        umcUserRegisterApplyInfoBo.setUserRoleRelApplyBoList(umcUserRoleRelApplyBos);
        umcUserRegisterApplyInfoBo.setApplyId(applyId);
        umcUserRegisterApplyInfoBo.setCompanyId(umcUserRegisterApplyInfoBo.getOrgId());
        umcUserRegisterApplyInfoBo.setStopStatus("01");
        umcUserRegisterApplyInfoBo.setApplyType("1");
        if (!auditFlowExists) {
            umcUserRegisterApplyInfoBo.setApplyStatus("1");
        } else {
            umcUserRegisterApplyInfoBo.setApplyStatus(NEED_AUDIT_FLAG);
        }
        return umcUserRegisterApplyInfoBo;
    }

    private UmcEnterpriseRegisterInfoBo buildEnterpriseInfo(DycUmcUserOrEnterpriseRegisterReqBo reqBo, AuthOrgInfoBo orgInfoBo, AuthUserInfoBo userInfoBo, Long applyId, Date now, List<UmcOrgTagRelApplyBo> orgTagRelApplyBos) {
        UmcEnterpriseRegisterInfoBo umcEnterpriseRegisterInfoBo = new UmcEnterpriseRegisterInfoBo();
        UmcOrgInfoBo umcOrgInfoBo = new UmcOrgInfoBo();
        umcOrgInfoBo.setOrgId(orgInfoBo.getOrgId());
        umcOrgInfoBo.setTenantId(reqBo.getTenantId());
        umcOrgInfoBo.setOrgTreePath(orgInfoBo.getOrgTreePath());
        umcOrgInfoBo.setParentId(orgInfoBo.getParentId());
        if ("1".equals(reqBo.getRegisterType())) {
            umcEnterpriseRegisterInfoBo.setOrgClass("1");
        } else if (org.equals(reqBo.getRegisterType())) {
            umcEnterpriseRegisterInfoBo.setOrgClass(org);
        } else {
            throw new ZTBusinessException("\u672a\u77e5\u7684\u6ce8\u518c\u7c7b\u578b");
        }
        umcOrgInfoBo.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_COMPANY);
        umcOrgInfoBo.setCompanyId(orgInfoBo.getOrgId());
        umcOrgInfoBo.setOrgCode(reqBo.getOrgCodeWeb());
        umcOrgInfoBo.setDeep(ORG_DEEP);
        umcOrgInfoBo.setOrgName(reqBo.getOrgNameWeb());
        umcOrgInfoBo.setOrgAlias(reqBo.getAliasWeb());
        umcOrgInfoBo.setIsVirtual("1");
        umcOrgInfoBo.setOrgStatus("1");
        umcOrgInfoBo.setCreateOperId(userInfoBo.getUserId());
        umcOrgInfoBo.setCreateOperName(reqBo.getMemName2());
        umcOrgInfoBo.setCreateTime(now);
        ArrayList<UmcOrgTagRelBo> orgTagRelList = new ArrayList<UmcOrgTagRelBo>();
        for (String tag : reqBo.getTradeCapacity().split(",")) {
            UmcOrgTagRelBo umcOrgTagRelBo = new UmcOrgTagRelBo();
            UmcOrgTagRelApplyBo umcOrgTagRelApplyBo = new UmcOrgTagRelApplyBo();
            umcOrgTagRelBo.setTagStatus("1");
            umcOrgTagRelBo.setOrgId(orgInfoBo.getOrgId());
            umcOrgTagRelBo.setTenantId(reqBo.getTenantId());
            umcOrgTagRelBo.setTagId(tag);
            umcOrgTagRelBo.setCreateOperId(userInfoBo.getUserId());
            umcOrgTagRelBo.setCreateOperName(reqBo.getMemName2());
            umcOrgTagRelBo.setCreateTime(now);
            umcOrgTagRelBo.setEffTime(new Date());
            BeanUtils.copyProperties((Object)umcOrgTagRelBo, (Object)umcOrgTagRelApplyBo);
            umcOrgTagRelApplyBo.setApplyId(applyId);
            umcOrgTagRelApplyBo.setDelFlag(NEED_AUDIT_FLAG);
            orgTagRelList.add(umcOrgTagRelBo);
            orgTagRelApplyBos.add(umcOrgTagRelApplyBo);
        }
        umcOrgInfoBo.setOrgTagRelList(orgTagRelList);
        umcEnterpriseRegisterInfoBo.setOrgId(orgInfoBo.getOrgId());
        umcEnterpriseRegisterInfoBo.setTenantId(reqBo.getTenantId());
        umcEnterpriseRegisterInfoBo.setOrgShortName(reqBo.getAliasWeb());
        umcEnterpriseRegisterInfoBo.setIsAbroad(NEED_AUDIT_FLAG);
        umcEnterpriseRegisterInfoBo.setIsMerchant("1");
        umcEnterpriseRegisterInfoBo.setIndustry(reqBo.getTradeType());
        umcEnterpriseRegisterInfoBo.setTelephone(reqBo.getRegMobile());
        umcEnterpriseRegisterInfoBo.setMailBox(reqBo.getRegEmail());
        umcEnterpriseRegisterInfoBo.setLegalPerson(reqBo.getMemName2());
        umcEnterpriseRegisterInfoBo.setOrgCertificateCode(reqBo.getOrgCertificateCode());
        umcEnterpriseRegisterInfoBo.setCreditNo(reqBo.getOrgCertificateCode());
        if (!CollectionUtils.isEmpty(reqBo.getBusinessLicense())) {
            umcEnterpriseRegisterInfoBo.setBusinessLicense(JSON.toJSONString(reqBo.getBusinessLicense()));
        }
        umcEnterpriseRegisterInfoBo.setOrgInfoBo(umcOrgInfoBo);
        umcEnterpriseRegisterInfoBo.setCreateOperId(userInfoBo.getUserId());
        umcEnterpriseRegisterInfoBo.setCreateOperName(reqBo.getMemName2());
        umcEnterpriseRegisterInfoBo.setCreateTime(now);
        ArrayList<UmcEnterpriseContactBo> umcEnterpriseContactBos = new ArrayList<UmcEnterpriseContactBo>();
        UmcEnterpriseContactBo umcEnterpriseContactBo = new UmcEnterpriseContactBo();
        umcEnterpriseContactBo.setContactName(reqBo.getMemName2());
        umcEnterpriseContactBo.setEmail(reqBo.getRegEmail());
        umcEnterpriseContactBo.setCardNum(reqBo.getCertNo());
        umcEnterpriseContactBo.setContactId(Long.valueOf(IdUtil.nextId()));
        umcEnterpriseContactBo.setPhoneNumber(reqBo.getRegMobile());
        umcEnterpriseContactBo.setCustId(userInfoBo.getCustId());
        umcEnterpriseContactBo.setOrgId(userInfoBo.getOrgId());
        umcEnterpriseContactBo.setTenantId(userInfoBo.getTenantId());
        umcEnterpriseContactBo.setCreateOperId(userInfoBo.getUserId());
        umcEnterpriseContactBo.setCreateOperName(reqBo.getMemName2());
        umcEnterpriseContactBo.setCreateTime(now);
        umcEnterpriseContactBo.setTel(reqBo.getRegMobile());
        umcEnterpriseContactBo.setExtField1("1");
        umcEnterpriseContactBos.add(umcEnterpriseContactBo);
        umcEnterpriseRegisterInfoBo.setEnterpriseContactBoList(umcEnterpriseContactBos);
        return umcEnterpriseRegisterInfoBo;
    }

    private UmcEnterpriseRegisterApplyInfoBo buildEnterpriseApplyInfo(Long applyId, UmcEnterpriseRegisterInfoBo umcEnterpriseRegisterInfoBo, List<UmcOrgTagRelApplyBo> orgTagRelApplyBos, boolean auditFlowExists) {
        UmcEnterpriseRegisterApplyInfoBo umcEnterpriseRegisterApplyInfoBo = (UmcEnterpriseRegisterApplyInfoBo)JUtil.js((Object)umcEnterpriseRegisterInfoBo, UmcEnterpriseRegisterApplyInfoBo.class);
        if (!auditFlowExists) {
            umcEnterpriseRegisterApplyInfoBo.setApplyStatus("1");
        } else {
            umcEnterpriseRegisterApplyInfoBo.setApplyStatus(NEED_AUDIT_FLAG);
        }
        umcEnterpriseRegisterApplyInfoBo.setApplyId(applyId);
        umcEnterpriseRegisterApplyInfoBo.setApplyType("1");
        UmcOrgInfoApplyBo umcOrgInfoApplyBo = (UmcOrgInfoApplyBo)JUtil.js((Object)umcEnterpriseRegisterInfoBo.getOrgInfoBo(), UmcOrgInfoApplyBo.class);
        umcOrgInfoApplyBo.setOrgTagRelApplyBoList(orgTagRelApplyBos);
        umcOrgInfoApplyBo.setEffTime(new Date());
        umcOrgInfoApplyBo.setApplyId(applyId);
        umcEnterpriseRegisterApplyInfoBo.setOrgInfoApplyBo(umcOrgInfoApplyBo);
        umcEnterpriseRegisterApplyInfoBo.setIsMerchant("1");
        List umcEnterpriseContactApplyBos = JUtil.jsl((List)umcEnterpriseRegisterInfoBo.getEnterpriseContactBoList(), UmcEnterpriseContactApplyBo.class);
        umcEnterpriseContactApplyBos.forEach(umcEnterpriseContactApplyBo -> {
            umcEnterpriseContactApplyBo.setApplyId(applyId);
            umcEnterpriseContactApplyBo.setDelFlag(NEED_AUDIT_FLAG);
        });
        umcEnterpriseRegisterApplyInfoBo.setEnterpriseContactApplyBoList(umcEnterpriseContactApplyBos);
        return umcEnterpriseRegisterApplyInfoBo;
    }

    public AuthEnterpriseUserRegisterRspBo createOrgUserAuth(DycUmcUserOrEnterpriseRegisterReqBo reqBo, String pwd, String salt, boolean auditFlowExists) {
        AuthEnterpriseRegisterBo authEnterpriseRegisterBo = this.buildAuthOrgBo(reqBo);
        AuthUserRegisterInfoBo authCreateUserInfoReqBo = this.buildAuthUserBo(reqBo, pwd, salt, auditFlowExists);
        AuthEnterpriseUserRegisterReqBo authEnterpriseUserRegisterReqBo = new AuthEnterpriseUserRegisterReqBo();
        authEnterpriseUserRegisterReqBo.setAuthEnterpriseRegisterBo(authEnterpriseRegisterBo);
        authEnterpriseUserRegisterReqBo.setAuthUserRegisterInfoBo(authCreateUserInfoReqBo);
        AuthEnterpriseUserRegisterRspBo authEnterpriseUserRegisterRspBo = this.authEnterpriseUserRegisterService.dealEnterpriseUserRegister(authEnterpriseUserRegisterReqBo);
        if (!"0000".equals(authEnterpriseUserRegisterRspBo.getRespCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u6743\u9650\u7ec4\u7ec7\u7528\u6237\u5931\u8d25");
        }
        return authEnterpriseUserRegisterRspBo;
    }

    private AuthUserRegisterInfoBo buildAuthUserBo(DycUmcUserOrEnterpriseRegisterReqBo reqBo, String pwd, String salt, boolean auditFlowExists) {
        AuthUserRegisterInfoBo authCreateUserInfoReqBo = new AuthUserRegisterInfoBo();
        authCreateUserInfoReqBo.setTenantId(reqBo.getTenantId());
        authCreateUserInfoReqBo.setAuthorityType("auth:default:manage");
        authCreateUserInfoReqBo.setIsMain("1");
        authCreateUserInfoReqBo.setUserStatus("1");
        AuthCustInfoBo authCustInfoBo = new AuthCustInfoBo();
        authCustInfoBo.setLoginName(reqBo.getRegAccount());
        authCustInfoBo.setTenantId(reqBo.getTenantId());
        authCustInfoBo.setCustPassword(pwd);
        authCustInfoBo.setPasswordSalt(salt);
        authCustInfoBo.setPasswordEffDate(new Date());
        authCustInfoBo.setPasswordEffDateStart(DateUtils.addDays((Date)new Date(), (int)this.password_eff));
        authCustInfoBo.setCustName(reqBo.getMemName2());
        authCustInfoBo.setCellPhone(reqBo.getRegMobile());
        authCustInfoBo.setCustEmail(reqBo.getRegEmail());
        authCustInfoBo.setCustStatus("1");
        authCustInfoBo.setCustSource("1");
        authCustInfoBo.setCreateOperId(OPER_ID);
        authCustInfoBo.setCreateOperName(reqBo.getMemName2());
        authCustInfoBo.setCreateTime(new Date());
        authCreateUserInfoReqBo.setCustInfo(authCustInfoBo);
        ArrayList<AuthUserTagRelBo> userTagRelList = new ArrayList<AuthUserTagRelBo>();
        for (String s : reqBo.getTradeCapacity().split(",")) {
            AuthUserTagRelBo umcUserTagRelBo = new AuthUserTagRelBo();
            umcUserTagRelBo.setIsDefalt(NEED_AUDIT_FLAG);
            umcUserTagRelBo.setTagId(Convert.toLong((Object)s));
            umcUserTagRelBo.setCreateOperId(OPER_ID);
            umcUserTagRelBo.setCreateTime(new Date());
            umcUserTagRelBo.setCreateOperName(reqBo.getMemName2());
            userTagRelList.add(umcUserTagRelBo);
        }
        if (!CollectionUtils.isEmpty(userTagRelList)) {
            ((AuthUserTagRelBo)userTagRelList.get(0)).setIsDefalt("1");
        }
        List authDistributeBos = JSONObject.parseArray((String)JSON.toJSONString(this.buildUserRole(reqBo, OPER_ID, auditFlowExists)), AuthDistributeBo.class);
        authDistributeBos.forEach(authDistributeBo -> {
            authDistributeBo.setAuthId(Long.valueOf(IdUtil.nextId()));
            authDistributeBo.setDisFlag(AuthConstant.ROLE_DIS_FLAG.USER);
        });
        authCreateUserInfoReqBo.setUserTagRelList(userTagRelList);
        authCreateUserInfoReqBo.setAuthDistributeList(authDistributeBos);
        return authCreateUserInfoReqBo;
    }

    private AuthEnterpriseRegisterBo buildAuthOrgBo(DycUmcUserOrEnterpriseRegisterReqBo reqBo) {
        AuthEnterpriseRegisterBo authEnterpriseRegisterBo = new AuthEnterpriseRegisterBo();
        authEnterpriseRegisterBo.setTenantId(reqBo.getTenantId());
        if ("1".equals(reqBo.getRegisterType())) {
            authEnterpriseRegisterBo.setParentId(this.register_default_parent_personal_org);
        } else if (org.equals(reqBo.getRegisterType())) {
            authEnterpriseRegisterBo.setParentId(this.register_default_parent_org);
        } else {
            throw new ZTBusinessException("\u672a\u77e5\u7684\u6ce8\u518c\u7c7b\u578b");
        }
        authEnterpriseRegisterBo.setOrgCode(reqBo.getOrgCodeWeb());
        authEnterpriseRegisterBo.setOrgName(reqBo.getOrgNameWeb());
        authEnterpriseRegisterBo.setOrgAlias(reqBo.getAliasWeb());
        authEnterpriseRegisterBo.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_COMPANY);
        authEnterpriseRegisterBo.setIsVirtual("1");
        authEnterpriseRegisterBo.setOrgStatus("1");
        authEnterpriseRegisterBo.setCreateTime(new Date());
        authEnterpriseRegisterBo.setCreateOperId(OPER_ID);
        authEnterpriseRegisterBo.setCreateOperName(reqBo.getMemName2());
        ArrayList<AuthOrgTagRelBo> orgTagRelList = new ArrayList<AuthOrgTagRelBo>();
        for (String tag : reqBo.getTradeCapacity().split(",")) {
            AuthOrgTagRelBo authOrgTagRelBo = new AuthOrgTagRelBo();
            authOrgTagRelBo.setTagStatus("1");
            authOrgTagRelBo.setTagId(Convert.toLong((Object)tag));
            authOrgTagRelBo.setCreateOperId(OPER_ID);
            authOrgTagRelBo.setCreateTime(new Date());
            authOrgTagRelBo.setCreateOperName(OPER_NAME);
            orgTagRelList.add(authOrgTagRelBo);
        }
        authEnterpriseRegisterBo.setOrgTagList(orgTagRelList);
        return authEnterpriseRegisterBo;
    }

    public List<UmcUserTagRelBo> buildUserTag(DycUmcUserOrEnterpriseRegisterReqBo reqBo, Long userId) {
        ArrayList<UmcUserTagRelBo> userTagRelList = new ArrayList<UmcUserTagRelBo>();
        boolean flag = true;
        int orderBy = 0;
        for (String s : reqBo.getTradeCapacity().split(",")) {
            UmcUserTagRelBo umcUserTagRelBo = new UmcUserTagRelBo();
            umcUserTagRelBo.setUserId(userId);
            umcUserTagRelBo.setRelId(Long.valueOf(IdUtil.nextId()));
            umcUserTagRelBo.setTenantId(reqBo.getTenantId());
            if (flag) {
                umcUserTagRelBo.setIsDefalt("1");
                flag = false;
            } else {
                umcUserTagRelBo.setIsDefalt(NEED_AUDIT_FLAG);
            }
            umcUserTagRelBo.setTagId(s);
            umcUserTagRelBo.setCreateOperId(userId);
            umcUserTagRelBo.setCreateOperName(reqBo.getMemName2());
            umcUserTagRelBo.setOrderBy(Integer.toString(orderBy));
            ++orderBy;
            userTagRelList.add(umcUserTagRelBo);
        }
        return userTagRelList;
    }

    public List<UmcUserRoleRelBo> buildUserRole(DycUmcUserOrEnterpriseRegisterReqBo reqBo, Long createId, boolean auditFlowExists) {
        Date now = new Date();
        ArrayList<UmcUserRoleRelBo> userRoleRelList = new ArrayList<UmcUserRoleRelBo>();
        if (!auditFlowExists) {
            String[] personRole;
            String role = "";
            if ("1".equals(reqBo.getRegisterType())) {
                role = this.registerDefaultPersonalRole;
            } else if (org.equals(reqBo.getRegisterType())) {
                role = this.registerDefaultEnterpriseRole;
            } else {
                throw new ZTBusinessException("\u672a\u77e5\u7684\u6ce8\u518c\u7c7b\u578b");
            }
            if (!StringUtils.isBlank((CharSequence)role) && (personRole = role.split(",")).length > 0) {
                String[] stringArray = personRole;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String value = stringArray[i];
                    UmcUserRoleRelBo umcUserRoleRelBo = new UmcUserRoleRelBo();
                    umcUserRoleRelBo.setTenantId(reqBo.getTenantId());
                    umcUserRoleRelBo.setRoleId(Long.valueOf(Long.parseLong(value)));
                    umcUserRoleRelBo.setTagId("9");
                    umcUserRoleRelBo.setCreateOperId(createId);
                    umcUserRoleRelBo.setCreateTime(now);
                    umcUserRoleRelBo.setCreateOperName(reqBo.getMemName2());
                    userRoleRelList.add(umcUserRoleRelBo);
                }
            }
            if (!StringUtils.isBlank((CharSequence)this.registerDefaultRoleCommon)) {
                for (String commRole : this.registerDefaultRoleCommon.split(",")) {
                    UmcUserRoleRelBo umcUserRoleRelBo = new UmcUserRoleRelBo();
                    umcUserRoleRelBo.setTenantId(reqBo.getTenantId());
                    umcUserRoleRelBo.setRoleId(Convert.toLong((Object)commRole));
                    umcUserRoleRelBo.setTagId("9");
                    umcUserRoleRelBo.setCreateOperId(createId);
                    umcUserRoleRelBo.setCreateTime(now);
                    umcUserRoleRelBo.setCreateOperName(reqBo.getMemName2());
                    userRoleRelList.add(umcUserRoleRelBo);
                }
            }
        }
        UmcUserRoleRelBo umcUserRoleRelBo = new UmcUserRoleRelBo();
        umcUserRoleRelBo.setTenantId(reqBo.getTenantId());
        umcUserRoleRelBo.setRoleId(DEFAULT_ROLE_ID);
        umcUserRoleRelBo.setTagId("9");
        umcUserRoleRelBo.setCreateOperId(createId);
        umcUserRoleRelBo.setCreateTime(now);
        umcUserRoleRelBo.setCreateOperName(reqBo.getMemName2());
        userRoleRelList.add(umcUserRoleRelBo);
        return userRoleRelList.stream().distinct().collect(Collectors.toList());
    }

    private void syncCs(DycUmcUserOrEnterpriseRegisterReqBo reqBo, AuthOrgInfoBo orgInfoBo, Long userId) {
        if (this.custServiceEnable) {
            DycUmcCustServiceTenantAddFuncReqBo dycUmcCustServiceTenantAddFuncReqBo = new DycUmcCustServiceTenantAddFuncReqBo();
            dycUmcCustServiceTenantAddFuncReqBo.setTenantId(Convert.toStr((Object)orgInfoBo.getOrgId()));
            dycUmcCustServiceTenantAddFuncReqBo.setTenantName(Convert.toStr((Object)orgInfoBo.getOrgName()));
            JSONObject label = this.getLabel(orgInfoBo);
            dycUmcCustServiceTenantAddFuncReqBo.setExtInfo(label.toJSONString());
            this.dycUmcCustServiceTenantAddFunction.tenantAdd(dycUmcCustServiceTenantAddFuncReqBo);
            DycUmcCustSericeUsersAddFuncReqBo dycUmcCustSericeUsersAddFuncReqBo = new DycUmcCustSericeUsersAddFuncReqBo();
            dycUmcCustSericeUsersAddFuncReqBo.setTenantCode(Convert.toStr((Object)orgInfoBo.getOrgId()));
            ArrayList<DycUmcCustServiceUsersFuncBo> dycUmcCustServiceUsersFuncBos = new ArrayList<DycUmcCustServiceUsersFuncBo>();
            DycUmcCustServiceUsersFuncBo dycUmcCustServiceUsersFuncBo = new DycUmcCustServiceUsersFuncBo();
            dycUmcCustServiceUsersFuncBo.setExtUid(userId + "_1");
            dycUmcCustServiceUsersFuncBo.setUserType("1");
            dycUmcCustServiceUsersFuncBo.setNickname(reqBo.getMemName2());
            HashMap<String, String> extDataMap = new HashMap<String, String>();
            extDataMap.put("memUserType", "1");
            extDataMap.put("purchaserId", Convert.toStr((Object)orgInfoBo.getOrgId()));
            extDataMap.put("userId", Convert.toStr((Object)userId));
            dycUmcCustServiceUsersFuncBo.setExtData(JSON.toJSONString(extDataMap));
            dycUmcCustServiceUsersFuncBo.setName(reqBo.getRegAccount());
            dycUmcCustServiceUsersFuncBos.add(dycUmcCustServiceUsersFuncBo);
            dycUmcCustSericeUsersAddFuncReqBo.setUsers(dycUmcCustServiceUsersFuncBos);
            this.dycUmcCustSericeUsersAddFunction.usersAdd(dycUmcCustSericeUsersAddFuncReqBo);
        }
    }

    private JSONObject getLabel(AuthOrgInfoBo orgInfoBo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CS_LABEL, (Object)"");
        if (CollectionUtils.isEmpty((Collection)orgInfoBo.getOrgTagList())) {
            List tagIdList = orgInfoBo.getOrgTagList().stream().map(AuthOrgTagRelBo::getTagId).collect(Collectors.toList());
            if (tagIdList.contains(Convert.toLong((Object)org))) {
                jsonObject.put(CS_LABEL, (Object)SUPPLIER_LABEL);
            }
            if (tagIdList.contains(Convert.toLong((Object)"1"))) {
                jsonObject.put(CS_LABEL, (Object)OPERATION_LABEL);
            }
        }
        return jsonObject;
    }

    private void sendPlatformUsage(AuthUserInfoBo userInfoBo, AuthOrgInfoBo orgInfoBo) {
        DycUmcCreatePlatformUsageFuncReqBo dycUmcCreatePlatformUsageFuncReqBo = new DycUmcCreatePlatformUsageFuncReqBo();
        dycUmcCreatePlatformUsageFuncReqBo.setApplyType("1");
        dycUmcCreatePlatformUsageFuncReqBo.setLinkMan(userInfoBo.getCustInfo().getCustName());
        dycUmcCreatePlatformUsageFuncReqBo.setName(userInfoBo.getCustInfo().getCustName());
        dycUmcCreatePlatformUsageFuncReqBo.setUserIdIn(userInfoBo.getUserId());
        dycUmcCreatePlatformUsageFuncReqBo.setOrgIdIn(orgInfoBo.getOrgId());
        dycUmcCreatePlatformUsageFuncReqBo.setOrgName(orgInfoBo.getOrgName());
        dycUmcCreatePlatformUsageFuncReqBo.setOrgIdIn(orgInfoBo.getOrgId());
        dycUmcCreatePlatformUsageFuncReqBo.setOrgIdWeb(orgInfoBo.getOrgId());
        dycUmcCreatePlatformUsageFuncReqBo.setOrgNameWeb(orgInfoBo.getOrgName());
        dycUmcCreatePlatformUsageFuncReqBo.setCompanyIdIn(orgInfoBo.getOrgId());
        dycUmcCreatePlatformUsageFuncReqBo.setCompanyName(orgInfoBo.getOrgName());
        this.dycUmcCreatePlatformUsageFunction.createPlatformUsage(dycUmcCreatePlatformUsageFuncReqBo);
    }

    private UmcRegisterAccountBo buildAccountInfo(AuthUserInfoBo userInfoBo, DycUmcUserOrEnterpriseRegisterReqBo reqBo) {
        UmcRegisterAccountBo umcRegisterAccountBo = new UmcRegisterAccountBo();
        umcRegisterAccountBo.setAccountName(reqBo.getOrgNameWeb());
        umcRegisterAccountBo.setTenantId(reqBo.getTenantId());
        umcRegisterAccountBo.setPurchaseOrgName(reqBo.getOrgNameWeb());
        umcRegisterAccountBo.setOrgCertificateCode(reqBo.getOrgCertificateCode());
        umcRegisterAccountBo.setLegalPerson(reqBo.getMemName2());
        umcRegisterAccountBo.setDeliveryCenterId(this.deliveryCenterId);
        umcRegisterAccountBo.setContact(reqBo.getMemName2());
        umcRegisterAccountBo.setTelephone(reqBo.getRegMobile());
        umcRegisterAccountBo.setTrade(reqBo.getTradeType());
        umcRegisterAccountBo.setProvinceId("1");
        umcRegisterAccountBo.setAccountOwner(person);
        umcRegisterAccountBo.setUserId(userInfoBo.getUserId());
        umcRegisterAccountBo.setUsername(reqBo.getMemName2());
        umcRegisterAccountBo.setOwnerMemId(userInfoBo.getUserId());
        umcRegisterAccountBo.setOrgId(userInfoBo.getOrgId());
        return umcRegisterAccountBo;
    }

    private boolean qryAuditFlow() {
        OsWorkFlowReqBO osWorkFlowReqBO = new OsWorkFlowReqBO();
        osWorkFlowReqBO.setSysCode(this.sys_code);
        osWorkFlowReqBO.setProcDefKey(this.extRegistAuditKey);
        OsWorkFlowRespBO osWorkflow = this.osworkflowWhetherChartAbilityService.findOsWorkflow(osWorkFlowReqBO);
        if (!"0000".equals(osWorkflow.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u6d41\u7a0b\u56fe\u662f\u5426\u5b58\u5728\u5931\u8d25");
        }
        return null != osWorkflow.getFindFlag() && osWorkflow.getFindFlag() != false;
    }
}

