/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.login.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.authority.service.domainservice.AuthCreateLoginLogService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthCreateLoginLogReqBo;
import com.tydic.dyc.authority.service.organization.AuthGetOrgInfoDetailService;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgInfoDetailReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthGetOrgInfoDetailRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgTagRelBo;
import com.tydic.dyc.authority.service.user.AuthGetLoginCustListService;
import com.tydic.dyc.authority.service.user.AuthGetUserInfoDetailService;
import com.tydic.dyc.authority.service.user.AuthGetUserInfoListService;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetLoginCustListReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetLoginCustListRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserInfoDetailReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserInfoDetailRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserInfoListReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserInfoListRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.common.member.login.api.AutzQueryService;
import com.tydic.dyc.common.member.login.api.LoginServcie;
import com.tydic.dyc.common.member.login.api.PicVfCodeService;
import com.tydic.dyc.common.member.login.bo.GetPicVfCodeReqBO;
import com.tydic.dyc.common.member.login.bo.GetPicVfCodeRspBO;
import com.tydic.dyc.common.member.login.bo.LoginReqBo;
import com.tydic.dyc.common.member.login.bo.LoginRspBo;
import com.tydic.dyc.common.member.vfcode.api.VerifyCodeService;
import com.tydic.dyc.common.member.vfcode.bo.VerifyCodeReqBo;
import com.tydic.dyc.common.member.vfcode.bo.VerifyCodeRspBo;
import com.tydic.umc.security.utils.AesUtil;
import com.tydic.umc.security.utils.LoginPasswordUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.login.api.LoginServcie"})
public class LoginServcieImpl
implements LoginServcie {
    private static final Logger log = LoggerFactory.getLogger(LoginServcieImpl.class);
    @Value(value="${login.vfType:1}")
    private String vfType;
    @Value(value="${login.defaultVfFlag:true}")
    private Boolean defaultVfFlag;
    @Value(value="${login.defaultVfCode:1111}")
    private String defaultVfCode;
    @Value(value="${login.loginNum:50}")
    private Integer loginNum;
    @Value(value="${login.lockTime:86400}")
    private int loginLockTime;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${login.refreshTime:10}")
    private int refreshTime;
    @Value(value="${login.uniqueLoginFlag:false}")
    private Boolean uniqueLoginFlag;
    private static final int OFFSET = 4;
    @Autowired
    private LoginPasswordUtils passwordUtils;
    @Autowired
    private PicVfCodeService picVfCodeService;
    @Autowired
    private AutzQueryService autzQueryService;
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private AuthGetLoginCustListService authGetLoginCustListService;
    @Autowired
    private AuthGetUserInfoListService authGetUserInfoListService;
    @Autowired
    private AuthCreateLoginLogService authCreateLoginLogService;
    @Autowired
    private VerifyCodeService verifyCodeService;
    private static final String sendVfCodePcLogin = "login_vf_code";
    @Autowired
    private AuthGetOrgInfoDetailService authGetOrgInfoDetailService;
    @Autowired
    private AuthGetUserInfoDetailService authGetUserInfoDetailService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @PostMapping(value={"login"})
    public LoginRspBo login(@RequestBody LoginReqBo reqBo) {
        log.debug("\u767b\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBo));
        LoginRspBo loginRspBo = new LoginRspBo();
        loginRspBo.setRespCode("0000");
        loginRspBo.setRespDesc("\u6210\u529f");
        this.initParam(reqBo);
        GetPicVfCodeReqBO getPicVfCodeReqBO = new GetPicVfCodeReqBO();
        getPicVfCodeReqBO.setIp(reqBo.getIp());
        getPicVfCodeReqBO.setSessionId(reqBo.getSessionId());
        getPicVfCodeReqBO.setVfCode(reqBo.getVfCode());
        String vfVerifyType = reqBo.getVfVerifyType();
        String sessionId = reqBo.getSessionId();
        if (StringUtils.isNotBlank((CharSequence)vfVerifyType)) {
            this.vfType = vfVerifyType;
        }
        AuthUserInfoBo userInfoBo = new AuthUserInfoBo();
        if (!(!this.vfType.equals("1") || this.defaultVfCode.equals(reqBo.getVfCode()) && this.defaultVfFlag.booleanValue())) {
            GetPicVfCodeRspBO getPicVfCodeRspBO = this.picVfCodeService.checkVfCode(getPicVfCodeReqBO);
            if (!"0000".equals(getPicVfCodeRspBO.getRespCode())) {
                throw new ZTBusinessException(getPicVfCodeRspBO.getRespDesc());
            }
        } else if (!(!this.vfType.equals("2") || this.defaultVfCode.equals(reqBo.getVfCode()) && this.defaultVfFlag.booleanValue())) {
            Integer veriCode = this.autzQueryService.getCurrentIdCaptcha(sessionId);
            if (null == veriCode) throw new ZTBusinessException("\u6ed1\u52a8\u9a8c\u8bc1\u5931\u8d25\uff01");
            if (Integer.parseInt(reqBo.getVfCode()) >= veriCode + 4 || Integer.parseInt(reqBo.getVfCode()) <= veriCode - 4) throw new ZTBusinessException("\u6ed1\u52a8\u9a8c\u8bc1\u8fc7\u671f\uff01");
            String string = this.autzQueryService.putCurrentIpCode(sessionId);
        } else if (this.vfType.equals("2") && this.vfType.equals("1") && this.vfType.equals("3") && this.vfType.equals("0")) {
            throw new ZTBusinessException("\u65e0\u6548\u9a8c\u8bc1\u6a21\u5f0f\uff0c\u65e0\u6cd5\u767b\u5f55");
        }
        if ("2".equals(reqBo.getLoginType()) || "1".equals(reqBo.getLoginType())) {
            Integer num = (Integer)this.cacheService.get("cas" + reqBo.getLoginName());
            if (num != null && num.equals(this.loginNum)) {
                throw new ZTBusinessException("\u60a8\u5df2\u8fde\u7eed\u8f93\u5165\u9519\u8bef" + this.loginNum + "\u6b21\uff0c\u8bf724\u5c0f\u65f6\u540e\u5c1d\u8bd5");
            }
            if (num == null) {
                num = 0;
            }
            log.debug("\u5bc6\u6587:{}", (Object)reqBo.getPassWord());
            log.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
            String pwd = AesUtil.decryptStr((String)reqBo.getPassWord(), (String)this.ORIGINAL_KEY);
            if (StringUtils.isEmpty((CharSequence)pwd)) {
                throw new ZTBusinessException("\u767b\u9646\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
            }
            log.debug("\u660e\u6587:{}", (Object)pwd);
            reqBo.setPassWord(pwd);
            loginRspBo = this.verifyLogin(reqBo);
            userInfoBo = this.getLoginUserInfo(loginRspBo.getCustInfo());
        } else {
            if (!"3".equals(reqBo.getLoginType())) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            if (!this.defaultVfCode.equals(reqBo.getVfCode()) || !this.defaultVfFlag.booleanValue()) {
                String vfCode = (String)this.cacheService.get("loginVfCode" + reqBo.getUserId());
                if (StringUtils.isEmpty((CharSequence)vfCode)) {
                    throw new ZTBusinessException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                }
                if (!vfCode.equals(reqBo.getVfCode())) {
                    throw new ZTBusinessException("\u9a8c\u8bc1Id\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                }
                this.cacheService.delete("loginVfCode" + reqBo.getUserId());
                userInfoBo = this.getLoginUserInfo(reqBo.getUserId());
            } else {
                userInfoBo = this.getLoginUserInfo(reqBo.getUserId());
            }
        }
        this.cacheService.delete("cas" + reqBo.getLoginName());
        this.cacheService.delete("verificationCode" + sessionId);
        log.debug("\u65e5\u5fd7\u8bb0\u5f551:{}", (Object)JSON.toJSONString((Object)userInfoBo));
        log.debug("\u65e5\u5fd7\u8bb0\u5f552:{}", (Object)JSON.toJSONString((Object)reqBo));
        this.createLoginLog(reqBo, userInfoBo);
        loginRspBo.setUserInfo(userInfoBo);
        log.debug("\u65e5\u5fd7\u8bb0\u5f553:{}", (Object)JSON.toJSONString((Object)((Object)loginRspBo)));
        return loginRspBo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LoginRspBo verifyLogin(LoginReqBo reqBo) {
        LoginRspBo rspBo = new LoginRspBo();
        AuthGetLoginCustListReqBo loginBo = new AuthGetLoginCustListReqBo();
        loginBo.setLoginName(reqBo.getLoginName());
        boolean loginResult = false;
        AuthCustInfoBo custInfoBo = new AuthCustInfoBo();
        AuthGetLoginCustListRspBo loginRspBo = this.authGetLoginCustListService.getLoginCustInfoList(loginBo);
        if ("0000".equals(loginRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)loginRspBo.getCustInfoList())) {
            custInfoBo = (AuthCustInfoBo)loginRspBo.getCustInfoList().get(0);
            if ("2".equals(reqBo.getLoginType())) {
                VerifyCodeReqBo verifyCodeReqBo = new VerifyCodeReqBo();
                verifyCodeReqBo.setVerifyValue(reqBo.getLoginName());
                verifyCodeReqBo.setVerifyCode(reqBo.getPassWord());
                verifyCodeReqBo.setBusiKey(sendVfCodePcLogin);
                VerifyCodeRspBo verifyCodeRspBo = this.verifyCodeService.checkVerifyCodeForTemp(verifyCodeReqBo);
                if (!"0000".equals(verifyCodeRspBo.getRespCode())) throw new ZTBusinessException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                loginResult = true;
            } else if (!StringUtils.isBlank((CharSequence)custInfoBo.getInitialPassword())) {
                if (reqBo.getPassWord().equals(custInfoBo.getInitialPassword())) {
                    loginResult = true;
                }
            } else {
                loginResult = this.passwordUtils.verifyPassword(reqBo.getPassWord(), custInfoBo.getCustPassword(), custInfoBo.getPasswordSalt());
            }
        }
        if (!loginResult) {
            this.loginErrorCount(reqBo);
        }
        rspBo.setCustInfo(custInfoBo);
        return rspBo;
    }

    private void loginErrorCount(LoginReqBo reqBo) {
        Integer num = (Integer)this.cacheService.get("cas" + reqBo.getLoginName());
        if (num == null) {
            num = 0;
        }
        num = num + 1;
        this.cacheService.set("cas" + reqBo.getLoginName(), (Object)num, this.loginLockTime);
        int residualTimes = this.loginNum - num;
        String errorMessage = residualTimes > 0 ? "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + residualTimes + "\u6b21\u673a\u4f1a\uff01" : "\u60a8\u5df2\u8fde\u7eed\u8f93\u5165\u9519\u8bef" + this.loginNum + "\u6b21\uff0c\u7981\u6b62\u5f53\u524d\u7528\u6237\u767b\u5f55";
        throw new ZTBusinessException(errorMessage);
    }

    private void initParam(LoginReqBo reqBo) {
        if ("2".equals(reqBo.getLoginType())) {
            if (StringUtils.isBlank((CharSequence)reqBo.getLoginName())) {
                throw new ZTBusinessException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if ("1".equals(reqBo.getLoginType())) {
            if (StringUtils.isBlank((CharSequence)reqBo.getLoginName()) || StringUtils.isBlank((CharSequence)reqBo.getPassWord())) {
                throw new ZTBusinessException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if ("3".equals(reqBo.getLoginType())) {
            if (reqBo.getUserId() == null || reqBo.getUserId() == 0L) {
                throw new ZTBusinessException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
    }

    private AuthUserInfoBo getLoginUserInfo(AuthCustInfoBo custInfoBo) {
        AuthGetUserInfoListReqBo userReqBo = new AuthGetUserInfoListReqBo();
        userReqBo.setMainCustId(custInfoBo.getCustId());
        userReqBo.setIsMain("1");
        userReqBo.setUserStatus("1");
        AuthGetUserInfoListRspBo userRspBo = this.authGetUserInfoListService.getUserInfoList(userReqBo);
        if (!"0000".equals(userRspBo.getRespCode())) {
            throw new ZTBusinessException(userRspBo.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)userRspBo.getUserInfoList())) {
            throw new ZTBusinessException("\u7528\u6237\u88ab\u505c\u7528");
        }
        AuthUserInfoBo rspBo = (AuthUserInfoBo)userRspBo.getUserInfoList().get(0);
        AuthGetUserInfoDetailReqBo userDetailReqBo = new AuthGetUserInfoDetailReqBo();
        userDetailReqBo.setUserId(rspBo.getUserId());
        AuthGetUserInfoDetailRspBo rspInfoBo = this.authGetUserInfoDetailService.getUserInfoDetail(userDetailReqBo);
        rspBo.setCustInfo(rspInfoBo.getUserInfoBo().getCustInfo());
        List userTagList = rspInfoBo.getUserInfoBo().getUserTagRelList();
        AuthGetOrgInfoDetailReqBo orgReqBo = new AuthGetOrgInfoDetailReqBo();
        orgReqBo.setOrgId(rspBo.getOrgId());
        AuthGetOrgInfoDetailRspBo orgDetailRspBo = this.authGetOrgInfoDetailService.getOrgInfoDetail(orgReqBo);
        if (orgDetailRspBo != null && orgDetailRspBo.getOrgInfoBo() != null) {
            if ("0".equals(orgDetailRspBo.getOrgInfoBo().getOrgStatus())) {
                throw new ZTBusinessException("\u7528\u6237\u673a\u6784\u72b6\u6001\u5f02\u5e38");
            }
        } else {
            throw new ZTBusinessException("\u7528\u6237\u673a\u6784\u72b6\u6001\u5f02\u5e38");
        }
        List orgTagList = orgDetailRspBo.getOrgInfoBo().getOrgTagList();
        int i = 0;
        if (!CollectionUtils.isEmpty((Collection)orgTagList) && !CollectionUtils.isEmpty((Collection)userTagList)) {
            for (AuthUserTagRelBo userTag : userTagList) {
                for (AuthOrgTagRelBo orgTag : orgTagList) {
                    if (!userTag.getTagId().equals(orgTag.getTagId())) continue;
                    if (i == 0) {
                        rspBo.setUserDefaltTag(String.valueOf(userTag.getTagId()));
                    }
                    if ("1".equals(userTag.getIsDefalt())) {
                        rspBo.setUserDefaltTag(String.valueOf(userTag.getTagId()));
                        return rspBo;
                    }
                    ++i;
                }
            }
        }
        return rspBo;
    }

    private AuthUserInfoBo getLoginUserInfo(Long userId) {
        AuthGetUserInfoListReqBo userReqBo = new AuthGetUserInfoListReqBo();
        userReqBo.setUserId(userId);
        userReqBo.setUserStatus("1");
        AuthGetUserInfoListRspBo userRspBo = this.authGetUserInfoListService.getUserInfoList(userReqBo);
        if (CollectionUtils.isEmpty((Collection)userRspBo.getUserInfoList())) {
            throw new ZTBusinessException("\u7528\u6237\u88ab\u505c\u7528");
        }
        AuthUserInfoBo rspBo = (AuthUserInfoBo)userRspBo.getUserInfoList().get(0);
        AuthGetUserInfoDetailReqBo userDetailReqBo = new AuthGetUserInfoDetailReqBo();
        userDetailReqBo.setUserId(rspBo.getUserId());
        AuthGetUserInfoDetailRspBo rspInfoBo = this.authGetUserInfoDetailService.getUserInfoDetail(userDetailReqBo);
        rspBo.setCustInfo(rspInfoBo.getUserInfoBo().getCustInfo());
        List userTagList = rspInfoBo.getUserInfoBo().getUserTagRelList();
        AuthGetOrgInfoDetailReqBo orgReqBo = new AuthGetOrgInfoDetailReqBo();
        orgReqBo.setOrgId(rspBo.getOrgId());
        AuthGetOrgInfoDetailRspBo orgDetailRspBo = this.authGetOrgInfoDetailService.getOrgInfoDetail(orgReqBo);
        if (orgDetailRspBo != null && orgDetailRspBo.getOrgInfoBo() != null) {
            if ("0".equals(orgDetailRspBo.getOrgInfoBo().getOrgStatus())) {
                throw new ZTBusinessException("\u7528\u6237\u673a\u6784\u72b6\u6001\u5f02\u5e38");
            }
        } else {
            throw new ZTBusinessException("\u7528\u6237\u673a\u6784\u72b6\u6001\u5f02\u5e38");
        }
        List orgTagList = orgDetailRspBo.getOrgInfoBo().getOrgTagList();
        if (!CollectionUtils.isEmpty((Collection)orgTagList) && !CollectionUtils.isEmpty((Collection)userTagList)) {
            int i = 0;
            for (AuthUserTagRelBo userTag : userTagList) {
                for (AuthOrgTagRelBo orgTag : orgTagList) {
                    if (!userTag.getTagId().equals(orgTag.getTagId())) continue;
                    if (i == 0) {
                        rspBo.setUserDefaltTag(String.valueOf(userTag.getTagId()));
                    }
                    if ("1".equals(userTag.getIsDefalt())) {
                        rspBo.setUserDefaltTag(String.valueOf(userTag.getTagId()));
                        return rspBo;
                    }
                    ++i;
                }
            }
        }
        return rspBo;
    }

    private void createLoginLog(LoginReqBo reqBo, AuthUserInfoBo userInfoBo) {
        AuthCreateLoginLogReqBo createLoginReqBo = new AuthCreateLoginLogReqBo();
        createLoginReqBo.setTenantId(userInfoBo.getTenantId());
        createLoginReqBo.setUserId(userInfoBo.getUserId());
        createLoginReqBo.setCustId(userInfoBo.getCustId());
        createLoginReqBo.setCustName(userInfoBo.getCustInfo().getCustName());
        createLoginReqBo.setOrgId(userInfoBo.getOrgId());
        createLoginReqBo.setOrgTreePath(userInfoBo.getOrgTreePath());
        createLoginReqBo.setLoginName(userInfoBo.getCustInfo().getLoginName());
        createLoginReqBo.setHost(reqBo.getIp());
        createLoginReqBo.setBrowser(reqBo.getAgent());
        createLoginReqBo.setLoginSource(reqBo.getLoginSource());
        createLoginReqBo.setCreateOperId(userInfoBo.getCreateOperId());
        createLoginReqBo.setCreateOperName(userInfoBo.getCustInfo().getCustName());
        createLoginReqBo.setUpdateOperId(userInfoBo.getCreateOperId());
        createLoginReqBo.setUpdateOperName(userInfoBo.getCustInfo().getCustName());
        this.authCreateLoginLogService.createLoginLog(createLoginReqBo);
    }
}

