/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.sysdictionary.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.atom.busicommon.api.DycAgrDicDictionaryFunction;
import com.tydic.dyc.atom.busicommon.api.DycFscDicDictionaryFunction;
import com.tydic.dyc.atom.busicommon.api.DycUccDictionaryFunction;
import com.tydic.dyc.atom.busicommon.api.DycUmcDictionaryFunction;
import com.tydic.dyc.atom.busicommon.bo.DycAgrOperateDicDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycAgrOperateDicDictionaryFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycAgrQryDicDictionaryByListFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycAgrQryDicDictionaryByListFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycFscDicDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycFscDictionaryFuncPageRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycFscDictionaryFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycFscQueryDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryAddFuncBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryAddFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryDeleteFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryDeleteFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryUpdateFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryUpdateFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUmcDicDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUmcDictionaryFuncRspBO;
import com.tydic.dyc.atom.common.member.sysdictionary.api.DycUmcQueryBypCodeBackPoFunction;
import com.tydic.dyc.atom.common.member.sysdictionary.bo.DycUmcQueryBypCodeBackPoFunctionReqBo;
import com.tydic.dyc.atom.common.member.sysdictionary.bo.DycUmcQueryBypCodeBackPoFunctionRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.common.member.sysdictionary.api.DycUmcDicDataQueryService;
import com.tydic.dyc.common.member.sysdictionary.bo.ComPesDicDataOperateReqBO;
import com.tydic.dyc.common.member.sysdictionary.bo.ComPesDicDataOperateRspBO;
import com.tydic.dyc.common.member.sysdictionary.bo.DycUmcDicCodeDataQueryRspBO;
import com.tydic.dyc.common.member.sysdictionary.bo.DycUmcDicDataQueryForControllerRspBO;
import com.tydic.dyc.common.member.sysdictionary.bo.DycUmcDicDataQueryReqBO;
import com.tydic.dyc.common.member.sysdictionary.bo.DycUmcDicDataQueryRspBO;
import com.tydic.dyc.common.member.sysdictionary.bo.DycUmcDictionaryRspDataBO;
import com.tydic.dyc.common.member.sysdictionary.bo.DycUmcPesDictionaryCodeBO;
import com.tydic.dyc.oc.service.domainservice.UocProDictionaryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryCreateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryCreateRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryDeleteReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryDeleteRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryUpdateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocProDictionaryUpdateRspBO;
import com.tydic.dyc.umc.service.sysdictionary.UmcPesDicQryListByConfigKeysService;
import com.tydic.dyc.umc.service.sysdictionary.bo.UmcPesDicConfigBo;
import com.tydic.dyc.umc.service.sysdictionary.bo.UmcPesDicQryListByConfigKeysReqBo;
import com.tydic.dyc.umc.service.sysdictionary.bo.UmcPesDicQryListByConfigKeysRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.sysdictionary.api.DycUmcDicDataQueryService"})
public class DycUmcDicDataQueryServiceImpl
implements DycUmcDicDataQueryService {
    private static final Logger log = LoggerFactory.getLogger(DycUmcDicDataQueryServiceImpl.class);
    public static final int DICTIONARY_KEY_EXPIRE = 3600;
    public static final String DICTIONARY_KEY_PREFIX = "PES_DIC_";
    public static final String RSP_CODE_SUCCESS = "0000";
    public static final String RSP_CODE_FAILURE = "9999";
    public static final String UOC_PRO_CODE = "UOC_PRO";
    public static final String UMC_PLUS_CODE = "UMC_PLUS";
    public static final String UCC_CODE = "UCC";
    public static final String FSC_CODE = "FSC";
    public static final String AGR_CODE = "AGR";
    public static final Integer QUERY = 0;
    public static final Integer INSERT = 1;
    public static final Integer UPDATE = 2;
    public static final Integer DELETE = 3;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UmcPesDicQryListByConfigKeysService umcPesDicQryListByConfigKeysService;
    @Autowired
    private DycUmcQueryBypCodeBackPoFunction dycUmcQueryBypCodeBackPoFunction;
    @Autowired
    private DycUccDictionaryFunction dycUccDictionaryFunction;
    @Autowired
    private DycFscDicDictionaryFunction dycFscDictionaryFunction;
    @Autowired
    private DycAgrDicDictionaryFunction dycAgrDicDictionaryFunction;
    @Autowired
    private UocProDictionaryService uocProDictionaryService;
    @Autowired
    private DycUmcDictionaryFunction dycUmcDictionaryFunction;
    private static Map<String, BiFunction<Integer, DycUmcPesDictionaryCodeBO, List<DycUmcPesDictionaryCodeBO>>> dicActionMap = Maps.newHashMapWithExpectedSize((int)4);

    public DycUmcDicDataQueryServiceImpl() {
        dicActionMap.put(UMC_PLUS_CODE, this::callUmcDicService);
        dicActionMap.put(UCC_CODE, this::callUccDicService);
        dicActionMap.put(FSC_CODE, this::callFscDicService);
        dicActionMap.put(AGR_CODE, this::callAgrDicService);
        dicActionMap.put(UOC_PRO_CODE, this::callUocProDicService);
    }

    @Override
    @PostMapping(value={"queryCodeList"})
    public DycUmcDicDataQueryRspBO queryCodeList(@RequestBody DycUmcDicDataQueryReqBO reqBO) {
        DycUmcDicDataQueryRspBO rspBO = new DycUmcDicDataQueryRspBO();
        if (CollectionUtils.isEmpty(reqBO.getConfigKeys())) {
            rspBO.setRespCode(RSP_CODE_FAILURE);
            rspBO.setRespDesc("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            return rspBO;
        }
        HashMap rspData = Maps.newHashMapWithExpectedSize((int)reqBO.getConfigKeys().size());
        List<String> callConfigKeys = this.cacheDataProcess(reqBO.getConfigKeys(), rspData);
        if (!CollectionUtils.isEmpty(callConfigKeys)) {
            UmcPesDicQryListByConfigKeysReqBo umcPesDicQryListByConfigKeysReqBo = new UmcPesDicQryListByConfigKeysReqBo();
            umcPesDicQryListByConfigKeysReqBo.setCallConfigKeys(callConfigKeys);
            log.info("umcPesDicQryListByConfigKeysAbilityReqBO ===================================" + umcPesDicQryListByConfigKeysReqBo.toString());
            UmcPesDicQryListByConfigKeysRspBo umcPesDicQryListByConfigKeysAbilityRspBO = this.umcPesDicQryListByConfigKeysService.qryPesDicListByConfigKeys(umcPesDicQryListByConfigKeysReqBo);
            log.info("umcPesDicQryListByConfigKeysAbilityRspBO ===================================" + umcPesDicQryListByConfigKeysAbilityRspBO.toString());
            List configList = umcPesDicQryListByConfigKeysAbilityRspBO.getConfigList();
            if (CollectionUtils.isEmpty((Collection)configList)) {
                rspBO.setRespCode(RSP_CODE_FAILURE);
                rspBO.setRespDesc("\u83b7\u53d6\u5b57\u5178\u914d\u7f6e\u4e3a\u7a7a\uff0ccallConfigKeys=" + callConfigKeys.toString());
                return rspBO;
            }
            Map<String, UmcPesDicConfigBo> dicMap = configList.stream().collect(Collectors.toMap(UmcPesDicConfigBo::getConfigKey, Function.identity()));
            HashMap<String, UmcPesDicConfigBo> pCodeMap = new HashMap<String, UmcPesDicConfigBo>();
            for (UmcPesDicConfigBo comPesDicConfigPO : configList) {
                pCodeMap.put(comPesDicConfigPO.getPCode(), comPesDicConfigPO);
            }
            pCodeMap.keySet().forEach(pCodeKey -> this.cacheClient.delete(pCodeKey));
            log.info("dicMap =======================================" + dicMap.toString());
            log.info("callConfigKeys ======================================" + callConfigKeys.toString());
            log.info("\u7f13\u5b58rspData ======================================" + ((Object)rspData).toString());
            this.dicDataProcess(callConfigKeys, dicMap, rspData);
            log.info("\u4e2d\u5fc3\u5b57\u5178rspData ======================================" + ((Object)rspData).toString());
        }
        ArrayList<DycUmcDictionaryRspDataBO> data = new ArrayList<DycUmcDictionaryRspDataBO>();
        rspData.keySet().forEach(key -> {
            DycUmcDictionaryRspDataBO rspDataBO = new DycUmcDictionaryRspDataBO();
            rspDataBO.setConfigKey((String)key);
            rspDataBO.setCodeList((List)rspData.get(key));
            data.add(rspDataBO);
        });
        rspBO.setData(data);
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("\u83b7\u53d6\u6570\u636e\u6210\u529f");
        return rspBO;
    }

    @Override
    @PostMapping(value={"queryCodeListCode"})
    public DycUmcDicCodeDataQueryRspBO queryCodeListCode(@RequestBody DycUmcDicDataQueryReqBO reqBO) {
        DycUmcDicDataQueryRspBO dycUmcDicDataQueryRspBO = this.queryCodeList(reqBO);
        DycUmcDicCodeDataQueryRspBO rspBO = new DycUmcDicCodeDataQueryRspBO();
        if (!CollectionUtils.isEmpty(dycUmcDicDataQueryRspBO.getData())) {
            rspBO.setData(dycUmcDicDataQueryRspBO.getData().stream().collect(Collectors.toMap(DycUmcDictionaryRspDataBO::getConfigKey, DycUmcDictionaryRspDataBO::getCodeList)));
        }
        return rspBO;
    }

    @Override
    @PostMapping(value={"dealCodeOperate"})
    public ComPesDicDataOperateRspBO dealCodeOperate(@RequestBody ComPesDicDataOperateReqBO reqBO) {
        if (reqBO.getOperateType() == null) {
            throw new ZTBusinessException("\u4f20\u5165[operateType]\u4e3a\u7a7a");
        }
        if (!(INSERT.equals(reqBO.getOperateType()) || UPDATE.equals(reqBO.getOperateType()) || DELETE.equals(reqBO.getOperateType()))) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b[operateType]");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCenter())) {
            throw new ZTBusinessException("\u4f20\u5165[center]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getConfigKey())) {
            throw new ZTBusinessException("\u4f20\u5165[configKey]\u4e3a\u7a7a");
        }
        if (dicActionMap.get(reqBO.getCenter()) == null) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + reqBO.getCenter());
        }
        DycUmcPesDictionaryCodeBO dictionaryCode = (DycUmcPesDictionaryCodeBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO.getDictionaryCode()), DycUmcPesDictionaryCodeBO.class));
        if (StringUtils.isEmpty((Object)dictionaryCode.getCode()) || dictionaryCode.getCode().trim().length() < 1) {
            throw new ZTBusinessException("\u4f20\u5165\u7f16\u7801\u4e3a\u7a7a" + reqBO.getCenter());
        }
        if (StringUtils.isEmpty((Object)dictionaryCode.getTitle()) || dictionaryCode.getTitle().trim().length() < 1) {
            throw new ZTBusinessException("\u4f20\u5165\u5b57\u5178\u4e3a\u7a7a" + reqBO.getCenter());
        }
        List<DycUmcPesDictionaryCodeBO> rspInfo = dicActionMap.get(reqBO.getCenter()).apply(reqBO.getOperateType(), dictionaryCode);
        ComPesDicDataOperateRspBO rspBO = new ComPesDicDataOperateRspBO();
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return rspBO;
    }

    @Override
    @PostMapping(value={"queryCodeListNoAuth"})
    public DycUmcDicDataQueryForControllerRspBO queryCodeListNoAuth(@RequestBody DycUmcDicDataQueryReqBO reqBO) {
        DycUmcDicDataQueryRspBO dycUmcDicDataQueryRspBO = this.queryCodeList(reqBO);
        DycUmcDicDataQueryForControllerRspBO controllerRspBO = new DycUmcDicDataQueryForControllerRspBO();
        HashedMap data1 = new HashedMap();
        if (!CollectionUtils.isEmpty(dycUmcDicDataQueryRspBO.getData())) {
            dycUmcDicDataQueryRspBO.getData().forEach(arg_0 -> DycUmcDicDataQueryServiceImpl.lambda$queryCodeListNoAuth$2((Map)data1, arg_0));
            controllerRspBO.setData((Map<String, List<DycUmcPesDictionaryCodeBO>>)data1);
        }
        controllerRspBO.setData1(dycUmcDicDataQueryRspBO.getData());
        controllerRspBO.setRespCode(RSP_CODE_SUCCESS);
        controllerRspBO.setRespDesc("\u6210\u529f");
        return controllerRspBO;
    }

    private List<DycUmcPesDictionaryCodeBO> callAgrDicService(Integer operateType, DycUmcPesDictionaryCodeBO dictionaryCode) {
        DycUmcPesDictionaryCodeBO rspBO = new DycUmcPesDictionaryCodeBO();
        log.info("dictionaryCode ================================" + dictionaryCode.toString());
        if (QUERY.equals(operateType)) {
            DycAgrQryDicDictionaryByListFuncReqBO dycAgrQryDicDictionaryByListFuncReqBO = new DycAgrQryDicDictionaryByListFuncReqBO();
            dycAgrQryDicDictionaryByListFuncReqBO.setPcodenew(dictionaryCode.getPCode());
            log.info("dycAgrQryDicDictionaryByListFuncReqBO =================================" + dycAgrQryDicDictionaryByListFuncReqBO.toString());
            DycAgrQryDicDictionaryByListFuncRspBO dycAgrQryDicDictionaryByListFuncRspBO = this.dycAgrDicDictionaryFunction.queryDicDictionaryByList(dycAgrQryDicDictionaryByListFuncReqBO);
            List rows = dycAgrQryDicDictionaryByListFuncRspBO.getRows();
            return CollectionUtils.isEmpty((Collection)rows) ? Lists.newArrayList() : JUtil.jsl((List)rows, DycUmcPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            DycAgrOperateDicDictionaryFuncReqBO dycAgrOperateDicDictionaryFuncReqBO = new DycAgrOperateDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)dycAgrOperateDicDictionaryFuncReqBO);
            dycAgrOperateDicDictionaryFuncReqBO.setOperType(Integer.valueOf(1));
            dycAgrOperateDicDictionaryFuncReqBO.setPcodenew(dictionaryCode.getPCode());
            DycAgrOperateDicDictionaryFuncRspBO dycAgrOperateDicDictionaryFuncRspBO = this.dycAgrDicDictionaryFunction.operateDicDictionary(dycAgrOperateDicDictionaryFuncReqBO);
            rspBO.setRespCode(dycAgrOperateDicDictionaryFuncRspBO.getRespCode());
            rspBO.setRespDesc(dycAgrOperateDicDictionaryFuncRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            DycAgrOperateDicDictionaryFuncReqBO dycAgrOperateDicDictionaryFuncReqBO = new DycAgrOperateDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)dycAgrOperateDicDictionaryFuncReqBO);
            dycAgrOperateDicDictionaryFuncReqBO.setOperType(Integer.valueOf(3));
            dycAgrOperateDicDictionaryFuncReqBO.setPcodenew(dictionaryCode.getPCode());
            DycAgrOperateDicDictionaryFuncRspBO dycAgrOperateDicDictionaryFuncRspBO = this.dycAgrDicDictionaryFunction.operateDicDictionary(dycAgrOperateDicDictionaryFuncReqBO);
            rspBO.setRespCode(dycAgrOperateDicDictionaryFuncRspBO.getRespCode());
            rspBO.setRespDesc(dycAgrOperateDicDictionaryFuncRspBO.getRespDesc());
        } else {
            DycAgrOperateDicDictionaryFuncReqBO dycAgrOperateDicDictionaryFuncReqBO = new DycAgrOperateDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)dycAgrOperateDicDictionaryFuncReqBO);
            dycAgrOperateDicDictionaryFuncReqBO.setOperType(Integer.valueOf(2));
            dycAgrOperateDicDictionaryFuncReqBO.setPcodenew(dictionaryCode.getPCode());
            DycAgrOperateDicDictionaryFuncRspBO dycAgrOperateDicDictionaryFuncRspBO = this.dycAgrDicDictionaryFunction.operateDicDictionary(dycAgrOperateDicDictionaryFuncReqBO);
            rspBO.setRespCode(dycAgrOperateDicDictionaryFuncRspBO.getRespCode());
            rspBO.setRespDesc(dycAgrOperateDicDictionaryFuncRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<DycUmcPesDictionaryCodeBO> callUocProDicService(Integer operateType, DycUmcPesDictionaryCodeBO dictionaryCode) {
        DycUmcPesDictionaryCodeBO rspBO = new DycUmcPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            UocProDictionaryReqBO reqBO = new UocProDictionaryReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            UocProDictionaryRspBO qryRspBO = this.uocProDictionaryService.qryDic(reqBO);
            List rspList = qryRspBO.getRows();
            return CollectionUtils.isEmpty((Collection)rspList) ? Lists.newArrayList() : JUtil.jsl((List)rspList, DycUmcPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            UocProDictionaryCreateReqBO reqBO = new UocProDictionaryCreateReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPCode(dictionaryCode.getPCode());
            UocProDictionaryCreateRspBO addRspBO = this.uocProDictionaryService.createDic(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            UocProDictionaryUpdateReqBO reqBO = new UocProDictionaryUpdateReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPCode(dictionaryCode.getPCode());
            UocProDictionaryUpdateRspBO updateRspBO = this.uocProDictionaryService.updateDic(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            UocProDictionaryDeleteReqBO reqBO = new UocProDictionaryDeleteReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            UocProDictionaryDeleteRspBO delRspBO = this.uocProDictionaryService.deleteDic(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<DycUmcPesDictionaryCodeBO> callUmcDicService(Integer operateType, DycUmcPesDictionaryCodeBO dictionaryCode) {
        DycUmcPesDictionaryCodeBO rspBO = new DycUmcPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            DycUmcQueryBypCodeBackPoFunctionReqBo reqBO = new DycUmcQueryBypCodeBackPoFunctionReqBo();
            reqBO.setPCode(dictionaryCode.getPCode());
            DycUmcQueryBypCodeBackPoFunctionRspBo qryRspBO = this.dycUmcQueryBypCodeBackPoFunction.queryBypCodeBackPo(reqBO);
            log.info("umc:{}", (Object)JUtil.jsl((List)qryRspBO.getData(), DycUmcPesDictionaryCodeBO.class));
            return CollectionUtils.isEmpty((Collection)qryRspBO.getData()) ? Lists.newArrayList() : JUtil.jsl((List)qryRspBO.getData(), DycUmcPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            DycUmcDicDictionaryFuncReqBO reqBO = new DycUmcDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            DycUmcDictionaryFuncRspBO addRspBO = this.dycUmcDictionaryFunction.addDicDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            DycUmcDicDictionaryFuncReqBO reqBO = new DycUmcDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            DycUmcDictionaryFuncRspBO updateRspBO = this.dycUmcDictionaryFunction.updateDicDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            DycUmcDicDictionaryFuncReqBO reqBO = new DycUmcDicDictionaryFuncReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            DycUmcDictionaryFuncRspBO delRspBO = this.dycUmcDictionaryFunction.deleteDicDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<DycUmcPesDictionaryCodeBO> callUccDicService(Integer operateType, DycUmcPesDictionaryCodeBO dictionaryCode) {
        DycUmcPesDictionaryCodeBO rspBO = new DycUmcPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            DycUccDictionaryFuncReqBO reqBO = new DycUccDictionaryFuncReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            DycUccDictionaryFuncRspBO qryRspBO = this.dycUccDictionaryFunction.queryDictionary(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : JUtil.jsl((List)qryRspBO.getRows(), DycUmcPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            DycUccDictionaryAddFuncBO reqBO = new DycUccDictionaryAddFuncBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            DycUccDictionaryAddFuncRspBO addRspBO = this.dycUccDictionaryFunction.insertDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            DycUccDictionaryUpdateFuncReqBO reqBO = new DycUccDictionaryUpdateFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            DycUccDictionaryUpdateFuncRspBO updateRspBO = this.dycUccDictionaryFunction.updateDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            DycUccDictionaryDeleteFuncReqBO reqBO = new DycUccDictionaryDeleteFuncReqBO();
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            DycUccDictionaryDeleteFuncRspBO delRspBO = this.dycUccDictionaryFunction.deleteDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<DycUmcPesDictionaryCodeBO> callFscDicService(Integer operateType, DycUmcPesDictionaryCodeBO dictionaryCode) {
        DycUmcPesDictionaryCodeBO rspBO = new DycUmcPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            DycFscQueryDictionaryFuncReqBO reqBO = new DycFscQueryDictionaryFuncReqBO();
            reqBO.setPcode(dictionaryCode.getPCode());
            DycFscDictionaryFuncPageRspBO qryRspBO = this.dycFscDictionaryFunction.queryBypCodeBackPo(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : JUtil.jsl((List)qryRspBO.getRows(), DycUmcPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            DycFscDicDictionaryFuncReqBO reqBO = new DycFscDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            DycFscDictionaryFuncRspBO addRspBO = this.dycFscDictionaryFunction.addDicDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            DycFscDicDictionaryFuncReqBO reqBO = new DycFscDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            DycFscDictionaryFuncRspBO updateRspBO = this.dycFscDictionaryFunction.updateDicDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            DycFscDicDictionaryFuncReqBO reqBO = new DycFscDicDictionaryFuncReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            DycFscDictionaryFuncRspBO delRspBO = this.dycFscDictionaryFunction.deleteDicDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private void dicDataProcess(List<String> configKeys, Map<String, UmcPesDicConfigBo> dicMap, Map<String, List<DycUmcPesDictionaryCodeBO>> rspData) {
        for (String configKey : configKeys) {
            if (dicMap.get(configKey) == null) {
                rspData.put(configKey, Lists.newArrayList());
                log.error("\u672a\u83b7\u53d6\u5230\u5b57\u5178\u914d\u7f6e\uff0cconfigKey=" + configKey);
                continue;
            }
            UmcPesDicConfigBo dicInfo = dicMap.get(configKey);
            if (dicActionMap.get(dicInfo.getCenter()) == null) {
                rspData.put(configKey, Lists.newArrayList());
                log.error("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + dicInfo.getCenter());
                continue;
            }
            DycUmcPesDictionaryCodeBO param = new DycUmcPesDictionaryCodeBO();
            param.setPCode(dicInfo.getPCode());
            List<DycUmcPesDictionaryCodeBO> dicList = dicActionMap.get(dicInfo.getCenter()).apply(QUERY, param);
            log.info("dicList--------------------->:{}", (Object)JSON.toJSONString(dicList));
            rspData.put(configKey, dicList);
            if (!CollectionUtils.isEmpty(dicList)) continue;
            log.info("{}\u5b57\u5178\u670d\u52a1\u672a\u8fd4\u56de\u5b57\u5178\u6570\u636e\uff0cpCode={}", (Object)dicInfo.getCenter(), (Object)dicInfo.getPCode());
        }
    }

    private List<String> cacheDataProcess(List<String> configKeys, Map<String, List<DycUmcPesDictionaryCodeBO>> rspData) {
        ArrayList notExistsKeys = Lists.newArrayListWithExpectedSize((int)configKeys.size());
        for (String configKey : configKeys) {
            notExistsKeys.add(configKey);
        }
        return notExistsKeys;
    }

    private static /* synthetic */ void lambda$queryCodeListNoAuth$2(Map data1, DycUmcDictionaryRspDataBO e) {
        data1.put(e.getConfigKey(), e.getCodeList());
    }
}

