/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.utils;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";
    private static final String FONT_NAME = "\u5fae\u8f6f\u96c5\u9ed1";
    public static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);
    private static final String PATH = "dyc-common";
    @Value(value="${plugin.file.type}")
    private static String fileType;
    @Value(value="${oss.fileUrl:}")
    private static String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private static String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private static String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private static String fastdfsDownloadUrl;

    public static void getExcelDate(String path, List<List<String>> data, Integer readLine, Integer sheetAt) throws Exception {
        int count = 1;
        try {
            URL url = new URL(path);
            File file = new File(url.getFile());
            InputStream inputStream = url.openStream();
            ExcelUtils.checkExcelVaild(path);
            Workbook workbook = ExcelUtils.getWorkbok(path, inputStream);
            Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
            int end = sheet.getRow(sheetAt.intValue()).getLastCellNum();
            logger.debug("\u622a\u6b62\u5217\u4e3a\u7b2c\uff1a" + end + "\u5217");
            logger.debug("\u4ece\u7b2c\uff1a" + readLine + "\u884c\u5f00\u59cb\u8bfb\u53d6");
            for (Row row : sheet) {
                ArrayList<String> c = new ArrayList<String>();
                if (row.getCell(0) == null || "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    if (count < readLine) continue;
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                data.add(c);
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7b2c" + count + "\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private static void checkExcelVaild(String filePath) throws Exception {
        if (filePath == null) {
            return;
        }
        String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private static Workbook getWorkbok(String filePath, InputStream inputStream) throws IOException {
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new IOException("\u6587\u4ef6\u4e0d\u662fExcel");
        }
        HSSFWorkbook wb = null;
        if (EXCEL_XLS.equals(extString)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (EXCEL_XLSX.equals(extString)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        cell.setCellType(CellType.STRING);
        switch (cell.getCellType()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }

    public static CellStyle setHeadCellStyle(SXSSFWorkbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName(FONT_NAME);
        font.setFontHeightInPoints((short)12);
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.PALE_BLUE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static CellStyle setBodyCellStyle(SXSSFWorkbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName(FONT_NAME);
        font.setFontHeightInPoints((short)12);
        font.setColor((short)Short.MAX_VALUE);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static void createHeadContent(SXSSFSheet sheet, CellStyle cellStyle, List<Map<String, Object>> mapList, boolean flag, SXSSFWorkbook workbook) {
        if (mapList != null && mapList.size() > 0) {
            HashMap map = new HashMap();
            for (Map<String, Object> aMapList : mapList) {
                map = map.size() > aMapList.size() ? map : aMapList;
            }
            if (flag) {
                CellStyle headStyle2 = ExcelUtils.setBodyCellStyle(workbook);
                Font font = workbook.createFont();
                font.setBold(true);
                font.setFontName(FONT_NAME);
                font.setFontHeightInPoints((short)12);
                font.setColor((short)Short.MAX_VALUE);
                headStyle2.setFont(font);
                SXSSFRow rowHerder = sheet.createRow(0);
                SXSSFCell cell = rowHerder.createCell(0);
                cell.setCellStyle(headStyle2);
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 11));
                cell.setCellValue("\u7535\u5b50\u8d85\u5e02_\u5546\u54c1\u6e05\u5355");
                SXSSFRow row2 = sheet.createRow(1);
                Set keySet = map.keySet();
                Iterator iterator = keySet.iterator();
                int col = 0;
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    SXSSFCell cell2 = row2.createCell(col);
                    cell2.setCellStyle(cellStyle);
                    cell2.setCellValue(StringUtils.isBlank((CharSequence)key) ? "" : key);
                    ++col;
                }
            } else {
                cellStyle.setFillPattern(FillPatternType.NO_FILL);
                SXSSFRow row = sheet.createRow(0);
                Set keySet = map.keySet();
                Iterator iterator = keySet.iterator();
                int col = 0;
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    SXSSFCell cell = row.createCell(col);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(StringUtils.isBlank((CharSequence)key) ? "" : key);
                    ++col;
                }
            }
        } else {
            logger.error("\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static void createHeadContent(SXSSFSheet sheet, CellStyle cellStyle, List<Map<String, Object>> mapList, boolean flag, SXSSFWorkbook workbook, String headTile, Integer headLength) {
        if (mapList != null && mapList.size() > 0) {
            HashMap map = new HashMap();
            for (Map<String, Object> aMapList : mapList) {
                map = map.size() > aMapList.size() ? map : aMapList;
            }
            if (flag) {
                CellStyle headStyle2 = ExcelUtils.setBodyCellStyle(workbook);
                Font font = workbook.createFont();
                font.setBold(true);
                font.setFontName(FONT_NAME);
                font.setFontHeightInPoints((short)12);
                font.setColor((short)Short.MAX_VALUE);
                headStyle2.setFont(font);
                SXSSFRow rowHerder = sheet.createRow(0);
                SXSSFCell cell = rowHerder.createCell(0);
                cell.setCellStyle(headStyle2);
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headLength - 1));
                cell.setCellValue(headTile);
                SXSSFRow row2 = sheet.createRow(1);
                Set keySet = map.keySet();
                Iterator iterator = keySet.iterator();
                int col = 0;
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    SXSSFCell cell2 = row2.createCell(col);
                    cell2.setCellStyle(cellStyle);
                    cell2.setCellValue(StringUtils.isBlank((CharSequence)key) ? "" : key);
                    ++col;
                }
            } else {
                cellStyle.setFillPattern(FillPatternType.NO_FILL);
                SXSSFRow row = sheet.createRow(0);
                Set keySet = map.keySet();
                Iterator iterator = keySet.iterator();
                int col = 0;
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    SXSSFCell cell = row.createCell(col);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(StringUtils.isBlank((CharSequence)key) ? "" : key);
                    ++col;
                }
            }
        } else {
            logger.error("\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static void createBodyContent(SXSSFSheet sheet, CellStyle cellStyle, List<Map<String, Object>> mapList, boolean flag, SXSSFWorkbook workbook, BigDecimal totalPrice) {
        if (mapList != null && !mapList.isEmpty()) {
            if (!flag) {
                return;
            }
            Map<String, Object> map = null;
            int j = 1;
            if (flag) {
                j = 2;
            }
            for (int i = 0; i < mapList.size(); ++i) {
                map = mapList.get(i);
                SXSSFRow row = sheet.createRow(i + j);
                Set<String> keySet = map.keySet();
                Iterator<String> iterator = keySet.iterator();
                int col = 0;
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    Object object = map.get(key);
                    SXSSFCell cell = row.createCell(col);
                    cell.setCellValue(object == null ? "" : object.toString());
                    cell.setCellStyle(cellStyle);
                    ++col;
                }
                map.clear();
            }
            if (flag) {
                CellStyle headStyle2 = ExcelUtils.setBodyCellStyle(workbook);
                headStyle2.setAlignment(HorizontalAlignment.RIGHT);
                headStyle2.setVerticalAlignment(VerticalAlignment.TOP);
                SXSSFRow row2 = sheet.createRow(mapList.size() + 2);
                SXSSFCell cell2 = row2.createCell(0);
                cell2.setCellStyle(headStyle2);
                sheet.addMergedRegion(new CellRangeAddress(mapList.size() + 2, mapList.size() + 2, 0, 11));
                cell2.setCellValue("\u603b\u4ef7\u5408\u8ba1\uff1a" + totalPrice);
            }
            mapList.clear();
            mapList = null;
        } else {
            logger.error("\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static void createImportBodyContent(SXSSFSheet sheet, CellStyle cellStyle, List<Map<String, Object>> mapList, boolean flag, SXSSFWorkbook workbook) {
        if (mapList != null && !mapList.isEmpty()) {
            if (!flag) {
                return;
            }
            Map<String, Object> map = null;
            int j = 1;
            for (int i = 0; i < mapList.size(); ++i) {
                map = mapList.get(i);
                SXSSFRow row = sheet.createRow(i + j);
                Set<String> keySet = map.keySet();
                Iterator<String> iterator = keySet.iterator();
                int col = 0;
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    Object object = map.get(key);
                    SXSSFCell cell = row.createCell(col);
                    cell.setCellValue(object == null ? "" : object.toString());
                    cell.setCellStyle(cellStyle);
                    ++col;
                }
                map.clear();
            }
            mapList.clear();
            mapList = null;
        } else {
            logger.error("\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static SXSSFWorkbook createWorkbook(List<Map<String, Object>> data, String name, boolean flag, BigDecimal totalPrice) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet(name);
        CellStyle headStyle = ExcelUtils.setHeadCellStyle(workbook);
        ExcelUtils.createHeadContent(sheet, headStyle, data, flag, workbook);
        CellStyle bodyStyle = ExcelUtils.setBodyCellStyle(workbook);
        ExcelUtils.createBodyContent(sheet, bodyStyle, data, flag, workbook, totalPrice);
        return workbook;
    }

    public static SXSSFWorkbook createWorkbook(List<Map<String, Object>> data, String name, boolean flag, BigDecimal totalPrice, String headTile, Integer headLength) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet(name);
        CellStyle headStyle = ExcelUtils.setHeadCellStyle(workbook);
        ExcelUtils.createHeadContent(sheet, headStyle, data, flag, workbook, headTile, headLength);
        CellStyle bodyStyle = ExcelUtils.setBodyCellStyle(workbook);
        ExcelUtils.createBodyContent(sheet, bodyStyle, data, flag, workbook, totalPrice);
        return workbook;
    }

    public static SXSSFWorkbook createImportWorkbook(List<Map<String, Object>> data, String name) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet(name);
        CellStyle headStyle = ExcelUtils.setHeadCellStyle(workbook);
        ExcelUtils.createHeadContent(sheet, headStyle, data, false, workbook);
        CellStyle bodyStyle = ExcelUtils.setBodyCellStyle(workbook);
        ExcelUtils.createImportBodyContent(sheet, bodyStyle, data, true, workbook);
        return workbook;
    }

    public static List<Map<String, String>> getExcelDate(MultipartFile file) throws Exception {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        ExcelUtils.format(title, list, result);
        return result;
    }

    public static void getExcelDate(MultipartFile file, List<List<String>> data, List<String> title) throws Exception {
        ExcelUtils.checkExcelVaild(file);
        Workbook workbook = ExcelUtils.getWorkbok(file);
        int count = 0;
        Sheet sheet = workbook.getSheetAt(0);
        for (Row row : sheet) {
            int i;
            ArrayList<String> c = new ArrayList<String>();
            int end = row.getLastCellNum();
            boolean cow = true;
            for (i = 0; i < end; ++i) {
                if (null == row.getCell(i) || "".equals(row.getCell(i).toString())) continue;
                cow = false;
                break;
            }
            if (cow) continue;
            for (i = 0; i < end; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    c.add("");
                    continue;
                }
                Object obj = ExcelUtils.getValue(cell);
                if (count == 0) {
                    title.add(String.valueOf(obj).trim());
                    continue;
                }
                if (count < 1) continue;
                c.add(String.valueOf(obj).trim());
            }
            ++count;
            if (c.size() <= 0) continue;
            ArrayList<String> d = new ArrayList<String>();
            for (String str : c) {
                if (str.endsWith(".0")) {
                    str = str.substring(0, str.length() - 2);
                }
                d.add(str);
            }
            data.add(d);
        }
    }

    private static void format(List<String> title, List<List<String>> lists, List<Map<String, String>> result) {
        for (List<String> list : lists) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < title.size(); ++i) {
                String s = title.get(i);
                if (i < list.size()) {
                    map.put(s, list.get(i));
                    continue;
                }
                map.put(s, "");
            }
            result.add(map);
        }
    }

    private static Workbook getWorkbok(MultipartFile file) throws IOException {
        HSSFWorkbook wb = null;
        if (file.getOriginalFilename().endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(file.getInputStream());
        } else if (file.getOriginalFilename().endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(file.getInputStream());
        }
        return wb;
    }

    private static void checkExcelVaild(MultipartFile file) throws Exception {
        if (!file.getOriginalFilename().endsWith(EXCEL_XLS) && !file.getOriginalFilename().endsWith(EXCEL_XLSX)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }
}

