/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.common.ability.api.UccSkuBatchAddRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuBatchAddRecordAbilityReqBO;
import com.tydic.dyc.agr.service.domainservice.AgrFlowCancelService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrFlowCancelReqBo;
import com.tydic.dyc.agr.service.domainservice.bo.AgrFlowCancelRspBo;
import com.tydic.dyc.atom.busicommon.api.DycUocGemiSendMessageAtomFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocCandidatesBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocTaskBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.common.api.DycFlowCancelService;
import com.tydic.dyc.common.bo.DyCommonReceiverBo;
import com.tydic.dyc.common.bo.DycFlowCancelReqBO;
import com.tydic.dyc.common.bo.DycFlowCancelRspBO;
import com.tydic.dyc.umc.service.todo.UmcSendRevokeTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendRevokeTodoReqBo;
import com.tydic.osworkflow.ability.OsworkflowRuntimeProcInstHandleAbilityService;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleReqBO;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleRespBO;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.api.DycFlowCancelService"})
public class DycFlowCancelServiceImpl
implements DycFlowCancelService {
    private static final Logger log = LoggerFactory.getLogger(DycFlowCancelServiceImpl.class);
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private AgrFlowCancelService agrFlowCancelService;
    @Autowired
    private UccSkuBatchAddRecordAbilityService uccSkuBatchAddRecordAbilityService;
    @Autowired
    private UmcSendRevokeTodoService umcSendRevokeTodoService;
    @Autowired
    private DycUocGemiSendMessageAtomFunction dycUocGemiSendMessageAtomFunction;
    @Autowired
    private OsworkflowRuntimeProcInstHandleAbilityService osworkflowRuntimeProcInstHandleAbilityService;

    @Override
    @PostMapping(value={"cancelFlow"})
    public DycFlowCancelRspBO cancelFlow(@RequestBody DycFlowCancelReqBO dycFlowCancelReqBO) {
        this.validParam(dycFlowCancelReqBO);
        EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
        eacRuInstAbilityReqBO.setApproveInstId(dycFlowCancelReqBO.getAuditProcInstId());
        log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5ba1\u6279\u6d41\u7ec8\u6b62\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacRuInstAbilityReqBO));
        EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5ba1\u6279\u6d41\u7ec8\u6b62\u670d\u52a1\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacRuInstAbilityRspBO));
        if (!"0000".equals(eacRuInstAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u56de\u9000\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacRuInstAbilityRspBO.getRespCode() + "\u3011," + eacRuInstAbilityRspBO.getRespDesc());
        }
        if (!StringUtils.isEmpty((Object)dycFlowCancelReqBO.getBusiProcInstId())) {
            DeleteProcInstSingleReqBO deleteProcInstSingleReqBO = new DeleteProcInstSingleReqBO();
            deleteProcInstSingleReqBO.setProcInstId(dycFlowCancelReqBO.getBusiProcInstId());
            log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u4e1a\u52a1\u6d41\u7ec8\u6b62\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)deleteProcInstSingleReqBO));
            DeleteProcInstSingleRespBO deleteProcInstSingleRespBO = this.osworkflowRuntimeProcInstHandleAbilityService.deleteProcInstSingle(deleteProcInstSingleReqBO);
            log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u4e1a\u52a1\u6d41\u7ec8\u6b62\u670d\u52a1\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)deleteProcInstSingleRespBO));
        }
        List<DycUocTaskBO> cancelTaskInfos = this.invokeBusiCenter(dycFlowCancelReqBO);
        this.recallTodo(dycFlowCancelReqBO, cancelTaskInfos);
        this.sendMessage(cancelTaskInfos, dycFlowCancelReqBO);
        return new DycFlowCancelRspBO();
    }

    private void sendMessage(List<DycUocTaskBO> cancelTaskInfos, DycFlowCancelReqBO dycFlowCancelReqBO) {
        if (!CollectionUtils.isEmpty(cancelTaskInfos)) {
            ArrayList<DyCommonReceiverBo> receiverIdList = new ArrayList<DyCommonReceiverBo>();
            for (DycUocTaskBO DycUocTaskBO2 : cancelTaskInfos) {
                if (CollectionUtils.isEmpty((Collection)DycUocTaskBO2.getCandidates())) continue;
                for (DycUocCandidatesBO dycUocCandidatesBO : DycUocTaskBO2.getCandidates()) {
                    DyCommonReceiverBo bo = new DyCommonReceiverBo();
                    bo.setReceiverId(dycUocCandidatesBO.getCandidateId());
                    bo.setReceiverName(dycUocCandidatesBO.getCandidateName());
                    receiverIdList.add(bo);
                }
            }
            if (!CollectionUtils.isEmpty(receiverIdList)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("taskCode", "audit_proc_cancel");
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("objCode", dycFlowCancelReqBO.getObjCode());
                map.put("data", dataMap);
                map.put("sendId", dycFlowCancelReqBO.getUserId());
                map.put("sendName", dycFlowCancelReqBO.getName());
                map.put("receiverIdList", JSON.toJSONString(receiverIdList));
                try {
                    this.dycUocGemiSendMessageAtomFunction.sendMessage(map);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u901a\u77e5\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private void recallTodo(DycFlowCancelReqBO dycFlowCancelReqBO, List<DycUocTaskBO> cancelTaskInfos) {
        if (!CollectionUtils.isEmpty(cancelTaskInfos)) {
            for (DycUocTaskBO dycUocTaskBO : cancelTaskInfos) {
                if (dycUocTaskBO.getFinish() == null || !dycUocTaskBO.getFinish().equals(false)) continue;
                try {
                    UmcSendRevokeTodoReqBo umcSendRevokeTodoReqBo = new UmcSendRevokeTodoReqBo();
                    umcSendRevokeTodoReqBo.setBusiId(dycUocTaskBO.getTaskId());
                    umcSendRevokeTodoReqBo.setOperUserId("" + dycFlowCancelReqBO.getUserId());
                    umcSendRevokeTodoReqBo.setOperUserName(dycFlowCancelReqBO.getName());
                    this.umcSendRevokeTodoService.revokeTodo(umcSendRevokeTodoReqBo);
                }
                catch (Exception e) {
                    log.error("\u64a4\u56de\u5f85\u529e\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private List<DycUocTaskBO> invokeBusiCenter(DycFlowCancelReqBO dycFlowCancelReqBO) {
        List<Object> cancelTaskInfos = new ArrayList<DycUocTaskBO>();
        if (dycFlowCancelReqBO.getCenter().equals("AGR")) {
            AgrFlowCancelReqBo agrFlowCancelReqBo = (AgrFlowCancelReqBo)JSON.parseObject((String)JSON.toJSONString((Object)dycFlowCancelReqBO), AgrFlowCancelReqBo.class);
            AgrFlowCancelRspBo agrFlowCancelRspBo = this.agrFlowCancelService.cancelFlow(agrFlowCancelReqBo);
            cancelTaskInfos = JSONArray.parseArray((String)JSON.toJSONString((Object)agrFlowCancelRspBo.getCancelTaskInfos()), DycUocTaskBO.class);
        }
        if (dycFlowCancelReqBO.getCenter().equals("UCC")) {
            this.skuRevoke(dycFlowCancelReqBO);
        }
        return cancelTaskInfos;
    }

    private void skuRevoke(DycFlowCancelReqBO dycFlowCancelReqBO) {
        UccSkuBatchAddRecordAbilityReqBO uccSkuBatchAddRecordAbilityReqBO = new UccSkuBatchAddRecordAbilityReqBO();
        uccSkuBatchAddRecordAbilityReqBO.setUserId(dycFlowCancelReqBO.getUserId());
        uccSkuBatchAddRecordAbilityReqBO.setName(dycFlowCancelReqBO.getName());
        uccSkuBatchAddRecordAbilityReqBO.setOrgId(dycFlowCancelReqBO.getOrgId());
        uccSkuBatchAddRecordAbilityReqBO.setOrgName(dycFlowCancelReqBO.getOrgName());
        uccSkuBatchAddRecordAbilityReqBO.setCompanyId(dycFlowCancelReqBO.getCompanyId());
        uccSkuBatchAddRecordAbilityReqBO.setCompanyName(dycFlowCancelReqBO.getCompanyName());
        uccSkuBatchAddRecordAbilityReqBO.setObjType(dycFlowCancelReqBO.getObjType());
        ArrayList<UccSkuBatchAddRecordBO> uccSkuBatchAddRecordBOS = new ArrayList<UccSkuBatchAddRecordBO>();
        UccSkuBatchAddRecordBO uccSkuBatchAddRecordBO = new UccSkuBatchAddRecordBO();
        uccSkuBatchAddRecordBO.setObjId(dycFlowCancelReqBO.getOrderId());
        uccSkuBatchAddRecordBO.setObjJson(JSON.toJSONString((Object)dycFlowCancelReqBO));
        uccSkuBatchAddRecordBOS.add(uccSkuBatchAddRecordBO);
        uccSkuBatchAddRecordAbilityReqBO.setBatchObjList(uccSkuBatchAddRecordBOS);
        this.uccSkuBatchAddRecordAbilityService.addSkuBatchDealRecord(uccSkuBatchAddRecordAbilityReqBO);
    }

    private void validParam(DycFlowCancelReqBO dycFlowCancelReqBO) {
        if (dycFlowCancelReqBO == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)dycFlowCancelReqBO.getOrderId())) {
            throw new BaseBusinessException("0001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)dycFlowCancelReqBO.getObjId())) {
            throw new BaseBusinessException("0001", "objId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)dycFlowCancelReqBO.getAuditProcInstId())) {
            throw new BaseBusinessException("0001", "auditProcInstId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)dycFlowCancelReqBO.getCenter())) {
            throw new BaseBusinessException("0001", "center\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

