/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.userapply.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.user.AuthCreateUserInfoService;
import com.tydic.dyc.authority.service.user.bo.AuthCreateUserInfoReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthCreateUserInfoRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.base.utils.SaltUtils;
import com.tydic.dyc.common.member.userapply.api.DycPersonUserRegisterService;
import com.tydic.dyc.common.member.userapply.bo.DycPersonUserRegisterReqBo;
import com.tydic.dyc.common.member.userapply.bo.DycPersonUserRegisterRspBo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcEnumConstant;
import com.tydic.dyc.umc.service.enterpriseapply.UmcEnterpriseInfoApplyAddService;
import com.tydic.dyc.umc.service.user.UmcUserInfoAddService;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoAddReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserTagRelBo;
import com.tydic.umc.security.utils.AesUtil;
import com.tydic.umc.security.utils.EncryptUtils;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.userapply.api.DycPersonUserRegisterService"})
public class DycPersonUserRegisterServiceImpl
implements DycPersonUserRegisterService {
    @Autowired
    private AuthCreateUserInfoService authCreateUserInfoService;
    @Autowired
    private UmcUserInfoAddService umcUserInfoAddService;
    @Autowired
    private UmcEnterpriseInfoApplyAddService umcEnterpriseInfoApplyAddService;
    @Autowired
    private EncryptUtils encryptUtils;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Value(value="${login.originalKey:12345678901234561234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${password.default:123456}")
    private String defaultPasswd;
    @Value(value="${role.default.purchaser:1}")
    private Long defaultPurchaserRole;
    @Value(value="${role.default.supplier:2}")
    private Long defaultSupplierRole;
    @Value(value="${purchaser.tag:1}")
    private String PURCHASER_TAG;
    @Value(value="${supplier.tag:2}")
    private String SUPPLIER_TAG;
    private static final Logger LOGGER = LoggerFactory.getLogger(DycPersonUserRegisterServiceImpl.class);
    private static final String SELF_REGISTRATION = "2";
    private static final String PURCHASE = "1";
    private static final String SALE = "2";

    @Override
    @PostMapping(value={"personUserRegister"})
    public DycPersonUserRegisterRspBo personUserRegister(@RequestBody DycPersonUserRegisterReqBo reqBo) {
        this.validReqParams(reqBo);
        DycPersonUserRegisterRspBo rspBo = new DycPersonUserRegisterRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        try {
            LOGGER.debug("\u5bc6\u6587:{}", (Object)reqBo.getPasswd());
            LOGGER.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
            String pwd = AesUtil.decryptStr((String)reqBo.getPasswd(), (String)this.ORIGINAL_KEY);
            String confirmPasswd = AesUtil.decryptStr((String)reqBo.getConfirmPasswd(), (String)this.ORIGINAL_KEY);
            LOGGER.debug("\u660e\u6587:{}", (Object)pwd);
            LOGGER.debug("\u786e\u8ba4\u5bc6\u7801\u660e\u6587:{}", (Object)confirmPasswd);
            if (org.apache.commons.lang.StringUtils.isBlank((String)pwd) || org.apache.commons.lang.StringUtils.isBlank((String)confirmPasswd)) {
                throw new ZTBusinessException("\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
            }
            if (!pwd.equals(confirmPasswd)) {
                throw new ZTBusinessException("\u4e24\u6b21\u5bc6\u7801\u4e0d\u4e00\u81f4");
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
        }
        AuthCreateUserInfoReqBo authCreateUserInfoReqBo = this.buildAuthMember(reqBo);
        AuthCreateUserInfoRspBo authCreateUserInfoRspBo = this.authCreateUserInfoService.createUserInfo(authCreateUserInfoReqBo);
        UmcUserInfoAddReqBo umcUserInfoAddReqBo = this.buildMember(reqBo, authCreateUserInfoRspBo.getUserInfoBo());
        this.umcUserInfoAddService.createUserInfo(umcUserInfoAddReqBo);
        return rspBo;
    }

    private void validReqParams(DycPersonUserRegisterReqBo reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRegAccount())) {
            throw new ZTBusinessException("\u6ce8\u518c\u8d26\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getCustName())) {
            throw new ZTBusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == reqBo.getSex()) {
            throw new ZTBusinessException("\u6027\u522b\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRegMobile())) {
            throw new ZTBusinessException("\u6ce8\u518c\u7535\u8bdd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRegEmail())) {
            throw new ZTBusinessException("\u6ce8\u518c\u90ae\u7bb1\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getSmsCheck())) {
            throw new ZTBusinessException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPasswd())) {
            throw new ZTBusinessException("\u767b\u5f55\u5bc6\u7801\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getTradeCapacity())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u8d38\u6613\u8eab\u4efd\u4e3a\u7a7a");
        }
        if (null == reqBo.getCertType()) {
            throw new ZTBusinessException("\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == reqBo.getCertNo()) {
            throw new ZTBusinessException("\u8bc1\u4ef6\u53f7\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrgCodeWeb())) {
            throw new ZTBusinessException("\u673a\u6784\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrgAliasWeb())) {
            throw new ZTBusinessException("\u673a\u6784\u7b80\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrgNameWeb())) {
            throw new ZTBusinessException("\u673a\u6784\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getIndustry())) {
            throw new ZTBusinessException("\u6240\u5c5e\u884c\u4e1a\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPasswd())) {
            if (StringUtils.isEmpty((Object)reqBo.getConfirmPasswd())) {
                throw new ZTBusinessException("\u786e\u8ba4\u5bc6\u7801\u4e3a\u7a7a");
            }
            if (!reqBo.getPasswd().equals(reqBo.getConfirmPasswd())) {
                throw new ZTBusinessException("\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u4e00\u81f4");
            }
        }
    }

    private AuthCreateUserInfoReqBo buildAuthMember(DycPersonUserRegisterReqBo reqBo) {
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        ArrayList<String> tagIdList = new ArrayList<String>();
        for (String s : reqBo.getTradeCapacity()) {
            if (PURCHASE.equals(s)) {
                roleIdList.add(this.defaultSupplierRole);
                tagIdList.add(this.PURCHASER_TAG);
            }
            if (!"2".equals(s)) continue;
            roleIdList.add(this.defaultPurchaserRole);
            tagIdList.add(this.SUPPLIER_TAG);
        }
        reqBo.setRoleIdList(roleIdList);
        reqBo.setTagIdList(tagIdList);
        AuthCreateUserInfoReqBo authCreateUserInfoReqBo = new AuthCreateUserInfoReqBo();
        authCreateUserInfoReqBo.setOrgId(reqBo.getOrgIdWeb());
        authCreateUserInfoReqBo.setIsMain(PURCHASE);
        authCreateUserInfoReqBo.setCreateTime(new Date());
        authCreateUserInfoReqBo.setCreateOperId(reqBo.getUserIdIn());
        authCreateUserInfoReqBo.setCreateOperName(reqBo.getCustNameIn());
        AuthCustInfoBo authCustInfoBo = new AuthCustInfoBo();
        authCustInfoBo.setLoginName(reqBo.getRegAccount());
        String password = reqBo.getPassword();
        if (StringUtils.isEmpty((Object)password)) {
            password = this.defaultPasswd;
        }
        String encrypt = this.encryptUtils.encryptByType(password, this.encryptType);
        String salt = SaltUtils.getSerialNo((int)8);
        String pwd = this.encryptUtils.encryptByType(encrypt + salt, this.encryptType);
        authCustInfoBo.setCustPassword(pwd);
        authCustInfoBo.setPasswordSalt(salt);
        authCustInfoBo.setCustName(reqBo.getCustName());
        authCustInfoBo.setCellPhone(reqBo.getRegMobile());
        authCustInfoBo.setCustEmail(reqBo.getRegEmail());
        authCustInfoBo.setCustStatus("01");
        authCustInfoBo.setCustSource("2");
        authCustInfoBo.setCreateOperId(reqBo.getUserIdIn());
        authCustInfoBo.setCreateOperName(reqBo.getCustNameIn());
        authCustInfoBo.setCreateTime(new Date());
        authCreateUserInfoReqBo.setCustInfo(authCustInfoBo);
        ArrayList<AuthDistributeBo> authDistributeBoList = new ArrayList<AuthDistributeBo>();
        if (!CollectionUtils.isEmpty(reqBo.getRoleIdList())) {
            for (Long roleId : reqBo.getRoleIdList()) {
                AuthDistributeBo authDistributeBo = new AuthDistributeBo();
                authDistributeBo.setRoleId(roleId);
                authDistributeBo.setOrgId(reqBo.getOrgIdWeb());
                authDistributeBo.setCreateOperId(reqBo.getUserIdIn());
                authDistributeBo.setCreateTime(new Date());
                authDistributeBo.setCreateOperName(reqBo.getCustNameIn());
                authDistributeBoList.add(authDistributeBo);
            }
        }
        ArrayList<AuthUserTagRelBo> userTagRelBoList = new ArrayList<AuthUserTagRelBo>(reqBo.getTagIdList().size());
        if (!CollectionUtils.isEmpty(reqBo.getTagIdList())) {
            for (String tagId : reqBo.getTagIdList()) {
                AuthUserTagRelBo authUserTagRelBo = new AuthUserTagRelBo();
                authUserTagRelBo.setTagId(Long.valueOf(tagId));
                authUserTagRelBo.setCreateOperId(reqBo.getUserIdIn());
                authUserTagRelBo.setCreateTime(new Date());
                authUserTagRelBo.setCreateOperName(reqBo.getCustNameIn());
                userTagRelBoList.add(authUserTagRelBo);
            }
        }
        authCreateUserInfoReqBo.setUserTagRelList(userTagRelBoList);
        authCreateUserInfoReqBo.setAuthDistributeList(authDistributeBoList);
        return authCreateUserInfoReqBo;
    }

    private UmcUserInfoAddReqBo buildMember(DycPersonUserRegisterReqBo reqBo, AuthUserInfoBo authUserInfoBo) {
        UmcUserInfoAddReqBo umcUserInfoAddReqBo = new UmcUserInfoAddReqBo();
        umcUserInfoAddReqBo.setUserId(authUserInfoBo.getUserId());
        umcUserInfoAddReqBo.setCustId(authUserInfoBo.getCustId());
        umcUserInfoAddReqBo.setMainCustId(authUserInfoBo.getCustId());
        umcUserInfoAddReqBo.setOrgId(reqBo.getOrgIdWeb());
        umcUserInfoAddReqBo.setIsMain(PURCHASE);
        UmcCustInfoBo custInfoBo = new UmcCustInfoBo();
        custInfoBo.setWorkNo(reqBo.getWorkNo());
        custInfoBo.setStopStatus("01");
        if (!StringUtils.isEmpty((Object)reqBo.getCustClassify())) {
            custInfoBo.setCustClassify("2");
        } else {
            custInfoBo.setCustClassify(reqBo.getCustClassify());
        }
        custInfoBo.setRegAccount(reqBo.getRegAccount());
        custInfoBo.setRegMobile(reqBo.getRegMobile());
        custInfoBo.setRegEmail(reqBo.getRegEmail());
        custInfoBo.setIsOnline(UmcEnumConstant.IsOnline.NO.getCode());
        custInfoBo.setCustStatus(UmcEnumConstant.CustState.EFFECTIVE.getCode());
        custInfoBo.setPasswd(reqBo.getPasswd());
        custInfoBo.setIsPasswdValid(UmcEnumConstant.IsPasswdValid.YES.getCode());
        custInfoBo.setMaxRepeatLoginNum(UmcCommConstant.UmcDefaultValue.MAX_REPEAT_LOGIN_NUM);
        custInfoBo.setCustName(reqBo.getCustName());
        custInfoBo.setSex(reqBo.getSex());
        custInfoBo.setCertNo(reqBo.getCertNo());
        custInfoBo.setCertType(UmcEnumConstant.CertType.ID_18.getCode());
        custInfoBo.setIsBlacklist(UmcEnumConstant.IsBlacklist.NO.getCode());
        custInfoBo.setCreateTime(new Date());
        custInfoBo.setCreateOperId(reqBo.getUserIdIn());
        custInfoBo.setCreateOperName(reqBo.getCustNameIn());
        umcUserInfoAddReqBo.setCustInfo(custInfoBo);
        ArrayList<UmcUserTagRelBo> userTagRelBoList = new ArrayList<UmcUserTagRelBo>(reqBo.getTagIdList().size());
        if (!CollectionUtils.isEmpty(reqBo.getTagIdList())) {
            for (String tagId : reqBo.getTagIdList()) {
                UmcUserTagRelBo umcUserTagRelBo = new UmcUserTagRelBo();
                umcUserTagRelBo.setTagId(tagId);
                umcUserTagRelBo.setCreateOperId(reqBo.getUserIdIn());
                umcUserTagRelBo.setCreateTime(new Date());
                umcUserTagRelBo.setCreateOperName(reqBo.getCustNameIn());
                userTagRelBoList.add(umcUserTagRelBo);
            }
        }
        umcUserInfoAddReqBo.setUserTagRelList(userTagRelBoList);
        return umcUserInfoAddReqBo;
    }
}

