/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.procinst.AgrSaveTodoService;
import com.tydic.dyc.agr.service.procinst.bo.AgrSaveTodoReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrSaveTodoRspBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrUocTodoBo;
import com.tydic.dyc.atom.busicommon.api.DycUocGemiSendMessageAtomFunction;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.common.api.DycSendBusiProcessTodoService;
import com.tydic.dyc.common.bo.DyCommonReceiverBo;
import com.tydic.dyc.common.bo.DycSendBusiProcessTodoReqBO;
import com.tydic.dyc.common.bo.DycSendBusiProcessTodoRspBO;
import com.tydic.dyc.common.bo.DycSendBusiProessTodoConfigBO;
import com.tydic.dyc.oc.service.common.UocBatchSaveTodoInfoService;
import com.tydic.dyc.oc.service.common.bo.UocBatchSaveTodoInfoReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBatchSaveTodoInfoRspBo;
import com.tydic.dyc.oc.service.common.bo.UocTodoBo;
import com.tydic.dyc.umc.service.todo.UmcQueryToDoItemListService;
import com.tydic.dyc.umc.service.todo.UmcSendTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoItemListReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoItemListRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoItemBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.api.DycSendBusiProcessTodoService"})
public class DycSendBusiProcessTodoServiceImpl
implements DycSendBusiProcessTodoService {
    private static final Logger log = LoggerFactory.getLogger(DycSendBusiProcessTodoServiceImpl.class);
    @Autowired
    private UmcQueryToDoItemListService umcQueryToDoItemListService;
    @Autowired
    private UmcSendTodoService umcSendTodoService;
    @Autowired
    private AuthGetUserByRoleAndOrgService authGetUserByRoleAndOrgService;
    private final Integer PURCHASE = 1;
    private final Integer SUPPLIER = 2;
    private final Integer PRO = 3;
    @Autowired
    private DycUocGemiSendMessageAtomFunction dycUocGemiSendMessageAtomFunction;
    @Autowired
    private UocBatchSaveTodoInfoService uocBatchSaveTodoInfoService;
    @Autowired
    private AgrSaveTodoService agrSaveTodoService;

    @Override
    @PostMapping(value={"sendBusiProcessTodo"})
    public DycSendBusiProcessTodoRspBO sendBusiProcessTodo(@RequestBody DycSendBusiProcessTodoReqBO reqBO) {
        DycSendBusiProcessTodoRspBO rspBO = new DycSendBusiProcessTodoRspBO();
        if (reqBO == null || reqBO.getTodoConfigJson() == null) {
            return rspBO;
        }
        List todoConfigList = JSON.parseArray((String)reqBO.getTodoConfigJson(), DycSendBusiProessTodoConfigBO.class);
        if (todoConfigList == null || todoConfigList.isEmpty()) {
            return rspBO;
        }
        for (DycSendBusiProessTodoConfigBO todoConfig : todoConfigList) {
            UmcToDoItemBo umcToDoItemBo = this.qryTodoData(todoConfig.getTodoItemCode(), reqBO.getTodoModuleCode());
            AuthGetUserByRoleAndOrgRspBo rspBo = this.qryTodoReceiver(todoConfig, reqBO);
            if (rspBo == null || CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
                throw new ZTBusinessException("\u5f85\u529e\u63a5\u6536\u4eba\u4e3a\u7a7a");
            }
            UmcSendTodoRspBo umcSendTodoRspBo = this.sendTodo(umcToDoItemBo, rspBo, reqBO);
            this.saveTodoInfo(umcSendTodoRspBo, umcToDoItemBo, reqBO);
            if (!todoConfig.getSendMsgFlag().booleanValue()) continue;
            this.sendMessage(rspBo, reqBO);
        }
        return rspBO;
    }

    private void sendMessage(AuthGetUserByRoleAndOrgRspBo rspBo, DycSendBusiProcessTodoReqBO reqBO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskCode", "uoc_supplier_confirm");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("saleOrderNo", reqBO.getTodoOrderNo());
        map.put("data", dataMap);
        map.put("sendId", 1L);
        map.put("sendName", "admin");
        ArrayList receiverIdList = new ArrayList();
        rspBo.getRows().forEach(obj -> {
            DyCommonReceiverBo bo = new DyCommonReceiverBo();
            bo.setReceiverId(obj.getUserId() + "");
            bo.setReceiverName(obj.getCustName());
            receiverIdList.add(bo);
        });
        map.put("receiverIdList", JSON.toJSONString(receiverIdList));
        try {
            this.dycUocGemiSendMessageAtomFunction.sendMessage(map);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u901a\u77e5\u5931\u8d25", (Throwable)e);
        }
    }

    private void saveTodoInfo(UmcSendTodoRspBo sendTodoRspBo, UmcToDoItemBo umcToDoItemBo, DycSendBusiProcessTodoReqBO reqBO) {
        ArrayList uocTodoBos = new ArrayList();
        Date date = new Date();
        sendTodoRspBo.getTodoList().forEach(obj -> {
            UocTodoBo todoBo = new UocTodoBo();
            BeanUtils.copyProperties((Object)obj, (Object)todoBo);
            todoBo.setOrderId(reqBO.getOrderId());
            todoBo.setBusiId(reqBO.getTaskId());
            todoBo.setCreateTime(date);
            todoBo.setTodoState(Integer.valueOf(0));
            uocTodoBos.add(todoBo);
        });
        if ("uoc".equals(umcToDoItemBo.getTodoModuleCode()) || "settle".equals(umcToDoItemBo.getTodoModuleCode())) {
            UocBatchSaveTodoInfoReqBo uocSaveTodoInfoReqBo = new UocBatchSaveTodoInfoReqBo();
            uocSaveTodoInfoReqBo.setUocTodoBos(uocTodoBos);
            if ("uoc".equals(umcToDoItemBo.getTodoModuleCode())) {
                log.info("\u8ba2\u5355\u5b58\u50a8\u5f85\u529e\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocSaveTodoInfoReqBo));
            } else if ("settle".equals(umcToDoItemBo.getTodoModuleCode())) {
                log.info("\u8ba2\u5355\u5b58\u50a8\u5f85\u529e\u4fe1\u606f\u5165\u53c2\uff08\u7ed3\u7b97\uff09\uff1a" + JSON.toJSONString((Object)uocSaveTodoInfoReqBo));
            }
            UocBatchSaveTodoInfoRspBo uocBatchSaveTodoInfoRspBo = this.uocBatchSaveTodoInfoService.batchSaveTodoInfo(uocSaveTodoInfoReqBo);
            if (!"0000".equals(uocBatchSaveTodoInfoRspBo.getRespCode())) {
                throw new ZTBusinessException(uocBatchSaveTodoInfoRspBo.getRespDesc());
            }
        } else if ("agr".equals(umcToDoItemBo.getTodoModuleCode())) {
            AgrSaveTodoReqBO agrSaveTodoReqBO = new AgrSaveTodoReqBO();
            agrSaveTodoReqBO.setAgrUocTodo(JUtil.jsl(uocTodoBos, AgrUocTodoBo.class));
            log.info("\u534f\u8bae\u4e2d\u5fc3\u4fdd\u5b58\u5f85\u529e\u4fe1\u606f\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)agrSaveTodoReqBO));
            AgrSaveTodoRspBO agrSaveTodoRspBO = this.agrSaveTodoService.saveTodo(agrSaveTodoReqBO);
            if (!"0000".equals(agrSaveTodoRspBO.getRespCode())) {
                throw new ZTBusinessException("\u534f\u8bae\u4e2d\u5fc3\u4fdd\u5b58\u5f85\u529e\u4fe1\u606f\u5931\u8d25: " + agrSaveTodoRspBO.getRespDesc());
            }
        }
    }

    private UmcSendTodoRspBo sendTodo(UmcToDoItemBo umcToDoItemBo, AuthGetUserByRoleAndOrgRspBo rspBo, DycSendBusiProcessTodoReqBO reqBo) {
        UmcSendTodoReqBo sendTodoReqBo = new UmcSendTodoReqBo();
        ArrayList todoList = new ArrayList();
        rspBo.getRows().forEach(obj -> {
            UmcTodoBo umcTodoBo = new UmcTodoBo();
            umcTodoBo.setTodoId(umcToDoItemBo.getTodoItemId());
            umcTodoBo.setTodoItemCode(umcToDoItemBo.getTodoItemCode());
            umcTodoBo.setTodoItemName(umcToDoItemBo.getTodoItemName());
            umcTodoBo.setTodoName(umcTodoBo.getTodoItemName() + "\uff1a" + reqBo.getTodoOrderNo());
            umcTodoBo.setBusiId(reqBo.getTaskId());
            umcTodoBo.setTodoUrl(umcToDoItemBo.getTodoUrl());
            umcTodoBo.setTodoModuleCode(umcToDoItemBo.getTodoModuleCode());
            umcTodoBo.setTodoModuleName(umcToDoItemBo.getTodoModuleName());
            umcTodoBo.setCreateOperId(obj.getUserId() + "");
            umcTodoBo.setCreateOperName(obj.getCustName());
            umcTodoBo.setCreateTime(new Date());
            umcTodoBo.setCandidateOperId(obj.getUserId() + "");
            umcTodoBo.setCandidateOperName(obj.getCustName());
            umcTodoBo.setProcInstId(reqBo.getProcInstId());
            todoList.add(umcTodoBo);
        });
        sendTodoReqBo.setTodoList(todoList);
        log.info("\u63a8\u9001\u5f85\u529e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)sendTodoReqBo));
        UmcSendTodoRspBo umcSendTodoRspBo = this.umcSendTodoService.sendTodo(sendTodoReqBo);
        log.info("\u63a8\u9001\u5f85\u529e\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcSendTodoRspBo));
        if (!"0000".equals(umcSendTodoRspBo.getRespCode())) {
            throw new ZTBusinessException(umcSendTodoRspBo.getRespDesc());
        }
        return umcSendTodoRspBo;
    }

    private AuthGetUserByRoleAndOrgRspBo qryTodoReceiver(DycSendBusiProessTodoConfigBO todoConfig, DycSendBusiProcessTodoReqBO reqBO) {
        AuthGetUserByRoleAndOrgReqBo authGetUserByRoleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
        authGetUserByRoleAndOrgReqBo.setRoleIds(todoConfig.getRoleIds());
        if (this.PURCHASE.equals(todoConfig.getTodoReceiver())) {
            authGetUserByRoleAndOrgReqBo.setLvOrgId(reqBO.getPurchaseId());
        } else if (this.SUPPLIER.equals(todoConfig.getTodoReceiver())) {
            authGetUserByRoleAndOrgReqBo.setLvOrgId(reqBO.getSupplierId());
        } else if (this.PRO.equals(todoConfig.getTodoReceiver())) {
            authGetUserByRoleAndOrgReqBo.setLvOrgId(reqBO.getProId());
        }
        AuthGetUserByRoleAndOrgRspBo rspBo = this.authGetUserByRoleAndOrgService.getUserByRoleAndOrg(authGetUserByRoleAndOrgReqBo);
        return rspBo;
    }

    private UmcToDoItemBo qryTodoData(String todoItemCode, String todoModuleCode) {
        UmcQueryToDoItemListReqBo umcQueryToDoItemListReqBo = new UmcQueryToDoItemListReqBo();
        umcQueryToDoItemListReqBo.setTodoItemCode(todoItemCode);
        umcQueryToDoItemListReqBo.setTodoModuleCode(todoModuleCode);
        log.info(JSON.toJSONString((Object)("\u67e5\u8be2\u5f85\u529e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQueryToDoItemListReqBo))));
        UmcQueryToDoItemListRspBo doItemListRspBo = this.umcQueryToDoItemListService.queryToDoItemList(umcQueryToDoItemListReqBo);
        log.info(JSON.toJSONString((Object)("\u67e5\u8be2\u5f85\u529e\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)doItemListRspBo))));
        if (!"0000".equals(doItemListRspBo.getRespCode())) {
            throw new ZTBusinessException(doItemListRspBo.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)doItemListRspBo.getRows()) || doItemListRspBo.getRows().size() != 1) {
            throw new ZTBusinessException("\u4ee3\u529e\u9879\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u552f\u4e00");
        }
        return (UmcToDoItemBo)doItemListRspBo.getRows().get(0);
    }
}

