/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.shoppingcart.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.mall.ability.api.UccMallBatchShopingQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccBatchShopQryBo;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopQryMsgBo;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopingQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopingQryAbilityRspBO;
import com.tydic.dyc.common.member.shoppingcart.api.DycMallExportShoppingCartGoodsService;
import com.tydic.dyc.common.member.shoppingcart.bo.DycMallExportShoppingCartGoodsBo;
import com.tydic.dyc.common.member.shoppingcart.bo.DycMallExportShoppingCartGoodsReqBO;
import com.tydic.dyc.common.member.shoppingcart.bo.DycMallExportShoppingCartGoodsRspBO;
import com.tydic.dyc.common.member.shoppingcart.bo.DycMallUscGoodsInfoExtBO;
import com.tydic.dyc.common.member.utils.ExcelUtils;
import com.tydic.dyc.umc.service.shoppingcart.UmcGetShoppingCartPageListService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcGetShoppingCartPageListReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcGetShoppingCartPageListRspBo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.shoppingcart.api.DycMallExportShoppingCartGoodsService"})
public class DycMallExportShoppingCartGoodsServiceImpl
implements DycMallExportShoppingCartGoodsService {
    private static final Logger log = LoggerFactory.getLogger(DycMallExportShoppingCartGoodsServiceImpl.class);
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Value(value="${oss.accessUrl:http://liando-mall-uat.oss-cn-beijing.aliyuncs.com/}")
    private String preFilePath;
    @Value(value="${oss.fileUrl:http://10.0.11.61:8060/downloadFile/}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:8888}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:10.0.11.58:22122}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url:http://10.200.199.100:8888}")
    private String exportFilePublicUrl;
    public static final String RESP_CODE_SUCCESS = "0000";
    public static final String FILE_NAME = "\u5546\u54c1\u6e05\u5355";
    @Autowired
    private UmcGetShoppingCartPageListService umcGetShoppingCartPageListService;
    @Autowired
    private UccMallBatchShopingQryAbilityService uccMallBatchShopingQryAbilityService;

    @Override
    @PostMapping(value={"exportShoppingCartGoods"})
    public DycMallExportShoppingCartGoodsRspBO exportShoppingCartGoods(@RequestBody DycMallExportShoppingCartGoodsReqBO reqBO) {
        DycMallExportShoppingCartGoodsRspBO rspBO = new DycMallExportShoppingCartGoodsRspBO();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        HashMap<Long, String> goodsLinks = new HashMap<Long, String>();
        UmcGetShoppingCartPageListReqBo uscReqBo1 = (UmcGetShoppingCartPageListReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UmcGetShoppingCartPageListReqBo.class);
        uscReqBo1.setUserId(reqBO.getUserId());
        uscReqBo1.setPageNo(-1);
        uscReqBo1.setPageSize(-1);
        ArrayList<Long> spIds = new ArrayList<Long>();
        if (reqBO.getUscGoodsInfoList() != null) {
            for (DycMallUscGoodsInfoExtBO goodsInfoExtBO : reqBO.getUscGoodsInfoList()) {
                spIds.add(goodsInfoExtBO.getSpId());
                goodsLinks.put(goodsInfoExtBO.getSpId(), goodsInfoExtBO.getGoodsUrl());
            }
        }
        uscReqBo1.setSpIds(spIds);
        UmcGetShoppingCartPageListRspBo uscRspbo = this.umcGetShoppingCartPageListService.getShoppingCartPageList(uscReqBo1);
        if (!RESP_CODE_SUCCESS.equals(uscRspbo.getRespCode())) {
            throw new ZTBusinessException(uscRspbo.getRespDesc());
        }
        List shoppingCartPOS = uscRspbo.getRows();
        if (CollectionUtils.isEmpty((Collection)shoppingCartPOS)) {
            rspBO.setRespCode(RESP_CODE_SUCCESS);
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u8d2d\u7269\u8f66\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        log.debug("\u67e5\u8be2\u8d2d\u7269\u8f66\u6570\u636e\u51fa\u53c2\uff1a{}", (Object)shoppingCartPOS);
        UccMallBatchShopingQryAbilityReqBO uccBatchShopQryReqBo = new UccMallBatchShopingQryAbilityReqBO();
        HashMap distinctShopping = new HashMap();
        for (Object shoppingCartPO : shoppingCartPOS) {
            if (distinctShopping.containsKey(shoppingCartPO.getSkuId())) {
                ((List)distinctShopping.get(shoppingCartPO.getSkuId())).add(shoppingCartPO);
                continue;
            }
            ArrayList<Object> skuCart = new ArrayList<Object>();
            skuCart.add(shoppingCartPO);
            distinctShopping.put(shoppingCartPO.getSkuId(), skuCart);
        }
        ArrayList<UccBatchShopQryBo> shopQry = new ArrayList<UccBatchShopQryBo>();
        for (Long skuId : distinctShopping.keySet()) {
            UccBatchShopQryBo uscBatchShopQryReqBO = new UccBatchShopQryBo();
            uscBatchShopQryReqBO.setSkuId(skuId);
            BigDecimal productAmount = new BigDecimal(0);
            Long shopCode = null;
            for (UmcAddShoppingCartBo shoppingCartPO : (List)distinctShopping.get(skuId)) {
                productAmount = productAmount.add(shoppingCartPO.getProductAmount());
                if (shopCode != null || !StringUtils.isNotBlank((String)shoppingCartPO.getShopCode())) continue;
                shopCode = Long.valueOf(shoppingCartPO.getShopCode());
            }
            uscBatchShopQryReqBO.setSupplierShopId(shopCode);
            uscBatchShopQryReqBO.setSaleNum(String.valueOf(productAmount));
            uscBatchShopQryReqBO.setProvince(Integer.valueOf(Math.toIntExact(reqBO.getProvince())));
            uscBatchShopQryReqBO.setCity(Integer.valueOf(Math.toIntExact(reqBO.getCity())));
            uscBatchShopQryReqBO.setCounty(Integer.valueOf(Math.toIntExact(reqBO.getCounty())));
            uscBatchShopQryReqBO.setTown(Integer.valueOf(Math.toIntExact(reqBO.getTown())));
            shopQry.add(uscBatchShopQryReqBO);
        }
        uccBatchShopQryReqBo.setShopQry(shopQry);
        uccBatchShopQryReqBo.setCompanyId(reqBO.getCompanyId());
        uccBatchShopQryReqBo.setIsprofess(reqBO.getIsprofess());
        UccMallBatchShopingQryAbilityRspBO uccBatchShopQryRspBo = new UccMallBatchShopingQryAbilityRspBO();
        try {
            log.debug("\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uccBatchShopQryReqBo));
            uccBatchShopQryRspBo = this.uccMallBatchShopingQryAbilityService.qryInfo(uccBatchShopQryReqBo);
            log.debug("\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)uccBatchShopQryRspBo));
            if (!RESP_CODE_SUCCESS.equals(uccBatchShopQryRspBo.getRespCode()) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccBatchShopQryRspBo.getShopQryMsg())) {
                throw new ZTBusinessException("\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u5931\u8d25:" + uccBatchShopQryRspBo.getRespDesc() + "\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u5931\u8d25:" + uccBatchShopQryRspBo.getRespDesc() + "\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        BigDecimal totalPrice = new BigDecimal(0);
        List uccMallBatchShopQryMsgBos = uccBatchShopQryRspBo.getShopQryMsg();
        Map<Object, Object> batchShopQryMsgRspBOMap = new HashMap();
        if (uccMallBatchShopQryMsgBos != null) {
            batchShopQryMsgRspBOMap = uccMallBatchShopQryMsgBos.stream().collect(Collectors.toMap(UccMallBatchShopQryMsgBo::getSkuId, UscBatchShopQryMsgRspBO -> UscBatchShopQryMsgRspBO));
        }
        int index = 0;
        for (UmcAddShoppingCartBo shoppingCartPO : shoppingCartPOS) {
            ++index;
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            UccMallBatchShopQryMsgBo shopQryMsgRspBO = (UccMallBatchShopQryMsgBo)batchShopQryMsgRspBOMap.get(shoppingCartPO.getSkuId());
            BigDecimal singlePrice = new BigDecimal(0);
            BigDecimal singlePriceWithRate = new BigDecimal(0);
            BigDecimal saleCount = new BigDecimal(0);
            BigDecimal totalInPrice = new BigDecimal(0);
            String stockName = "\u5e93\u5b58\u4e0d\u8db3";
            if (shopQryMsgRspBO != null) {
                if (shopQryMsgRspBO.getPrice() != null) {
                    singlePrice = shopQryMsgRspBO.getPrice();
                }
                singlePriceWithRate = singlePrice;
                if (!StringUtils.isBlank((String)shopQryMsgRspBO.getSaleNum())) {
                    saleCount = new BigDecimal(shopQryMsgRspBO.getSaleNum());
                }
                if (singlePriceWithRate.compareTo(BigDecimal.ZERO) != 0 && saleCount.compareTo(BigDecimal.ZERO) != 0) {
                    totalInPrice = singlePriceWithRate.multiply(saleCount).setScale(2, 0);
                }
                if (shopQryMsgRspBO.getStockStateDesc() != null) {
                    stockName = shopQryMsgRspBO.getStockStateDesc();
                }
            }
            item.put("\u5e8f\u53f7", index);
            item.put("\u5546\u54c1\u540d\u79f0", shopQryMsgRspBO != null ? shopQryMsgRspBO.getSkuName() : "");
            item.put("\u5546\u54c1\u7f16\u7801", shopQryMsgRspBO != null ? shopQryMsgRspBO.getSkuCode() : "");
            item.put("\u89c4\u683c", shopQryMsgRspBO != null ? shopQryMsgRspBO.getSpec() : "");
            item.put("\u578b\u53f7", shopQryMsgRspBO != null ? shopQryMsgRspBO.getModel() : "");
            item.put("\u5546\u54c1\u94fe\u63a5", goodsLinks.get(shoppingCartPO.getSpId()));
            item.put("\u6765\u6e90\u7535\u5546", shopQryMsgRspBO != null ? shopQryMsgRspBO.getSupplierName() : "");
            item.put("\u5355\u4ef7", singlePriceWithRate);
            item.put("\u603b\u4ef7", totalInPrice);
            data.add(item);
            if (totalInPrice.compareTo(BigDecimal.ZERO) == 0) continue;
            totalPrice = totalPrice.add(totalInPrice);
        }
        this.uploadFile(data, totalPrice, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = this.preFilePath + rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setFullFilePath(fullFilePath);
        rspBO.setRespCode(RESP_CODE_SUCCESS);
        rspBO.setRespDesc("\u521b\u5efaexcel \u6570\u636e\u6210\u529f!");
        return rspBO;
    }

    @Override
    @PostMapping(value={"getShoppingCartGoods"})
    public DycMallExportShoppingCartGoodsRspBO getShoppingCartGoods(@RequestBody DycMallExportShoppingCartGoodsReqBO reqBO) {
        DycMallExportShoppingCartGoodsRspBO rspBO = new DycMallExportShoppingCartGoodsRspBO();
        ArrayList data = new ArrayList();
        HashMap<Long, String> goodsLinks = new HashMap<Long, String>();
        UmcGetShoppingCartPageListReqBo uscReqBo1 = (UmcGetShoppingCartPageListReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UmcGetShoppingCartPageListReqBo.class);
        uscReqBo1.setUserId(reqBO.getUserId());
        uscReqBo1.setPageNo(-1);
        uscReqBo1.setPageSize(-1);
        ArrayList<Long> spIds = new ArrayList<Long>();
        if (reqBO.getUscGoodsInfoList() != null) {
            for (DycMallUscGoodsInfoExtBO goodsInfoExtBO : reqBO.getUscGoodsInfoList()) {
                spIds.add(goodsInfoExtBO.getSpId());
                goodsLinks.put(goodsInfoExtBO.getSpId(), goodsInfoExtBO.getGoodsUrl());
            }
        }
        uscReqBo1.setSpIds(spIds);
        UmcGetShoppingCartPageListRspBo uscRspbo = this.umcGetShoppingCartPageListService.getShoppingCartPageList(uscReqBo1);
        if (!RESP_CODE_SUCCESS.equals(uscRspbo.getRespCode())) {
            throw new ZTBusinessException(uscRspbo.getRespDesc());
        }
        List shoppingCartPOS = uscRspbo.getRows();
        if (CollectionUtils.isEmpty((Collection)shoppingCartPOS)) {
            rspBO.setRespCode(RESP_CODE_SUCCESS);
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u8d2d\u7269\u8f66\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        log.debug("\u67e5\u8be2\u8d2d\u7269\u8f66\u6570\u636e\u51fa\u53c2\uff1a{}", (Object)shoppingCartPOS);
        UccMallBatchShopingQryAbilityReqBO uccBatchShopQryReqBo = new UccMallBatchShopingQryAbilityReqBO();
        HashMap distinctShopping = new HashMap();
        for (Object shoppingCartPO : shoppingCartPOS) {
            if (distinctShopping.containsKey(shoppingCartPO.getSkuId())) {
                ((List)distinctShopping.get(shoppingCartPO.getSkuId())).add(shoppingCartPO);
                continue;
            }
            ArrayList<Object> skuCart = new ArrayList<Object>();
            skuCart.add(shoppingCartPO);
            distinctShopping.put(shoppingCartPO.getSkuId(), skuCart);
        }
        ArrayList<UccBatchShopQryBo> shopQry = new ArrayList<UccBatchShopQryBo>();
        for (Long skuId : distinctShopping.keySet()) {
            UccBatchShopQryBo uscBatchShopQryReqBO = new UccBatchShopQryBo();
            uscBatchShopQryReqBO.setSkuId(skuId);
            BigDecimal productAmount = new BigDecimal(0);
            Long shopCode = null;
            for (UmcAddShoppingCartBo shoppingCartPO : (List)distinctShopping.get(skuId)) {
                productAmount = productAmount.add(shoppingCartPO.getProductAmount());
                if (shopCode != null || !StringUtils.isNotBlank((String)shoppingCartPO.getShopCode())) continue;
                shopCode = Long.valueOf(shoppingCartPO.getShopCode());
            }
            uscBatchShopQryReqBO.setSupplierShopId(shopCode);
            uscBatchShopQryReqBO.setSaleNum(String.valueOf(productAmount));
            uscBatchShopQryReqBO.setProvince(Integer.valueOf(Math.toIntExact(reqBO.getProvince())));
            uscBatchShopQryReqBO.setCity(Integer.valueOf(Math.toIntExact(reqBO.getCity())));
            uscBatchShopQryReqBO.setCounty(Integer.valueOf(Math.toIntExact(reqBO.getCounty())));
            uscBatchShopQryReqBO.setTown(Integer.valueOf(Math.toIntExact(reqBO.getTown())));
            shopQry.add(uscBatchShopQryReqBO);
        }
        uccBatchShopQryReqBo.setShopQry(shopQry);
        uccBatchShopQryReqBo.setCompanyId(reqBO.getCompanyId());
        uccBatchShopQryReqBo.setIsprofess(reqBO.getIsprofess());
        UccMallBatchShopingQryAbilityRspBO uccBatchShopQryRspBo = new UccMallBatchShopingQryAbilityRspBO();
        try {
            log.debug("\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uccBatchShopQryReqBo));
            uccBatchShopQryRspBo = this.uccMallBatchShopingQryAbilityService.qryInfo(uccBatchShopQryReqBo);
            log.debug("\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)uccBatchShopQryRspBo));
            if (!RESP_CODE_SUCCESS.equals(uccBatchShopQryRspBo.getRespCode()) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccBatchShopQryRspBo.getShopQryMsg())) {
                throw new ZTBusinessException("\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u5931\u8d25:" + uccBatchShopQryRspBo.getRespDesc() + "\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528\u7535\u5b50\u8d85\u5e02\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u5931\u8d25:" + uccBatchShopQryRspBo.getRespDesc() + "\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        BigDecimal totalPrice = new BigDecimal(0);
        List uccMallBatchShopQryMsgBos = uccBatchShopQryRspBo.getShopQryMsg();
        Map<Object, Object> batchShopQryMsgRspBOMap = new HashMap();
        if (uccMallBatchShopQryMsgBos != null) {
            batchShopQryMsgRspBOMap = uccMallBatchShopQryMsgBos.stream().collect(Collectors.toMap(UccMallBatchShopQryMsgBo::getSkuId, UscBatchShopQryMsgRspBO -> UscBatchShopQryMsgRspBO));
        }
        ArrayList<DycMallExportShoppingCartGoodsBo> dycMallExportShoppingCartGoodsBos = new ArrayList<DycMallExportShoppingCartGoodsBo>();
        int index = 0;
        for (UmcAddShoppingCartBo shoppingCartPO : shoppingCartPOS) {
            ++index;
            LinkedHashMap item = new LinkedHashMap();
            UccMallBatchShopQryMsgBo shopQryMsgRspBO = (UccMallBatchShopQryMsgBo)batchShopQryMsgRspBOMap.get(shoppingCartPO.getSkuId());
            BigDecimal singlePrice = new BigDecimal(0);
            BigDecimal singlePriceWithRate = new BigDecimal(0);
            BigDecimal saleCount = new BigDecimal(0);
            BigDecimal totalInPrice = new BigDecimal(0);
            String stockName = "\u5e93\u5b58\u4e0d\u8db3";
            if (shopQryMsgRspBO != null) {
                if (shopQryMsgRspBO.getPrice() != null) {
                    singlePrice = shopQryMsgRspBO.getPrice();
                }
                singlePriceWithRate = singlePrice;
                if (!StringUtils.isBlank((String)shopQryMsgRspBO.getSaleNum())) {
                    saleCount = new BigDecimal(shopQryMsgRspBO.getSaleNum());
                }
                if (singlePriceWithRate.compareTo(BigDecimal.ZERO) != 0 && saleCount.compareTo(BigDecimal.ZERO) != 0) {
                    totalInPrice = singlePriceWithRate.multiply(saleCount).setScale(2, 0);
                }
                if (shopQryMsgRspBO.getStockStateDesc() != null) {
                    stockName = shopQryMsgRspBO.getStockStateDesc();
                }
                DycMallExportShoppingCartGoodsBo dycMallExportShoppingCartGoodsBo = new DycMallExportShoppingCartGoodsBo();
                dycMallExportShoppingCartGoodsBo.setSeq(index);
                dycMallExportShoppingCartGoodsBo.setSkuName(shopQryMsgRspBO.getSkuName());
                dycMallExportShoppingCartGoodsBo.setSkuCode(shopQryMsgRspBO.getSkuCode());
                dycMallExportShoppingCartGoodsBo.setExtSkuId(shopQryMsgRspBO.getExtralSkuId());
                dycMallExportShoppingCartGoodsBo.setSpec(shopQryMsgRspBO.getSpec());
                dycMallExportShoppingCartGoodsBo.setModel(shopQryMsgRspBO.getModel());
                dycMallExportShoppingCartGoodsBo.setSkuDetailUrl((String)goodsLinks.get(shoppingCartPO.getSpId()));
                dycMallExportShoppingCartGoodsBo.setSupplierName(shopQryMsgRspBO.getSupplierName());
                dycMallExportShoppingCartGoodsBo.setStockName(stockName);
                dycMallExportShoppingCartGoodsBo.setRate(Convert.toStr((Object)shopQryMsgRspBO.getRate()));
                dycMallExportShoppingCartGoodsBo.setTaxPrice(Convert.toStr((Object)singlePriceWithRate));
                dycMallExportShoppingCartGoodsBo.setTotalPrice(Convert.toStr((Object)totalInPrice));
                dycMallExportShoppingCartGoodsBo.setPurchaseModName(shoppingCartPO.getPurchaseModName());
                dycMallExportShoppingCartGoodsBo.setNum(Convert.toStr((Object)shoppingCartPO.getProductAmount()));
                dycMallExportShoppingCartGoodsBos.add(dycMallExportShoppingCartGoodsBo);
            }
            if (totalInPrice.compareTo(BigDecimal.ZERO) == 0) continue;
            totalPrice = totalPrice.add(totalInPrice);
        }
        rspBO.setRows(dycMallExportShoppingCartGoodsBos);
        rspBO.setRespCode(RESP_CODE_SUCCESS);
        rspBO.setRespDesc("\u521b\u5efaexcel \u6570\u636e\u6210\u529f!");
        return rspBO;
    }

    private void uploadFile(List<Map<String, Object>> data, BigDecimal totalPrice, DycMallExportShoppingCartGoodsRspBO rspBO) {
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        try (SXSSFWorkbook workbook = ExcelUtils.createWorkbook(data, "\u5546\u54c1", true, totalPrice, FILE_NAME, data.get(0).size());){
            String uploadPath = "usc";
            String fileName = FILE_NAME + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xlsx";
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }
}

