/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.transfer.impl;

import com.tydic.dyc.common.member.transfer.api.DycCommonUmcMerchantListQueryAbilityService;
import com.tydic.dyc.common.member.transfer.bo.DycCommonUmcMerchantListQueryAbilityReqBO;
import com.tydic.dyc.common.member.transfer.bo.DycCommonUmcMerchantListQueryAbilityRspBO;
import com.tydic.dyc.common.member.transfer.bo.DycSupplierBusinessBO;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseInfoListPageService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseContactBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoListPageReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoListPageRspBo;
import com.tydic.fsc.bo.FscMerchantBO;
import com.tydic.fsc.common.ability.api.FscMerchantListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantListQueryAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="DycCommonUmcMerchantListQueryAbilityService")
@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.transfer.api.DycCommonUmcMerchantListQueryAbilityService"})
public class DycCommonUmcMerchantListQueryAbilityServiceImpl
implements DycCommonUmcMerchantListQueryAbilityService {
    @Autowired
    private FscMerchantListQueryAbilityService fscMerchantListQueryAbilityService;
    @Autowired
    private UmcQryEnterpriseInfoListPageService umcQryEnterpriseInfoListPageService;
    @Value(value="#{'${onlineOrgIdS:100055,100058,100059,100060,100061,100062,100064,100065}'.split(',')}")
    private List<Long> onlineOrgIdS;
    private static final String ONLINE = "1";
    private static final String AGREEMENT = "2";
    private static final String NOT_AGREEMENT = "3";
    private static final Integer SUPPLIER = 2;

    @Override
    @PostMapping(value={"queryMerchantList"})
    public DycCommonUmcMerchantListQueryAbilityRspBO queryMerchantList(@RequestBody DycCommonUmcMerchantListQueryAbilityReqBO reqBO) {
        DycCommonUmcMerchantListQueryAbilityRspBO rspBO = new DycCommonUmcMerchantListQueryAbilityRspBO();
        UmcQryEnterpriseInfoListPageReqBo umcQryEnterpriseInfoListPageReqBo = new UmcQryEnterpriseInfoListPageReqBo();
        if (ONLINE.equals(reqBO.getOperType())) {
            umcQryEnterpriseInfoListPageReqBo.setOrgIdList(this.onlineOrgIdS);
        } else {
            FscMerchantListQueryAbilityReqBO queryAbilityReqBO = new FscMerchantListQueryAbilityReqBO();
            queryAbilityReqBO.setMerchantCategory(SUPPLIER);
            ArrayList<Integer> merchantTypeList = new ArrayList<Integer>();
            merchantTypeList.add(3);
            if (AGREEMENT.equals(reqBO.getOperType())) {
                merchantTypeList.add(1);
            } else if (NOT_AGREEMENT.equals(reqBO.getOperType())) {
                merchantTypeList.add(2);
            }
            queryAbilityReqBO.setMerchantTypeList(merchantTypeList);
            FscMerchantListQueryAbilityRspBO queryAbilityRspBO = this.fscMerchantListQueryAbilityService.queryMerchantOrgIds(queryAbilityReqBO);
            if (!CollectionUtils.isEmpty((Collection)queryAbilityRspBO.getRows())) {
                ArrayList<Long> orgIds = new ArrayList<Long>();
                for (FscMerchantBO row : queryAbilityRspBO.getRows()) {
                    orgIds.add(row.getOrgId());
                }
                if (!CollectionUtils.isEmpty(orgIds)) {
                    umcQryEnterpriseInfoListPageReqBo.setOrgIdList(orgIds);
                }
            }
        }
        umcQryEnterpriseInfoListPageReqBo.setPageNo(-1);
        umcQryEnterpriseInfoListPageReqBo.setPageSize(-1);
        UmcQryEnterpriseInfoListPageRspBo businessAbilityRspBo = this.umcQryEnterpriseInfoListPageService.qryEnterpriseInfoListPage(umcQryEnterpriseInfoListPageReqBo);
        if (!CollectionUtils.isEmpty((Collection)businessAbilityRspBo.getRows())) {
            List<DycSupplierBusinessBO> rspSupBoList = this.BuildRspBo(businessAbilityRspBo.getRows());
            rspBO.setRows(rspSupBoList);
        }
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    private List<DycSupplierBusinessBO> BuildRspBo(List<UmcEnterpriseInfoBo> enterpriseInfoBoList) {
        ArrayList<DycSupplierBusinessBO> supList = new ArrayList<DycSupplierBusinessBO>();
        for (UmcEnterpriseInfoBo enterpriseInfoBo : enterpriseInfoBoList) {
            DycSupplierBusinessBO supBo = new DycSupplierBusinessBO();
            supBo.setSupplierId(enterpriseInfoBo.getOrgId());
            supBo.setBusinessScope(enterpriseInfoBo.getBusinessScope());
            supBo.setEnterpriseId(enterpriseInfoBo.getOrgId());
            supBo.setOrgId(enterpriseInfoBo.getOrgId());
            supBo.setSupplierAttr(enterpriseInfoBo.getOrgClass());
            supBo.setSupplierName(enterpriseInfoBo.getOrgName());
            supBo.setSupplierEnName(enterpriseInfoBo.getOrgEnName());
            supBo.setSupplierShortName(enterpriseInfoBo.getOrgShortName());
            if (!CollectionUtils.isEmpty((Collection)enterpriseInfoBo.getEnterpriseContactList())) {
                UmcEnterpriseContactBo contactBo = (UmcEnterpriseContactBo)enterpriseInfoBo.getEnterpriseContactList().get(0);
                supBo.setConsignerName(contactBo.getContactName());
                supBo.setPhoneNumber(contactBo.getPhoneNumber());
                supBo.setTel(contactBo.getTel());
                supBo.setEmail(contactBo.getEmail());
                supBo.setConsignerIdcardNum(contactBo.getCardNum());
            }
            supBo.setCreateNo(enterpriseInfoBo.getCreateOperId());
            supBo.setCreateTime(enterpriseInfoBo.getCreateTime());
            supBo.setUpdateNo(enterpriseInfoBo.getUpdateOperId());
            supBo.setUpdateTime(enterpriseInfoBo.getUpdateTime());
            supList.add(supBo);
        }
        return supList;
    }
}

