/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.login.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.common.member.login.api.AutzQueryService;
import com.tydic.umc.security.utils.UtilString;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.login.api.AutzQueryService"})
public class AutzQueryServiceImpl
implements AutzQueryService {
    private static final Logger log = LoggerFactory.getLogger(AutzQueryServiceImpl.class);
    @Autowired
    private CacheClient cacheService;

    @Override
    @PostMapping(value={"getCurrentIPCode"})
    public String getCurrentIPCode(@RequestBody String host) {
        String verificationCode = null;
        verificationCode = (String)this.cacheService.get("verificationCode" + host);
        return verificationCode;
    }

    @Override
    @PostMapping(value={"getCurrentIdCaptcha"})
    public Integer getCurrentIdCaptcha(@RequestBody String host) {
        String verificationCode = null;
        verificationCode = (String)this.cacheService.get("verificationCode" + host);
        if (UtilString.isNotEmpty((CharSequence)verificationCode)) {
            log.info("key={},\u6ed1\u5757\u4f4d\u7f6e\u7f13\u5b58\u503c{}", (Object)host, (Object)verificationCode);
            return Integer.parseInt(verificationCode);
        }
        return 0;
    }

    @Override
    @PostMapping(value={"putCurrentIpCode"})
    public String putCurrentIpCode(@RequestBody String host) {
        String veriCode = "";
        if (UtilString.isNotEmpty((CharSequence)host)) {
            String code;
            veriCode = code = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 6);
        }
        return veriCode;
    }

    @Override
    @PostMapping(value={"getCaptchaImageBase64Str"})
    public String getCaptchaImageBase64Str(@RequestBody String imageName) {
        String base64Str = null;
        base64Str = (String)this.cacheService.get("captchaImage" + imageName);
        return base64Str;
    }

    @Override
    @PostMapping(value={"removeCurrentIPCode"})
    public void removeCurrentIPCode(@RequestBody String host) {
        this.cacheService.delete("verificationCode" + host);
    }
}

