/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.login.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.common.member.login.api.PicVfCodeService;
import com.tydic.dyc.common.member.login.bo.GetPicVfCodeReqBO;
import com.tydic.dyc.common.member.login.bo.GetPicVfCodeRspBO;
import com.tydic.umc.security.utils.VerifyCodeUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.login.api.PicVfCodeService"})
public class PicVfCodeServiceImpl
implements PicVfCodeService {
    private static final Logger log = LoggerFactory.getLogger(PicVfCodeServiceImpl.class);
    private static final Integer DEFUALT_CODE_LENGTH = 4;
    private static final Integer PIC_WIGTH = 80;
    private static final Integer PIC_HEIGHT = 30;
    private Base64 base64 = new Base64();
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${picVfCodeExpTime}")
    private String picVfCodeExpTime;
    private static final String VF_CODE_KEY = "picVfCode";

    @Override
    @PostMapping(value={"getPicVfCode"})
    public GetPicVfCodeRspBO getPicVfCode(@RequestBody GetPicVfCodeReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getSessionId())) {
            throw new ZTBusinessException("\u5165\u53c2[sessionId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String sessionId = reqBO.getSessionId();
        GetPicVfCodeRspBO rspBO = new GetPicVfCodeRspBO();
        if (null == reqBO.getVfCodeLength()) {
            reqBO.setVfCodeLength(DEFUALT_CODE_LENGTH);
        }
        String code = VerifyCodeUtils.generateVerifyCode((int)reqBO.getVfCodeLength());
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u56fe\u7247\u9a8c\u8bc1\u7801:{}", (Object)code);
        }
        if (null == reqBO.getPicHeight() || null == reqBO.getPicWidth()) {
            reqBO.setPicHeight(PIC_HEIGHT);
            reqBO.setPicWidth(PIC_WIGTH);
        }
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            VerifyCodeUtils.outputImage((int)reqBO.getPicWidth(), (int)reqBO.getPicHeight(), (OutputStream)fos, (String)code);
            rspBO.setPicVfCode(this.base64.encodeToString(fos.toByteArray()));
            rspBO.setVfCode(code);
            this.cacheClient.set(VF_CODE_KEY + sessionId, (Object)code, Integer.parseInt(this.picVfCodeExpTime));
            fos.close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u83b7\u53d6\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25\uff01");
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u5b57\u8282\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Override
    @PostMapping(value={"checkVfCode"})
    public GetPicVfCodeRspBO checkVfCode(@RequestBody GetPicVfCodeReqBO reqBO) {
        this.initParam(reqBO);
        Object obj = this.cacheClient.get(VF_CODE_KEY + reqBO.getSessionId());
        if (null == obj) {
            throw new ZTBusinessException("\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
        }
        if (!String.valueOf(obj).equals(reqBO.getVfCode())) {
            throw new ZTBusinessException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        if (log.isDebugEnabled()) {
            log.debug("redis key:{} value:{} reqBo:{}", new Object[]{VF_CODE_KEY + reqBO.getSessionId(), obj, JSON.toJSONString((Object)reqBO)});
        }
        this.cacheClient.delete(VF_CODE_KEY + reqBO.getVfCode());
        GetPicVfCodeRspBO rspBO = new GetPicVfCodeRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void initParam(GetPicVfCodeReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getVfCode())) {
            throw new ZTBusinessException("\u5165\u53c2\u9a8c\u8bc1\u7801\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSessionId())) {
            throw new ZTBusinessException("\u5165\u53c2\u4f1a\u8bddID\u4e3a\u7a7a\uff01");
        }
    }
}

