/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.vfcode.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.common.member.vfcode.api.VerifyCodeService;
import com.tydic.dyc.common.member.vfcode.bo.ReceiverBo;
import com.tydic.dyc.common.member.vfcode.bo.SendMessageReqBo;
import com.tydic.dyc.common.member.vfcode.bo.SendMessageRspBo;
import com.tydic.dyc.common.member.vfcode.bo.VerifyCodeReqBo;
import com.tydic.dyc.common.member.vfcode.bo.VerifyCodeRspBo;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.vfcode.api.VerifyCodeService"})
public class VerifyCodeServiceImpl
implements VerifyCodeService {
    private static final Logger log = LoggerFactory.getLogger(VerifyCodeServiceImpl.class);
    @Autowired
    private CacheClient cacheService;
    private static Integer NEED_VFCODE = 1;
    private static Integer NOT_NEED_VFCODE = 0;
    private static String MSG_NULL_REGACCOUNT = "\u3010regAccount\u3011\u4e3a\u7a7a";
    private static String MSG_NULL_VERIFYVALUE = "\u3010verifyValue\u3011\u4e3a\u7a7a";
    @Value(value="${vfCodeExpTime}")
    private Integer verifyExpireTime;
    @Value(value="${sendVfCodeTemplateId}")
    private Long sendVfCodeTemplateId;
    @Value(value="${_TYPE:HTTP}")
    private String _TYPE;
    @Value(value="${isSendMsg:false}")
    private boolean IS_SEND_MSG;
    @Value(value="${MALL_SEND_PLATFORM:2}")
    private String MALL_SEND_PLATFORM;
    @Value(value="${IS_SHOW_VFCODE:true}")
    private boolean IS_SHOW_VFCODE;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${IS_DECRYPT:false}")
    private boolean IS_DECRYPT;
    @Value(value="${isSendMail:false}")
    private boolean IS_SEND_MAIL;
    @Value(value="${geminiSendUrl}")
    private String geminiSendUrl;

    @Override
    @PostMapping(value={"getVerifyCodeForTemp"})
    public VerifyCodeRspBo getVerifyCodeForTemp(@RequestBody VerifyCodeReqBo reqBo) {
        if (StringUtils.isBlank((CharSequence)reqBo.getVerifyValue())) {
            throw new ZTBusinessException("\u5165\u53c2verifyValue\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String verifyCode = String.valueOf((Math.random() * 9.0 + 1.0) * 100000.0).substring(0, 6);
        if (this.IS_SEND_MSG) {
            SendMessageReqBo sendMessageReqBo = this.buildMessageBo(reqBo, verifyCode);
            this.sendMessage(sendMessageReqBo);
        }
        if (null == reqBo.getVerifyCodeExpireTime()) {
            reqBo.setVerifyCodeExpireTime(this.verifyExpireTime);
        }
        String key = "VERIFY_CODE_PREFIX_";
        if (!StringUtils.isBlank((CharSequence)reqBo.getBusiKey())) {
            key = key + reqBo.getBusiKey();
        }
        this.cacheService.set(key + reqBo.getVerifyValue(), (Object)verifyCode, reqBo.getVerifyCodeExpireTime().intValue());
        VerifyCodeRspBo rspBO = new VerifyCodeRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
        if (this.IS_SHOW_VFCODE) {
            rspBO.setVerifyCode(verifyCode);
        }
        return rspBO;
    }

    @Override
    @PostMapping(value={"checkVerifyCodeForTemp"})
    public VerifyCodeRspBo checkVerifyCodeForTemp(@RequestBody VerifyCodeReqBo reqBo) {
        Object verifyCode;
        VerifyCodeRspBo rspBO = new VerifyCodeRspBo();
        if (StringUtils.isBlank((CharSequence)reqBo.getVerifyCode())) {
            throw new ZTBusinessException("\u3010verifyCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getVerifyValue())) {
            throw new ZTBusinessException(MSG_NULL_VERIFYVALUE);
        }
        String key = "VERIFY_CODE_PREFIX_";
        if (!StringUtils.isBlank((CharSequence)reqBo.getBusiKey())) {
            key = key + reqBo.getBusiKey();
        }
        if (null == (verifyCode = this.cacheService.get(key + reqBo.getVerifyValue())) || !reqBo.getVerifyCode().equals(verifyCode.toString())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return rspBO;
        }
        this.cacheService.delete(key + reqBo.getVerifyValue());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u6821\u9a8c\u6210\u529f");
        return rspBO;
    }

    private SendMessageReqBo buildMessageBo(VerifyCodeReqBo reqBo, String verifyCode) {
        ReceiverBo receiverBo;
        SendMessageReqBo rspBo = new SendMessageReqBo();
        ArrayList<ReceiverBo> receiverBoList = new ArrayList<ReceiverBo>();
        if (StringUtils.isNotBlank((CharSequence)reqBo.getMobilePhone())) {
            receiverBo = new ReceiverBo();
            receiverBo.setReceiverId("1");
            receiverBo.setReceiverName("admin");
            receiverBo.setMobileNumber(reqBo.getMobilePhone());
            receiverBoList.add(receiverBo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getEmail())) {
            receiverBo = new ReceiverBo();
            receiverBo.setReceiverId("1");
            receiverBo.setReceiverName("admin");
            receiverBo.setEMail(reqBo.getEmail());
            receiverBoList.add(receiverBo);
        }
        if (reqBo.getUserId() != null) {
            receiverBo = new ReceiverBo();
            receiverBo.setReceiverId(String.valueOf(reqBo.getUserId()));
            receiverBo.setReceiverName(String.valueOf(reqBo.getCustName()));
            receiverBoList.add(receiverBo);
        }
        rspBo.setTaskCode(reqBo.getBusiKey());
        rspBo.setReceivers(receiverBoList);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("vfCode", verifyCode);
        rspBo.setData(JSON.toJSONString(data));
        rspBo.setSendId("1");
        return rspBo;
    }

    private SendMessageRspBo sendMessage(SendMessageReqBo reqBo) {
        String geminiSendFuncReqBoStr = JSON.toJSONString((Object)reqBo);
        log.info("HTTP\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3-\u5165\u53c2\uff1a{}", (Object)geminiSendFuncReqBoStr);
        String geminiSendFuncRspBoStr = HttpUtil.post((String)this.geminiSendUrl, (String)geminiSendFuncReqBoStr);
        log.info("HTTP\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3-\u51fa\u53c2\uff1a{}", (Object)geminiSendFuncRspBoStr);
        SendMessageRspBo rspBo = (SendMessageRspBo)((Object)JUtil.jss((String)geminiSendFuncRspBoStr, SendMessageRspBo.class));
        if (!"0000".equals(rspBo.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5f02\u5e38\uff0c\u5f02\u5e38\u7f16\u7801\u3010" + rspBo.getRespCode() + "\u3011," + rspBo.getRespDesc());
        }
        return rspBo;
    }
}

