/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.constants.DycFuncRspConstants;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEstoreQryAfterTakeFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreQryAfterTakeBo;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreQryAfterTakeFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreQryAfterTakeFuncRspBO;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfterTypeAndTakeValueEntity;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocEstoreQryAfterTakeFunctionImpl
implements DycUocEstoreQryAfterTakeFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreQryAfterTakeFunctionImpl.class);
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;

    @Override
    public DycUocEstoreQryAfterTakeFuncRspBO qryAfterTake(DycUocEstoreQryAfterTakeFuncReqBO reqBo) {
        DycUocEstoreQryAfterTakeFuncRspBO funcRspBO = new DycUocEstoreQryAfterTakeFuncRspBO();
        funcRspBO.setRespCode("0000");
        funcRspBO.setRespDesc("\u6210\u529f");
        this.validateArg(reqBo);
        UocGetSaleOrderDetailServiceReqBo uocGetSaleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
        uocGetSaleOrderDetailServiceReqBo.setOrderId(reqBo.getOrderId());
        uocGetSaleOrderDetailServiceReqBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocGetSaleOrderDetailServiceRspBo saleOrderDetail = this.uocGetSaleOrderDetailService.getSaleOrderDetail(uocGetSaleOrderDetailServiceReqBo);
        for (Long itemId : reqBo.getOrdItemList()) {
            JSONObject afterOrderType = this.buildThirdEntity(saleOrderDetail, itemId);
            String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + saleOrderDetail.getSupId()));
            try {
                log.info("httpReqStr: {}", (Object)JSONObject.toJSONString((Object)reqBo));
                String httpRspStr = DycEsbUtil.doPostReuest((String)reqBo.getRequestUrl(), (String)JSONObject.toJSONString((Object)afterOrderType), (String)hsn);
                log.info("httpRspStr: {}", (Object)httpRspStr);
                this.resolveRsp(httpRspStr, funcRspBO);
            }
            catch (ZTBusinessException e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        return funcRspBO;
    }

    private JSONObject buildThirdEntity(UocGetSaleOrderDetailServiceRspBo saleOrderDetail, Long itemId) {
        JSONObject param = new JSONObject();
        List saleOrderDetailServiceRspItemBoList = saleOrderDetail.getSaleOrderDetailServiceRspItemBoList();
        Map<Long, UocGetSaleOrderDetailServiceRspItemBo> itemBoMap = saleOrderDetailServiceRspItemBoList.stream().collect(Collectors.toMap(UocGetSaleOrderDetailServiceRspItemBo::getSaleOrderItemId, o -> o));
        UocGetSaleOrderDetailServiceRspItemBo uocGetSaleOrderDetailServiceRspItemBo = itemBoMap.get(itemId);
        String skuExtSkuId = uocGetSaleOrderDetailServiceRspItemBo.getSkuExtSkuId();
        String saleOrderNoExt = saleOrderDetail.getSaleOrderNoExt();
        param.put("orderId", (Object)saleOrderNoExt);
        param.put("skuId", (Object)skuExtSkuId);
        return param;
    }

    private void resolveRsp(String returnString, DycUocEstoreQryAfterTakeFuncRspBO funcRspBO) {
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        ArrayList<DycUocEstoreQryAfterTakeBo> uocAfterServiceTypeQryServiceRspAfsBos = new ArrayList<DycUocEstoreQryAfterTakeBo>();
        if (rspJsonObject.getBoolean("success").booleanValue() && rspJsonObject.get((Object)"result") != null) {
            Object object = rspJsonObject.get((Object)"result");
            try {
                List parseArray = JSON.parseArray((String)object.toString(), AfterTypeAndTakeValueEntity.class);
                List resultByOrder = parseArray.stream().sorted(new Comparator<AfterTypeAndTakeValueEntity>(){

                    @Override
                    public int compare(AfterTypeAndTakeValueEntity o1, AfterTypeAndTakeValueEntity o2) {
                        return o1.getType().compareTo(o2.getType());
                    }
                }).collect(Collectors.toList());
                for (AfterTypeAndTakeValueEntity afterTypeAndTakeValueEntity : resultByOrder) {
                    DycUocEstoreQryAfterTakeBo uocAfterServiceTypeQryServiceRspAfsBo;
                    Integer type = afterTypeAndTakeValueEntity.getType();
                    if (DycFuncRspConstants.ThirdApiCommonConstant.AfterTakeConstant.SMQJ.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new DycUocEstoreQryAfterTakeBo();
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeName("\u4e0a\u95e8\u53d6\u4ef6");
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (DycFuncRspConstants.ThirdApiCommonConstant.AfterTakeConstant.KHFH.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new DycUocEstoreQryAfterTakeBo();
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                        uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeName("\u5ba2\u6237\u53d1\u8d27");
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (!DycFuncRspConstants.ThirdApiCommonConstant.AfterTakeConstant.KHSH.equals(type)) continue;
                    uocAfterServiceTypeQryServiceRspAfsBo = new DycUocEstoreQryAfterTakeBo();
                    uocAfterServiceTypeQryServiceRspAfsBo.setPickwareType(type);
                    uocAfterServiceTypeQryServiceRspAfsBo.setPickwareTypeName("\u5ba2\u6237\u9001\u8d27");
                    uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                }
                if (CollectionUtil.isEmpty(funcRspBO.getAfterTakeList())) {
                    funcRspBO.setAfterTakeList(uocAfterServiceTypeQryServiceRspAfsBos);
                } else {
                    List intersection = (List)CollectionUtil.intersection(funcRspBO.getAfterTakeList(), uocAfterServiceTypeQryServiceRspAfsBos);
                    funcRspBO.setAfterTakeList(intersection);
                }
            }
            catch (Exception e) {
                funcRspBO.setAfterTakeList(uocAfterServiceTypeQryServiceRspAfsBos);
            }
        }
    }

    private void validateArg(DycUocEstoreQryAfterTakeFuncReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new ZTBusinessException("\u9500\u552e\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

