/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.estore.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.base.utils.IdUtil;
import com.tydic.dyc.estore.order.api.DycUocCheckRefuseOrderService;
import com.tydic.dyc.estore.order.bo.DycUocCheckRefuseOrderServiceReqBO;
import com.tydic.dyc.estore.order.bo.DycUocCheckRefuseOrderServiceRspBO;
import com.tydic.dyc.oc.service.checkorder.UocCreateCheckOrderService;
import com.tydic.dyc.oc.service.checkorder.UocGetOutCheckOrderInfoService;
import com.tydic.dyc.oc.service.checkorder.bo.UocCheckOrderBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocCheckOrderErrorItemBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocCreateCheckOrderServiceReqBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocGetOutCheckOrderInfoServiceReqBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocGetOutCheckOrderInfoServiceRspBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocOutCheckOrderBo;
import com.tydic.dyc.oc.service.domainservice.UocGetCheckVoterOrdersService;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCheckVoterOrdersReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCheckVoterOrdersRspBO;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderBo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.estore.order.api.DycUocCheckRefuseOrderService"})
public class DycUocCheckRefuseOrderServiceImpl
implements DycUocCheckRefuseOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocCheckRefuseOrderServiceImpl.class);
    @Autowired
    private UocGetOutCheckOrderInfoService uocGetOutCheckOrderInfoService;
    @Autowired
    private UocGetCheckVoterOrdersService uocGetCheckVoterOrdersService;
    @Autowired
    private UocCreateCheckOrderService uocCreateCheckOrderService;

    @Override
    @PostMapping(value={"checkNewOrder"})
    public DycUocCheckRefuseOrderServiceRspBO checkNewOrder(@RequestBody DycUocCheckRefuseOrderServiceReqBO reqBO) {
        DycUocCheckRefuseOrderServiceRspBO rspBO = new DycUocCheckRefuseOrderServiceRspBO();
        UocGetOutCheckOrderInfoServiceRspBo esCheckOrders = this.getEsCheckOrders(reqBO);
        UocGetCheckVoterOrdersRspBO dycCheckOrders = this.getDycCheckOrders(reqBO);
        UocCreateCheckOrderServiceReqBo createCheckOrderServiceReqBo = this.checkOrder(esCheckOrders, dycCheckOrders, reqBO);
        this.uocCreateCheckOrderService.createCheckOrder(createCheckOrderServiceReqBo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UocGetOutCheckOrderInfoServiceRspBo getEsCheckOrders(DycUocCheckRefuseOrderServiceReqBO reqBO) {
        UocGetOutCheckOrderInfoServiceReqBo getCheckOrderInfoServiceReqBo = new UocGetOutCheckOrderInfoServiceReqBo();
        getCheckOrderInfoServiceReqBo.setSupplier(DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupNo())) + ":" + DycPropertiesUtil.getProperty((String)("SUPPLIER_NAME_" + reqBO.getSupNo())));
        getCheckOrderInfoServiceReqBo.setOrderTimeStart(this.computeTime().getString("startDate"));
        getCheckOrderInfoServiceReqBo.setOrderTimeEnd(this.computeTime().getString("endDate"));
        getCheckOrderInfoServiceReqBo.setCheckType(Integer.valueOf(3));
        UocGetOutCheckOrderInfoServiceRspBo uocGetOutCheckOrderInfoServiceRspBo = this.uocGetOutCheckOrderInfoService.getCheckOrderInfo(getCheckOrderInfoServiceReqBo);
        return uocGetOutCheckOrderInfoServiceRspBo;
    }

    private UocGetCheckVoterOrdersRspBO getDycCheckOrders(DycUocCheckRefuseOrderServiceReqBO reqBO) {
        UocGetCheckVoterOrdersReqBO uocGetCheckOrdersReqBO = new UocGetCheckVoterOrdersReqBO();
        uocGetCheckOrdersReqBO.setArriveTimeStart(this.computeTime().getString("startDate"));
        uocGetCheckOrdersReqBO.setArriveTimeEnd(this.computeTime().getString("endDate"));
        uocGetCheckOrdersReqBO.setSupId(reqBO.getSupNo());
        uocGetCheckOrdersReqBO.setCheckType(Integer.valueOf(3));
        UocGetCheckVoterOrdersRspBO uocGetCheckOrdersRspBO = this.uocGetCheckVoterOrdersService.getCheckShipOrders(uocGetCheckOrdersReqBO);
        return uocGetCheckOrdersRspBO;
    }

    private BigDecimal computePrice(BigDecimal account, BigDecimal price) {
        return null;
    }

    private UocCreateCheckOrderServiceReqBo checkOrder(UocGetOutCheckOrderInfoServiceRspBo esCheckOrders, UocGetCheckVoterOrdersRspBO dycCheckOrders, DycUocCheckRefuseOrderServiceReqBO reqBO) {
        UocCheckOrderErrorItemBo errorItemBo;
        UocCreateCheckOrderServiceReqBo checkOrderBO = new UocCreateCheckOrderServiceReqBo();
        ArrayList<UocCheckOrderBo> uocCheckOrderBos = new ArrayList<UocCheckOrderBo>();
        List dycOrders = dycCheckOrders.getUocShipOrderBos();
        List esOrders = esCheckOrders.getOrderBos();
        Integer esOrderTotal = esOrders.size();
        log.info("\u7535\u5546\u4fa7\u62d2\u6536\u5355\u603b\u91cf\uff1a{}", (Object)esOrderTotal);
        Integer dycOrderTotal = dycOrders.size();
        log.info("\u5546\u57ce\u4fa7\u62d2\u6536\u603b\u91cf\uff1a{}", (Object)dycOrderTotal);
        Map<String, BigDecimal> dycOrderPriceMap = dycOrders.stream().collect(Collectors.toMap(UocShipOrderBo::getShipOrderNoExt, UocShipOrderBo::getRejectPrice));
        Map<String, Long> dycOrderMap = dycOrders.stream().collect(Collectors.toMap(UocShipOrderBo::getShipOrderNoExt, UocShipOrderBo::getShipOrderId));
        Map<String, BigDecimal> esOrderPriceMap = esOrders.stream().collect(Collectors.toMap(UocOutCheckOrderBo::getOutOrderId, UocOutCheckOrderBo::getOutOrderPrice));
        Map<String, String> dycOrderNoMap = dycOrders.stream().collect(Collectors.toMap(UocShipOrderBo::getShipOrderNoExt, UocShipOrderBo::getShipOrderNo));
        LocalDate localDate = LocalDate.now().minusDays(1L);
        String date = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        ArrayList<UocCheckOrderErrorItemBo> uocCheckOrderErrorItemBos = new ArrayList<UocCheckOrderErrorItemBo>();
        long checkId = IdUtil.nextId();
        Integer checkMoneyResult = 1;
        if (esOrderTotal.compareTo(dycOrderTotal) >= 0) {
            for (UocOutCheckOrderBo esOrder : esOrders) {
                errorItemBo = new UocCheckOrderErrorItemBo();
                BigDecimal dycPrice = dycOrderPriceMap.get(esOrder.getOutOrderId());
                if (ObjectUtil.isEmpty((Object)dycPrice)) {
                    checkMoneyResult = 2;
                    errorItemBo.setCheckDate(date);
                    errorItemBo.setCheckErrorItemId(Long.valueOf(IdUtil.nextId()));
                    errorItemBo.setCheckId(Long.valueOf(checkId));
                    errorItemBo.setCheckType(Integer.valueOf(3));
                    errorItemBo.setSupplier(DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupNo())) + ":" + DycPropertiesUtil.getProperty((String)("SUPPLIER_NAME_" + reqBO.getSupNo())));
                    errorItemBo.setOutOrderPrice(esOrder.getOutOrderPrice());
                    errorItemBo.setOutOrderId(esOrder.getOutOrderId());
                    uocCheckOrderErrorItemBos.add(errorItemBo);
                    continue;
                }
                int comparePriceResult = esOrder.getOutOrderPrice().compareTo(dycPrice);
                if (comparePriceResult == 0) continue;
                checkMoneyResult = 2;
                errorItemBo.setCheckDate(date);
                errorItemBo.setCheckErrorItemId(Long.valueOf(IdUtil.nextId()));
                errorItemBo.setCheckId(Long.valueOf(checkId));
                errorItemBo.setCheckType(Integer.valueOf(3));
                errorItemBo.setSupplier(DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupNo())) + ":" + DycPropertiesUtil.getProperty((String)("SUPPLIER_NAME_" + reqBO.getSupNo())));
                errorItemBo.setInternalObjId(dycOrderMap.get(esOrder.getOutOrderId()));
                errorItemBo.setInternalObjType(Integer.valueOf(2));
                errorItemBo.setInternalObjNo(dycOrderNoMap.get(esOrder.getOutOrderId()));
                errorItemBo.setInternalObjPrice(dycOrderPriceMap.get(esOrder.getOutOrderId()));
                errorItemBo.setOutOrderPrice(esOrder.getOutOrderPrice());
                errorItemBo.setOutOrderId(esOrder.getOutOrderId());
                uocCheckOrderErrorItemBos.add(errorItemBo);
            }
        } else if (esOrderTotal.compareTo(dycOrderTotal) < 0) {
            for (UocShipOrderBo dycOrder : dycOrders) {
                errorItemBo = new UocCheckOrderErrorItemBo();
                BigDecimal esPrice = esOrderPriceMap.get(dycOrder.getShipOrderNoExt());
                if (ObjectUtil.isEmpty((Object)esPrice)) {
                    checkMoneyResult = 2;
                    errorItemBo.setCheckDate(date);
                    errorItemBo.setCheckErrorItemId(Long.valueOf(IdUtil.nextId()));
                    errorItemBo.setCheckId(Long.valueOf(checkId));
                    errorItemBo.setCheckType(Integer.valueOf(3));
                    errorItemBo.setSupplier(DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupNo())) + ":" + DycPropertiesUtil.getProperty((String)("SUPPLIER_NAME_" + reqBO.getSupNo())));
                    errorItemBo.setInternalObjId(dycOrder.getSaleOrderId());
                    errorItemBo.setInternalObjType(Integer.valueOf(2));
                    errorItemBo.setInternalObjNo(dycOrder.getShipOrderNo());
                    errorItemBo.setInternalObjPrice(dycOrder.getRejectPrice());
                    uocCheckOrderErrorItemBos.add(errorItemBo);
                    continue;
                }
                int comparePriceResult = dycOrder.getRejectPrice().compareTo(esPrice);
                if (comparePriceResult == 0) continue;
                checkMoneyResult = 2;
                errorItemBo.setCheckDate(date);
                errorItemBo.setCheckErrorItemId(Long.valueOf(IdUtil.nextId()));
                errorItemBo.setCheckType(Integer.valueOf(3));
                errorItemBo.setSupplier(DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupNo())) + ":" + DycPropertiesUtil.getProperty((String)("SUPPLIER_NAME_" + reqBO.getSupNo())));
                errorItemBo.setInternalObjId(dycOrder.getShipOrderId());
                errorItemBo.setInternalObjType(Integer.valueOf(2));
                errorItemBo.setInternalObjNo(dycOrder.getShipOrderNo());
                errorItemBo.setInternalObjPrice(dycOrder.getRejectPrice());
                errorItemBo.setOutOrderPrice(esOrderPriceMap.get(dycOrder.getShipOrderNoExt()));
                errorItemBo.setOutOrderId(dycOrder.getShipOrderNoExt().toString());
                uocCheckOrderErrorItemBos.add(errorItemBo);
            }
        }
        UocOutCheckOrderBo uocOutCheckOrderBo = new UocOutCheckOrderBo();
        uocOutCheckOrderBo.setCheckType(Integer.valueOf(3));
        BigDecimal orderPrice = dycOrders.stream().map(UocShipOrderBo::getRejectPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u5546\u57ce\u4fa7\u62d2\u6536\u5355\u603b\u91d1\u989d\uff1a{}", (Object)orderPrice.toPlainString());
        BigDecimal esOrderPrice = esOrders.stream().map(UocOutCheckOrderBo::getOutOrderPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u7535\u5546\u4fa7\u62d2\u6536\u5355\u603b\u91d1\u989d\uff1a{}", (Object)esOrderPrice.toPlainString());
        UocCheckOrderBo uocCheckOrderBo = new UocCheckOrderBo();
        uocCheckOrderBo.setCheckType(Integer.valueOf(3));
        uocCheckOrderBo.setCheckTypeDesc("\u62d2\u6536\u8ba2\u5355\u5bf9\u8d26");
        uocCheckOrderBo.setSupplier(DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupNo())) + ":" + DycPropertiesUtil.getProperty((String)("SUPPLIER_NAME_" + reqBO.getSupNo())));
        uocCheckOrderBo.setCheckId(Long.valueOf(checkId));
        uocCheckOrderBo.setCheckAmountResult(Integer.valueOf(esOrderTotal.equals(dycOrderTotal) ? 1 : 2));
        uocCheckOrderBo.setCheckAmountResultDesc(uocCheckOrderBo.getCheckAmountResult() == 1 ? "\u6570\u91cf\u4e00\u81f4" : "\u6570\u91cf\u4e0d\u4e00\u81f4");
        uocCheckOrderBo.setCheckMoneyResult(checkMoneyResult);
        uocCheckOrderBo.setCheckMoneyResultDesc(checkMoneyResult == 1 ? "\u91d1\u989d\u4e00\u81f4" : "\u91d1\u989d\u4e0d\u4e00\u81f4");
        uocCheckOrderBo.setExecuteTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        uocCheckOrderBo.setCheckDate(date);
        uocCheckOrderBo.setInternalOrderAmount(Integer.valueOf(dycOrders.size()));
        uocCheckOrderBo.setInternalOrderPrice(orderPrice);
        uocCheckOrderBo.setOutOrderPrice(esOrderPrice);
        uocCheckOrderBo.setOutOrderAmount(Integer.valueOf(esOrders.size()));
        uocCheckOrderBo.setUocCheckOrderErrorItemBos(uocCheckOrderErrorItemBos);
        uocCheckOrderBos.add(uocCheckOrderBo);
        checkOrderBO.setUocCheckOrderBos(uocCheckOrderBos);
        return checkOrderBO;
    }

    private JSONObject computeTime() {
        LocalDate localDate = LocalDate.now().minusDays(1L);
        String defaultStartDate = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        defaultStartDate = defaultStartDate + " 00:00:00";
        String defaultEndDate = defaultStartDate.substring(0, 10) + " 23:59:59";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("startDate", (Object)defaultStartDate);
        jsonObject.put("endDate", (Object)defaultEndDate);
        return jsonObject;
    }
}

