/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.estore.order.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.busicommon.order.api.DycUocRefundPayFunction;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocRefundPayFunctionReqBO;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocRefundPayFunctionRspBO;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.estore.order.api.DycUocDealAfOrderMsgService;
import com.tydic.dyc.estore.order.bo.DycUocDealAfOrderMsgServiceReqBO;
import com.tydic.dyc.estore.order.bo.DycUocDealAfOrderMsgServiceRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderSupplierConfirmService;
import com.tydic.dyc.oc.service.domainservice.UocGetAfOrderDetailService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetAfOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetAfOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.order.UocQryOutOrderIndexService;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceRspBo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.estore.order.api.DycUocDealAfOrderMsgService"})
public class DycUocDealAfOrderMsgServiceImpl
implements DycUocDealAfOrderMsgService {
    private static final Logger log = LoggerFactory.getLogger(DycUocDealAfOrderMsgServiceImpl.class);
    private static final Integer AFTER_PROCESSING_STATE = 0;
    private static final Integer AFTER_SUCCESS_STATE = 1;
    private static final Integer AFTER_FAIL_STATE = 2;
    @Autowired
    private UocQryOutOrderIndexService uocQryOutOrderIndexService;
    @Autowired
    private UocGetAfOrderDetailService uocGetAfOrderDetailService;
    @Autowired
    private UocAfterOrderSupplierConfirmService uocAfterOrderSupplierConfirmService;
    @Autowired
    private DycUocRefundPayFunction dycUocRefundPayFunction;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;

    @Override
    @PostMapping(value={"estorAfOrder"})
    public DycUocDealAfOrderMsgServiceRspBO estorAfOrder(@RequestBody DycUocDealAfOrderMsgServiceReqBO reqBO) {
        DycUocDealAfOrderMsgServiceRspBO rspBO = new DycUocDealAfOrderMsgServiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocQryOutOrderIndexServiceRspBo qryOutOrderIndexBo = this.qryOrderQueryIndex(reqBO);
        UocGetAfOrderDetailServiceRspBo afOrderDetailSBo = this.qryAfOrderDetail(reqBO, qryOutOrderIndexBo);
        this.dealAfOrder(reqBO, qryOutOrderIndexBo, afOrderDetailSBo);
        return rspBO;
    }

    private UocQryOutOrderIndexServiceRspBo qryOrderQueryIndex(DycUocDealAfOrderMsgServiceReqBO reqBO) {
        UocQryOutOrderIndexServiceReqBo serviceReqBo = new UocQryOutOrderIndexServiceReqBo();
        serviceReqBo.setOutOrderNo(reqBO.getResult().getServiceId());
        serviceReqBo.setType(reqBO.getType());
        serviceReqBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        UocQryOutOrderIndexServiceRspBo serviceRspBo = this.uocQryOutOrderIndexService.qryOutOrderIndex(serviceReqBo);
        if (!"0000".equals(serviceRspBo.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u5916\u90e8\u552e\u540e\u670d\u52a1\u5355" + reqBO.getResult().getServiceId() + "\u5173\u8054\u8868\u5931\u8d25");
        }
        return this.uocQryOutOrderIndexService.qryOutOrderIndex(serviceReqBo);
    }

    private UocGetAfOrderDetailServiceRspBo qryAfOrderDetail(DycUocDealAfOrderMsgServiceReqBO reqBO, UocQryOutOrderIndexServiceRspBo qryOutOrderIndexBo) {
        UocGetAfOrderDetailServiceReqBo dycUocGetAfOrderDetailFuncReqBO = new UocGetAfOrderDetailServiceReqBo();
        dycUocGetAfOrderDetailFuncReqBO.setOrderId(((UocQryOutOrderIndexBo)qryOutOrderIndexBo.getQryOutOrderIndexBoList().get(0)).getOrderId());
        dycUocGetAfOrderDetailFuncReqBO.setAfOrderId(((UocQryOutOrderIndexBo)qryOutOrderIndexBo.getQryOutOrderIndexBoList().get(0)).getObjId());
        UocGetAfOrderDetailServiceRspBo dycUocGetAfOrderDetailFuncRspBO = this.uocGetAfOrderDetailService.qryAfOrderDetails(dycUocGetAfOrderDetailFuncReqBO);
        if (!"0000".equals(dycUocGetAfOrderDetailFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u552e\u540e\u5355" + dycUocGetAfOrderDetailFuncReqBO.getAfOrderId() + "\u552e\u540e\u4fe1\u606f\u5931\u8d25");
        }
        return dycUocGetAfOrderDetailFuncRspBO;
    }

    private void dealAfOrder(DycUocDealAfOrderMsgServiceReqBO reqBO, UocQryOutOrderIndexServiceRspBo qryOutOrderIndexBo, UocGetAfOrderDetailServiceRspBo afOrderDetailSBo) {
        UocQryOutOrderIndexBo afOrderIndexBo = (UocQryOutOrderIndexBo)qryOutOrderIndexBo.getQryOutOrderIndexBoList().get(0);
        UocAfterOrderSupplierConfirmReqBo dycUocAfterOrderSupplierConfirmFuncReqBO = this.getUocAfterOrderSupplierConfirmReqBo(reqBO, afOrderDetailSBo, afOrderIndexBo);
        UocAfterOrderSupplierConfirmRspBo dycUocAfterOrderSupplierConfirmFuncRspBO = this.uocAfterOrderSupplierConfirmService.dealAfterOrderSupplierConfirm(dycUocAfterOrderSupplierConfirmFuncReqBO);
        if (!"0000".equals(dycUocAfterOrderSupplierConfirmFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u552e\u540e\u5355" + afOrderIndexBo.getObjId() + "\u7684\u552e\u540e\u6d88\u606f\u5904\u7406\u5931\u8d25:" + dycUocAfterOrderSupplierConfirmFuncRspBO.getRespCode());
        }
        if (dycUocAfterOrderSupplierConfirmFuncRspBO.isReConsume()) {
            this.doBuisPricess(reqBO, afOrderDetailSBo);
            if (AFTER_SUCCESS_STATE.equals(reqBO.getResult().getState())) {
                this.refundPay(dycUocAfterOrderSupplierConfirmFuncReqBO, dycUocAfterOrderSupplierConfirmFuncRspBO);
            }
            log.info("\u7535\u5546\u552e\u540e\u5904\u7406\u57cb\u70b9,\u552e\u540e\u5355{},\u72b6\u6001\u4e3a\uff1a{}", (Object)afOrderDetailSBo.getServInfo().getAfServCode(), (Object)afOrderDetailSBo.getServInfo().getServState());
            this.extracted(afOrderDetailSBo, afOrderIndexBo);
        }
    }

    private UocAfterOrderSupplierConfirmReqBo getUocAfterOrderSupplierConfirmReqBo(DycUocDealAfOrderMsgServiceReqBO reqBO, UocGetAfOrderDetailServiceRspBo afOrderDetailSBo, UocQryOutOrderIndexBo afOrderIndexBo) {
        UocAfterOrderSupplierConfirmReqBo dycUocAfterOrderSupplierConfirmFuncReqBO = new UocAfterOrderSupplierConfirmReqBo();
        dycUocAfterOrderSupplierConfirmFuncReqBO.setAfOrderId(afOrderIndexBo.getObjId());
        dycUocAfterOrderSupplierConfirmFuncReqBO.setOrderId(afOrderIndexBo.getOrderId());
        dycUocAfterOrderSupplierConfirmFuncReqBO.setConfirmflag(reqBO.getResult().getState());
        dycUocAfterOrderSupplierConfirmFuncReqBO.setTaskId(afOrderDetailSBo.getServInfo().getTaskId());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getTime())) {
            DateTime date = DateUtil.date((Date)reqBO.getTime());
            dycUocAfterOrderSupplierConfirmFuncReqBO.setDateTime((Date)date);
        }
        dycUocAfterOrderSupplierConfirmFuncReqBO.setTraceId(reqBO.getTraceId());
        return dycUocAfterOrderSupplierConfirmFuncReqBO;
    }

    private void extracted(UocGetAfOrderDetailServiceRspBo afOrderDetailSBo, UocQryOutOrderIndexBo afOrderIndexBo) {
        if (UocDicConstant.SERVICE_STATE.SUMIT_APPLICATION.equals(afOrderDetailSBo.getServInfo().getServState())) {
            try {
                this.buryPointAfOrder(afOrderIndexBo);
            }
            catch (Exception e) {
                log.error("\u57cb\u70b9\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void refundPay(UocAfterOrderSupplierConfirmReqBo dycUocAfterOrderSupplierConfirmFuncReqBO, UocAfterOrderSupplierConfirmRspBo dycUocAfterOrderSupplierConfirmFuncRspBO) {
        DycUocRefundPayFunctionReqBO dycUocRefundPayFunctionReqBO = new DycUocRefundPayFunctionReqBO();
        dycUocRefundPayFunctionReqBO.setOrderId(dycUocAfterOrderSupplierConfirmFuncReqBO.getOrderId());
        dycUocRefundPayFunctionReqBO.setSaleOrderId(dycUocAfterOrderSupplierConfirmFuncRspBO.getSaleOrderId());
        dycUocRefundPayFunctionReqBO.setAfOrderId(dycUocAfterOrderSupplierConfirmFuncReqBO.getAfOrderId());
        dycUocRefundPayFunctionReqBO.setReturnNode("4");
        DycUocRefundPayFunctionRspBO dycUocRefundPayFunctionRspBO = this.dycUocRefundPayFunction.refundPay(dycUocRefundPayFunctionReqBO);
        if (!"0000".equals(dycUocRefundPayFunctionRspBO.getRespCode())) {
            throw new ZTBusinessException("\u652f\u4ed8\u9000\u6b3e\u5931\u8d25");
        }
    }

    private void doBuisPricess(DycUocDealAfOrderMsgServiceReqBO reqBO, UocGetAfOrderDetailServiceRspBo afOrderDetailSBo) {
        String taskId = afOrderDetailSBo.getServInfo().getTaskId();
        String stepId = afOrderDetailSBo.getServInfo().getStepId();
        Integer pickwareType = afOrderDetailSBo.getServInfo().getPickwareType();
        DycBusiProcessFlowFuncReqBO flowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        flowFuncReqBO.setTaskId(taskId);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("afterSaleState", reqBO.getResult().getState());
        map.put("pickwareType", 1);
        flowFuncReqBO.setVariables(map);
        DycBusiProcessFlowFuncRspBO flowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(flowFuncReqBO);
        if (!"0000".equals(flowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u552e\u540e\u5355" + afOrderDetailSBo.getServInfo().getAfServCode() + "\u4e1a\u52a1\u6d41\u8f6c\u5931\u8d25:" + flowFuncRspBO.getRespCode());
        }
    }

    private void buryPointAfOrder(UocQryOutOrderIndexBo contextBO) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("afOrderId", (Object)contextBO.getObjId());
        jsonObject.put("orderId", (Object)contextBO.getOrderId());
        ArrayList<DycBuriedPointCallFuncBo> buildsList = new ArrayList<DycBuriedPointCallFuncBo>();
        DycBuriedPointCallFuncBo bo = new DycBuriedPointCallFuncBo();
        bo.setIdent("supConfirm");
        bo.setDycBusiCode("afterSaleOrderSync");
        bo.setDycCenterCode("UOC");
        bo.setData((Object)jsonObject);
        buildsList.add(bo);
        funcReqBo.setBusiList(buildsList);
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u7535\u5546\u4f9b\u5e94\u5546\u786e\u8ba4\u552e\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }
}

