/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.estore.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.estore.api.DycUocEstoreCancelSaleOrderFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreCancelSaleOrderFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreCancelSaleOrderFuncRspBO;
import com.tydic.dyc.estore.order.api.DycUocEstoreCancelSaleOrderService;
import com.tydic.dyc.estore.order.bo.DycUocEstoreCancelSaleOrderReqBO;
import com.tydic.dyc.estore.order.bo.DycUocEstoreCancelSaleOrderRspBO;
import com.tydic.dyc.oc.service.order.UocQryOutOrderIndexService;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.estore.order.api.DycUocEstoreCancelSaleOrderService"})
public class DycUocEstoreCancelSaleOrderServiceImpl
implements DycUocEstoreCancelSaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreCancelSaleOrderServiceImpl.class);
    @Autowired
    private UocQryOutOrderIndexService uocQryOutOrderIndexService;
    @Autowired
    private DycUocEstoreCancelSaleOrderFunction dycUocEstoreCancelSaleOrderFunction;
    @Value(value="${ESB_CANCEL_ORDER_URL}")
    private String esCancelOrderUrl;

    @Override
    @PostMapping(value={"cancelSaleOrder"})
    public DycUocEstoreCancelSaleOrderRspBO cancelSaleOrder(@RequestBody DycUocEstoreCancelSaleOrderReqBO reqBO) {
        this.validateArg(reqBO);
        DycUocEstoreCancelSaleOrderRspBO rspBO = new DycUocEstoreCancelSaleOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocQryOutOrderIndexServiceReqBo uocReqBo = (UocQryOutOrderIndexServiceReqBo)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UocQryOutOrderIndexServiceReqBo.class);
        uocReqBo.setObjId(reqBO.getSaleOrderId());
        UocQryOutOrderIndexServiceRspBo uocRspBo = this.uocQryOutOrderIndexService.qryOutOrderIndex(uocReqBo);
        if (!"0000".equals(uocRspBo.getRespCode())) {
            throw new ZTBusinessException(uocRspBo.getRespDesc());
        }
        if (ObjectUtil.isEmpty((Object)uocRspBo.getQryOutOrderIndexBoList())) {
            throw new ZTBusinessException("\u8ba2\u5355Id\uff1a" + reqBO.getOrderId() + " \u6ca1\u6709\u67e5\u8be2\u5230\u7535\u5546\u8ba2\u5355id");
        }
        DycUocEstoreCancelSaleOrderFuncReqBO funcReqBO = new DycUocEstoreCancelSaleOrderFuncReqBO();
        funcReqBO.setOutOrderId(((UocQryOutOrderIndexBo)uocRspBo.getQryOutOrderIndexBoList().get(0)).getOutObjId());
        funcReqBO.setSupplierNo(uocRspBo.getSupplierNo());
        funcReqBO.setOrderId(reqBO.getOrderId());
        funcReqBO.setObjId(((UocQryOutOrderIndexBo)uocRspBo.getQryOutOrderIndexBoList().get(0)).getObjId());
        DycUocEstoreCancelSaleOrderFuncRspBO funcRspBO = this.dycUocEstoreCancelSaleOrderFunction.cancelSaleOrder(funcReqBO);
        if (!"0000".equals(funcRspBO.getRespCode())) {
            throw new ZTBusinessException(funcRspBO.getRespDesc());
        }
        return rspBO;
    }

    private void validateArg(DycUocEstoreCancelSaleOrderReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSaleOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

