/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.pay.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.pay.api.DycFscComQueryOrderQuantityAbilityService;
import com.tydic.dyc.fsc.pay.bo.DycFscComQueryOrderQuantityAbilityReqBO;
import com.tydic.dyc.fsc.pay.bo.DycFscComQueryOrderQuantityAbilityRspBO;
import com.tydic.dyc.fsc.pay.bo.DycFscUocQryAcceptOrderListReqBO;
import com.tydic.dyc.fsc.pay.bo.DycFscUocQryAcceptOrderListRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.fsc.pay.api.DycFscComQueryOrderQuantityAbilityService"})
public class DycFscComQueryOrderQuantityAbilityServiceImpl
implements DycFscComQueryOrderQuantityAbilityService {
    public static final Integer SUBMITTED_1006 = 1006;
    public static final Integer SUBMITTED_1004 = 1004;
    public static final Integer SUBMITTED_1014 = 1014;
    public static final String UN_SUBMIT_00 = "0,0";
    public static final String UN_SUBMIT_03 = "0,3";
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Value(value="${fsc.qry.url:http://39.105.66.173:10220/query}")
    private String generalQueryUrl;

    @Override
    @PostMapping(value={"quertySettleQuantity"})
    public DycFscComQueryOrderQuantityAbilityRspBO quertySettleQuantity(@RequestBody DycFscComQueryOrderQuantityAbilityReqBO reqBO) {
        DycFscComQueryOrderQuantityAbilityRspBO rspBO = new DycFscComQueryOrderQuantityAbilityRspBO();
        this.getCheckCount(reqBO, rspBO);
        this.getFscOrderCount(reqBO, rspBO);
        return rspBO;
    }

    private void getFscOrderCount(DycFscComQueryOrderQuantityAbilityReqBO reqBO, DycFscComQueryOrderQuantityAbilityRspBO rspBO) {
        FscComOrderListQueryAbilityRspBO fscComOrderListQueryAbilityRspBO = this.getFscOrder(reqBO);
        List rows = fscComOrderListQueryAbilityRspBO.getRows();
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            rspBO.setAgrFscOrderCount(Convert.toInt((Object)rows.stream().filter(fscComOrderListBO -> "3".equals(fscComOrderListBO.getOrderSource())).count()));
            rspBO.setNoAgrFscOrderCount(Convert.toInt((Object)rows.stream().filter(fscComOrderListBO -> "1".equals(fscComOrderListBO.getOrderSource())).count()));
            rspBO.setEcoFscOrderCount(Convert.toInt((Object)rows.stream().filter(fscComOrderListBO -> "2".equals(fscComOrderListBO.getOrderSource())).count()));
        }
    }

    private void getCheckCount(DycFscComQueryOrderQuantityAbilityReqBO reqBO, DycFscComQueryOrderQuantityAbilityRspBO rspBO) {
        rspBO.setAgrCheckCount(this.getOrderCheckCount(reqBO, "3"));
        rspBO.setNoAgrCheckCount(this.getOrderCheckCount(reqBO, "1"));
        rspBO.setEcoCheckCount(this.getOrderCheckCount(reqBO, "2"));
    }

    private Integer getOrderCheckCount(DycFscComQueryOrderQuantityAbilityReqBO reqBO, String orderSource) {
        DycFscUocQryAcceptOrderListReqBO uocInspectionDetailsListPageQueryReqBO = new DycFscUocQryAcceptOrderListReqBO();
        uocInspectionDetailsListPageQueryReqBO.setRelInfo(Arrays.asList(UN_SUBMIT_00, UN_SUBMIT_03));
        uocInspectionDetailsListPageQueryReqBO.setPurNo(Convert.toStr((Object)reqBO.getCompanyId()));
        uocInspectionDetailsListPageQueryReqBO.setOrderSourceList(Collections.singletonList(orderSource));
        DycFscUocQryAcceptOrderListRspBO inspectionList = this.getInspectionList(uocInspectionDetailsListPageQueryReqBO);
        return inspectionList.getRecordsTotal();
    }

    private FscComOrderListQueryAbilityRspBO getFscOrder(DycFscComQueryOrderQuantityAbilityReqBO reqBO) {
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = new FscComOrderListQueryAbilityReqBO();
        fscComOrderListQueryAbilityReqBO.setOrderFlows(Collections.singletonList(FscConstants.OrderFlow.INVOICE));
        fscComOrderListQueryAbilityReqBO.setOrderStates(Arrays.asList(SUBMITTED_1004, SUBMITTED_1006, SUBMITTED_1014));
        fscComOrderListQueryAbilityReqBO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        fscComOrderListQueryAbilityReqBO.setPurchaserId(reqBO.getPurchaserId());
        fscComOrderListQueryAbilityReqBO.setPageSize(Integer.valueOf(1000));
        fscComOrderListQueryAbilityReqBO.setPageNo(Integer.valueOf(1));
        FscComOrderListQueryAbilityRspBO fscComOrderListQueryAbilityRspBO = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
        if (!"0000".equals(fscComOrderListQueryAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(fscComOrderListQueryAbilityRspBO.getRespDesc());
        }
        return fscComOrderListQueryAbilityRspBO;
    }

    private DycFscUocQryAcceptOrderListRspBO getInspectionList(DycFscUocQryAcceptOrderListReqBO qryAcceptOrderListReqBO) {
        String rspJsonStr = this.commonQry(JSON.toJSONString((Object)((Object)qryAcceptOrderListReqBO)));
        return (DycFscUocQryAcceptOrderListRspBO)((Object)JSON.parseObject((String)rspJsonStr, DycFscUocQryAcceptOrderListRspBO.class));
    }

    private String commonQry(String reqJsonStr) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("queryCountFlag", (Object)true);
        jsonObject.put("reqParams", (Object)reqJsonStr);
        return HttpUtil.post((String)this.generalQueryUrl, (String)jsonObject.toJSONString(), (int)6000);
    }

    public FscComOrderListPageQueryAbilityService getFscComOrderListPageQueryAbilityService() {
        return this.fscComOrderListPageQueryAbilityService;
    }

    public String getGeneralQueryUrl() {
        return this.generalQueryUrl;
    }

    public void setFscComOrderListPageQueryAbilityService(FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService) {
        this.fscComOrderListPageQueryAbilityService = fscComOrderListPageQueryAbilityService;
    }

    public void setGeneralQueryUrl(String generalQueryUrl) {
        this.generalQueryUrl = generalQueryUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DycFscComQueryOrderQuantityAbilityServiceImpl)) {
            return false;
        }
        DycFscComQueryOrderQuantityAbilityServiceImpl other = (DycFscComQueryOrderQuantityAbilityServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FscComOrderListPageQueryAbilityService this$fscComOrderListPageQueryAbilityService = this.getFscComOrderListPageQueryAbilityService();
        FscComOrderListPageQueryAbilityService other$fscComOrderListPageQueryAbilityService = other.getFscComOrderListPageQueryAbilityService();
        if (this$fscComOrderListPageQueryAbilityService == null ? other$fscComOrderListPageQueryAbilityService != null : !this$fscComOrderListPageQueryAbilityService.equals(other$fscComOrderListPageQueryAbilityService)) {
            return false;
        }
        String this$generalQueryUrl = this.getGeneralQueryUrl();
        String other$generalQueryUrl = other.getGeneralQueryUrl();
        return !(this$generalQueryUrl == null ? other$generalQueryUrl != null : !this$generalQueryUrl.equals(other$generalQueryUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DycFscComQueryOrderQuantityAbilityServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FscComOrderListPageQueryAbilityService $fscComOrderListPageQueryAbilityService = this.getFscComOrderListPageQueryAbilityService();
        result = result * 59 + ($fscComOrderListPageQueryAbilityService == null ? 43 : $fscComOrderListPageQueryAbilityService.hashCode());
        String $generalQueryUrl = this.getGeneralQueryUrl();
        result = result * 59 + ($generalQueryUrl == null ? 43 : $generalQueryUrl.hashCode());
        return result;
    }

    public String toString() {
        return "DycFscComQueryOrderQuantityAbilityServiceImpl(fscComOrderListPageQueryAbilityService=" + this.getFscComOrderListPageQueryAbilityService() + ", generalQueryUrl=" + this.getGeneralQueryUrl() + ")";
    }
}

