/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.pay.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.pay.api.DycFscQueryServiceListNewAbilityService;
import com.tydic.dyc.fsc.pay.bo.DycFscOrderInfoBO;
import com.tydic.dyc.fsc.pay.bo.DycFscQueryServiceListAbilityReqBO;
import com.tydic.dyc.fsc.pay.bo.DycFscQueryServiceListAbilityRspBO;
import com.tydic.dyc.fsc.pay.bo.DycUocProTransactionListQueryReqBO;
import com.tydic.dyc.fsc.pay.bo.DycUocProTransactionListQueryRspBO;
import com.tydic.dyc.fsc.pay.bo.DycUocServiceFeeQryListBO;
import com.tydic.dyc.fsc.pay.bo.FscServiceListBO;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.fsc.pay.api.DycFscQueryServiceListNewAbilityService"})
public class DycFscQueryServiceListNewAbilityServiceImpl
implements DycFscQueryServiceListNewAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycFscQueryServiceListNewAbilityServiceImpl.class);
    private static final Integer TAB_ID = 80013;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Value(value="${fsc.qry.url:}")
    private String generalQueryUrl;

    @Override
    @PostMapping(value={"qryServiceList"})
    public DycFscQueryServiceListAbilityRspBO qryServiceList(@RequestBody DycFscQueryServiceListAbilityReqBO reqBO) {
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = (FscComOrderListQueryAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), FscComOrderListQueryAbilityReqBO.class);
        FscComOrderListQueryAbilityRspBO abilityRspBO = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        String rspString = JSON.toJSONString((Object)abilityRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        DycFscQueryServiceListAbilityRspBO dycFscQueryServiceListAbilityRspBO = (DycFscQueryServiceListAbilityRspBO)((Object)JSON.parseObject((String)rspString, DycFscQueryServiceListAbilityRspBO.class));
        if (!CollectionUtils.isEmpty((Collection)dycFscQueryServiceListAbilityRspBO.getRows())) {
            ArrayList<Long> relIdList = new ArrayList<Long>();
            for (FscServiceListBO bo : dycFscQueryServiceListAbilityRspBO.getRows()) {
                relIdList.add(bo.getFscOrderId());
            }
            HashMap orderInfo = new HashMap();
            DycUocProTransactionListQueryReqBO uocProTransactionServiceListQueryReqBo = new DycUocProTransactionListQueryReqBO();
            uocProTransactionServiceListQueryReqBo.setRelIdList(relIdList);
            uocProTransactionServiceListQueryReqBo.setPageSize(20000);
            DycUocProTransactionListQueryRspBO monthFee = this.getMonthFee(uocProTransactionServiceListQueryReqBo);
            Map<Long, List<DycUocServiceFeeQryListBO>> dycUocServiceFeeQryListMap = monthFee.getRows().stream().collect(Collectors.groupingBy(DycUocServiceFeeQryListBO::getRelId));
            for (Map.Entry<Long, List<DycUocServiceFeeQryListBO>> dycUocServiceFeeQryListEntry : dycUocServiceFeeQryListMap.entrySet()) {
                ArrayList<DycFscOrderInfoBO> dycFscOrderInfoBOS = new ArrayList<DycFscOrderInfoBO>();
                for (DycUocServiceFeeQryListBO bo : dycUocServiceFeeQryListEntry.getValue()) {
                    DycFscOrderInfoBO dycFscOrderInfoBO = new DycFscOrderInfoBO();
                    dycFscOrderInfoBO.setOrderId(Convert.toStr((Object)bo.getOrderId()));
                    dycFscOrderInfoBO.setInspectionVoucherCode(Convert.toStr((Object)bo.getInspOrderNo()));
                    dycFscOrderInfoBO.setInspTotalPurchaseMoney(bo.getPurFee());
                    dycFscOrderInfoBO.setOrderCreateTime(DateUtil.format((Date)bo.getCreateTime(), (String)"yyyy-MM-dd hh:mm:ss"));
                    dycFscOrderInfoBO.setPurAccountName(bo.getPurAccountName());
                    dycFscOrderInfoBO.setPurchaseVoucherNo(bo.getSaleOrderNo());
                    dycFscOrderInfoBO.setPurName(bo.getPurName());
                    dycFscOrderInfoBO.setPurPlaceOrderName(bo.getPurName());
                    dycFscOrderInfoBO.setSerPriceMoney(bo.getSerPriceMoney());
                    dycFscOrderInfoBO.setSaleVoucherId(bo.getSaleOrderId());
                    dycFscOrderInfoBO.setOrderSource(bo.getOrderSource());
                    dycFscOrderInfoBO.setPurLogName(bo.getPurUserName());
                    dycFscOrderInfoBO.setPurLogName(bo.getPurUserName());
                    dycFscOrderInfoBOS.add(dycFscOrderInfoBO);
                }
                orderInfo.put(dycUocServiceFeeQryListEntry.getKey(), dycFscOrderInfoBOS);
            }
            for (FscServiceListBO fscServiceListBO : dycFscQueryServiceListAbilityRspBO.getRows()) {
                fscServiceListBO.setOrderInfo((List)orderInfo.get(fscServiceListBO.getFscOrderId()));
            }
        }
        return dycFscQueryServiceListAbilityRspBO;
    }

    private DycUocProTransactionListQueryRspBO getMonthFee(DycUocProTransactionListQueryReqBO reqBO) {
        log.info("\u901a\u7528\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        String rspJsonStr = this.commonQry(JSON.toJSONString((Object)((Object)reqBO)));
        log.info("\u901a\u7528\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)rspJsonStr);
        return (DycUocProTransactionListQueryRspBO)((Object)JSON.parseObject((String)rspJsonStr, DycUocProTransactionListQueryRspBO.class));
    }

    private String commonQry(String reqJsonStr) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("queryCountFlag", (Object)false);
        jsonObject.put("reqParams", (Object)reqJsonStr);
        return HttpUtil.post((String)this.generalQueryUrl, (String)jsonObject.toJSONString(), (int)6000);
    }
}

