/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.mall.order.api.DycUocQryBargainingListService;
import com.tydic.dyc.mall.order.bo.DycUocButtonBo;
import com.tydic.dyc.mall.order.bo.DycUocQryBargainingListBO;
import com.tydic.dyc.mall.order.bo.DycUocQryBargainingListReqBO;
import com.tydic.dyc.mall.order.bo.DycUocQryBargainingListRspBO;
import com.tydic.dyc.oc.service.bargaining.UocQryOrderListByBargainingIdService;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryOrderListByBargainingIdReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryOrderListByBargainingIdRspBo;
import com.tydic.dyc.oc.service.domainservice.UocTacheButtonQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.order.api.DycUocQryBargainingListService"})
public class DycUocQryBargainingListServiceImpl
implements DycUocQryBargainingListService {
    private static final Logger log = LoggerFactory.getLogger(DycUocQryBargainingListServiceImpl.class);
    @Value(value="${uoc.bargaining.qry.tab.id:70051}")
    private String qryBargainingTabId;
    @Autowired
    private UocTacheButtonQryService uocTacheButtonQryService;
    @Autowired
    private UocQryOrderListByBargainingIdService uocQryOrderListByBargainingIdService;
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;

    @Override
    @PostMapping(value={"qryBargainingList"})
    public DycUocQryBargainingListRspBO qryBargainingList(@RequestBody DycUocQryBargainingListReqBO reqBO) {
        this.setAuth(reqBO);
        JSONObject reqBoJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqBoJsonObj.toJSONString());
        dycGeneralQueryFuncReqBO.setSortQueryConfigList(reqBO.getSortQueryConfigList());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        log.info("\u8bae\u4ef7\u5355\u67e5\u8be2es\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dycGeneralQueryFuncRspBO));
        DycUocQryBargainingListRspBO rspBO = (DycUocQryBargainingListRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocQryBargainingListRspBO.class));
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTabId()) && this.qryBargainingTabId.equals(reqBO.getTabId())) {
            this.setButton(rspBO.getRows(), reqBO);
            this.reorderFlag(rspBO.getRows());
        }
        return rspBO;
    }

    private void setAuth(DycUocQryBargainingListReqBO reqBo) {
        if ("1".equals(reqBo.getIsProfessionalOrgExt())) {
            reqBo.setBargainingOperId(reqBo.getUserId().toString());
        }
    }

    private void reorderFlag(List<DycUocQryBargainingListBO> rows) {
        for (DycUocQryBargainingListBO item : rows) {
            if (!"YJ_YXD".equals(item.getBargainingState()) || !ObjectUtil.isNotEmpty(item.getButtons())) continue;
            UocQryOrderListByBargainingIdReqBo listByBargainingIdReqBo = new UocQryOrderListByBargainingIdReqBo();
            listByBargainingIdReqBo.setBargainingId(item.getBargainingId());
            UocQryOrderListByBargainingIdRspBo bargainingIdRspBo = this.uocQryOrderListByBargainingIdService.qryOrderListByBargainingId(listByBargainingIdReqBo);
            if (!bargainingIdRspBo.isReorderFlag()) continue;
            DycUocButtonBo buttonBo = new DycUocButtonBo();
            buttonBo.setMenuCode("CXXD");
            buttonBo.setMenuDesc("\u91cd\u65b0\u4e0b\u5355");
            item.getButtons().add(buttonBo);
        }
    }

    private void setButton(List<DycUocQryBargainingListBO> rows, DycUocQryBargainingListReqBO reqBO) {
        log.info("\u8bae\u4ef7\u5355\u67e5\u8be2\u6309\u94ae\u8bbe\u7f6e\u5f00\u59cb");
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        HashSet tacheCodes = new HashSet();
        HashSet orderIdList = new HashSet();
        ArrayList objIdList = new ArrayList();
        HashSet bargainingStateList = new HashSet();
        rows.forEach(dycUocQryBargainingListBO -> {
            objIdList.add(dycUocQryBargainingListBO.getBargainingId());
            orderIdList.add(dycUocQryBargainingListBO.getBargainingId());
            if (StringUtils.isNotBlank((CharSequence)dycUocQryBargainingListBO.getBargainingState())) {
                bargainingStateList.add(dycUocQryBargainingListBO.getBargainingState());
            }
        });
        UocTacheButtonQryReqBo uocTacheButtonQryFuncReqBo = new UocTacheButtonQryReqBo();
        uocTacheButtonQryFuncReqBo.setOrderStatusList(new ArrayList(bargainingStateList));
        uocTacheButtonQryFuncReqBo.setTacheCodes(new ArrayList(tacheCodes));
        uocTacheButtonQryFuncReqBo.setObjIdList(objIdList);
        uocTacheButtonQryFuncReqBo.setOrderIdList(new ArrayList(orderIdList));
        uocTacheButtonQryFuncReqBo.setTabId(reqBO.getTabId());
        uocTacheButtonQryFuncReqBo.setReflected(reqBO.getReflected());
        UocTacheButtonQryRspBo uocTacheButtonQryFuncRspBo = this.uocTacheButtonQryService.qryTacheButton(uocTacheButtonQryFuncReqBo);
        List uocTacheButtonInfoFuncBOS = uocTacheButtonQryFuncRspBo.getUocTacheButtonS();
        log.info("\u8bae\u4ef7\u5355\u67e5\u8be2\u6309\u94ae\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)uocTacheButtonInfoFuncBOS));
        if (!CollectionUtil.isEmpty((Collection)uocTacheButtonInfoFuncBOS)) {
            Map<String, List<UocTacheButtonInfoBO>> statusMap = uocTacheButtonInfoFuncBOS.stream().filter(uocTacheButton -> StringUtils.isNotBlank((CharSequence)uocTacheButton.getOrderStatus())).collect(Collectors.groupingBy(UocTacheButtonInfoBO::getOrderStatus));
            rows.forEach(dycUocSaleOrderInfoBO -> {
                List tacheButtonInfoFuncBOS;
                ArrayList dycUocButtonBos = new ArrayList();
                if (StringUtils.isNotBlank((CharSequence)dycUocSaleOrderInfoBO.getBargainingState()) && !CollectionUtil.isEmpty((Collection)(tacheButtonInfoFuncBOS = (List)statusMap.get(dycUocSaleOrderInfoBO.getBargainingState())))) {
                    dycUocButtonBos.addAll(tacheButtonInfoFuncBOS.stream().map(uocButtonFuncBo -> {
                        DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                        dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                        dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                        dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                        return dycUocButtonBo;
                    }).collect(Collectors.toList()));
                }
                dycUocSaleOrderInfoBO.setButtons(dycUocButtonBos.stream().distinct().collect(Collectors.toList()));
            });
        }
    }
}

