/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.Payload;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.authority.service.domainservice.AuthGetUserAccessMenuService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetUserAccessMenuReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetUserAccessMenuRspBo;
import com.tydic.dyc.authority.service.orgtype.AuthGetOrgTypeListService;
import com.tydic.dyc.authority.service.orgtype.bo.AuthGetOrgTypeListReqBo;
import com.tydic.dyc.authority.service.orgtype.bo.AuthGetOrgTypeListRspBo;
import com.tydic.dyc.authority.service.orgtype.bo.AuthOrgTypeBo;
import com.tydic.dyc.authority.service.user.AuthGetUserAdmOrgListService;
import com.tydic.dyc.authority.service.user.AuthGetUserInfoDetailService;
import com.tydic.dyc.authority.service.user.bo.AuthAdmOrgRelBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserAdmOrgListReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserAdmOrgListRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserInfoDetailReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserInfoDetailRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseInfoDetailService;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgInfoDetailService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgTagRelBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoDetailReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoDetailRspBo;
import com.tydic.dyc.umc.service.user.UmcQryUserInfoDetailService;
import com.tydic.dyc.umc.service.user.bo.UmcQryUserInfoDetailReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcQryUserInfoDetailRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserTagRelBo;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcUserDetails;
import com.tydic.umc.security.entity.AuthorityInfo;
import com.tydic.umc.security.entity.MenuInfo;
import com.tydic.umc.security.service.ApplicationPropertyService;
import com.tydic.umc.security.service.GetLogInUserInfoService;
import com.tydic.umc.security.service.bo.GetLogInUserInfoReqBo;
import com.tydic.umc.security.service.bo.GetSingleValuePropertyReqBO;
import com.tydic.umc.security.service.bo.GetSingleValuePropertyRspBO;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetLogInUserInfoServiceImpl
implements GetLogInUserInfoService {
    private static final Logger log = LoggerFactory.getLogger(GetLogInUserInfoServiceImpl.class);
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${password.expDay:90}")
    private int passwordExpDay;
    @Autowired
    private CacheClient cacheTemplate;
    @Autowired
    private UmcQryUserInfoDetailService umcQryUserInfoDetailService;
    @Autowired
    private AuthGetUserInfoDetailService authGetUserInfoDetailService;
    @Autowired
    private AuthGetOrgTypeListService authGetOrgTypeListService;
    @Autowired
    private UmcQryOrgInfoDetailService umcQryOrgInfoDetailService;
    @Autowired
    private AuthGetUserAdmOrgListService authGetUserAdmOrgListService;
    @Autowired
    private ApplicationPropertyService applicationPropertyService;
    @Autowired
    private UmcQryEnterpriseInfoDetailService umcQryEnterpriseInfoDetailService;
    @Autowired
    AuthGetUserAccessMenuService authGetUserAccessMenuService;

    @Override
    public UmcUserDetails getLoginUserInfo(GetLogInUserInfoReqBo reqBo) {
        UmcUserDetails umcUserDetails = new UmcUserDetails();
        umcUserDetails.setRespCode("0000");
        umcUserDetails.setRespDesc("\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("\u5165\u53c2\u8bf7\u6c42==>{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        JWSObject jwsObject = null;
        try {
            jwsObject = JWSObject.parse((String)reqBo.getToken());
            Payload payload = jwsObject.getPayload();
            JSONObject jsonOBj = payload.toJSONObject();
            reqBo.setUserId(Long.parseLong(jsonOBj.get((Object)"userId").toString()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String tokenMsg = (String)this.cacheTemplate.get(reqBo.getToken());
        UmcMemInfoBO umcMemInfoBO = (UmcMemInfoBO)com.alibaba.fastjson.JSONObject.parseObject((String)tokenMsg, UmcMemInfoBO.class);
        if (umcMemInfoBO != null && umcMemInfoBO.getUserId() != null && umcMemInfoBO.getMemIdExt() != null) {
            umcUserDetails.setUserDetails(umcMemInfoBO);
            this.checkUri(reqBo, umcMemInfoBO, umcUserDetails);
            return umcUserDetails;
        }
        UmcMemInfoBO userInfo = this.loadUserInfo(reqBo);
        log.debug("loadUserInfo\u65b9\u6cd5\u5b8c\u6210\u540e\u7684\u5bf9\u8c61==>{}", (Object)userInfo);
        if (userInfo != null) {
            String defaultAppCode = "dyc";
            if (StringUtils.isBlank((CharSequence)reqBo.getAppCode())) {
                reqBo.setAppCode(defaultAppCode);
            }
            try {
                this.loadUserAuthoritys(userInfo, reqBo);
            }
            catch (Exception e) {
                e.printStackTrace();
                umcUserDetails.setRespDesc("\u9519\u8bef" + e);
                umcUserDetails.setRespCode("AE403");
                return umcUserDetails;
            }
            if (null != userInfo) {
                this.cacheTemplate.set(reqBo.getToken(), (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)userInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}), this.expTime);
            }
            this.checkUri(reqBo, userInfo, umcUserDetails);
            umcUserDetails.setUserDetails(userInfo);
        }
        return umcUserDetails;
    }

    private void checkUri(GetLogInUserInfoReqBo reqBo, UmcMemInfoBO userInfo, UmcUserDetails rspBo) {
        List mcs;
        Object obj = this.cacheTemplate.get("DIC_MENU_CODE_REDIS_" + reqBo.getUri());
        boolean result = false;
        if (obj != null && !CollectionUtils.isEmpty((Collection)(mcs = (List)obj))) {
            result = true;
            for (String menuCode : mcs) {
                if (!userInfo.getMenuCodeList().contains(menuCode)) continue;
                result = false;
                break;
            }
        }
        if (result) {
            rspBo.setRespDesc("\u65e0\u6743\u9650\u64cd\u4f5c[" + reqBo.getUri() + "]");
            rspBo.setRespCode("AE403");
        }
    }

    private UmcMemInfoBO loadUserInfo(GetLogInUserInfoReqBo reqBo) {
        UmcMemInfoBO userInfo = new UmcMemInfoBO();
        log.debug("loadUserInfo\u5165\u53c2\u8bf7\u6c42==>{}", (Object)JSON.toJSONString((Object)reqBo));
        AuthGetUserInfoDetailReqBo authReqUserBo = new AuthGetUserInfoDetailReqBo();
        authReqUserBo.setUserId(reqBo.getUserId());
        AuthGetUserInfoDetailRspBo rspAuthUser = this.authGetUserInfoDetailService.getUserInfoDetail(authReqUserBo);
        if (rspAuthUser != null && rspAuthUser.getUserInfoBo() != null) {
            Long adminId;
            AuthGetUserAdmOrgListReqBo admOrgReqBo = new AuthGetUserAdmOrgListReqBo();
            admOrgReqBo.setUserId(rspAuthUser.getUserInfoBo().getUserId());
            AuthGetUserAdmOrgListRspBo admOrgRspBo = this.authGetUserAdmOrgListService.getAdmOrgListService(admOrgReqBo);
            if (admOrgRspBo != null && !CollectionUtils.isEmpty((Collection)admOrgRspBo.getAdmOrgList())) {
                ArrayList<Long> admOrgList = new ArrayList<Long>();
                for (AuthAdmOrgRelBo bo : admOrgRspBo.getAdmOrgList()) {
                    admOrgList.add(bo.getAdmOrgId());
                }
                userInfo.setMgOrgIdsIn(admOrgList);
                userInfo.setMgOrgIdsExt(admOrgList);
            }
            if ((adminId = Long.valueOf(1L)).equals(reqBo.getUserId())) {
                ArrayList<Long> mgOrgIds = new ArrayList<Long>();
                mgOrgIds.add(1L);
                userInfo.setMgOrgIdsIn(mgOrgIds);
                userInfo.setMgOrgIdsExt(mgOrgIds);
            }
            UmcQryUserInfoDetailReqBo reqUserBo = new UmcQryUserInfoDetailReqBo();
            reqUserBo.setUserId(reqBo.getUserId());
            UmcQryUserInfoDetailRspBo rspUser = this.umcQryUserInfoDetailService.qryUserInfoDetail(reqUserBo);
            Date now = new Date();
            Date effDate = rspAuthUser.getUserInfoBo().getCustInfo().getPasswordEffDate();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(effDate);
            ((Calendar)calendar).add(5, this.passwordExpDay);
            Date expDate = calendar.getTime();
            boolean needResetPwd = false;
            if (StringUtils.isNotBlank((CharSequence)rspAuthUser.getUserInfoBo().getCustInfo().getInitialPassword()) || expDate.getTime() < now.getTime()) {
                needResetPwd = true;
            }
            UmcQryOrgInfoDetailReqBo orgReqBo = new UmcQryOrgInfoDetailReqBo();
            orgReqBo.setOrgId(rspUser.getOrgId());
            UmcQryOrgInfoDetailRspBo orgRspBo = this.umcQryOrgInfoDetailService.qryOrgInfoDetail(orgReqBo);
            UmcQryEnterpriseInfoDetailReqBo enterpriseReqBo = new UmcQryEnterpriseInfoDetailReqBo();
            enterpriseReqBo.setOrgId(rspUser.getOrgId());
            UmcQryEnterpriseInfoDetailRspBo enterpriseRspBo = this.umcQryEnterpriseInfoDetailService.qryEnterpriseInfoDetail(enterpriseReqBo);
            orgReqBo.setOrgId(orgRspBo.getCompanyId());
            UmcQryOrgInfoDetailRspBo orgComRspBo = this.umcQryOrgInfoDetailService.qryOrgInfoDetail(orgReqBo);
            userInfo.setUserIdIn(rspUser.getUserId());
            userInfo.setCustIdIn(rspUser.getCustId());
            userInfo.setCustNameIn(rspUser.getCustInfoBo().getCustName());
            userInfo.setMainCustIdIn(rspUser.getMainCustId());
            userInfo.setCustTypeIn(rspUser.getCustInfoBo().getCustType());
            userInfo.setRegEmailIn(rspUser.getCustInfoBo().getRegEmail());
            userInfo.setRegMobileIn(rspUser.getCustInfoBo().getRegMobile());
            userInfo.setRegAccountIn(rspUser.getCustInfoBo().getRegAccount());
            userInfo.setUserTypeIn(rspUser.getUserType());
            userInfo.setCompanyIdIn(orgRspBo.getCompanyId());
            userInfo.setCompanyName(orgComRspBo.getOrgName());
            userInfo.setCompanyNameIn(orgComRspBo.getOrgName());
            userInfo.setLoginTagIn(reqBo.getTagId());
            userInfo.setTradeUserTypeSelectCook(reqBo.getTagId());
            log.debug("\u5f53\u524d\u9009\u62e9\u8eab\u4efd1", com.alibaba.fastjson.JSONObject.toJSON((Object)reqBo.getTagId()));
            if ("2".equals(userInfo.getLoginTagIn())) {
                userInfo.setSupId(userInfo.getCompanyIdIn());
            }
            userInfo.setOrgTreePathIn(orgRspBo.getOrgTreePath());
            userInfo.setOrgIdIn(orgRspBo.getOrgId());
            userInfo.setOrgClassIn(enterpriseRspBo.getOrgClass());
            userInfo.setOrgNameIn(orgRspBo.getOrgName());
            userInfo.setTenantIdIn(rspUser.getTenantId());
            userInfo.setNeedResetPwd(needResetPwd);
            userInfo.setPassPwdExpDate(expDate);
            if (!CollectionUtils.isEmpty((Collection)rspUser.getUserExtMapBoList())) {
                for (Object bo : rspUser.getUserExtMapBoList()) {
                    if (!"lastLoginTime".equals(bo.getFieldCode())) continue;
                    userInfo.setLastLoginTimeIn(bo.getFieldValue());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)rspUser.getUserTagRelBoList())) {
                ArrayList<String> tagIdList = new ArrayList<String>();
                for (UmcUserTagRelBo userBo : rspUser.getUserTagRelBoList()) {
                    if (CollectionUtils.isEmpty((Collection)orgRspBo.getEnterpriseOrgTagRelList())) continue;
                    for (UmcOrgTagRelBo orgBo : orgRspBo.getEnterpriseOrgTagRelList()) {
                        if (!userBo.getTagId().equals(orgBo.getTagId())) continue;
                        tagIdList.add(userBo.getTagId());
                    }
                }
                userInfo.setTagListIn(tagIdList);
                userInfo.setTradeUserTypeCook(tagIdList);
                log.debug("\u5f53\u524d\u9009\u62e9\u8eab\u4efd2", com.alibaba.fastjson.JSONObject.toJSON((Object)reqBo.getTagId()));
            }
            userInfo.setLoginSourceIn(reqBo.getLoginSource());
            GetSingleValuePropertyReqBO getSingleValuePropertyReqBO = new GetSingleValuePropertyReqBO();
            getSingleValuePropertyReqBO.setKey("staff.welfare.pay.config.enable");
            GetSingleValuePropertyRspBO umcQrySingleValuePropertyAbilityRspBO = this.applicationPropertyService.qrySingleValue(getSingleValuePropertyReqBO);
            if ("0000".equals(umcQrySingleValuePropertyAbilityRspBO.getRespCode()) && !StringUtils.isBlank((CharSequence)umcQrySingleValuePropertyAbilityRspBO.getValue())) {
                userInfo.setStaffWelfarePayConfigEnable(Boolean.parseBoolean(umcQrySingleValuePropertyAbilityRspBO.getValue()));
            }
            userInfo.setNeedResetPwd(needResetPwd);
            userInfo.setPassPwdExpDate(expDate);
            userInfo.setUserId(rspUser.getUserId());
            userInfo.setName(rspUser.getCustInfoBo().getCustName());
            userInfo.setCompanyIdExt(userInfo.getCompanyIdIn());
            userInfo.setCompanyId(userInfo.getCompanyIdIn());
            userInfo.setMemIdIn(rspUser.getUserId());
            userInfo.setOrgCodeIn(orgRspBo.getOrgCode());
            userInfo.setUserIdIn(userInfo.getUserId());
            userInfo.setMemAffiliationExt(userInfo.getMemAffiliation());
            userInfo.setMemIdExt(rspUser.getUserId());
            userInfo.setSex(rspUser.getCustInfoBo().getSex());
            userInfo.setRegEmail(rspUser.getCustInfoBo().getRegEmail());
            userInfo.setLoginSourceIn(reqBo.getLoginSource());
            userInfo.setUsername(rspUser.getCustInfoBo().getRegAccount());
            userInfo.setOrgId(rspUser.getOrgId());
            userInfo.setOrgCodeIn(orgRspBo.getOrgCode());
            userInfo.setCellphone(rspUser.getCustInfoBo().getRegMobile());
            userInfo.setOrgTypeIn(String.valueOf(orgRspBo.getOrgType()));
            userInfo.setOrgPath(rspUser.getOrgTreePath());
            userInfo.setOrgName(orgRspBo.getOrgName());
            userInfo.setMemUserType(rspUser.getUserType());
            userInfo.setOrgClass(enterpriseRspBo.getOrgClass());
            userInfo.setOrgClass(enterpriseRspBo.getOrgClass());
            userInfo.setLoginTagIn(reqBo.getTagId());
            userInfo.setIsProfessionalOrgExt(reqBo.getTagId());
            userInfo.setIsprofess(userInfo.getIsProfessionalOrgExt());
            if (null != orgRspBo.getOrgType()) {
                AuthGetOrgTypeListReqBo authGetOrgTypeListReqBo = new AuthGetOrgTypeListReqBo();
                authGetOrgTypeListReqBo.setOrgTypeId(orgRspBo.getOrgType());
                AuthGetOrgTypeListRspBo orgTypeList = this.authGetOrgTypeListService.getOrgTypeList(authGetOrgTypeListReqBo);
                if (!CollectionUtils.isEmpty((Collection)orgTypeList.getRows())) {
                    userInfo.setManageLevelIn(((AuthOrgTypeBo)orgTypeList.getRows().get(0)).getManageLevel());
                }
            }
        }
        return userInfo;
    }

    private void loadUserAuthoritys(UmcMemInfoBO infoUser, GetLogInUserInfoReqBo reqBo) {
        AuthGetUserAccessMenuReqBo accessMenuReqBo = new AuthGetUserAccessMenuReqBo();
        accessMenuReqBo.setTenantId(reqBo.getTenantId());
        accessMenuReqBo.setUserId(reqBo.getUserId());
        accessMenuReqBo.setCustId(infoUser.getCustIdIn());
        accessMenuReqBo.setCustName(infoUser.getCustNameIn());
        accessMenuReqBo.setOrgId(infoUser.getOrgIdIn());
        accessMenuReqBo.setOrgTreePath(infoUser.getOrgTreePathIn());
        ArrayList<String> tagIdList = new ArrayList<String>();
        tagIdList.add(reqBo.getTagId());
        accessMenuReqBo.setTagIdList(tagIdList);
        try {
            AuthGetUserAccessMenuRspBo menuRspBo = this.authGetUserAccessMenuService.getUserAccessMenu(accessMenuReqBo);
            log.debug("\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u83dc\u5355\u51fa\u53c2\uff1a" + com.alibaba.fastjson.JSONObject.toJSONString((Object)menuRspBo));
            if (!"0000".equals(menuRspBo.getRespCode())) {
                throw new ZTBusinessException("\u83dc\u5355\u6743\u9650\u83b7\u53d6\u5f02\u5e38");
            }
            HashMap<String, List<MenuInfo>> menus = new HashMap<String, List<MenuInfo>>();
            menuRspBo.getMenus().keySet().forEach(key -> {
                List accessMenus = (List)menuRspBo.getMenus().get(key);
                List menuInfos = JUtil.jsl((List)accessMenus, MenuInfo.class);
                menus.put((String)key, menuInfos);
            });
            log.debug("\u8f6c\u5316\u51fa\u53c2\uff1a" + com.alibaba.fastjson.JSONObject.toJSONString(menus));
            infoUser.setMenus(menus);
            infoUser.setMenuCodeListIn(menuRspBo.getMenuCodeList());
            infoUser.setMenuCodeList(menuRspBo.getMenuCodeList());
            HashSet<AuthorityInfo> permissions = new HashSet<AuthorityInfo>();
            for (String permission : menuRspBo.getPermission()) {
                AuthorityInfo authorityInfo = new AuthorityInfo();
                authorityInfo.setKey(permission);
                permissions.add(authorityInfo);
            }
            infoUser.setPermissionIn(permissions);
            infoUser.setPermission(permissions);
        }
        catch (Exception e) {
            log.error("\u83dc\u5355\u6743\u9650\u83b7\u53d6\u5f02\u5e38", (Throwable)e);
            throw new ZTBusinessException("\u83dc\u5355\u6743\u9650\u83b7\u53d6\u5f02\u5e38");
        }
    }
}

