/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.agreement.ability.bo.AgreementSettlementBO;
import com.tydic.commodity.mall.ability.api.UccMallSpuOrderListQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryBO;
import com.tydic.dyc.atom.base.constants.DycFuncCommonConstants;
import com.tydic.dyc.atom.selfrun.api.DycUocCommodityBatchQryFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocAgreementFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCreateSaleOrderAgrFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocPayConfigInfoFuncBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocCommodityBatchQryFunctionImpl
implements DycUocCommodityBatchQryFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocCommodityBatchQryFunctionImpl.class);
    @Autowired
    private UccMallSpuOrderListQueryAbilityService uccMallSpuOrderListQueryAbilityService;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    private static final String PLA = "1";
    private static final String PUR = "2";
    private static final Integer UOC_PUR = 1;
    private static final Integer UOC_PLA = 2;
    private static final String ZQ_PAY = "2";
    private static final String JD_PAY = "1";
    private static final String PRE_PAY = "0";
    private static final Integer UOC_ZQ_PAY = 2;
    private static final Integer UOC_JD_PAY = 1;
    private static final Integer UOC_YF_PAY = 0;
    private static final String PAY_DAY = "2";
    private static final String ASSIGN = "1";

    @Override
    public DycUocCommodityBatchQryFuncRspBO qryCommodityByBatch(DycUocCommodityBatchQryFuncReqBO reqBO) {
        UccMallSpuOrderListQueryAbilityReqBO uccMallSpuOrderListQueryAbilityReqBO = (UccMallSpuOrderListQueryAbilityReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UccMallSpuOrderListQueryAbilityReqBO.class);
        UccMallSpuOrderListQueryAbilityRspBO uccMallSpuOrderListQueryAbilityRspBO = this.uccMallSpuOrderListQueryAbilityService.querySpuOrderListInfo(uccMallSpuOrderListQueryAbilityReqBO);
        if ("0000".equals(uccMallSpuOrderListQueryAbilityRspBO.getRespCode())) {
            if (reqBO.getSkuOrderList().size() == uccMallSpuOrderListQueryAbilityRspBO.getOrderSpuList().size()) {
                DycUocCommodityBatchQryFuncRspBO rspBO = this.comparePriceAndAssembleData(reqBO.getSkuOrderList(), uccMallSpuOrderListQueryAbilityRspBO.getOrderSpuList());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4e0b\u5355\u5546\u54c1\u4fe1\u606f\u6279\u91cf\u67e5\u8be2\u6210\u529f\uff01");
                return rspBO;
            }
            throw new ZTBusinessException("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5546\u57ce\u4e0b\u5355\u5546\u54c1\u6570\u636e\u67e5\u8be2API\u5931\u8d25\uff1a" + uccMallSpuOrderListQueryAbilityRspBO.getRespDesc());
    }

    private DycUocCommodityBatchQryFuncRspBO comparePriceAndAssembleData(List<DycUocCommodityBatchQryFuncBO> inputCommodityInfos, List<UccMallSpuOrderListQueryBO> uccSpuInfos) {
        ArrayList<DycUocCommodityFuncBO> commodityInfos = new ArrayList<DycUocCommodityFuncBO>();
        Map inputCommodityInfosMap = inputCommodityInfos.stream().collect(Collectors.toMap(DycUocCommodityBatchQryFuncBO::getSkuId, Function.identity()));
        HashMap<Long, DycUocAgreementFuncBO> resultAgreementInfosMap = new HashMap<Long, DycUocAgreementFuncBO>();
        for (UccMallSpuOrderListQueryBO uccSpuInfo : uccSpuInfos) {
            for (UccMallSkuDetailInfoBO uccSkuInfo : uccSpuInfo.getOrderSkuList()) {
                if (uccSkuInfo.getSalePrice().equals(this.BigDecimal2Long(((DycUocCommodityBatchQryFuncBO)inputCommodityInfosMap.get(uccSkuInfo.getSkuId())).getSalePrice()))) {
                    DycUocCommodityFuncBO commodityInfo = new DycUocCommodityFuncBO();
                    BeanUtils.copyProperties((Object)uccSkuInfo, (Object)commodityInfo);
                    commodityInfo.setSkuId(String.valueOf(uccSkuInfo.getSkuId()));
                    commodityInfo.setCommodityId(String.valueOf(uccSkuInfo.getCommodityId()));
                    commodityInfo.setCommodityTypeId(String.valueOf(uccSkuInfo.getCommodityTypeId()));
                    commodityInfo.setSupId(String.valueOf(uccSpuInfo.getVendorId()));
                    commodityInfo.setSupplierShopId(String.valueOf(uccSkuInfo.getSupplierShopId()));
                    commodityInfo.setSupplierShopName(uccSkuInfo.getShopName());
                    commodityInfo.setPurchasePrice(this.Long2BigDecimal(uccSkuInfo.getAgreementPrice()));
                    commodityInfo.setSalePrice(this.Long2BigDecimal(uccSkuInfo.getSalePrice()));
                    commodityInfo.setPurchaseCount(((DycUocCommodityBatchQryFuncBO)inputCommodityInfosMap.get(uccSkuInfo.getSkuId())).getPurchaseCount());
                    commodityInfo.setUnitName(uccSkuInfo.getMeasureName());
                    commodityInfo.setSettleUnit(uccSkuInfo.getSettlementUnit());
                    commodityInfo.setTax(String.valueOf(uccSpuInfo.getRate()));
                    commodityInfo.setSkuMaterialId(String.valueOf(uccSkuInfo.getMaterialId()));
                    commodityInfo.setSkuMaterialCode(String.valueOf(uccSkuInfo.getMaterialCode()));
                    commodityInfo.setSkuBrandId(String.valueOf(uccSkuInfo.getBrandId()));
                    commodityInfo.setSkuBrandName(uccSkuInfo.getBrandName());
                    commodityInfo.setSkuMaterialName(uccSkuInfo.getMaterialName());
                    commodityInfo.setSkuMaterialTypeName(uccSkuInfo.getCatalogName());
                    commodityInfo.setSkuMaterialTypeId(String.valueOf(uccSkuInfo.getCatalogId()));
                    commodityInfo.setSkuMainPicUrl(uccSkuInfo.getSkuMainPic());
                    if (null != uccSkuInfo.getAgreementId()) {
                        commodityInfo.setAgreementId(String.valueOf(uccSkuInfo.getAgreementId()));
                        AgrQryAgreementSubjectDetailsAbilityReqBO agrQryAgreementSubjectDetailsAbilityReqBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
                        agrQryAgreementSubjectDetailsAbilityReqBO.setAgreementId(uccSkuInfo.getAgreementId());
                        AgrQryAgreementSubjectDetailsAbilityRspBO agrQryAgreementSubjectDetailsAbilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(agrQryAgreementSubjectDetailsAbilityReqBO);
                        if ("0000".equals(agrQryAgreementSubjectDetailsAbilityRspBO.getRespCode())) {
                            commodityInfo.setAgreementInfo((DycUocCreateSaleOrderAgrFuncBO)JSONObject.parseObject((String)JSON.toJSONString((Object)agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO()), DycUocCreateSaleOrderAgrFuncBO.class));
                            if (!resultAgreementInfosMap.containsKey(uccSkuInfo.getAgreementId())) {
                                DycUocAgreementFuncBO agreementFuncBO = new DycUocAgreementFuncBO();
                                agreementFuncBO.setAdjustPrice((int)agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getAdjustPrice());
                                agreementFuncBO.setAgrDataId(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getAgreementId());
                                agreementFuncBO.setAgrId(String.valueOf(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getAgreementId()));
                                agreementFuncBO.setProDeliveryId(String.valueOf(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getProducerId()));
                                agreementFuncBO.setProDeliveryName(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getProducerName());
                                ArrayList<DycUocPayConfigInfoFuncBO> confBos = new ArrayList<DycUocPayConfigInfoFuncBO>();
                                for (AgreementSettlementBO agreementSettlementBO : agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getPaymentMethod()) {
                                    DycUocPayConfigInfoFuncBO agrPayConfInfo = new DycUocPayConfigInfoFuncBO();
                                    agrPayConfInfo.setModelSettle(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getTradeMode().intValue());
                                    if (DycFuncCommonConstants.ARGEEMENT_TRADE_MODE.MY.equals(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getTradeMode())) {
                                        if ("2".equals(agreementSettlementBO.getSettlementObject())) {
                                            agrPayConfInfo.setUserType(UOC_PUR);
                                        } else {
                                            agrPayConfInfo.setUserType(UOC_PLA);
                                        }
                                    } else {
                                        agrPayConfInfo.setUserType(UOC_PUR);
                                    }
                                    if (PRE_PAY.equals(agreementSettlementBO.getSettlementType())) {
                                        agrPayConfInfo.setPayType(UOC_YF_PAY);
                                        agrPayConfInfo.setPrePaySup(new BigDecimal(100));
                                    } else if ("2".equals(agreementSettlementBO.getSettlementType())) {
                                        agrPayConfInfo.setPayType(UOC_ZQ_PAY);
                                        agrPayConfInfo.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                                        if ("2".equals(agreementSettlementBO.getAssign())) {
                                            agrPayConfInfo.setPayRule(Integer.valueOf("2"));
                                            agrPayConfInfo.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                                        } else {
                                            agrPayConfInfo.setPayRule(Integer.valueOf("1"));
                                            agrPayConfInfo.setPayAccountDay(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                                        }
                                    } else if ("1".equals(agreementSettlementBO.getSettlementType())) {
                                        agrPayConfInfo.setPayType(UOC_JD_PAY);
                                        agrPayConfInfo.setPrePaySup(agreementSettlementBO.getPrePay());
                                        agrPayConfInfo.setVerPaySup(agreementSettlementBO.getPickPay());
                                        agrPayConfInfo.setPilPaySup(agreementSettlementBO.getComPay());
                                        agrPayConfInfo.setQuaPaySup(agreementSettlementBO.getQuaPay());
                                    }
                                    confBos.add(agrPayConfInfo);
                                }
                                agreementFuncBO.setConfBos(confBos);
                                resultAgreementInfosMap.put(uccSkuInfo.getAgreementId(), agreementFuncBO);
                            }
                        } else {
                            throw new ZTBusinessException("\u534f\u8bae\u5546\u54c1\uff0c\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5931\u8d25");
                        }
                    }
                    commodityInfos.add(commodityInfo);
                    continue;
                }
                throw new ZTBusinessException(uccSkuInfo.getSkuId() + "\u5165\u53c2\u4ef7\u683c\u548c\u5546\u54c1\u4e2d\u5fc3\u8fd4\u56de\u4ef7\u683c\u4e0d\u4e00\u81f4\uff01");
            }
        }
        DycUocCommodityBatchQryFuncRspBO rspBO = new DycUocCommodityBatchQryFuncRspBO();
        rspBO.setCommodityInfos(commodityInfos);
        if (!resultAgreementInfosMap.isEmpty()) {
            ArrayList<DycUocAgreementFuncBO> agreementInfos = new ArrayList<DycUocAgreementFuncBO>();
            Iterator agreementInfosIterator = resultAgreementInfosMap.keySet().iterator();
            while (agreementInfosIterator.hasNext()) {
                DycUocAgreementFuncBO agreementInfo = (DycUocAgreementFuncBO)resultAgreementInfosMap.get(agreementInfosIterator.next());
                agreementInfos.add(agreementInfo);
            }
            rspBO.setAgreementInfos(agreementInfos);
        }
        return rspBO;
    }

    private BigDecimal Long2BigDecimal(Long money) {
        try {
            BigDecimal price = MoneyUtils.Long2BigDecimal((Long)money);
            return price;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff1aLong\u8f6c\u5316\u4e3aBigDecimal\u5f02\u5e38");
        }
    }

    private Long BigDecimal2Long(BigDecimal money) {
        try {
            Long price = MoneyUtils.BigDecimal2Long((BigDecimal)money);
            return price;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff1aBigDecimal\u8f6c\u5316\u4e3aLong\u5f02\u5e38");
        }
    }
}

