/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.mall.ability.api.UccMallSpuOrderListQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuOrderQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryBO;
import com.tydic.dyc.agr.service.agr.AgrGetAgrDetailService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigDetailBo;
import com.tydic.dyc.atom.base.constants.DycFuncCommonConstants;
import com.tydic.dyc.atom.selfrun.api.DycUocCommodityBatchQryFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocAgreementFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCreateSaleOrderAgrFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocPayConfigInfoFuncBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocCommodityBatchQryFunctionImpl
implements DycUocCommodityBatchQryFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocCommodityBatchQryFunctionImpl.class);
    @Autowired
    private UccMallSpuOrderListQueryAbilityService uccMallSpuOrderListQueryAbilityService;
    @Autowired
    private AgrGetAgrDetailService agrGetAgrDetailService;
    @Autowired
    private AgrGetAgrItemListService agrGetAgrItemListService;
    private static final String PLA = "1";
    private static final String PUR = "0";
    private static final Integer UOC_PUR = 1;
    private static final Integer UOC_PLA = 2;
    private static final String ZQ_PAY = "2";
    private static final String JD_PAY = "1";
    private static final String PRE_PAY = "0";
    private static final Integer UOC_ZQ_PAY = 2;
    private static final Integer UOC_JD_PAY = 1;
    private static final Integer UOC_YF_PAY = 0;
    private static final String PAY_DAY = "2";
    private static final String ASSIGN = "1";

    @Override
    public DycUocCommodityBatchQryFuncRspBO qryCommodityByBatch(DycUocCommodityBatchQryFuncReqBO reqBO) {
        UccMallSpuOrderListQueryAbilityReqBO uccMallSpuOrderListQueryAbilityReqBO = new UccMallSpuOrderListQueryAbilityReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccMallSpuOrderListQueryAbilityReqBO);
        ArrayList<UccMallSkuOrderQryReqBO> skuOrderList = new ArrayList<UccMallSkuOrderQryReqBO>();
        for (DycUocCommodityBatchQryFuncBO uocCommodityBatchQryFuncBO : reqBO.getSkuOrderList()) {
            UccMallSkuOrderQryReqBO uccMallSkuOrderQryReqBO = new UccMallSkuOrderQryReqBO();
            BeanUtils.copyProperties((Object)uocCommodityBatchQryFuncBO, (Object)uccMallSkuOrderQryReqBO);
            uccMallSkuOrderQryReqBO.setNum(uocCommodityBatchQryFuncBO.getPurchaseCount());
            skuOrderList.add(uccMallSkuOrderQryReqBO);
        }
        uccMallSpuOrderListQueryAbilityReqBO.setSkuOrderList(skuOrderList);
        UccMallSpuOrderListQueryAbilityRspBO uccMallSpuOrderListQueryAbilityRspBO = this.uccMallSpuOrderListQueryAbilityService.querySpuOrderListInfo(uccMallSpuOrderListQueryAbilityReqBO);
        if ("0000".equals(uccMallSpuOrderListQueryAbilityRspBO.getRespCode())) {
            int skuCount = 0;
            for (UccMallSpuOrderListQueryBO item : uccMallSpuOrderListQueryAbilityRspBO.getOrderSpuList()) {
                skuCount += item.getOrderSkuList().size();
            }
            if (reqBO.getSkuOrderList().size() == skuCount) {
                DycUocCommodityBatchQryFuncRspBO rspBO = this.comparePriceAndAssembleData(reqBO.getSkuOrderList(), uccMallSpuOrderListQueryAbilityRspBO.getOrderSpuList());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4e0b\u5355\u5546\u54c1\u4fe1\u606f\u6279\u91cf\u67e5\u8be2\u6210\u529f\uff01");
                return rspBO;
            }
            throw new ZTBusinessException("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5546\u57ce\u4e0b\u5355\u5546\u54c1\u6570\u636e\u67e5\u8be2API\u5931\u8d25\uff1a" + uccMallSpuOrderListQueryAbilityRspBO.getRespDesc());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DycUocCommodityBatchQryFuncRspBO comparePriceAndAssembleData(List<DycUocCommodityBatchQryFuncBO> inputCommodityInfos, List<UccMallSpuOrderListQueryBO> uccSpuInfos) {
        ArrayList<DycUocCommodityFuncBO> commodityInfos = new ArrayList<DycUocCommodityFuncBO>();
        inputCommodityInfos.forEach(bo -> bo.setSkuIdAndCount(bo.getSkuId() + "_" + bo.getPurchaseCount()));
        Map<String, List<DycUocCommodityBatchQryFuncBO>> inputCommodityInfosMap = inputCommodityInfos.stream().collect(Collectors.groupingBy(DycUocCommodityBatchQryFuncBO::getSkuIdAndCount));
        HashMap<Long, DycUocAgreementFuncBO> resultAgreementInfosMap = new HashMap<Long, DycUocAgreementFuncBO>();
        ArrayList uccSkuInfoList = new ArrayList();
        for (UccMallSpuOrderListQueryBO uccSpuInfo : uccSpuInfos) {
            uccSkuInfoList.addAll(uccSpuInfo.getOrderSkuList());
        }
        Map spuInfoMap = uccSpuInfos.stream().collect(Collectors.toMap(UccMallSpuOrderListQueryBO::getCommodityId, Function.identity()));
        Map<String, List<UccMallSkuDetailInfoBO>> rspSkuMap = uccSkuInfoList.stream().collect(Collectors.groupingBy(UccMallSkuDetailInfoBO::getKey));
        for (Map.Entry<String, List<UccMallSkuDetailInfoBO>> entry : rspSkuMap.entrySet()) {
            List<DycUocCommodityBatchQryFuncBO> reqSkuBOs = inputCommodityInfosMap.get(entry.getKey());
            for (int i = 0; i < entry.getValue().size(); ++i) {
                if (!entry.getValue().get(i).getSalePrice().equals(this.BigDecimal2Long(reqSkuBOs.get(i).getSalePrice()))) throw new ZTBusinessException(entry.getValue().get(i).getSkuId() + "\u5165\u53c2\u4ef7\u683c\u548c\u5546\u54c1\u4e2d\u5fc3\u8fd4\u56de\u4ef7\u683c\u4e0d\u4e00\u81f4\uff01");
                DycUocCommodityFuncBO commodityInfo = new DycUocCommodityFuncBO();
                BeanUtils.copyProperties((Object)entry.getValue().get(i), (Object)((Object)commodityInfo));
                commodityInfo.setPlanId(reqSkuBOs.get(i).getPlanId());
                commodityInfo.setPlanNo(reqSkuBOs.get(i).getPlanNo());
                commodityInfo.setPlanItemId(reqSkuBOs.get(i).getPlanItemId());
                commodityInfo.setPlanItemNo(reqSkuBOs.get(i).getPlanItemNo());
                commodityInfo.setSkuId(String.valueOf(entry.getValue().get(i).getSkuId()));
                commodityInfo.setCommodityId(String.valueOf(entry.getValue().get(i).getCommodityId()));
                commodityInfo.setCommodityTypeId(String.valueOf(entry.getValue().get(i).getCommodityTypeId()));
                commodityInfo.setSupplierId(String.valueOf(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getVendorId()));
                commodityInfo.setSupplierShopId(String.valueOf(entry.getValue().get(i).getSupplierShopId()));
                commodityInfo.setSupplierShopName(entry.getValue().get(i).getShopName());
                commodityInfo.setPurchasePrice(this.Long2BigDecimal(entry.getValue().get(i).getAgreementPrice()));
                commodityInfo.setSalePrice(this.Long2BigDecimal(entry.getValue().get(i).getSalePrice()));
                commodityInfo.setPurchaseCount(entry.getValue().get(i).getNum());
                commodityInfo.setUnitName(entry.getValue().get(i).getMeasureName());
                commodityInfo.setSettleUnit(entry.getValue().get(i).getSettlementUnit());
                commodityInfo.setTax(String.valueOf(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getRate()));
                commodityInfo.setSkuMaterialId(String.valueOf(entry.getValue().get(i).getMaterialId()));
                commodityInfo.setSkuMaterialCode(String.valueOf(entry.getValue().get(i).getMaterialCode()));
                commodityInfo.setSkuBrandId(String.valueOf(entry.getValue().get(i).getBrandId()));
                commodityInfo.setSkuBrandName(entry.getValue().get(i).getBrandName());
                commodityInfo.setSkuMaterialName(entry.getValue().get(i).getMaterialName());
                commodityInfo.setSkuMaterialTypeName(entry.getValue().get(i).getCatalogName());
                commodityInfo.setSkuMaterialTypeId(String.valueOf(entry.getValue().get(i).getCatalogId()));
                commodityInfo.setSkuExtSkuId(entry.getValue().get(i).getExtSkuId());
                commodityInfo.setSkuMainPicUrl(entry.getValue().get(i).getSkuMainPic());
                commodityInfo.setRejectAllowDate(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getRejectAllowDate());
                commodityInfo.setExchangeAllowDate(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getExchangeAllowDate());
                commodityInfo.setMaintainAllowDate(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getMaintainAllowDate());
                if (null != entry.getValue().get(i).getAgreementId()) {
                    commodityInfo.setAgreementId(String.valueOf(entry.getValue().get(i).getAgreementId()));
                    if (null != entry.getValue().get(i).getAgreementDetailsId()) {
                        commodityInfo.setDeliveryTimeDate(this.arrivalSysle(entry.getValue().get(i).getAgreementDetailsId()));
                    }
                    AgrGetAgrDetailReqBo agrGetAgrDetailReqBo = new AgrGetAgrDetailReqBo();
                    agrGetAgrDetailReqBo.setAgrId(entry.getValue().get(i).getAgreementId());
                    log.info("\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)agrGetAgrDetailReqBo));
                    AgrGetAgrDetailRspBo agrGetAgrDetailRspBo = this.agrGetAgrDetailService.getAgrDetail(agrGetAgrDetailReqBo);
                    log.info("\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)agrGetAgrDetailRspBo));
                    if (!"0000".equals(agrGetAgrDetailRspBo.getRespCode())) throw new ZTBusinessException("\u534f\u8bae\u5546\u54c1\uff0c\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5931\u8d25");
                    DycUocCreateSaleOrderAgrFuncBO agrFuncBO = (DycUocCreateSaleOrderAgrFuncBO)JSONObject.parseObject((String)JSON.toJSONString((Object)agrGetAgrDetailRspBo.getAgrMainSaveBO()), DycUocCreateSaleOrderAgrFuncBO.class);
                    agrFuncBO.setAgreementId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrId());
                    agrFuncBO.setAgreementName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrName());
                    agrFuncBO.setAgreementCode(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrMode());
                    agrFuncBO.setPlaAgreementCode(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrCode());
                    agrFuncBO.setIsDispatch(agrGetAgrDetailRspBo.getAgrMainSaveBO().getWhetherDispatch() == null ? (byte)1 : agrGetAgrDetailRspBo.getAgrMainSaveBO().getWhetherDispatch().byteValue());
                    agrFuncBO.setSupplierId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getManagementOrgId());
                    agrFuncBO.setSupplierName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getManagementOrgName());
                    agrFuncBO.setVendorId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getSupplierId());
                    agrFuncBO.setVendorName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getSupplierName());
                    agrFuncBO.setVendorContact(agrGetAgrDetailRspBo.getAgrMainSaveBO().getSupplierContact());
                    agrFuncBO.setVendorPhone(agrGetAgrDetailRspBo.getAgrMainSaveBO().getSupplierPhone());
                    agrFuncBO.setEntAgreementCode(agrGetAgrDetailRspBo.getAgrMainSaveBO().getEnAgrCode());
                    agrFuncBO.setProducerId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrOperatorId());
                    agrFuncBO.setProducerName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrOperatorName());
                    if (agrFuncBO.getPrePaySup() == null) {
                        agrFuncBO.setPrePaySup(BigDecimal.ZERO);
                    }
                    if (agrFuncBO.getVerPaySup() == null) {
                        agrFuncBO.setVerPaySup(BigDecimal.ZERO);
                    }
                    if (agrFuncBO.getPilPaySup() == null) {
                        agrFuncBO.setPilPaySup(BigDecimal.ZERO);
                    }
                    if (agrFuncBO.getQuaPaySup() == null) {
                        agrFuncBO.setQuaPaySup(BigDecimal.ZERO);
                    }
                    commodityInfo.setAgrBo(agrFuncBO);
                    if (!resultAgreementInfosMap.containsKey(entry.getValue().get(i).getAgreementId())) {
                        AgrPayConfigDetailBo payTypeSup;
                        DycUocAgreementFuncBO agreementFuncBO = new DycUocAgreementFuncBO();
                        agreementFuncBO.setAdjustPrice(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAdjustPrice());
                        agreementFuncBO.setAgrDataId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrId());
                        agreementFuncBO.setAgrId(String.valueOf(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrId()));
                        agreementFuncBO.setProDeliveryId(String.valueOf(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrOperatorId()));
                        agreementFuncBO.setProDeliveryName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrOperatorName());
                        ArrayList<DycUocPayConfigInfoFuncBO> confBos = new ArrayList<DycUocPayConfigInfoFuncBO>();
                        Integer tradeMode = agrGetAgrDetailRspBo.getAgrMainSaveBO().getTradeMode();
                        AgrPayConfigDetailBo payTypePur = agrGetAgrDetailRspBo.getAgrMainSaveBO().getPayTypePur();
                        if (!Objects.isNull(payTypePur) && null != payTypePur.getPayType()) {
                            this.setPayInfo(confBos, payTypePur, tradeMode);
                        }
                        if (!Objects.isNull(payTypeSup = agrGetAgrDetailRspBo.getAgrMainSaveBO().getPayTypeSup())) {
                            this.setPayInfo(confBos, payTypeSup, tradeMode);
                        }
                        agreementFuncBO.setConfBos(confBos);
                        resultAgreementInfosMap.put(entry.getValue().get(i).getAgreementId(), agreementFuncBO);
                    }
                }
                commodityInfos.add(commodityInfo);
            }
        }
        DycUocCommodityBatchQryFuncRspBO rspBO = new DycUocCommodityBatchQryFuncRspBO();
        rspBO.setCommodityInfos(commodityInfos);
        if (resultAgreementInfosMap.isEmpty()) return rspBO;
        ArrayList<DycUocAgreementFuncBO> agreementInfos = new ArrayList<DycUocAgreementFuncBO>();
        Iterator agreementInfosIterator = resultAgreementInfosMap.keySet().iterator();
        while (agreementInfosIterator.hasNext()) {
            DycUocAgreementFuncBO agreementInfo = (DycUocAgreementFuncBO)resultAgreementInfosMap.get(agreementInfosIterator.next());
            agreementInfos.add(agreementInfo);
        }
        rspBO.setAgreementInfos(agreementInfos);
        return rspBO;
    }

    private BigDecimal Long2BigDecimal(Long money) {
        try {
            BigDecimal price = MoneyUtils.Long2BigDecimal((Long)money);
            return price;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff1aLong\u8f6c\u5316\u4e3aBigDecimal\u5f02\u5e38");
        }
    }

    private Long BigDecimal2Long(BigDecimal money) {
        try {
            Long price = MoneyUtils.BigDecimal2Long((BigDecimal)money);
            return price;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff1aBigDecimal\u8f6c\u5316\u4e3aLong\u5f02\u5e38");
        }
    }

    private String arrivalSysle(Long agrId) {
        AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
        agrGetAgrItemListReqBO.setAgrId(agrId);
        AgrGetAgrItemListRspBO agrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
        if (!"0000".equals(agrItemListRspBO.getRespCode())) {
            throw new ZTBusinessException(agrItemListRspBO.getRespDesc());
        }
        List agrItemDetailBosList = agrItemListRspBO.getRows();
        if (!CollectionUtils.isEmpty((Collection)agrItemDetailBosList)) {
            AgrItemDetailBo agrItemDetailBo = (AgrItemDetailBo)agrItemDetailBosList.get(0);
            return String.valueOf(agrItemDetailBo.getSupplyCycle());
        }
        return null;
    }

    private void setPayInfo(List<DycUocPayConfigInfoFuncBO> confBos, AgrPayConfigDetailBo agrPayConfigDetailBo, Integer tradeMode) {
        DycUocPayConfigInfoFuncBO agrPayConfInfo = new DycUocPayConfigInfoFuncBO();
        agrPayConfInfo.setModelSettle(tradeMode);
        if (DycFuncCommonConstants.ARGEEMENT_TRADE_MODE.MY.equals(tradeMode.byteValue())) {
            if ("0".equals(String.valueOf(agrPayConfigDetailBo.getPayObj()))) {
                agrPayConfInfo.setUserType(UOC_PUR);
            } else {
                agrPayConfInfo.setUserType(UOC_PLA);
            }
        } else {
            agrPayConfInfo.setUserType(UOC_PUR);
        }
        if ("0".equals(String.valueOf(agrPayConfigDetailBo.getPayType()))) {
            agrPayConfInfo.setPayType(UOC_YF_PAY);
            agrPayConfInfo.setPrePaySup(new BigDecimal(100));
            agrPayConfInfo.setVerPaySup(BigDecimal.ZERO);
            agrPayConfInfo.setPilPaySup(BigDecimal.ZERO);
            agrPayConfInfo.setQuaPaySup(BigDecimal.ZERO);
        } else if ("2".equals(String.valueOf(agrPayConfigDetailBo.getPayType()))) {
            agrPayConfInfo.setPayType(UOC_ZQ_PAY);
            agrPayConfInfo.setPaymentDays(Integer.valueOf(agrPayConfigDetailBo.getSettlementDate()));
            if ("2".equals(agrPayConfigDetailBo.getAssign())) {
                agrPayConfInfo.setPayRule(Integer.valueOf("2"));
                agrPayConfInfo.setPayNodeRule(agrPayConfigDetailBo.getBusiNode());
                agrPayConfInfo.setPaymentDays(Integer.valueOf(agrPayConfigDetailBo.getSettlementDate()));
            } else {
                agrPayConfInfo.setPayRule(Integer.valueOf("1"));
                agrPayConfInfo.setPayAccountDay(Integer.valueOf(agrPayConfigDetailBo.getSettlementDate()));
                agrPayConfInfo.setPayAccountDayRule(agrPayConfigDetailBo.getBusiNode());
            }
            agrPayConfInfo.setPrePaySup(BigDecimal.ZERO);
            agrPayConfInfo.setVerPaySup(BigDecimal.ZERO);
            agrPayConfInfo.setPilPaySup(BigDecimal.ZERO);
            agrPayConfInfo.setQuaPaySup(BigDecimal.ZERO);
        } else if ("1".equals(String.valueOf(agrPayConfigDetailBo.getPayType()))) {
            agrPayConfInfo.setPayType(UOC_JD_PAY);
            agrPayConfInfo.setPrePaySup(agrPayConfigDetailBo.getPrePay());
            agrPayConfInfo.setVerPaySup(agrPayConfigDetailBo.getMatPay());
            agrPayConfInfo.setPilPaySup(agrPayConfigDetailBo.getVerPay());
            agrPayConfInfo.setQuaPaySup(agrPayConfigDetailBo.getQuaPay());
        }
        confBos.add(agrPayConfInfo);
    }
}

