/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.busicommon.api.UocTacheButtonQryFunction;
import com.tydic.dyc.atom.busicommon.bo.UocTacheButtonInfoFuncBO;
import com.tydic.dyc.atom.busicommon.bo.UocTacheButtonQryFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.UocTacheButtonQryFuncRspBo;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycTabTacheCodeQryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeInfoFuncBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncRspBO;
import com.tydic.dyc.base.utils.ParseUrlParamUtil;
import com.tydic.dyc.selfrun.order.api.DycUocQryAcceptOrderListService;
import com.tydic.dyc.selfrun.order.bo.DycUocAcceptOrderInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocButtonBo;
import com.tydic.dyc.selfrun.order.bo.DycUocQryAcceptOrderListReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocQryAcceptOrderListRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabCountsBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabQueryCountBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocQryAcceptOrderListServiceImpl
implements DycUocQryAcceptOrderListService {
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private DycTabTacheCodeQryFunction dycTabTacheCodeQryFunction;
    @Autowired
    private UocTacheButtonQryFunction uocTacheButtonQryFunction;
    @Value(value="#{'${button.form.params.insp:orderId,saleOrderId,shipOrderId,orderSource,busiTaskInstBos.taskId:taskId,busiTaskInstBos.tacheCode:tacheCode,auditTaskInstBos.taskId:auditTaskId,auditOrderBoList.auditOrderId:auditOrderId}'.split(',')}")
    private List<String> buttonFormParams;
    public static final String TAB_COUNT = "tabCount";
    public static final String TAB_NAME = "tabName";

    @Override
    public DycUocQryAcceptOrderListRspBO qryAcceptOrderList(DycUocQryAcceptOrderListReqBO reqBO) {
        this.setAuth(reqBO);
        JSONObject reqBoJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
        this.setTabConf(reqBO, reqBoJsonObj);
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setReqParams(reqBoJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        DycUocQryAcceptOrderListRspBO rspBO = (DycUocQryAcceptOrderListRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocQryAcceptOrderListRspBO.class));
        List<DycUocAcceptOrderInfoBO> rows = rspBO.getRows();
        if (ObjectUtil.isNotEmpty(rows)) {
            rows = rows.stream().filter(each -> {
                if (null == each.getAllowChngTime() || null == each.getAcceptTime()) {
                    return true;
                }
                return System.currentTimeMillis() < each.getAllowChngTime().getTime() + each.getAcceptTime().getTime();
            }).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTabId())) {
            this.setButton(rows, reqBO);
        }
        Map<Long, Map<String, Object>> tabsCountMap = this.getTabsCount(reqBO);
        this.setTabCount(reqBO, rspBO, tabsCountMap);
        return rspBO;
    }

    private void setAuth(DycUocQryAcceptOrderListReqBO reqBO) {
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setProId(reqBO.getOrgId().toString());
        } else if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setPurUserId(reqBO.getUserId().toString());
        } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setSupplierId(reqBO.getSupId().toString());
        }
    }

    private void setTabCount(DycUocQryAcceptOrderListReqBO reqBO, DycUocQryAcceptOrderListRspBO rspBO, Map<Long, Map<String, Object>> tabsCountMap) {
        if (ObjectUtil.isNotNull((Object)((Object)rspBO)) && ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            ArrayList<DycUocTabCountsBO> saleTabCountList = new ArrayList<DycUocTabCountsBO>();
            reqBO.getTabQueryCountBos().forEach(each -> {
                DycUocTabCountsBO tabCountsBO = new DycUocTabCountsBO();
                tabCountsBO.setTabId(each.getTabId());
                if (ObjectUtil.isNotEmpty((Object)tabsCountMap) && tabsCountMap.containsKey(each.getTabId())) {
                    tabCountsBO.setTabCount((Integer)((Map)tabsCountMap.get(each.getTabId())).get(TAB_COUNT));
                    tabCountsBO.setTabName(((Map)tabsCountMap.get(each.getTabId())).get(TAB_NAME).toString());
                    if (tabCountsBO.getTabName().startsWith("\u5168\u90e8")) {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName());
                    } else {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName() + "(" + tabCountsBO.getTabCount() + ")");
                    }
                }
                saleTabCountList.add(tabCountsBO);
            });
            rspBO.setAcceptTabCountList(saleTabCountList);
        }
    }

    private Map<Long, Map<String, Object>> getTabsCount(DycUocQryAcceptOrderListReqBO reqBO) {
        HashMap<Long, Map<String, Object>> tabCountMap = new HashMap<Long, Map<String, Object>>();
        if (ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            for (DycUocTabQueryCountBO tabQueryCountBo : reqBO.getTabQueryCountBos()) {
                reqBO.setTacheCodes(tabQueryCountBo.getTabCodes());
                DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
                dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
                dycGeneralQueryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)reqBO)));
                String rspJsonStr = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO).getRspJsonStr();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (ObjectUtil.isNotEmpty((Object)rspJsonStr)) {
                    JSONObject jsonObject = JSON.parseObject((String)rspJsonStr);
                    map.put(TAB_COUNT, ObjectUtil.isNotNull((Object)jsonObject.get((Object)"recordsTotal")) ? (Integer)jsonObject.get((Object)"recordsTotal") : 0);
                }
                map.put(TAB_NAME, null != tabQueryCountBo.getTabName() ? tabQueryCountBo.getTabName() : "");
                tabCountMap.put(tabQueryCountBo.getTabId(), map);
            }
        }
        return tabCountMap;
    }

    private void setTabConf(DycUocQryAcceptOrderListReqBO reqBO, JSONObject reqJsonObj) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMenuCode())) {
            DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO;
            List dycTabTacheCodeInfoFuncBOS;
            List<DycTabTacheCodeInfoFuncBO> dycTabTacheCodeInfoFuncBOList = this.qryTab(reqBO.getMenuCode());
            if (CollectionUtils.isEmpty(dycTabTacheCodeInfoFuncBOList)) {
                return;
            }
            ConcurrentMap<Integer, List<DycTabTacheCodeInfoFuncBO>> tabTachCodeMap = dycTabTacheCodeInfoFuncBOList.stream().collect(Collectors.groupingByConcurrent(DycTabTacheCodeInfoFuncBO::getTabId));
            if (StringUtils.isBlank((CharSequence)reqBO.getTabId())) {
                reqBO.setTabId(Convert.toStr((Object)dycTabTacheCodeInfoFuncBOList.get(0).getTabId()));
            }
            if (!CollectionUtils.isEmpty((Collection)(dycTabTacheCodeInfoFuncBOS = (List)tabTachCodeMap.get(Convert.toInt((Object)reqBO.getTabId())))) && StringUtils.isNotBlank((CharSequence)(dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)dycTabTacheCodeInfoFuncBOS.get(0)).getParamJson())) {
                JSONObject paramJsonObj = JSON.parseObject((String)dycTabTacheCodeInfoFuncBO.getParamJson());
                reqJsonObj.putAll((Map)paramJsonObj);
            }
            ArrayList<DycUocTabQueryCountBO> tabQueryCountBos = new ArrayList<DycUocTabQueryCountBO>();
            tabTachCodeMap.forEach((key, value) -> {
                if (!CollectionUtils.isEmpty((Collection)value)) {
                    DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)value.get(0);
                    DycUocTabQueryCountBO dycUocTabQueryCountBO = new DycUocTabQueryCountBO();
                    dycUocTabQueryCountBO.setTabId(key.longValue());
                    dycUocTabQueryCountBO.setTabName(dycTabTacheCodeInfoFuncBO.getTabName());
                    dycUocTabQueryCountBO.setTabCodes(dycTabTacheCodeInfoFuncBO.getTacheCodes());
                    dycUocTabQueryCountBO.setTabStatus(dycTabTacheCodeInfoFuncBO.getTabStatusList());
                    dycUocTabQueryCountBO.setTabSubCodes(dycTabTacheCodeInfoFuncBO.getSubTacheCodes());
                    dycUocTabQueryCountBO.setTabDoneSubCodes(dycTabTacheCodeInfoFuncBO.getDoneTacheCodeList());
                    dycUocTabQueryCountBO.setParamJson(dycTabTacheCodeInfoFuncBO.getParamJson());
                    dycUocTabQueryCountBO.setSort(dycTabTacheCodeInfoFuncBO.getSort());
                    tabQueryCountBos.add(dycUocTabQueryCountBO);
                }
            });
            reqBO.setTabQueryCountBos(tabQueryCountBos);
        }
    }

    private List<DycTabTacheCodeInfoFuncBO> qryTab(String menuCode) {
        DycTabTacheCodeQryFuncReqBO dycTabTacheCodeQryFuncReqBO = new DycTabTacheCodeQryFuncReqBO();
        dycTabTacheCodeQryFuncReqBO.setMenuCode(menuCode);
        DycTabTacheCodeQryFuncRspBO dycTabTacheCodeQryFuncRspBO = this.dycTabTacheCodeQryFunction.qryTabTacheCode(dycTabTacheCodeQryFuncReqBO);
        return dycTabTacheCodeQryFuncRspBO.getRows();
    }

    private void setButton(List<DycUocAcceptOrderInfoBO> rows, DycUocQryAcceptOrderListReqBO reqBO) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        HashMap buttonParamMap = new HashMap();
        ArrayList<String> buttonParamList = new ArrayList<String>(this.buttonFormParams);
        buttonParamList.forEach(buttonFormParam -> {
            if (buttonFormParam.contains(":")) {
                String[] paramRel = buttonFormParam.split("\\:");
                buttonParamMap.put(paramRel[0], paramRel[1]);
            } else {
                buttonParamMap.put(buttonFormParam, buttonFormParam);
            }
        });
        this.buttonFormParams = new ArrayList(buttonParamMap.keySet());
        HashSet orderIdList = new HashSet();
        ArrayList objIdList = new ArrayList();
        HashSet inspOrderStateList = new HashSet();
        rows.forEach(dycUocInspOrderInfoBO -> {
            inspOrderStateList.add(dycUocInspOrderInfoBO.getInspOrderState());
            objIdList.add(dycUocInspOrderInfoBO.getAcceptOrderId());
            orderIdList.add(dycUocInspOrderInfoBO.getOrderId());
        });
        UocTacheButtonQryFuncReqBo uocTacheButtonQryFuncReqBo = new UocTacheButtonQryFuncReqBo();
        uocTacheButtonQryFuncReqBo.setTabId(reqBO.getTabId());
        uocTacheButtonQryFuncReqBo.setOrderStatusList(new ArrayList(inspOrderStateList));
        uocTacheButtonQryFuncReqBo.setObjIdList(objIdList);
        uocTacheButtonQryFuncReqBo.setOrderIdList(new ArrayList(orderIdList));
        UocTacheButtonQryFuncRspBo uocTacheButtonQryFuncRspBo = this.uocTacheButtonQryFunction.qryTacheButton(uocTacheButtonQryFuncReqBo);
        List uocTacheButtonInfoFuncBOS = uocTacheButtonQryFuncRspBo.getUocTacheButtonS();
        if (!CollectionUtil.isEmpty((Collection)uocTacheButtonInfoFuncBOS)) {
            Map<String, List<UocTacheButtonInfoFuncBO>> statusMap = uocTacheButtonInfoFuncBOS.stream().filter(uocTacheButton -> StringUtils.isNotBlank((CharSequence)uocTacheButton.getOrderStatus())).collect(Collectors.groupingBy(UocTacheButtonInfoFuncBO::getOrderStatus));
            rows.forEach(dycUocInspOrderInfoBO -> {
                List tacheButtonInfoFuncBOS;
                ArrayList dycUocButtonBos = new ArrayList();
                if (StringUtils.isNotBlank((CharSequence)dycUocInspOrderInfoBO.getInspOrderState()) && !CollectionUtil.isEmpty((Collection)(tacheButtonInfoFuncBOS = (List)statusMap.get(dycUocInspOrderInfoBO.getInspOrderState())))) {
                    dycUocButtonBos.addAll(tacheButtonInfoFuncBOS.stream().map(uocButtonFuncBo -> {
                        DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                        dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                        dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                        dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                        return dycUocButtonBo;
                    }).collect(Collectors.toList()));
                }
                dycUocInspOrderInfoBO.setButtons(dycUocButtonBos.stream().distinct().collect(Collectors.toList()));
                if (!CollectionUtils.isEmpty(dycUocInspOrderInfoBO.getButtons())) {
                    dycUocInspOrderInfoBO.getButtons().forEach(dycUocButtonBo -> {
                        if (null != dycUocButtonBo) {
                            dycUocButtonBo.setUri(ParseUrlParamUtil.calUri((String)dycUocButtonBo.getUri(), (Object)dycUocInspOrderInfoBO, (Map)buttonParamMap, this.buttonFormParams));
                        }
                    });
                }
            });
        }
    }
}

