/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycTabTacheCodeQryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeInfoFuncBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncRspBO;
import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.selfrun.order.api.DycUocQryExceptionChangesListService;
import com.tydic.dyc.selfrun.order.bo.DycUocQryExceptionChangesListReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocQryExceptionChangesListRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabCountsBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabQueryCountBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocQryExceptionChangesListServiceImpl
implements DycUocQryExceptionChangesListService {
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private DycTabTacheCodeQryFunction dycTabTacheCodeQryFunction;
    public static final String TAB_COUNT = "tabCount";
    public static final String TAB_NAME = "tabName";

    @Override
    public DycUocQryExceptionChangesListRspBO qryExceptionChangesList(DycUocQryExceptionChangesListReqBO reqBO) {
        this.setAuth(reqBO);
        JSONObject reqBoJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
        this.setTabConf(reqBO, reqBoJsonObj);
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqBoJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        DycUocQryExceptionChangesListRspBO rspBO = (DycUocQryExceptionChangesListRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocQryExceptionChangesListRspBO.class));
        Map<Long, Map<String, Object>> tabsCountMap = this.getTabsCount(reqBO);
        this.setTabCount(reqBO, rspBO, tabsCountMap);
        return rspBO;
    }

    private void setAuth(DycUocQryExceptionChangesListReqBO reqBO) {
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setProId(ObjectUtil.isEmpty((Object)reqBO.getOrgId()) ? "" : String.valueOf(reqBO.getOrgId()));
        } else if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setPurUserId(ObjectUtil.isEmpty((Object)reqBO.getUserId()) ? "" : String.valueOf(reqBO.getUserId()));
        } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
            reqBO.setSupplierId(reqBO.getSupId().toString());
        }
    }

    private Map<Long, Map<String, Object>> getTabsCount(DycUocQryExceptionChangesListReqBO reqBO) {
        BaseUmcReqBo baseUmcReqBo = (BaseUmcReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), BaseUmcReqBo.class);
        DycUocQryExceptionChangesListReqBO dycUocQryExceptionChangesListReqBO = (DycUocQryExceptionChangesListReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)baseUmcReqBo), DycUocQryExceptionChangesListReqBO.class));
        this.setAuth(dycUocQryExceptionChangesListReqBO);
        HashMap<Long, Map<String, Object>> tabCountMap = new HashMap<Long, Map<String, Object>>();
        if (ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            for (DycUocTabQueryCountBO tabQueryCountBo : reqBO.getTabQueryCountBos()) {
                DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
                dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
                JSONObject baseReqJsonObj = tabQueryCountBo.getTabId().toString().equals(reqBO.getTabId()) ? JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO))) : JSON.parseObject((String)JSON.toJSONString((Object)((Object)dycUocQryExceptionChangesListReqBO)));
                if (StringUtils.isNotBlank((CharSequence)tabQueryCountBo.getParamJson())) {
                    JSONObject tabQryCountJsonObj = JSON.parseObject((String)tabQueryCountBo.getParamJson());
                    baseReqJsonObj.putAll((Map)tabQryCountJsonObj);
                }
                dycGeneralQueryFuncReqBO.setReqParams(baseReqJsonObj.toJSONString());
                String rspJsonStr = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO).getRspJsonStr();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (ObjectUtil.isNotEmpty((Object)rspJsonStr)) {
                    JSONObject jsonObject = JSON.parseObject((String)rspJsonStr);
                    map.put(TAB_COUNT, ObjectUtil.isNotNull((Object)jsonObject.get((Object)"recordsTotal")) ? jsonObject.get((Object)"recordsTotal") : Integer.valueOf(0));
                }
                map.put(TAB_NAME, null != tabQueryCountBo.getTabName() ? tabQueryCountBo.getTabName() : "");
                tabCountMap.put(tabQueryCountBo.getTabId(), map);
            }
        }
        return tabCountMap;
    }

    private void setTabCount(DycUocQryExceptionChangesListReqBO reqBO, DycUocQryExceptionChangesListRspBO rspBO, Map<Long, Map<String, Object>> tabsCountMap) {
        if (ObjectUtil.isNotNull((Object)((Object)rspBO)) && ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            ArrayList<DycUocTabCountsBO> chngTabCountList = new ArrayList<DycUocTabCountsBO>();
            List<DycUocTabQueryCountBO> dycUocTabQueryCountBOList = reqBO.getTabQueryCountBos();
            if (StringUtils.isNotBlank((CharSequence)reqBO.getMenuCode())) {
                dycUocTabQueryCountBOList = dycUocTabQueryCountBOList.stream().sorted(Comparator.comparing(DycUocTabQueryCountBO::getSort)).collect(Collectors.toList());
            }
            dycUocTabQueryCountBOList.forEach(each -> {
                DycUocTabCountsBO tabCountsBO = new DycUocTabCountsBO();
                tabCountsBO.setTabId(each.getTabId());
                if (ObjectUtil.isNotEmpty((Object)tabsCountMap) && tabsCountMap.containsKey(each.getTabId())) {
                    tabCountsBO.setTabCount((Integer)((Map)tabsCountMap.get(each.getTabId())).get(TAB_COUNT));
                    tabCountsBO.setTabName(((Map)tabsCountMap.get(each.getTabId())).get(TAB_NAME).toString());
                    if (tabCountsBO.getTabName().startsWith("\u5168\u90e8")) {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName());
                    } else {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName() + "(" + tabCountsBO.getTabCount() + ")");
                    }
                }
                chngTabCountList.add(tabCountsBO);
            });
            rspBO.setChngTabCountList(chngTabCountList);
        }
    }

    private void setTabConf(DycUocQryExceptionChangesListReqBO reqBO, JSONObject reqJsonObj) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMenuCode())) {
            DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO;
            List dycTabTacheCodeInfoFuncBOS;
            List<DycTabTacheCodeInfoFuncBO> dycTabTacheCodeInfoFuncBOList = this.qryTab(reqBO.getMenuCode());
            if (CollectionUtils.isEmpty(dycTabTacheCodeInfoFuncBOList)) {
                return;
            }
            ConcurrentMap<Integer, List<DycTabTacheCodeInfoFuncBO>> tabTachCodeMap = dycTabTacheCodeInfoFuncBOList.stream().collect(Collectors.groupingByConcurrent(DycTabTacheCodeInfoFuncBO::getTabId));
            if (StringUtils.isBlank((CharSequence)reqBO.getTabId())) {
                reqBO.setTabId(Convert.toStr((Object)dycTabTacheCodeInfoFuncBOList.get(0).getTabId()));
            }
            if (!CollectionUtils.isEmpty((Collection)(dycTabTacheCodeInfoFuncBOS = (List)tabTachCodeMap.get(Convert.toInt((Object)reqBO.getTabId())))) && StringUtils.isNotBlank((CharSequence)(dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)dycTabTacheCodeInfoFuncBOS.get(0)).getParamJson())) {
                JSONObject paramJsonObj = JSON.parseObject((String)dycTabTacheCodeInfoFuncBO.getParamJson());
                reqJsonObj.putAll((Map)paramJsonObj);
            }
            ArrayList<DycUocTabQueryCountBO> tabQueryCountBos = new ArrayList<DycUocTabQueryCountBO>();
            tabTachCodeMap.forEach((key, value) -> {
                if (!CollectionUtils.isEmpty((Collection)value)) {
                    DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)value.get(0);
                    DycUocTabQueryCountBO dycUocTabQueryCountBO = new DycUocTabQueryCountBO();
                    dycUocTabQueryCountBO.setTabId(key.longValue());
                    dycUocTabQueryCountBO.setTabName(dycTabTacheCodeInfoFuncBO.getTabName());
                    dycUocTabQueryCountBO.setTabCodes(dycTabTacheCodeInfoFuncBO.getTacheCodes());
                    dycUocTabQueryCountBO.setTabStatus(dycTabTacheCodeInfoFuncBO.getTabStatusList());
                    dycUocTabQueryCountBO.setTabSubCodes(dycTabTacheCodeInfoFuncBO.getSubTacheCodes());
                    dycUocTabQueryCountBO.setTabDoneSubCodes(dycTabTacheCodeInfoFuncBO.getDoneTacheCodeList());
                    dycUocTabQueryCountBO.setParamJson(dycTabTacheCodeInfoFuncBO.getParamJson());
                    dycUocTabQueryCountBO.setSort(dycTabTacheCodeInfoFuncBO.getSort());
                    tabQueryCountBos.add(dycUocTabQueryCountBO);
                }
            });
            reqBO.setTabQueryCountBos(tabQueryCountBos);
        }
    }

    private List<DycTabTacheCodeInfoFuncBO> qryTab(String menuCode) {
        DycTabTacheCodeQryFuncReqBO dycTabTacheCodeQryFuncReqBO = new DycTabTacheCodeQryFuncReqBO();
        dycTabTacheCodeQryFuncReqBO.setMenuCode(menuCode);
        DycTabTacheCodeQryFuncRspBO dycTabTacheCodeQryFuncRspBO = this.dycTabTacheCodeQryFunction.qryTabTacheCode(dycTabTacheCodeQryFuncReqBO);
        return dycTabTacheCodeQryFuncRspBO.getRows();
    }
}

