/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.busicommon.api.DycUocProOrderButtonSettingsFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocProOrderEffectivePageQueryFunction;
import com.tydic.dyc.atom.busicommon.api.UocTacheButtonQryFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocProConfButtonFuncBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocProOrderEffectiveInfoFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycUocProOrderEffectiveListPageQueryFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycUocProOrderEffectiveListPageQueryFuncRspBo;
import com.tydic.dyc.atom.busicommon.bo.DycUocProQueryOrderButtonSettingsFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycUocProQueryOrderButtonSettingsFuncRspBo;
import com.tydic.dyc.atom.busicommon.bo.UocTacheButtonInfoFuncBO;
import com.tydic.dyc.atom.busicommon.bo.UocTacheButtonQryFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.UocTacheButtonQryFuncRspBo;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycTabTacheCodeQryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeInfoFuncBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncRspBO;
import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.base.utils.ParseUrlParamUtil;
import com.tydic.dyc.selfrun.order.api.DycUocSalOrderListQryService;
import com.tydic.dyc.selfrun.order.bo.DycUocButtonBo;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabCountsBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabQueryCountBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTaskInstInfoBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocSalOrderListQryServiceImpl
implements DycUocSalOrderListQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUocSalOrderListQryServiceImpl.class);
    public static final String TAB_COUNT = "tabCount";
    public static final String TAB_NAME = "tabName";
    public static final String DEFAULT = "DEFAULT";
    public static final Long ID = 1L;
    private static final String ELC = "2";
    private static final String EFFECTIVE_CODE_STOCK = "1";
    private static final String EFFECTIVE_CODE_PAY = "2";
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private UocTacheButtonQryFunction uocTacheButtonQryFunction;
    @Autowired
    private DycTabTacheCodeQryFunction dycTabTacheCodeQryFunction;
    @Value(value="#{'${button.form.params.sale:orderId,saleOrderId,orderSource,busiTaskInstBos.taskId:taskId,busiTaskInstBos.tacheCode:tacheCode,auditTaskInstBos.taskId:auditTaskId,auditOrderBoList.auditOrderId:auditOrderId}'.split(',')}")
    private List<String> buttonFormParams;
    @Autowired
    private DycUocProOrderButtonSettingsFunction dycUocProOrderButtonSettingsFunction;
    @Autowired
    private DycUocProOrderEffectivePageQueryFunction dycUocProOrderEffectivePageQueryFunction;

    @Override
    public DycUocSalOrderListQryRspBO qrySalOrderList(DycUocSalOrderListQryReqBO reqBO) {
        this.setAuthUser(reqBO);
        JSONObject reqJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
        this.setTabConf(reqBO, reqJsonObj);
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        DycUocSalOrderListQryRspBO rspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTabId())) {
            this.setButton(rspBO.getRows(), reqBO);
        }
        Map<Long, Map<String, Object>> tabsCountMap = this.getTabsCount(reqBO);
        this.setTabCount(reqBO, rspBO, tabsCountMap);
        return rspBO;
    }

    private void setAuthUser(DycUocSalOrderListQryReqBO reqBO) {
        if (null != reqBO.getUserId() && ObjectUtil.notEqual((Object)reqBO.getUserId(), (Object)ID)) {
            if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                reqBO.setProId(reqBO.getOrgId().toString());
            } else if (!EFFECTIVE_CODE_STOCK.equals(reqBO.getIsProfessionalOrgExt()) && "2".equals(reqBO.getIsProfessionalOrgExt())) {
                if (null == reqBO.getSupplierId() || reqBO.getSupplierId().equals("")) {
                    reqBO.setSupplierId(reqBO.getSupId().toString());
                } else {
                    reqBO.setSupplierId(reqBO.getSupId().toString().equals(reqBO.getSupplierId()) ? reqBO.getSupId().toString() : "*");
                }
            }
        }
        if (reqBO.getObjBusiType() != null) {
            ArrayList<String> auditDealResultQryKeys = new ArrayList<String>();
            String auditDealResultQryKey3 = reqBO.getUserId() + "_" + reqBO.getObjBusiType();
            String auditDealResultQryKey1 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 0;
            String auditDealResultQryKey2 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 1;
            if (!CollectionUtils.isEmpty(reqBO.getAuditOrderStatusQry())) {
                String auditDealResultQryKey = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + reqBO.getAuditOrderStatusQry().get(0);
                auditDealResultQryKeys.add(auditDealResultQryKey);
            } else if (reqBO.getTabId().equals("30014")) {
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            } else if (reqBO.getTabId().equals("30015")) {
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
            } else {
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            }
            reqBO.setAuditDealResultQryKeys(auditDealResultQryKeys);
        }
    }

    private void setTabConf(DycUocSalOrderListQryReqBO reqBO, JSONObject reqJsonObj) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMenuCode())) {
            DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO;
            List dycTabTacheCodeInfoFuncBOS;
            List<DycTabTacheCodeInfoFuncBO> dycTabTacheCodeInfoFuncBOList = this.qryTab(reqBO.getMenuCode());
            if (CollectionUtils.isEmpty(dycTabTacheCodeInfoFuncBOList)) {
                return;
            }
            ConcurrentMap<Integer, List<DycTabTacheCodeInfoFuncBO>> tabTachCodeMap = dycTabTacheCodeInfoFuncBOList.stream().collect(Collectors.groupingByConcurrent(DycTabTacheCodeInfoFuncBO::getTabId));
            if (StringUtils.isBlank((CharSequence)reqBO.getTabId())) {
                reqBO.setTabId(Convert.toStr((Object)dycTabTacheCodeInfoFuncBOList.get(0).getTabId()));
            }
            if (!CollectionUtils.isEmpty((Collection)(dycTabTacheCodeInfoFuncBOS = (List)tabTachCodeMap.get(Convert.toInt((Object)reqBO.getTabId())))) && StringUtils.isNotBlank((CharSequence)(dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)dycTabTacheCodeInfoFuncBOS.get(0)).getParamJson())) {
                JSONObject paramJsonObj = JSON.parseObject((String)dycTabTacheCodeInfoFuncBO.getParamJson());
                reqJsonObj.putAll((Map)paramJsonObj);
            }
            ArrayList<DycUocTabQueryCountBO> tabQueryCountBos = new ArrayList<DycUocTabQueryCountBO>();
            tabTachCodeMap.forEach((key, value) -> {
                if (!CollectionUtils.isEmpty((Collection)value)) {
                    DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)value.get(0);
                    DycUocTabQueryCountBO dycUocTabQueryCountBO = new DycUocTabQueryCountBO();
                    dycUocTabQueryCountBO.setTabId(key.longValue());
                    dycUocTabQueryCountBO.setTabName(dycTabTacheCodeInfoFuncBO.getTabName());
                    dycUocTabQueryCountBO.setTabCodes(dycTabTacheCodeInfoFuncBO.getTacheCodes());
                    dycUocTabQueryCountBO.setTabStatus(dycTabTacheCodeInfoFuncBO.getTabStatusList());
                    dycUocTabQueryCountBO.setTabSubCodes(dycTabTacheCodeInfoFuncBO.getSubTacheCodes());
                    dycUocTabQueryCountBO.setTabDoneSubCodes(dycTabTacheCodeInfoFuncBO.getDoneTacheCodeList());
                    dycUocTabQueryCountBO.setParamJson(dycTabTacheCodeInfoFuncBO.getParamJson());
                    dycUocTabQueryCountBO.setSort(dycTabTacheCodeInfoFuncBO.getSort());
                    tabQueryCountBos.add(dycUocTabQueryCountBO);
                }
            });
            reqBO.setTabQueryCountBos(tabQueryCountBos);
        }
    }

    private void setButton(List<DycUocSaleOrderInfoBO> rows, DycUocSalOrderListQryReqBO reqBO) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        HashSet tacheCodes = new HashSet();
        HashSet orderIdList = new HashSet();
        ArrayList objIdList = new ArrayList();
        HashSet saleOrderStateList = new HashSet();
        HashSet subTacheCodes = new HashSet();
        rows.forEach(dycUocSaleOrderInfoBO -> {
            for (DycUocTaskInstInfoBO busiTaskInstBo : dycUocSaleOrderInfoBO.getBusiTaskInstBos()) {
                tacheCodes.add(busiTaskInstBo.getTacheCode());
            }
            if (!CollectionUtils.isEmpty(dycUocSaleOrderInfoBO.getShipOrderIdList())) {
                objIdList.addAll(dycUocSaleOrderInfoBO.getShipOrderIdList().stream().map(Convert::toLong).collect(Collectors.toList()));
            }
            objIdList.add(dycUocSaleOrderInfoBO.getSaleOrderId());
            orderIdList.add(dycUocSaleOrderInfoBO.getOrderId());
            if (StringUtils.isNotBlank((CharSequence)dycUocSaleOrderInfoBO.getSaleOrderState())) {
                saleOrderStateList.add(dycUocSaleOrderInfoBO.getSaleOrderState());
            }
            if (!CollectionUtils.isEmpty(dycUocSaleOrderInfoBO.getShipOrderTacheCode())) {
                subTacheCodes.addAll(dycUocSaleOrderInfoBO.getShipOrderTacheCode());
            }
        });
        UocTacheButtonQryFuncReqBo uocTacheButtonQryFuncReqBo = new UocTacheButtonQryFuncReqBo();
        uocTacheButtonQryFuncReqBo.setTabId(reqBO.getTabId());
        uocTacheButtonQryFuncReqBo.setOrderStatusList(new ArrayList(saleOrderStateList));
        uocTacheButtonQryFuncReqBo.setTacheCodes(new ArrayList(tacheCodes));
        uocTacheButtonQryFuncReqBo.setSubOrderStatusCodes(new ArrayList(subTacheCodes));
        uocTacheButtonQryFuncReqBo.setObjIdList(objIdList);
        uocTacheButtonQryFuncReqBo.setOrderIdList(new ArrayList(orderIdList));
        uocTacheButtonQryFuncReqBo.setReflected(reqBO.getReflected());
        UocTacheButtonQryFuncRspBo uocTacheButtonQryFuncRspBo = this.uocTacheButtonQryFunction.qryTacheButton(uocTacheButtonQryFuncReqBo);
        List uocTacheButtonInfoFuncBOS = uocTacheButtonQryFuncRspBo.getUocTacheButtonS();
        if (!CollectionUtil.isEmpty((Collection)uocTacheButtonInfoFuncBOS)) {
            HashMap buttonParamMap = new HashMap();
            ArrayList<String> buttonParamList = new ArrayList<String>(this.buttonFormParams);
            buttonParamList.forEach(buttonFormParam -> {
                if (buttonFormParam.contains(":")) {
                    String[] paramRel = buttonFormParam.split("\\:");
                    buttonParamMap.put(paramRel[0], paramRel[1]);
                } else {
                    buttonParamMap.put(buttonFormParam, buttonFormParam);
                }
            });
            this.buttonFormParams = new ArrayList(buttonParamMap.keySet());
            Map<String, List<UocTacheButtonInfoFuncBO>> tacheCodeMap = uocTacheButtonInfoFuncBOS.stream().collect(Collectors.groupingBy(UocTacheButtonInfoFuncBO::getTacheCode));
            Map<String, List<UocTacheButtonInfoFuncBO>> subTacheCodeMap = uocTacheButtonInfoFuncBOS.stream().filter(uocTacheButton -> StringUtils.isNotBlank((CharSequence)uocTacheButton.getSubOrderStatusCode())).collect(Collectors.groupingBy(UocTacheButtonInfoFuncBO::getSubOrderStatusCode));
            Map<String, List<UocTacheButtonInfoFuncBO>> statusMap = uocTacheButtonInfoFuncBOS.stream().filter(uocTacheButton -> StringUtils.isNotBlank((CharSequence)uocTacheButton.getOrderStatus())).collect(Collectors.groupingBy(UocTacheButtonInfoFuncBO::getOrderStatus));
            ArrayList defaultButtonList = tacheCodeMap.get(DEFAULT);
            List defaultButtonBos = (CollectionUtils.isEmpty(defaultButtonList) ? new ArrayList() : defaultButtonList).stream().map(uocButtonFuncBo -> {
                DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                return dycUocButtonBo;
            }).collect(Collectors.toList());
            Map<String, Map<String, Long>> effConfMap = this.getConf();
            Map<String, List<String>> buttonConf = this.getButtonConf();
            rows.forEach(dycUocSaleOrderInfoBO -> {
                ArrayList dycUocButtonBos = new ArrayList(defaultButtonBos);
                if (!CollectionUtil.isEmpty(dycUocSaleOrderInfoBO.getShipOrderTacheCode())) {
                    dycUocSaleOrderInfoBO.getShipOrderTacheCode().stream().distinct().forEach(shipOrderTacheCode -> {
                        List shipTacheButtonList = (List)subTacheCodeMap.get(shipOrderTacheCode);
                        if (!CollectionUtils.isEmpty((Collection)shipTacheButtonList)) {
                            dycUocButtonBos.addAll(shipTacheButtonList.stream().map(uocButtonFuncBo -> {
                                DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                                dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                                dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                                dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                                return dycUocButtonBo;
                            }).collect(Collectors.toList()));
                        }
                    });
                } else if (StringUtils.isNotBlank((CharSequence)dycUocSaleOrderInfoBO.getSaleOrderState())) {
                    List tacheButtonInfoFuncBOS = (List)statusMap.get(dycUocSaleOrderInfoBO.getSaleOrderState());
                    if (!CollectionUtil.isEmpty((Collection)tacheButtonInfoFuncBOS)) {
                        dycUocButtonBos.addAll(tacheButtonInfoFuncBOS.stream().map(uocButtonFuncBo -> {
                            DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                            dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                            dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                            dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                            return dycUocButtonBo;
                        }).collect(Collectors.toList()));
                    }
                } else if (!CollectionUtil.isEmpty(dycUocSaleOrderInfoBO.getBusiTaskInstBos())) {
                    for (DycUocTaskInstInfoBO busiTaskInstBo : dycUocSaleOrderInfoBO.getBusiTaskInstBos()) {
                        List uocButtonFuncBos = (List)tacheCodeMap.get(busiTaskInstBo.getTacheCode());
                        if (CollectionUtil.isEmpty((Collection)uocButtonFuncBos)) continue;
                        dycUocButtonBos.addAll(uocButtonFuncBos.stream().map(uocButtonFuncBo -> {
                            DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                            dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                            dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                            dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                            return dycUocButtonBo;
                        }).collect(Collectors.toList()));
                    }
                }
                dycUocSaleOrderInfoBO.setButtons(dycUocButtonBos.stream().distinct().collect(Collectors.toList()));
                if (!CollectionUtils.isEmpty(dycUocSaleOrderInfoBO.getButtons())) {
                    Iterator<DycUocButtonBo> iterator = dycUocSaleOrderInfoBO.getButtons().iterator();
                    while (iterator.hasNext()) {
                        DycUocButtonBo dycUocButtonBo = iterator.next();
                        if (null == dycUocButtonBo) continue;
                        dycUocButtonBo.setUri(ParseUrlParamUtil.calUri((String)dycUocButtonBo.getUri(), (Object)dycUocSaleOrderInfoBO, (Map)buttonParamMap, this.buttonFormParams));
                        if (!CollectionUtils.isEmpty((Collection)((Collection)buttonConf.get(dycUocButtonBo.getMenuCode()))) && "2".equals(dycUocSaleOrderInfoBO.getOrderSource()) && !((List)buttonConf.get(dycUocButtonBo.getMenuCode())).contains(dycUocSaleOrderInfoBO.getSupId())) {
                            iterator.remove();
                        }
                        if (!"XS_QX_QXSQ".equals(dycUocSaleOrderInfoBO.getSaleOrderState()) || !"QXDD".equals(dycUocButtonBo.getMenuCode())) continue;
                        iterator.remove();
                    }
                }
                if (!CollectionUtils.isEmpty((Map)effConfMap) && StringUtils.isNotBlank((CharSequence)dycUocSaleOrderInfoBO.getSupId()) && StringUtils.isNotBlank((CharSequence)dycUocSaleOrderInfoBO.getOrderSource())) {
                    Map payEffMap;
                    Map stockEffMap = (Map)effConfMap.get(EFFECTIVE_CODE_STOCK + dycUocSaleOrderInfoBO.getOrderSource());
                    if (null != stockEffMap) {
                        Long time = (Long)stockEffMap.get(dycUocSaleOrderInfoBO.getSupId());
                        if (null == time) {
                            time = (Long)stockEffMap.get("0");
                        }
                        dycUocSaleOrderInfoBO.setStockAging(time);
                    }
                    if (null != (payEffMap = (Map)effConfMap.get("2" + dycUocSaleOrderInfoBO.getOrderSource()))) {
                        Long time = (Long)payEffMap.get(dycUocSaleOrderInfoBO.getSupId());
                        if (null == time) {
                            time = (Long)payEffMap.get("0");
                        }
                        dycUocSaleOrderInfoBO.setPayAging(time);
                    }
                }
            });
        }
    }

    private void setTabCount(DycUocSalOrderListQryReqBO reqBO, DycUocSalOrderListQryRspBO rspBO, Map<Long, Map<String, Object>> tabsCountMap) {
        if (ObjectUtil.isNotNull((Object)((Object)rspBO)) && ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            ArrayList<DycUocTabCountsBO> saleTabCountList = new ArrayList<DycUocTabCountsBO>();
            List<DycUocTabQueryCountBO> dycUocTabQueryCountBOList = reqBO.getTabQueryCountBos();
            if (StringUtils.isNotBlank((CharSequence)reqBO.getMenuCode())) {
                dycUocTabQueryCountBOList = dycUocTabQueryCountBOList.stream().sorted(Comparator.comparing(DycUocTabQueryCountBO::getSort)).collect(Collectors.toList());
            }
            dycUocTabQueryCountBOList.forEach(each -> {
                DycUocTabCountsBO tabCountsBO = new DycUocTabCountsBO();
                tabCountsBO.setTabId(each.getTabId());
                if (ObjectUtil.isNotEmpty((Object)tabsCountMap) && tabsCountMap.containsKey(each.getTabId())) {
                    tabCountsBO.setTabCount((Integer)((Map)tabsCountMap.get(each.getTabId())).get(TAB_COUNT));
                    tabCountsBO.setTabName(((Map)tabsCountMap.get(each.getTabId())).get(TAB_NAME).toString());
                    if (ObjectUtil.equal((Object)30014, (Object)each.getTabId().intValue())) {
                        tabCountsBO.setTabName(tabCountsBO.getTabName() + "(" + tabCountsBO.getTabCount() + ")");
                    }
                    tabCountsBO.setTabNameCount(tabCountsBO.getTabName() + "(" + tabCountsBO.getTabCount() + ")");
                    if (ObjectUtil.equal((Object)30401, (Object)each.getTabId().intValue())) {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName());
                    } else {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName() + "(" + tabCountsBO.getTabCount() + ")");
                    }
                }
                saleTabCountList.add(tabCountsBO);
            });
            rspBO.setSaleTabCountList(saleTabCountList);
        }
    }

    private Map<Long, Map<String, Object>> getTabsCount(DycUocSalOrderListQryReqBO reqBO) {
        BaseUmcReqBo baseUmcReqBo = (BaseUmcReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), BaseUmcReqBo.class);
        HashMap<Long, Map<String, Object>> tabCountMap = new HashMap<Long, Map<String, Object>>();
        if (ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            for (DycUocTabQueryCountBO tabQueryCountBo : reqBO.getTabQueryCountBos()) {
                JSONObject baseReqJsonObj;
                Date now = new Date();
                DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
                dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
                if (tabQueryCountBo.getTabId().toString().equals(reqBO.getTabId())) {
                    baseReqJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
                } else {
                    DycUocSalOrderListQryReqBO dycUocSalOrderListQryReqBO = (DycUocSalOrderListQryReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)baseUmcReqBo), DycUocSalOrderListQryReqBO.class));
                    BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)dycUocSalOrderListQryReqBO));
                    if (ObjectUtil.isNotEmpty((Object)tabQueryCountBo.getTabId())) {
                        dycUocSalOrderListQryReqBO.setTabId(String.valueOf(tabQueryCountBo.getTabId()));
                    }
                    this.setAuthUser(dycUocSalOrderListQryReqBO);
                    baseReqJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)dycUocSalOrderListQryReqBO)));
                }
                if (StringUtils.isNotBlank((CharSequence)tabQueryCountBo.getParamJson())) {
                    JSONObject tabQryCountJsonObj = JSON.parseObject((String)tabQueryCountBo.getParamJson());
                    baseReqJsonObj.putAll((Map)tabQryCountJsonObj);
                }
                log.info("\u67e5\u8be2\u6570\u91cf\u5165\u53c2:{}", (Object)baseReqJsonObj.toJSONString());
                dycGeneralQueryFuncReqBO.setReqParams(baseReqJsonObj.toJSONString());
                String rspJsonStr = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO).getRspJsonStr();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (ObjectUtil.isNotEmpty((Object)rspJsonStr)) {
                    JSONObject jsonObject = JSON.parseObject((String)rspJsonStr);
                    map.put(TAB_COUNT, ObjectUtil.isNotNull((Object)jsonObject.get((Object)"recordsTotal")) ? jsonObject.get((Object)"recordsTotal") : Integer.valueOf(0));
                }
                map.put(TAB_NAME, null != tabQueryCountBo.getTabName() ? tabQueryCountBo.getTabName() : "");
                tabCountMap.put(tabQueryCountBo.getTabId(), map);
                Date now2 = new Date();
                log.info("\u5faa\u73af\u67e5\u8be2\u6570\u91cf\u65f6\u95f4\u5f00\u59cb:{} \u7ed3\u675f:{} \u8017\u65f6:{}ms", new Object[]{DateUtils.dateToStr((Date)now, (String)"yyyy-MM-dd HH:mm:ss SSS"), DateUtils.dateToStr((Date)now2, (String)"yyyy-MM-dd HH:mm:ss SSS"), now2.getTime() - now.getTime()});
            }
        }
        return tabCountMap;
    }

    private List<DycTabTacheCodeInfoFuncBO> qryTab(String menuCode) {
        DycTabTacheCodeQryFuncReqBO dycTabTacheCodeQryFuncReqBO = new DycTabTacheCodeQryFuncReqBO();
        dycTabTacheCodeQryFuncReqBO.setMenuCode(menuCode);
        DycTabTacheCodeQryFuncRspBO dycTabTacheCodeQryFuncRspBO = this.dycTabTacheCodeQryFunction.qryTabTacheCode(dycTabTacheCodeQryFuncReqBO);
        return dycTabTacheCodeQryFuncRspBO.getRows();
    }

    private Map<String, Map<String, Long>> getConf() {
        DycUocProOrderEffectiveListPageQueryFuncReqBo dycUocProOrderEffectiveListPageQueryFuncReqBo = new DycUocProOrderEffectiveListPageQueryFuncReqBo();
        dycUocProOrderEffectiveListPageQueryFuncReqBo.setPageNo(-1);
        dycUocProOrderEffectiveListPageQueryFuncReqBo.setPageSize(-1);
        DycUocProOrderEffectiveListPageQueryFuncRspBo dycUocProOrderEffectiveListPageQueryFuncRspBo = this.dycUocProOrderEffectivePageQueryFunction.queryOrderEffectiveListPage(dycUocProOrderEffectiveListPageQueryFuncReqBo);
        if (CollectionUtils.isEmpty((Collection)dycUocProOrderEffectiveListPageQueryFuncRspBo.getRows())) {
            return new HashMap<String, Map<String, Long>>();
        }
        Map<String, List<DycUocProOrderEffectiveInfoFuncBo>> effListMap = dycUocProOrderEffectiveListPageQueryFuncRspBo.getRows().stream().collect(Collectors.groupingBy(e -> e.getEffectiveCode() + e.getBusinessTypeCode()));
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
        effListMap.forEach((key, value) -> map.put((String)key, value.stream().collect(Collectors.toMap(DycUocProOrderEffectiveInfoFuncBo::getSupplierNo, DycUocProOrderEffectiveInfoFuncBo::getAging))));
        return map;
    }

    private Map<String, List<String>> getButtonConf() {
        DycUocProQueryOrderButtonSettingsFuncReqBo dycUocProEditOrderButtonSettingsFuncReqBo = new DycUocProQueryOrderButtonSettingsFuncReqBo();
        DycUocProQueryOrderButtonSettingsFuncRspBo dycUocProQueryOrderButtonSettingsFuncRspBo = this.dycUocProOrderButtonSettingsFunction.queryOrderButtonSettings(dycUocProEditOrderButtonSettingsFuncReqBo);
        log.info("\u67e5\u8be2\u6309\u94ae\u914d\u7f6e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dycUocProQueryOrderButtonSettingsFuncRspBo));
        List rows = dycUocProQueryOrderButtonSettingsFuncRspBo.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return new HashMap<String, List<String>>(0);
        }
        HashMap<String, List<String>> buttonMap = new HashMap<String, List<String>>();
        for (DycUocProConfButtonFuncBO row : rows) {
            buttonMap.put(row.getButtonCode(), Arrays.asList(row.getSupNo().split(",")));
        }
        return buttonMap;
    }
}

