/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.cfc.ability.api.CfcAppModeConfigQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcAppModeConfigQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcAppModeConfigQryListPageAbilityRspBO;
import com.tydic.dyc.atom.busicommon.user.api.DycAuthUserDataPowerQryFunction;
import com.tydic.dyc.atom.busicommon.user.bo.DycAuthUserDataPowerQryFunctionReqBo;
import com.tydic.dyc.atom.busicommon.user.bo.DycAuthUserDataPowerQryFunctionRspBo;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycTabTacheCodeQryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeInfoFuncBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncRspBO;
import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.base.utils.ParseUrlParamUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocTacheButtonQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryRspBo;
import com.tydic.dyc.oc.service.order.UocProOrderButtonSettingsService;
import com.tydic.dyc.oc.service.order.UocProOrderEffectivePageQueryService;
import com.tydic.dyc.oc.service.order.UocProOrderEvaluatePageQueryService;
import com.tydic.dyc.oc.service.order.bo.UocProConfButtonBO;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluateInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluatePageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluatePageQueryRspBo;
import com.tydic.dyc.oc.service.order.bo.UocProQueryOrderButtonSettingsReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProQueryOrderButtonSettingsRspBo;
import com.tydic.dyc.selfrun.order.api.DycUocSalOrderListQryService;
import com.tydic.dyc.selfrun.order.bo.DycUocButtonBo;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderCommodityInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabCountsBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabQueryCountBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTaskInstInfoBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocSalOrderListQryService"})
public class DycUocSalOrderListQryServiceImpl
implements DycUocSalOrderListQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUocSalOrderListQryServiceImpl.class);
    public static final String TAB_COUNT = "tabCount";
    public static final String TAB_NAME = "tabName";
    public static final String DEFAULT = "DEFAULT";
    public static final Long ID = 1L;
    private static final String ELC = "2";
    private static final String EFFECTIVE_CODE_STOCK = "1";
    private static final String EFFECTIVE_CODE_PAY = "2";
    private static final String EFFECTIVE_CODE_INSP = "4";
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private UocTacheButtonQryService uocTacheButtonQryService;
    @Autowired
    private DycTabTacheCodeQryFunction dycTabTacheCodeQryFunction;
    @Value(value="#{'${button.form.params.sale:orderId,saleOrderId,orderSource,busiTaskInstBos.taskId:taskId,busiTaskInstBos.tacheCode:tacheCode,auditTaskInstBos.taskId:auditTaskId,auditOrderBoList.auditOrderId:auditOrderId}'.split(',')}")
    private List<String> buttonFormParams;
    @Value(value="${ROUTING_MENU_CODE}")
    private String routingMenuCode;
    @Autowired
    private UocProOrderButtonSettingsService uocProOrderButtonSettingsService;
    @Autowired
    private UocProOrderEffectivePageQueryService uocProOrderEffectivePageQueryService;
    @Autowired
    private UocProOrderEvaluatePageQueryService uocProOrderEvaluatePageQueryService;
    @Autowired
    private DycAuthUserDataPowerQryFunction dycAuthUserDataPowerQryFunction;
    private static final Integer SYSTEM_AUTOMATIC_PRAISE = 1;
    private static final Integer ALLOW_EVA = 1;
    private static final Integer NOT_ALLOW_EVA = 0;
    @Autowired
    private CfcAppModeConfigQryListPageAbilityService cfcAppModeConfigQryListPageAbilityService;

    @Override
    @PostMapping(value={"qrySalOrderList"})
    public DycUocSalOrderListQryRspBO qrySalOrderList(@RequestBody DycUocSalOrderListQryReqBO reqBO) {
        String dataAuth = this.setAuthUser(reqBO);
        JSONObject reqJsonObj = JSON.parseObject((String)dataAuth);
        JSONObject reqBoJsonObj1 = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
        reqJsonObj.putAll((Map)reqBoJsonObj1);
        this.setTabConf(reqBO, reqJsonObj);
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqJsonObj.toJSONString());
        dycGeneralQueryFuncReqBO.setSortQueryConfigList(reqBO.getSortQueryConfigList());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        DycUocSalOrderListQryRspBO rspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTabId())) {
            this.setButton(rspBO.getRows(), reqBO);
        }
        Map<Long, Map<String, Object>> tabsCountMap = this.getTabsCount(reqBO, reqJsonObj);
        this.setTabCount(reqBO, rspBO, tabsCountMap);
        this.checkIsPlanMode(reqBO, rspBO);
        if (ObjectUtil.isNotEmpty(rspBO.getRows())) {
            for (DycUocSaleOrderInfoBO item : rspBO.getRows()) {
                if (!org.springframework.util.CollectionUtils.isEmpty(item.getAuditTaskInstBos())) {
                    for (DycUocTaskInstInfoBO taskInfo : item.getAuditTaskInstBos()) {
                        if (!String.valueOf(reqBO.getUserId()).equals(taskInfo.getDealId()) || 0 != taskInfo.getFinishTag()) continue;
                        item.setTaskSignTag(taskInfo.getTaskSignTag());
                    }
                }
                if (EFFECTIVE_CODE_STOCK.equals(reqBO.getIsProfessionalOrgExt()) && item.getTradeMode() == 1 && "\u62d2\u5355\u5f85\u5904\u7406".equals(item.getSaleOrderStateStr())) {
                    item.setSaleOrderStateStr("\u5f85\u786e\u8ba4");
                }
                if (!"evaluateSaleOrder".equals(reqBO.getMenuCode())) continue;
                List<DycUocSaleOrderCommodityInfoBO> commodityInfos = item.getCommodityInfos();
                item.setCommodityInfos(commodityInfos.stream().filter(obj -> EFFECTIVE_CODE_STOCK.equals(obj.getEvaSign())).collect(Collectors.toList()));
            }
            for (DycUocSaleOrderInfoBO item : rspBO.getRows()) {
                List<DycUocButtonBo> buttonBos = item.getButtons();
                if (!"100055".equals(item.getSupId()) || "XS_FH_FHZ".equals(item.getSaleOrderState()) && null != item.getJdczFlag() && item.getJdczFlag() == 1 || !ObjectUtil.isNotEmpty(buttonBos)) continue;
                buttonBos = buttonBos.stream().filter(e -> !e.getMenuCode().equals("DHQR")).collect(Collectors.toList());
                item.setButtons(buttonBos);
            }
        }
        if (ObjectUtil.isNotEmpty(rspBO.getRows())) {
            int i = 1;
            for (DycUocSaleOrderInfoBO each : rspBO.getRows()) {
                each.setSort(i++);
            }
        }
        return rspBO;
    }

    private void checkIsPlanMode(DycUocSalOrderListQryReqBO reqBO, DycUocSalOrderListQryRspBO rspBO) {
        try {
            if (null != reqBO.getPurOrgId()) {
                CfcAppModeConfigQryListPageAbilityReqBO abilityReqBO = new CfcAppModeConfigQryListPageAbilityReqBO();
                abilityReqBO.setOrgIdWeb(Long.valueOf(Long.parseLong(reqBO.getPurOrgId())));
                CfcAppModeConfigQryListPageAbilityRspBO abilityRspBO = this.cfcAppModeConfigQryListPageAbilityService.qryAppModeConfigListPage(abilityReqBO);
                if (null != abilityRspBO && ObjectUtil.isNotEmpty((Object)abilityRspBO.getRows())) {
                    rspBO.setIsPlanMode(true);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3CfcAppModeConfigQryListPageAbilityService\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    private String setAuthUser(DycUocSalOrderListQryReqBO reqBO) {
        DycAuthUserDataPowerQryFunctionRspBo functionRspBo = null;
        if (null != reqBO.getUserId() && ObjectUtil.notEqual((Object)reqBO.getUserId(), (Object)ID) && !"30501".equals(reqBO.getTabId())) {
            DycAuthUserDataPowerQryFunctionReqBo functionReqBo;
            if ("0".equals(reqBO.getIsProfessionalOrgExt()) && StringUtils.isNotBlank((CharSequence)this.routingMenuCode) && Arrays.asList(this.routingMenuCode.split(";")).contains(reqBO.getMenuCode())) {
                reqBO.setAgreementCode(1);
                reqBO.setTradeMode("lcpAgrMatchingOrderQuery".equals(reqBO.getMenuCode()) || "lcpAgrMyMatchingSalesOrder".equals(reqBO.getMenuCode()) ? 2 : 1);
            }
            if (!"evaluateSaleOrder".equals(reqBO.getMenuCode()) && (reqBO.getMenuCode() != null || reqBO.getMenuId() != null) && (functionRspBo = this.dycAuthUserDataPowerQryFunction.qryUserDataPower(functionReqBo = (DycAuthUserDataPowerQryFunctionReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycAuthUserDataPowerQryFunctionReqBo.class))).getSeflFlag().booleanValue()) {
                reqBO.setOwnUserId(reqBO.getUserId() + "");
            }
        }
        if (reqBO.getObjBusiType() != null) {
            ArrayList<String> auditDealResultQryKeys = new ArrayList<String>();
            String auditDealResultQryKey3 = reqBO.getUserId() + "_" + reqBO.getObjBusiType();
            String auditDealResultQryKey1 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 0;
            String auditDealResultQryKey2 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 1;
            if (!org.springframework.util.CollectionUtils.isEmpty(reqBO.getAuditOrderStatusQry()) && reqBO.getAuditOrderStatusQry().size() > 0) {
                String auditDealResultQryKey = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + reqBO.getAuditOrderStatusQry().get(0);
                auditDealResultQryKeys.add(auditDealResultQryKey);
            } else if (reqBO.getTabId().equals("30014") || reqBO.getTabId().equals("30114") || reqBO.getTabId().equals("30017") || reqBO.getTabId().equals("30011")) {
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            } else if (reqBO.getTabId().equals("30015") || reqBO.getTabId().equals("30115") || reqBO.getTabId().equals("30018") || reqBO.getTabId().equals("30012")) {
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
            } else {
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            }
            reqBO.setAuditDealResultQryKeys(auditDealResultQryKeys);
            if (null != reqBO.getUserId() && ObjectUtil.notEqual((Object)reqBO.getUserId(), (Object)ID) && !"0".equals(reqBO.getIsProfessionalOrgExt())) {
                if (EFFECTIVE_CODE_STOCK.equals(reqBO.getIsProfessionalOrgExt())) {
                    reqBO.setOwnUserId(null);
                } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
                    // empty if block
                }
            }
        }
        if ("30501".equals(reqBO.getTabId()) || "30506".equals(reqBO.getTabId())) {
            reqBO.setProDeliveryId(String.valueOf(reqBO.getUserId()));
        }
        if (functionRspBo == null) {
            return "{}";
        }
        return JSON.toJSONString(functionRspBo);
    }

    private Map<String, UocProOrderEvaluateInfoBo> getEvaConf() {
        UocProOrderEvaluatePageQueryReqBo dycUocProOrderEvaluatePageQueryFuncReqBO = new UocProOrderEvaluatePageQueryReqBo();
        UocProOrderEvaluatePageQueryRspBo dycUocProOrderEvaluatePageQueryFuncRspBO = this.uocProOrderEvaluatePageQueryService.queryOrderEvaluatePage(dycUocProOrderEvaluatePageQueryFuncReqBO);
        if (!"0000".equals(dycUocProOrderEvaluatePageQueryFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8bc4\u4ef7\u914d\u7f6e\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u7f16\u7801\u3010" + dycUocProOrderEvaluatePageQueryFuncRspBO.getRespCode() + "\u3011," + dycUocProOrderEvaluatePageQueryFuncRspBO.getRespDesc());
        }
        List rows = dycUocProOrderEvaluatePageQueryFuncRspBO.getRows();
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            return rows.stream().collect(Collectors.toMap(UocProOrderEvaluateInfoBo::getApplicationUnitNo, o -> o));
        }
        return new HashMap<String, UocProOrderEvaluateInfoBo>();
    }

    private void setTabConf(DycUocSalOrderListQryReqBO reqBO, JSONObject reqJsonObj) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMenuCode())) {
            DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO;
            List dycTabTacheCodeInfoFuncBOS;
            List<DycTabTacheCodeInfoFuncBO> dycTabTacheCodeInfoFuncBOList = this.qryTab(reqBO.getMenuCode());
            if (org.springframework.util.CollectionUtils.isEmpty(dycTabTacheCodeInfoFuncBOList)) {
                return;
            }
            ConcurrentMap<Integer, List<DycTabTacheCodeInfoFuncBO>> tabTachCodeMap = dycTabTacheCodeInfoFuncBOList.stream().collect(Collectors.groupingByConcurrent(DycTabTacheCodeInfoFuncBO::getTabId));
            if (StringUtils.isBlank((CharSequence)reqBO.getTabId())) {
                reqBO.setTabId(Convert.toStr((Object)dycTabTacheCodeInfoFuncBOList.get(0).getTabId()));
            }
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)(dycTabTacheCodeInfoFuncBOS = (List)tabTachCodeMap.get(Convert.toInt((Object)reqBO.getTabId())))) && StringUtils.isNotBlank((CharSequence)(dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)dycTabTacheCodeInfoFuncBOS.get(0)).getParamJson())) {
                JSONObject paramJsonObj = JSON.parseObject((String)dycTabTacheCodeInfoFuncBO.getParamJson());
                reqJsonObj.putAll((Map)paramJsonObj);
            }
            ArrayList<DycUocTabQueryCountBO> tabQueryCountBos = new ArrayList<DycUocTabQueryCountBO>();
            tabTachCodeMap.forEach((key, value) -> {
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)value)) {
                    DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)value.get(0);
                    DycUocTabQueryCountBO dycUocTabQueryCountBO = new DycUocTabQueryCountBO();
                    dycUocTabQueryCountBO.setTabId(key.longValue());
                    dycUocTabQueryCountBO.setTabName(dycTabTacheCodeInfoFuncBO.getTabName());
                    dycUocTabQueryCountBO.setTabCodes(dycTabTacheCodeInfoFuncBO.getTacheCodes());
                    dycUocTabQueryCountBO.setTabStatus(dycTabTacheCodeInfoFuncBO.getTabStatusList());
                    dycUocTabQueryCountBO.setTabSubCodes(dycTabTacheCodeInfoFuncBO.getSubTacheCodes());
                    dycUocTabQueryCountBO.setTabDoneSubCodes(dycTabTacheCodeInfoFuncBO.getDoneTacheCodeList());
                    dycUocTabQueryCountBO.setParamJson(dycTabTacheCodeInfoFuncBO.getParamJson());
                    dycUocTabQueryCountBO.setSort(dycTabTacheCodeInfoFuncBO.getSort());
                    tabQueryCountBos.add(dycUocTabQueryCountBO);
                }
            });
            reqBO.setTabQueryCountBos(tabQueryCountBos);
        }
    }

    private void setButton(List<DycUocSaleOrderInfoBO> rows, DycUocSalOrderListQryReqBO reqBO) {
        if (org.springframework.util.CollectionUtils.isEmpty(rows)) {
            return;
        }
        HashSet tacheCodes = new HashSet();
        HashSet orderIdList = new HashSet();
        ArrayList objIdList = new ArrayList();
        HashSet saleOrderStateList = new HashSet();
        HashSet subTacheCodes = new HashSet();
        rows.forEach(dycUocSaleOrderInfoBO -> {
            if (!org.springframework.util.CollectionUtils.isEmpty(dycUocSaleOrderInfoBO.getWholeAuditOrderBoList())) {
                dycUocSaleOrderInfoBO.setAuditOrderBoList(dycUocSaleOrderInfoBO.getWholeAuditOrderBoList());
            }
            for (DycUocTaskInstInfoBO busiTaskInstBo : dycUocSaleOrderInfoBO.getBusiTaskInstBos()) {
                tacheCodes.add(busiTaskInstBo.getTacheCode());
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(dycUocSaleOrderInfoBO.getShipOrderIdList())) {
                objIdList.addAll(dycUocSaleOrderInfoBO.getShipOrderIdList().stream().map(Convert::toLong).collect(Collectors.toList()));
            }
            objIdList.add(dycUocSaleOrderInfoBO.getSaleOrderId());
            orderIdList.add(dycUocSaleOrderInfoBO.getOrderId());
            if (StringUtils.isNotBlank((CharSequence)dycUocSaleOrderInfoBO.getSaleOrderState())) {
                saleOrderStateList.add(dycUocSaleOrderInfoBO.getSaleOrderState());
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(dycUocSaleOrderInfoBO.getShipOrderTacheCode())) {
                subTacheCodes.addAll(dycUocSaleOrderInfoBO.getShipOrderTacheCode());
            }
        });
        UocTacheButtonQryReqBo uocTacheButtonQryFuncReqBo = new UocTacheButtonQryReqBo();
        uocTacheButtonQryFuncReqBo.setTabId(reqBO.getTabId());
        uocTacheButtonQryFuncReqBo.setOrderStatusList(new ArrayList(saleOrderStateList));
        uocTacheButtonQryFuncReqBo.setTacheCodes(new ArrayList(tacheCodes));
        uocTacheButtonQryFuncReqBo.setSubOrderStatusCodes(new ArrayList(subTacheCodes));
        uocTacheButtonQryFuncReqBo.setObjIdList(objIdList);
        uocTacheButtonQryFuncReqBo.setOrderIdList(new ArrayList(orderIdList));
        uocTacheButtonQryFuncReqBo.setReflected(reqBO.getReflected());
        UocTacheButtonQryRspBo uocTacheButtonQryFuncRspBo = this.uocTacheButtonQryService.qryTacheButton(uocTacheButtonQryFuncReqBo);
        List uocTacheButtonInfoFuncBOS = uocTacheButtonQryFuncRspBo.getUocTacheButtonS();
        if (!CollectionUtil.isEmpty((Collection)uocTacheButtonInfoFuncBOS)) {
            HashMap buttonParamMap = new HashMap();
            ArrayList<String> buttonParamList = new ArrayList<String>(this.buttonFormParams);
            buttonParamList.forEach(buttonFormParam -> {
                if (buttonFormParam.contains(":")) {
                    String[] paramRel = buttonFormParam.split("\\:");
                    buttonParamMap.put(paramRel[0], paramRel[1]);
                } else {
                    buttonParamMap.put(buttonFormParam, buttonFormParam);
                }
            });
            this.buttonFormParams = new ArrayList(buttonParamMap.keySet());
            Map<String, List<UocTacheButtonInfoBO>> tacheCodeMap = uocTacheButtonInfoFuncBOS.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getTacheCode())).collect(Collectors.groupingBy(UocTacheButtonInfoBO::getTacheCode));
            Map<String, List<UocTacheButtonInfoBO>> subTacheCodeMap = uocTacheButtonInfoFuncBOS.stream().filter(uocTacheButton -> StringUtils.isNotBlank((CharSequence)uocTacheButton.getSubOrderStatusCode())).collect(Collectors.groupingBy(UocTacheButtonInfoBO::getSubOrderStatusCode));
            Map<String, List<UocTacheButtonInfoBO>> statusMap = uocTacheButtonInfoFuncBOS.stream().filter(uocTacheButton -> StringUtils.isNotBlank((CharSequence)uocTacheButton.getOrderStatus())).collect(Collectors.groupingBy(UocTacheButtonInfoBO::getOrderStatus));
            ArrayList defaultButtonList = tacheCodeMap.get(DEFAULT);
            List defaultButtonBos = (org.springframework.util.CollectionUtils.isEmpty(defaultButtonList) ? new ArrayList() : defaultButtonList).stream().map(uocButtonFuncBo -> {
                DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                dycUocButtonBo.setId(uocButtonFuncBo.getId());
                dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                return dycUocButtonBo;
            }).collect(Collectors.toList());
            Map<String, UocProOrderEvaluateInfoBo> evaConf = this.getEvaConf();
            Map<String, Map<String, Long>> effConfMap = this.getConf();
            Map<String, List<String>> buttonConf = this.getButtonConf();
            rows.forEach(dycUocSaleOrderInfoBO -> {
                Object tacheButtonInfoFuncBOS;
                ArrayList dycUocButtonBos = new ArrayList(defaultButtonBos);
                if (!CollectionUtil.isEmpty(dycUocSaleOrderInfoBO.getShipOrderTacheCode())) {
                    dycUocSaleOrderInfoBO.getShipOrderTacheCode().stream().distinct().forEach(shipOrderTacheCode -> {
                        List shipTacheButtonList = (List)subTacheCodeMap.get(shipOrderTacheCode);
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)shipTacheButtonList)) {
                            dycUocButtonBos.addAll(shipTacheButtonList.stream().map(uocButtonFuncBo -> {
                                DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                                dycUocButtonBo.setId(uocButtonFuncBo.getId());
                                dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                                dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                                dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                                return dycUocButtonBo;
                            }).collect(Collectors.toList()));
                        }
                    });
                }
                if (StringUtils.isNotBlank((CharSequence)dycUocSaleOrderInfoBO.getSaleOrderState()) && !CollectionUtil.isEmpty((Collection)(tacheButtonInfoFuncBOS = (List)statusMap.get(dycUocSaleOrderInfoBO.getSaleOrderState())))) {
                    dycUocButtonBos.addAll(tacheButtonInfoFuncBOS.stream().map(uocButtonFuncBo -> {
                        DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                        dycUocButtonBo.setId(uocButtonFuncBo.getId());
                        dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                        dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                        dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                        return dycUocButtonBo;
                    }).collect(Collectors.toList()));
                }
                if (!CollectionUtil.isEmpty(dycUocSaleOrderInfoBO.getBusiTaskInstBos())) {
                    for (DycUocTaskInstInfoBO busiTaskInstBo : dycUocSaleOrderInfoBO.getBusiTaskInstBos()) {
                        ArrayList uocButtonFuncBos = (ArrayList)tacheCodeMap.get(busiTaskInstBo.getTacheCode());
                        if (ObjectUtil.equal((Object)dycUocSaleOrderInfoBO.getOrderSource(), (Object)UocDicConstant.ORDER_SOURCE.AGR_GENERATE.toString()) && ObjectUtil.isNotEmpty(dycUocSaleOrderInfoBO.getShipOrderTacheCode())) {
                            uocButtonFuncBos = new ArrayList();
                        }
                        if (CollectionUtil.isEmpty((Collection)uocButtonFuncBos)) continue;
                        dycUocButtonBos.addAll(uocButtonFuncBos.stream().map(uocButtonFuncBo -> {
                            DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                            dycUocButtonBo.setId(uocButtonFuncBo.getId());
                            dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                            dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                            dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                            return dycUocButtonBo;
                        }).collect(Collectors.toList()));
                    }
                }
                List<DycUocButtonBo> buttonBos = dycUocButtonBos.stream().distinct().sorted(Comparator.comparing(DycUocButtonBo::getId).reversed()).collect(Collectors.toList());
                log.info("\u53bb\u91cd\u524d\uff1a{}", (Object)JSON.toJSONString(buttonBos));
                buttonBos = buttonBos.stream().collect(Collectors.toMap(DycUocButtonBo::getMenuCode, Function.identity(), (k1, k2) -> k2)).values().stream().collect(Collectors.toList());
                log.info("\u53bb\u91cd\u540e\uff1a{}", (Object)JSON.toJSONString(buttonBos));
                dycUocSaleOrderInfoBO.setButtons(buttonBos);
                if (!org.springframework.util.CollectionUtils.isEmpty(dycUocSaleOrderInfoBO.getButtons())) {
                    Iterator<DycUocButtonBo> iterator = dycUocSaleOrderInfoBO.getButtons().iterator();
                    while (iterator.hasNext()) {
                        DycUocButtonBo dycUocButtonBo = iterator.next();
                        log.info("dycUocButtonBo{}", (Object)JSON.toJSONString((Object)dycUocButtonBo));
                        if (null == dycUocButtonBo) continue;
                        dycUocButtonBo.setUri(ParseUrlParamUtil.calUri((String)dycUocButtonBo.getUri(), null, null, null));
                        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)buttonConf.get(dycUocButtonBo.getMenuCode()))) && "2".equals(dycUocSaleOrderInfoBO.getOrderSource()) && !((List)buttonConf.get(dycUocButtonBo.getMenuCode())).contains(dycUocSaleOrderInfoBO.getSupId())) {
                            iterator.remove();
                        }
                        if ("100055".equals(dycUocSaleOrderInfoBO.getSupId()) && "JS".equalsIgnoreCase(dycUocButtonBo.getMenuCode())) {
                            iterator.remove();
                        }
                        if ("XS_QX_QXSQ".equals(dycUocSaleOrderInfoBO.getSaleOrderState()) && "QXDD".equals(dycUocButtonBo.getMenuCode())) {
                            iterator.remove();
                        }
                        if ("\u62d2\u5355\u5f85\u5904\u7406".equals(dycUocSaleOrderInfoBO.getSaleOrderStateStr()) && "ZCGM".equals(dycUocButtonBo.getMenuCode())) {
                            iterator.remove();
                        }
                        if ("\u53d6\u6d88\u7533\u8bf7\u4e2d".equals(dycUocSaleOrderInfoBO.getSaleOrderStateStr()) && "ZCGM".equals(dycUocButtonBo.getMenuCode())) {
                            iterator.remove();
                        }
                        if (EFFECTIVE_CODE_STOCK.equals(reqBO.getIsProfessionalOrgExt()) && dycUocSaleOrderInfoBO.getTradeMode() == Integer.valueOf(1) && "\u62d2\u5355\u5f85\u5904\u7406".equals(dycUocSaleOrderInfoBO.getSaleOrderStateStr()) && !"2".equals(dycUocSaleOrderInfoBO.getOrderSource()) && "HFDD".equals(dycUocButtonBo.getMenuCode())) {
                            iterator.remove();
                        }
                        if ("true".equals(dycUocSaleOrderInfoBO.getCloseDeffFlag()) && "20028".equals(reqBO.getTabId()) && "FH".equals(dycUocButtonBo.getMenuCode())) {
                            iterator.remove();
                        }
                        if (!"PJ".equals(dycUocButtonBo.getMenuCode()) || 0 == dycUocSaleOrderInfoBO.getEvaluateState()) continue;
                        iterator.remove();
                    }
                }
                if (!org.springframework.util.CollectionUtils.isEmpty((Map)effConfMap) && StringUtils.isNotBlank((CharSequence)dycUocSaleOrderInfoBO.getSupId()) && StringUtils.isNotBlank((CharSequence)dycUocSaleOrderInfoBO.getOrderSource())) {
                    Object changEffMap;
                    Map inspEffMap;
                    Map payEffMap;
                    Map stockEffMap = (Map)effConfMap.get(EFFECTIVE_CODE_STOCK + dycUocSaleOrderInfoBO.getOrderSource());
                    if (null != stockEffMap) {
                        Long time = (Long)stockEffMap.get(dycUocSaleOrderInfoBO.getSupId());
                        if (null == time) {
                            time = (Long)stockEffMap.get("0");
                        }
                        dycUocSaleOrderInfoBO.setStockAging(time);
                    }
                    if (null != (payEffMap = (Map)effConfMap.get("2" + dycUocSaleOrderInfoBO.getOrderSource()))) {
                        Long time = (Long)payEffMap.get(dycUocSaleOrderInfoBO.getSupId());
                        if (null == time) {
                            time = (Long)payEffMap.get("0");
                        }
                        dycUocSaleOrderInfoBO.setPayAging(time);
                    }
                    if (null != (inspEffMap = (Map)effConfMap.get(EFFECTIVE_CODE_INSP + dycUocSaleOrderInfoBO.getOrderSource()))) {
                        Long time = (Long)inspEffMap.get(dycUocSaleOrderInfoBO.getSupId());
                        if (null == time) {
                            time = (Long)inspEffMap.get("0");
                        }
                        dycUocSaleOrderInfoBO.setInspAging(time);
                    }
                    if (null != (changEffMap = (Map)effConfMap.get("5" + dycUocSaleOrderInfoBO.getOrderSource()))) {
                        Long time = (Long)changEffMap.get(dycUocSaleOrderInfoBO.getSupId());
                        if (null == time) {
                            time = (Long)changEffMap.get("0");
                        }
                        dycUocSaleOrderInfoBO.setAllowChngAging(time);
                    }
                }
                UocProOrderEvaluateInfoBo conf = this.getConf(evaConf, dycUocSaleOrderInfoBO.getPurchaseOrgId());
                Long evaluationDeadline = conf.getEvaluationDeadline();
                if (!org.springframework.util.CollectionUtils.isEmpty(dycUocSaleOrderInfoBO.getInspTimeList())) {
                    Date lastInspTime = (Date)dycUocSaleOrderInfoBO.getInspTimeList().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()).get(0);
                    if (System.currentTimeMillis() > lastInspTime.getTime() + evaluationDeadline && !SYSTEM_AUTOMATIC_PRAISE.equals(conf.getSystemAutomaticPraise())) {
                        dycUocSaleOrderInfoBO.setIsAllowEva(NOT_ALLOW_EVA);
                    } else {
                        dycUocSaleOrderInfoBO.setIsAllowEva(ALLOW_EVA);
                    }
                } else {
                    dycUocSaleOrderInfoBO.setIsAllowEva(ALLOW_EVA);
                }
                if (!CollectionUtil.isEmpty(dycUocSaleOrderInfoBO.getAuditTaskInstBos())) {
                    boolean auditButtonFlag = false;
                    for (DycUocTaskInstInfoBO auditTaskInstBo : dycUocSaleOrderInfoBO.getAuditTaskInstBos()) {
                        if (!reqBO.getUserId().toString().equals(auditTaskInstBo.getDealId()) || auditTaskInstBo.getFinishTag() != 0) continue;
                        auditButtonFlag = true;
                    }
                    if (!org.springframework.util.CollectionUtils.isEmpty(dycUocSaleOrderInfoBO.getButtons())) {
                        Iterator<DycUocButtonBo> iterator = dycUocSaleOrderInfoBO.getButtons().iterator();
                        while (iterator.hasNext()) {
                            DycUocButtonBo dycUocButtonBo = iterator.next();
                            if (auditButtonFlag || !"TG".equals(dycUocButtonBo.getMenuCode())) continue;
                            iterator.remove();
                        }
                    }
                }
            });
        }
    }

    private UocProOrderEvaluateInfoBo getConf(Map<String, UocProOrderEvaluateInfoBo> evaConf, String purId) {
        if (null == evaConf.get(purId)) {
            return evaConf.get("0");
        }
        return evaConf.get(purId);
    }

    private void setTabCount(DycUocSalOrderListQryReqBO reqBO, DycUocSalOrderListQryRspBO rspBO, Map<Long, Map<String, Object>> tabsCountMap) {
        if (ObjectUtil.isNotNull((Object)((Object)rspBO)) && ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            ArrayList<DycUocTabCountsBO> saleTabCountList = new ArrayList<DycUocTabCountsBO>();
            List<DycUocTabQueryCountBO> dycUocTabQueryCountBOList = reqBO.getTabQueryCountBos();
            if (StringUtils.isNotBlank((CharSequence)reqBO.getMenuCode())) {
                dycUocTabQueryCountBOList = dycUocTabQueryCountBOList.stream().sorted(Comparator.comparing(DycUocTabQueryCountBO::getSort)).collect(Collectors.toList());
            }
            dycUocTabQueryCountBOList.forEach(each -> {
                DycUocTabCountsBO tabCountsBO = new DycUocTabCountsBO();
                tabCountsBO.setTabId(each.getTabId());
                if (ObjectUtil.isNotEmpty((Object)tabsCountMap) && tabsCountMap.containsKey(each.getTabId())) {
                    tabCountsBO.setTabCount((Integer)((Map)tabsCountMap.get(each.getTabId())).get(TAB_COUNT));
                    tabCountsBO.setTabName(((Map)tabsCountMap.get(each.getTabId())).get(TAB_NAME).toString());
                    tabCountsBO.setTabNameCount(tabCountsBO.getTabName() + "(" + tabCountsBO.getTabCount() + ")");
                    if (ObjectUtil.equal((Object)30401, (Object)each.getTabId().intValue())) {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName());
                    } else {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName() + "(" + tabCountsBO.getTabCount() + ")");
                    }
                }
                saleTabCountList.add(tabCountsBO);
            });
            rspBO.setSaleTabCountList(saleTabCountList);
        }
    }

    private Map<Long, Map<String, Object>> getTabsCount(DycUocSalOrderListQryReqBO reqBO, JSONObject reqJsonObj) {
        BaseUmcReqBo baseUmcReqBo = (BaseUmcReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), BaseUmcReqBo.class);
        HashMap<Long, Map<String, Object>> tabCountMap = new HashMap<Long, Map<String, Object>>();
        if (ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            for (DycUocTabQueryCountBO tabQueryCountBo : reqBO.getTabQueryCountBos()) {
                JSONObject baseReqJsonObj;
                Date now = new Date();
                DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
                dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
                if (tabQueryCountBo.getTabId().toString().equals(reqBO.getTabId())) {
                    baseReqJsonObj = reqJsonObj;
                } else {
                    DycUocSalOrderListQryReqBO dycUocSalOrderListQryReqBO = (DycUocSalOrderListQryReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)baseUmcReqBo), DycUocSalOrderListQryReqBO.class));
                    if (StringUtils.isNotBlank((CharSequence)reqBO.getProDeliveryId())) {
                        reqBO.setProDeliveryId(null);
                    }
                    BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)dycUocSalOrderListQryReqBO));
                    if (ObjectUtil.isNotEmpty((Object)tabQueryCountBo.getTabId())) {
                        dycUocSalOrderListQryReqBO.setTabId(String.valueOf(tabQueryCountBo.getTabId()));
                    }
                    String dataAuth = this.setAuthUser(dycUocSalOrderListQryReqBO);
                    JSONObject dataJsonObj = JSON.parseObject((String)dataAuth);
                    dataJsonObj.remove((Object)"code");
                    if (tabQueryCountBo.getTabId() != null && tabQueryCountBo.getTabId().toString().equals("30501")) {
                        dycUocSalOrderListQryReqBO.setPurUserId(null);
                    }
                    baseReqJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)dycUocSalOrderListQryReqBO)));
                    baseReqJsonObj.putAll((Map)dataJsonObj);
                }
                if (StringUtils.isNotBlank((CharSequence)tabQueryCountBo.getParamJson())) {
                    JSONObject tabQryCountJsonObj = JSON.parseObject((String)tabQueryCountBo.getParamJson());
                    baseReqJsonObj.putAll((Map)tabQryCountJsonObj);
                }
                log.info("\u67e5\u8be2\u6570\u91cf\u5165\u53c2:{}", (Object)baseReqJsonObj.toJSONString());
                dycGeneralQueryFuncReqBO.setReqParams(baseReqJsonObj.toJSONString());
                String rspJsonStr = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO).getRspJsonStr();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (ObjectUtil.isNotEmpty((Object)rspJsonStr)) {
                    JSONObject jsonObject = JSON.parseObject((String)rspJsonStr);
                    map.put(TAB_COUNT, ObjectUtil.isNotNull((Object)jsonObject.get((Object)"recordsTotal")) ? jsonObject.get((Object)"recordsTotal") : Integer.valueOf(0));
                }
                map.put(TAB_NAME, null != tabQueryCountBo.getTabName() ? tabQueryCountBo.getTabName() : "");
                tabCountMap.put(tabQueryCountBo.getTabId(), map);
                Date now2 = new Date();
                log.info("\u5faa\u73af\u67e5\u8be2\u6570\u91cf\u65f6\u95f4\u5f00\u59cb:{} \u7ed3\u675f:{} \u8017\u65f6:{}ms", new Object[]{DateUtils.dateToStr((Date)now, (String)"yyyy-MM-dd HH:mm:ss SSS"), DateUtils.dateToStr((Date)now2, (String)"yyyy-MM-dd HH:mm:ss SSS"), now2.getTime() - now.getTime()});
            }
        }
        return tabCountMap;
    }

    private List<DycTabTacheCodeInfoFuncBO> qryTab(String menuCode) {
        DycTabTacheCodeQryFuncReqBO dycTabTacheCodeQryFuncReqBO = new DycTabTacheCodeQryFuncReqBO();
        dycTabTacheCodeQryFuncReqBO.setMenuCode(menuCode);
        DycTabTacheCodeQryFuncRspBO dycTabTacheCodeQryFuncRspBO = this.dycTabTacheCodeQryFunction.qryTabTacheCode(dycTabTacheCodeQryFuncReqBO);
        return dycTabTacheCodeQryFuncRspBO.getRows();
    }

    private Map<String, Map<String, Long>> getConf() {
        UocProOrderEffectiveListPageQueryReqBo pageQueryReqBo = new UocProOrderEffectiveListPageQueryReqBo();
        pageQueryReqBo.setPageNo(-1);
        pageQueryReqBo.setPageSize(-1);
        UocProOrderEffectiveListPageQueryRspBo uocProOrderEffectiveListPageQueryRspBo = this.uocProOrderEffectivePageQueryService.queryOrderEffectiveListPage(pageQueryReqBo);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)uocProOrderEffectiveListPageQueryRspBo.getRows())) {
            return new HashMap<String, Map<String, Long>>();
        }
        Map<String, List<UocProOrderEffectiveInfoBo>> effListMap = uocProOrderEffectiveListPageQueryRspBo.getRows().stream().collect(Collectors.groupingBy(e -> e.getEffectiveCode() + e.getBusinessTypeCode()));
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
        effListMap.forEach((key, value) -> map.put((String)key, value.stream().collect(Collectors.toMap(UocProOrderEffectiveInfoBo::getSupplierNo, UocProOrderEffectiveInfoBo::getAging))));
        return map;
    }

    private Map<String, List<String>> getButtonConf() {
        UocProQueryOrderButtonSettingsReqBo dycUocProEditOrderButtonSettingsFuncReqBo = new UocProQueryOrderButtonSettingsReqBo();
        UocProQueryOrderButtonSettingsRspBo dycUocProQueryOrderButtonSettingsFuncRspBo = this.uocProOrderButtonSettingsService.queryOrderButtonSettings(dycUocProEditOrderButtonSettingsFuncReqBo);
        log.info("\u67e5\u8be2\u6309\u94ae\u914d\u7f6e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dycUocProQueryOrderButtonSettingsFuncRspBo));
        List rows = dycUocProQueryOrderButtonSettingsFuncRspBo.getRows();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)rows)) {
            return new HashMap<String, List<String>>(0);
        }
        HashMap<String, List<String>> buttonMap = new HashMap<String, List<String>>();
        for (UocProConfButtonBO row : rows) {
            buttonMap.put(row.getButtonCode(), Arrays.asList(row.getSupNo().split(",")));
        }
        return buttonMap;
    }
}

