/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.busicommon.order.api.DycUocHaveDoneFunction;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocHaveDoneFuncReqBO;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocHaveDoneFuncRspBO;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.oc.service.domainservice.UocChngOrderConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseSaleTaskInstBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseShipTaskInstBo;
import com.tydic.dyc.selfrun.order.api.DycUocExceptionChangeConfimService;
import com.tydic.dyc.selfrun.order.bo.DycUocChngOrderListBO;
import com.tydic.dyc.selfrun.order.bo.DycUocExceptionChangeConfimReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocExceptionChangeConfimRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocExceptionChangeConfimService"})
public class DycUocExceptionChangeConfimServiceImpl
implements DycUocExceptionChangeConfimService {
    private static final Logger log = LoggerFactory.getLogger(DycUocExceptionChangeConfimServiceImpl.class);
    @Autowired
    private UocChngOrderConfirmOrRefuseService uocChngOrderConfirmOrRefuseService;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private DycUocHaveDoneFunction dycUocHaveDoneFunction;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpointUrl;

    @Override
    @PostMapping(value={"dealExceptionChangeConfim"})
    public DycUocExceptionChangeConfimRspBO dealExceptionChangeConfim(@RequestBody DycUocExceptionChangeConfimReqBO reqBO) {
        UocChngOrderConfirmOrRefuseReqBo funcReqBO = (UocChngOrderConfirmOrRefuseReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UocChngOrderConfirmOrRefuseReqBo.class);
        UocChngOrderConfirmOrRefuseRspBo refuseRspBo = this.uocChngOrderConfirmOrRefuseService.dealConfirmOrRefuse(funcReqBO);
        List shipTaskInstList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)refuseRspBo.getShipTaskInstList()), UocChngOrderConfirmOrRefuseShipTaskInstBo.class);
        List saleOrderTaskInstList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)refuseRspBo.getSaleOrderTaskInstList()), UocChngOrderConfirmOrRefuseSaleTaskInstBo.class);
        reqBO.getChngOrderList().forEach(dycUocChngOrderListBO -> {
            DycBusiProcessFlowFuncReqBO flowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("userId", reqBO.getUserId());
            variables.put("userName", reqBO.getUsername());
            variables.put("opFlag", reqBO.getOpFlag());
            variables.put("saleOrderNo", dycUocChngOrderListBO.getSaleOrderNo());
            flowFuncReqBO.setVariables(variables);
            flowFuncReqBO.setTaskId(dycUocChngOrderListBO.getTaskId());
            this.dycBusiProcessFlowFunction.flowBusiProcess(flowFuncReqBO);
        });
        if (CollectionUtil.isNotEmpty((Collection)shipTaskInstList)) {
            shipTaskInstList.forEach(shipTaskInst -> {
                DycBusiProcessFlowFuncReqBO flowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("userId", reqBO.getUserId());
                variables.put("userName", reqBO.getUsername());
                flowFuncReqBO.setVariables(variables);
                flowFuncReqBO.setTaskId(shipTaskInst.getTaskId());
                this.dycBusiProcessFlowFunction.flowBusiProcess(flowFuncReqBO);
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)saleOrderTaskInstList)) {
            saleOrderTaskInstList.forEach(saleOrderTaskInstBo -> {
                DycBusiProcessFlowFuncReqBO flowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("exceptionChangeFlag", "1");
                variables.put("userId", reqBO.getUserId());
                variables.put("userName", reqBO.getUsername());
                flowFuncReqBO.setVariables(variables);
                flowFuncReqBO.setTaskId(saleOrderTaskInstBo.getTaskId());
                this.dycBusiProcessFlowFunction.flowBusiProcess(flowFuncReqBO);
            });
        }
        this.pushTodo(reqBO);
        this.buryPoint(refuseRspBo.getShipOrderIdList(), refuseRspBo.getSaleOrderIdList(), refuseRspBo.getInspOrderIdList());
        return new DycUocExceptionChangeConfimRspBO();
    }

    private void pushTodo(DycUocExceptionChangeConfimReqBO reqBO) {
        for (DycUocChngOrderListBO dycUocChngOrderListBO : reqBO.getChngOrderList()) {
            DycUocHaveDoneFuncReqBO dycUocHaveDoneFuncReqBO = new DycUocHaveDoneFuncReqBO();
            dycUocHaveDoneFuncReqBO.setOrderId(dycUocChngOrderListBO.getOrderId());
            dycUocHaveDoneFuncReqBO.setTaskId(dycUocChngOrderListBO.getTaskId());
            dycUocHaveDoneFuncReqBO.setUserId(reqBO.getUserId());
            dycUocHaveDoneFuncReqBO.setUserName(reqBO.getName());
            DycUocHaveDoneFuncRspBO dycUocHaveDoneFuncRspBO = this.dycUocHaveDoneFunction.dealUocHaveDone(dycUocHaveDoneFuncReqBO);
            if ("0000".equals(dycUocHaveDoneFuncRspBO.getRespCode())) continue;
        }
    }

    private void buryPoint(List<String> contextBO, List<String> contextBO1, List<String> contextBO2) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (String string : contextBO) {
            String[] split = string.split("-");
            jsonObject.put("shipOrderId", (Object)split[0]);
            jsonObject.put("orderId", (Object)split[1]);
            list.add(jsonObject);
        }
        ArrayList<Object> buildsList = new ArrayList<Object>();
        for (JSONObject j : list) {
            DycBuriedPointCallFuncBo bo = new DycBuriedPointCallFuncBo();
            bo.setIdent("UPDATA");
            bo.setDycBusiCode("sendOrderSync");
            bo.setDycCenterCode("UOC");
            bo.setData((Object)j);
            buildsList.add(bo);
        }
        JSONObject jSONObject = new JSONObject();
        ArrayList<JSONObject> list1 = new ArrayList<JSONObject>();
        for (String s : contextBO1) {
            String[] split = s.split("-");
            jSONObject.put("saleOrderId", (Object)split[0]);
            jSONObject.put("orderId", (Object)split[1]);
            list1.add(jSONObject);
        }
        for (JSONObject j : list1) {
            DycBuriedPointCallFuncBo bo1 = new DycBuriedPointCallFuncBo();
            bo1.setIdent("UPDATA");
            bo1.setDycBusiCode("saleOrderSync");
            bo1.setDycCenterCode("UOC");
            bo1.setData((Object)j);
            buildsList.add(bo1);
        }
        JSONObject jsonObject2 = new JSONObject();
        ArrayList<JSONObject> list2 = new ArrayList<JSONObject>();
        for (String s : contextBO2) {
            String[] split = s.split("-");
            jsonObject2.put("inspOrderId", (Object)split[0]);
            jsonObject2.put("orderId", (Object)split[1]);
            list2.add(jsonObject2);
        }
        for (JSONObject j : list2) {
            DycBuriedPointCallFuncBo bo2 = new DycBuriedPointCallFuncBo();
            bo2.setIdent("UPDATA");
            bo2.setDycBusiCode("acceptanceOrderSync");
            bo2.setDycCenterCode("UOC");
            bo2.setData((Object)j);
            buildsList.add(bo2);
        }
        funcReqBo.setBusiList(buildsList);
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u5f02\u5e38\u53d8\u66f4\u786e\u8ba4,\u53d8\u66f4\u53d1\u8d27\u5355,\u9500\u552e\u5355,\u9a8c\u6536\u5355\u540e\u8fdb\u884c\u57cb\u70b9\uff08\u53d8\u66f4\uff09\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }
}

