/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycUocGemiSendMessageAtomFunction;
import com.tydic.dyc.atom.common.api.DycBusiProcessDeleteFunction;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessDeleteFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.estore.api.DycUocEstoreCancelSaleOrderFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreCancelSaleOrderFuncReqBO;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderAndStopProcessService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceReqBO;
import com.tydic.dyc.oc.service.order.UocProOrderEffectivePageQueryService;
import com.tydic.dyc.oc.service.order.UocQryOrderTaskInstanceListService;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOrderTaskInstanceListServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOrderTaskInstanceListServiceRspBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOrderTaskInstanceListServiceRspDataBo;
import com.tydic.dyc.selfrun.order.api.DycUocPaymentCancelOrderService;
import com.tydic.dyc.selfrun.order.bo.DycUocPaymentCancelReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocPaymentCancelRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocReceiverBo;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderInfoBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocPaymentCancelOrderService"})
public class DycUocPaymentCancelOrderServiceImpl
implements DycUocPaymentCancelOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocPaymentCancelOrderServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private UocProOrderEffectivePageQueryService uocProOrderEffectivePageQueryService;
    @Autowired
    private UocQryOrderTaskInstanceListService uocQryOrderTaskInstanceListService;
    @Autowired
    private UocCancelSaleOrderAndStopProcessService uocCancelSaleOrderAndStopProcessService;
    @Autowired
    private DycBusiProcessDeleteFunction dycBusiProcessDeleteFunction;
    @Autowired
    private DycUocEstoreCancelSaleOrderFunction dycUocEstoreCancelSaleOrderFunction;
    @Autowired
    private DycUocGemiSendMessageAtomFunction dycUocGemiSendMessageAtomFunction;
    @Autowired
    private AuthGetUserByRoleAndOrgService authGetUserByRoleAndOrgService;
    private static final String CANCEL_DEC = "\u8ba2\u5355\u4ed8\u6b3e\u65f6\u9650\u8d85\u65f6\uff0c\u81ea\u52a8\u53d6\u6d88";

    @Override
    @PostMapping(value={"paymentCancelOrderNoauth"})
    public DycUocPaymentCancelRspBO paymentCancelOrderNoauth(@RequestBody DycUocPaymentCancelReqBO reqBO) {
        List<DycUocSaleOrderInfoBO> dycUocSaleOrderInfoBOS = this.qrySaleOrderList(this.qryConfEffective());
        this.cancelOrderList(dycUocSaleOrderInfoBOS, reqBO);
        return new DycUocPaymentCancelRspBO();
    }

    private void cancelOrderList(List<DycUocSaleOrderInfoBO> dycUocSaleOrderInfoBOS, DycUocPaymentCancelReqBO reqBO) {
        HashMap failMap = new HashMap();
        dycUocSaleOrderInfoBOS.forEach(obj -> {
            try {
                UocCancelSaleOrderAndStopProcessServiceReqBO cancelSaleReqBO = new UocCancelSaleOrderAndStopProcessServiceReqBO();
                cancelSaleReqBO.setOrderId(obj.getOrderId());
                cancelSaleReqBO.setCancelReason(CANCEL_DEC);
                cancelSaleReqBO.setSaleOrderId(obj.getSaleOrderId());
                cancelSaleReqBO.setUserId(Long.valueOf(1L));
                cancelSaleReqBO.setName("\u7cfb\u7edf\u81ea\u52a8");
                cancelSaleReqBO.setTraceId(reqBO.getTraceId());
                this.uocCancelSaleOrderAndStopProcessService.cancelSaleOrderAndStopProcess(cancelSaleReqBO);
                if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(obj.getOrderSource())) {
                    DycUocEstoreCancelSaleOrderFuncReqBO funcReqBO = new DycUocEstoreCancelSaleOrderFuncReqBO();
                    funcReqBO.setOutOrderId(obj.getOutOrderId());
                    funcReqBO.setSupplierNo(obj.getSupId());
                    this.dycUocEstoreCancelSaleOrderFunction.cancelSaleOrder(funcReqBO);
                }
                DycBusiProcessDeleteFuncReqBO processDeleteFuncReqBO = new DycBusiProcessDeleteFuncReqBO();
                processDeleteFuncReqBO.setProcInstId(obj.getBusiProcId());
                this.dycBusiProcessDeleteFunction.deleteBusiProcess(processDeleteFuncReqBO);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("taskCode", "uoc_payment_overtime_cancel");
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("saleOrderNo", obj.getSaleOrderNo());
                map.put("data", dataMap);
                map.put("sendId", 1L);
                map.put("sendName", "admin");
                ArrayList<DycUocReceiverBo> receiverIdList = new ArrayList<DycUocReceiverBo>();
                DycUocReceiverBo bo = new DycUocReceiverBo();
                bo.setReceiverId(obj.getCreateOperId());
                bo.setReceiverName(obj.getCreateOperName());
                receiverIdList.add(bo);
                AuthGetUserByRoleAndOrgReqBo roleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
                roleAndOrgReqBo.setOrgIdWeb(Long.valueOf(Long.parseLong(obj.getPurchaseOrgId())));
                roleAndOrgReqBo.setRoleCodes(Arrays.asList("tenant:10000:caigoudanweijiesuanyuan"));
                AuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.authGetUserByRoleAndOrgService.getUserByRoleAndOrg(roleAndOrgReqBo);
                userByRoleAndOrg.getRows().forEach(x -> {
                    DycUocReceiverBo bo1 = new DycUocReceiverBo();
                    bo1.setReceiverId(x.getUserId() + "");
                    bo1.setReceiverName(x.getCustName());
                    receiverIdList.add(bo1);
                });
                map.put("receiverIdList", JSON.toJSONString(receiverIdList.stream().distinct().collect(Collectors.toList())));
                this.dycUocGemiSendMessageAtomFunction.sendMessage(map);
            }
            catch (ZTBusinessException e) {
                failMap.put(obj.getOrderId(), e.getMessage());
            }
        });
    }

    private List<UocProOrderEffectiveInfoBo> qryConfEffective() {
        UocProOrderEffectiveListPageQueryReqBo pageQueryReqBo = new UocProOrderEffectiveListPageQueryReqBo();
        pageQueryReqBo.setEffectiveCode("2");
        UocProOrderEffectiveListPageQueryRspBo queryRspBo = this.uocProOrderEffectivePageQueryService.queryOrderEffectiveListPage(pageQueryReqBo);
        if (!"0000".equals(queryRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)queryRspBo.getRows())) {
            throw new ZTBusinessException(queryRspBo.getRespDesc());
        }
        return queryRspBo.getRows();
    }

    private List<DycUocSaleOrderInfoBO> qrySaleOrderList(List<UocProOrderEffectiveInfoBo> effectiveInfoBos) {
        Map<String, Long> effectiveMap = effectiveInfoBos.stream().collect(Collectors.toMap(UocProOrderEffectiveInfoBo::getBusinessTypeCode, UocProOrderEffectiveInfoBo::getAging));
        DycUocSalOrderListQryReqBO salOrderListQryReqBO = new DycUocSalOrderListQryReqBO();
        DycGeneralQueryFuncReqBO queryFuncReqBO = new DycGeneralQueryFuncReqBO();
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = new DycGeneralQueryFuncRspBO();
        DycUocSalOrderListQryRspBO qryRspBO = new DycUocSalOrderListQryRspBO();
        salOrderListQryReqBO.setSaleOrdTacheStateList(Arrays.asList("A0007", "A0008", "N0004", "N0005", "E0003", "E0004"));
        queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)salOrderListQryReqBO)));
        queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
        dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
        qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
        Integer total = qryRspBO.getRecordsTotal() % 10 == 0 ? qryRspBO.getRecordsTotal() / 10 : qryRspBO.getRecordsTotal() / 10 + 1;
        ArrayList<DycUocSaleOrderInfoBO> uocSaleOrderInfoBOList = new ArrayList<DycUocSaleOrderInfoBO>();
        for (int i = 1; i <= total; ++i) {
            salOrderListQryReqBO.setPageNo(i);
            queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
            queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)salOrderListQryReqBO)));
            dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
            qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
            List<DycUocSaleOrderInfoBO> saleOrderInfoBOList = qryRspBO.getRows();
            saleOrderInfoBOList = saleOrderInfoBOList.stream().filter(obj -> {
                Long aging = (Long)effectiveMap.get(obj.getOrderSource());
                if (ObjectUtil.isEmpty((Object)aging)) {
                    log.info("\u8be5\u8ba2\u5355\u6ca1\u6709\u914d\u7f6e\u65f6\u9650");
                    return false;
                }
                Long nowMills = System.currentTimeMillis();
                UocQryOrderTaskInstanceListServiceReqBo taskInstanceListFuncReqBo = new UocQryOrderTaskInstanceListServiceReqBo();
                taskInstanceListFuncReqBo.setOrderId(obj.getOrderId());
                taskInstanceListFuncReqBo.setObjId(obj.getSaleOrderId().toString());
                taskInstanceListFuncReqBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                taskInstanceListFuncReqBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
                taskInstanceListFuncReqBo.setProcState(obj.getBusiTaskInstBos().get(0).getTacheCode());
                UocQryOrderTaskInstanceListServiceRspBo taskInstanceListFuncRspBo = this.uocQryOrderTaskInstanceListService.qryOrderTaskInstanceList(taskInstanceListFuncReqBo);
                if (!"0000".equals(taskInstanceListFuncRspBo.getRespCode()) || ObjectUtil.isEmpty((Object)taskInstanceListFuncRspBo.getDataList())) {
                    return false;
                }
                Long createTime = ((UocQryOrderTaskInstanceListServiceRspDataBo)taskInstanceListFuncRspBo.getDataList().get(0)).getCreateTime().getTime();
                if (aging + createTime - nowMills >= 0L) {
                    log.info("\u8ba2\u5355\uff1a{} +  \u4e0b\u5355\u65f6\u95f4: + {} + \u672a\u8d85\u65f6", (Object)obj.getSaleOrderNo(), (Object)createTime);
                    return false;
                }
                log.info("\u8ba2\u5355\uff1a{} +  \u4e0b\u5355\u65f6\u95f4: + {} + \u8d85\u65f6", (Object)obj.getSaleOrderNo(), (Object)createTime);
                return true;
            }).collect(Collectors.toList());
            uocSaleOrderInfoBOList.addAll(saleOrderInfoBOList);
        }
        return uocSaleOrderInfoBOList;
    }
}

