/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.purchase.ssc.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.purchase.ssc.api.DycSscMatImportFunction;
import com.tydic.dyc.atom.purchase.ssc.bo.DycCommonImportFailReasonFuncBO;
import com.tydic.dyc.atom.purchase.ssc.bo.DycSscMatImportFuncReqBO;
import com.tydic.dyc.atom.purchase.ssc.bo.DycSscMatImportFuncRspBO;
import com.tydic.dyc.atom.purchase.ssc.bo.DycSscSchemeMatBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.service.scheme.SscAddSchemeMatBatchService;
import com.tydic.dyc.ssc.service.scheme.SscDeleteSchemeMatBatchService;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeMatBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeMatBatchRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscDeleteSchemeMatBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycSscMatImportFunctionImpl
implements DycSscMatImportFunction {
    @Autowired
    private SscAddSchemeMatBatchService sscAddSchemeMatBatchService;
    @Autowired
    private SscDeleteSchemeMatBatchService sscDeleteSchemeMatBatchService;

    @Override
    public DycSscMatImportFuncRspBO dealSscMatImport(DycSscMatImportFuncReqBO reqBO) {
        List<DycSscSchemeMatBO> sscMat = reqBO.getSscMat();
        ArrayList<DycCommonImportFailReasonFuncBO> failReasonBOs = new ArrayList<DycCommonImportFailReasonFuncBO>();
        if (CollectionUtil.isNotEmpty(sscMat)) {
            HashMap<Integer, String> lineErrorMsgMap = new HashMap<Integer, String>();
            for (DycSscSchemeMatBO matBO : sscMat) {
                this.check(lineErrorMsgMap, matBO);
            }
            if (MapUtil.isNotEmpty(lineErrorMsgMap)) {
                lineErrorMsgMap.forEach((k, v) -> {
                    DycCommonImportFailReasonFuncBO bo = new DycCommonImportFailReasonFuncBO();
                    bo.setFailReason("\u7269\u6599\u660e\u7ec6\u884c\u3010" + k + "\u3011" + v.substring(1));
                    bo.setLineNum((Integer)k);
                    failReasonBOs.add(bo);
                });
            }
            if (CollectionUtil.isEmpty(failReasonBOs)) {
                this.setCode(reqBO.getSscMat());
                this.saveSscMat(reqBO);
            }
        }
        DycSscMatImportFuncRspBO rspBO = new DycSscMatImportFuncRspBO();
        rspBO.setFailReasonList(failReasonBOs);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveSscMat(DycSscMatImportFuncReqBO reqBO) {
        SscAddSchemeMatBatchReqBO sscAddSchemeMatBatchReqBO = (SscAddSchemeMatBatchReqBO)JUtil.js((Object)reqBO, SscAddSchemeMatBatchReqBO.class);
        sscAddSchemeMatBatchReqBO.setSscSchemeMat(JUtil.jsl(reqBO.getSscMat(), SscSchemeMatBO.class));
        sscAddSchemeMatBatchReqBO.setEnableDraft(Boolean.valueOf(true));
        SscDeleteSchemeMatBatchReqBO sscDeleteSchemeMatBatchReqBO = new SscDeleteSchemeMatBatchReqBO();
        sscDeleteSchemeMatBatchReqBO.setEnableDraft(Boolean.valueOf(true));
        this.sscDeleteSchemeMatBatchService.deleteSchemeMatBatch(sscDeleteSchemeMatBatchReqBO);
        SscAddSchemeMatBatchRspBO rspBO = this.sscAddSchemeMatBatchService.addSchemeMatBatch(sscAddSchemeMatBatchReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u7269\u6599\u660e\u7ec6\u65b0\u589e\u5931\u8d25" + rspBO.getRespDesc());
        }
    }

    public void setCode(List<DycSscSchemeMatBO> sscMat) {
        Map<String, List<DycSscSchemeMatBO>> keySscMatMap = sscMat.stream().collect(Collectors.groupingBy(e -> {
            String key = e.getProvinceName() + "_" + e.getCityName() + "_" + e.getCountyName();
            e.setKey(key);
            e.setPlaceStr(key.replace("_", ""));
            return key;
        }));
    }

    private void check(Map<Integer, String> lineErrorMsgMap, DycSscSchemeMatBO matBO) {
        Integer matNo = matBO.getMatNo();
        StringBuilder sb = new StringBuilder();
        if (StrUtil.isEmpty((CharSequence)matBO.getMatCode())) {
            sb.append(",\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)matBO.getMatName())) {
            sb.append(",\u7269\u6599\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)matBO.getMatSpec())) {
            sb.append(",\u89c4\u683c\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)matBO.getMatModel())) {
            sb.append(",\u578b\u53f7\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)matBO.getMeasureUnitName())) {
            sb.append(",\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)matBO.getExpectPrice())) {
            sb.append(",\u9884\u8ba1\u5355\u4ef7\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)matBO.getPurchaseNum())) {
            sb.append(",\u6570\u91cf\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)matBO.getTaxRate())) {
            sb.append(",\u7a0e\u7387\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)matBO.getDeliveryDate())) {
            sb.append(",\u4ea4\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)matBO.getProvince())) {
            sb.append(",\u4ea4\u8d27\u5730\u70b9\u7701\u4efd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)matBO.getCity())) {
            sb.append(",\u4ea4\u8d27\u5730\u70b9\u5730\u7ea7\u5e02\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)matBO.getCounty())) {
            sb.append(",\u4ea4\u8d27\u5730\u70b9\u53bf\u7ea7\u5e02\u4e3a\u7a7a");
        }
        if (StrUtil.isNotEmpty((CharSequence)sb.toString())) {
            lineErrorMsgMap.put(matNo, sb.toString());
        }
    }
}

