/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.purchase.ssc.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.enumType.YesNoEnum;
import com.tydic.dyc.atom.busicommon.user.api.DycAuthUserDataPowerQryFunction;
import com.tydic.dyc.atom.busicommon.user.bo.DycAuthUserDataPowerQryFunctionReqBo;
import com.tydic.dyc.atom.busicommon.user.bo.DycAuthUserDataPowerQryFunctionRspBo;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycGeneralTabsCountQueryFunction;
import com.tydic.dyc.atom.common.bo.DycCommonTabsCountBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncRspBO;
import com.tydic.dyc.base.bo.DycCommonButtonRspBo;
import com.tydic.dyc.base.bo.DycCommonUmcTabButtonConfBo;
import com.tydic.dyc.base.bo.DycCommonUmcTabIdConfBo;
import com.tydic.dyc.base.bo.DycCommonUocTabCountsBO;
import com.tydic.dyc.base.conf.CommonListQueryProperties;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.purchase.ssc.api.DycSscQrySchemeListService;
import com.tydic.dyc.purchase.ssc.bo.DycSscQrySchemeListReqBO;
import com.tydic.dyc.purchase.ssc.bo.DycSscQrySchemeListRspBO;
import com.tydic.dyc.purchase.ssc.bo.DycSscTaskBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.purchase.ssc.api.DycSscQrySchemeListService"})
public class DycSscQrySchemeListServiceImpl
implements DycSscQrySchemeListService {
    private static final Logger log = LoggerFactory.getLogger(DycSscQrySchemeListServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private DycAuthUserDataPowerQryFunction dycAuthUserDataPowerQryFunction;
    private static final String qryCode = "ssc_scheme";
    private static final String TOTAL = "\u5168\u90e8";
    @Value(value="${ssc.menuId.wtzg:1069284489164787712}")
    private String wtzg;
    @Value(value="${ssc.menuId.zxr:1073617737139359744}")
    private String zxr;
    @Value(value="${ssc.menuId.fabz:1069277372647247872}")
    private String fabz;
    @Autowired
    private DycGeneralTabsCountQueryFunction dycGeneralTabsCountQueryFunction;

    @Override
    @PostMapping(value={"qrySchemeList"})
    public DycSscQrySchemeListRspBO qrySchemeList(@RequestBody DycSscQrySchemeListReqBO reqBO) {
        reqBO.setCode(qryCode);
        String dataAuth = this.setDataAuth(reqBO);
        DycSscQrySchemeListRspBO rspBO = this.qryEsData(reqBO, dataAuth);
        this.dealButton(reqBO, rspBO);
        this.setTabCount(reqBO, rspBO, dataAuth);
        return rspBO;
    }

    private void setTabCount(DycSscQrySchemeListReqBO reqBO, DycSscQrySchemeListRspBO rspBO, String dataAuth) {
        if (reqBO.getTabId() != null) {
            ArrayList<DycGeneralTabsCountQueryBO> countList = new ArrayList<DycGeneralTabsCountQueryBO>();
            List<DycCommonUmcTabIdConfBo> tabIdConfList = reqBO.getConfTabList();
            for (DycCommonUmcTabIdConfBo tab : tabIdConfList) {
                if (!CommonListQueryProperties.QUANTITY_FLAG_YES.equals(tab.getQuantityFlag())) continue;
                DycGeneralTabsCountQueryBO cBo = new DycGeneralTabsCountQueryBO();
                cBo.setTabId(tab.getTabId());
                cBo.setTabName(tab.getTabName());
                JSONObject reqBoJsonObj = JSONObject.parseObject((String)dataAuth);
                if (reqBO.getTabId().equals(tab.getTabId())) {
                    reqBoJsonObj.putAll((Map)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO))));
                } else {
                    reqBoJsonObj.putAll((Map)JSONObject.parseObject((String)tab.getParamJson()));
                    if (this.wtzg.equals(String.valueOf(reqBO.getMenuId()))) {
                        reqBoJsonObj.put("orgCode", (Object)reqBO.getOrgCode());
                    } else if (this.zxr.equals(String.valueOf(reqBO.getMenuId()))) {
                        reqBoJsonObj.put("implId", (Object)reqBO.getImplId());
                    } else if (this.fabz.equals(String.valueOf(reqBO.getMenuId()))) {
                        reqBoJsonObj.put("userId", (Object)reqBO.getUserId());
                    }
                }
                cBo.setParamJsonStr(reqBoJsonObj.toJSONString());
                countList.add(cBo);
            }
            log.info("\u9875\u7b7e\u6570\u91cf\u67e5\u8be2-\u9875\u7b7e\u6761\u4ef6\u96c6\u5408\u4e3a: {}", (Object)JSON.toJSONString(tabIdConfList));
            DycGeneralTabsCountQueryFuncReqBO countReqBo = new DycGeneralTabsCountQueryFuncReqBO();
            countReqBo.setDycGeneralTabsCountQueryBOS(countList);
            DycGeneralTabsCountQueryFuncRspBO tabsCountRsp = this.dycGeneralTabsCountQueryFunction.getTabsCount(countReqBo);
            if ("0000".equals(tabsCountRsp.getRespCode())) {
                ArrayList<DycCommonUocTabCountsBO> tabCountList = new ArrayList<DycCommonUocTabCountsBO>();
                for (DycCommonTabsCountBO dycCommonTabsCountBO : tabsCountRsp.getTabCountList()) {
                    DycCommonUocTabCountsBO rspCountBo = new DycCommonUocTabCountsBO();
                    rspCountBo.setTabId((long)dycCommonTabsCountBO.getTabId());
                    rspCountBo.setTabName(dycCommonTabsCountBO.getTabName());
                    rspCountBo.setTabCount(dycCommonTabsCountBO.getTabCount());
                    if (TOTAL.equals(dycCommonTabsCountBO.getTabName())) {
                        rspCountBo.setTabNameCount(rspCountBo.getTabName() + "(" + rspCountBo.getTabCount() + ")");
                    } else {
                        rspCountBo.setTabNameCount(dycCommonTabsCountBO.getTabNameCount());
                    }
                    tabCountList.add(rspCountBo);
                }
                rspBO.setTabCountList(tabCountList);
            }
        }
    }

    private void dealButton(DycSscQrySchemeListReqBO reqBO, DycSscQrySchemeListRspBO rspBO) {
        Map<Integer, DycCommonUmcTabIdConfBo> tabIdButtonMap;
        DycCommonUmcTabIdConfBo dycCommonUmcTabIdConfBo2;
        if (!CollectionUtils.isEmpty(rspBO.getRows()) && reqBO.getTabId() != null && !CollectionUtils.isEmpty(reqBO.getConfTabList()) && reqBO.getTabId() != null && ObjectUtil.isNotNull((Object)(dycCommonUmcTabIdConfBo2 = (tabIdButtonMap = reqBO.getConfTabList().stream().collect(Collectors.toMap(DycCommonUmcTabIdConfBo::getTabId, dycCommonUmcTabIdConfBo -> dycCommonUmcTabIdConfBo))).get(reqBO.getTabId()))) && CollectionUtil.isNotEmpty(dycCommonUmcTabIdConfBo2.getUmcTacheButtonList())) {
            rspBO.getRows().forEach(e -> {
                Map<String, List<DycCommonUmcTabButtonConfBo>> statusButtonMap = dycCommonUmcTabIdConfBo2.getUmcTacheButtonList().stream().collect(Collectors.groupingBy(DycCommonUmcTabButtonConfBo::getDataStatus));
                String status = e.getSchemeAuditStatus() + "_" + (StrUtil.isEmpty((CharSequence)e.getSchemeStatus()) ? "" : e.getSchemeStatus());
                List<DycCommonUmcTabButtonConfBo> button = statusButtonMap.get(status);
                if ("1_".equals(status)) {
                    DycSscTaskBO dycSscTaskBO;
                    List<DycSscTaskBO> auditTaskList = e.getAuditTaskList();
                    if (CollectionUtil.isNotEmpty(auditTaskList) && ObjectUtil.isNotNull((Object)(dycSscTaskBO = (DycSscTaskBO)auditTaskList.stream().filter(x -> YesNoEnum.IS.getType().equals(x.getFinishTag())).findAny().orElse(null)))) {
                        button.removeIf(y -> "CH".equals(y.getBtnCode()));
                    }
                } else if (this.wtzg.equals(String.valueOf(reqBO.getMenuId())) && "2_1".equals(status) && StrUtil.isNotEmpty((CharSequence)e.getImplName()) && CollectionUtil.isNotEmpty(button)) {
                    button.removeIf(y -> "ZXRSL".equals(y.getBtnCode()) || "CGFAWTSL".equals(y.getBtnCode()));
                }
                e.setButton(JUtil.jsl(button, DycCommonButtonRspBo.class));
            });
        }
    }

    private DycSscQrySchemeListRspBO qryEsData(DycSscQrySchemeListReqBO reqBO, String dataAuth) {
        JSONObject reqBoJsonObj = JSON.parseObject((String)dataAuth);
        reqBoJsonObj.putAll((Map)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO))));
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqBoJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        log.info("\u91c7\u8d2d\u65b9\u6848\u67e5\u8be2es\u6570\u636e: {}", (Object)dycGeneralQueryFuncRspBO.getRspJsonStr());
        DycSscQrySchemeListRspBO rspBO = (DycSscQrySchemeListRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycSscQrySchemeListRspBO.class));
        log.info("\u91c7\u8d2d\u65b9\u6848es\u6570\u636e\u7ed3\u679c\u8f6c\u6362: {}", (Object)JSON.toJSONString((Object)((Object)rspBO)));
        for (int i = 0; i < rspBO.getRows().size(); ++i) {
            rspBO.getRows().get(i).setOrderBy(String.valueOf(i) + 1);
        }
        return rspBO;
    }

    private String setDataAuth(DycSscQrySchemeListReqBO reqBO) {
        if (reqBO.getMenuId() != null) {
            DycAuthUserDataPowerQryFunctionReqBo functionReqBo = (DycAuthUserDataPowerQryFunctionReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycAuthUserDataPowerQryFunctionReqBo.class);
            DycAuthUserDataPowerQryFunctionRspBo functionRspBo = this.dycAuthUserDataPowerQryFunction.qryUserDataPower(functionReqBo);
            return JSON.toJSONString((Object)functionRspBo);
        }
        return "{}";
    }
}

