/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrAgrItemSaveCheckService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrItemSaveCheckReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrItemSaveCheckRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.procinst.AgrGetTaskInstService;
import com.tydic.dyc.agr.service.procinst.AgrTaskDealService;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstReqBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstRspBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskDealReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskInfoBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrUocOrderTaskInstBo;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.api.DycGeneralBusiRuleExecFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncRspBO;
import com.tydic.dyc.zone.agr.api.DycAgrAgrSubmitService;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrSubmitReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrSubmitRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrAgrSubmitService"})
public class DycAgrAgrSubmitServiceImpl
implements DycAgrAgrSubmitService {
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;
    @Autowired
    private DycGeneralBusiRuleExecFunction dycGeneralBusiRuleExecFunction;
    @Autowired
    private DycBusiProcessStartFunction dycBusiProcessStartFunction;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private AgrGetTaskInstService agrGetTaskInstService;
    private final String SERCICE_CODE = "AGRB0003";
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;
    private final Integer submitFlag = 1;
    @Autowired
    private AgrTaskDealService agrTaskDealService;
    @Autowired
    private AgrAgrItemSaveCheckService agrAgrItemSaveCheckService;

    @Override
    @PostMapping(value={"dealAgrSubmit"})
    public DycAgrAgrSubmitRspBO dealAgrSubmit(@RequestBody DycAgrAgrSubmitReqBO reqBO) {
        DycAgrAgrSubmitRspBO rspBO = new DycAgrAgrSubmitRspBO();
        if (reqBO.getAgrId() == null) {
            throw new ZTBusinessException("agrId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AgrGetAgrMainRspBo agrGetAgrMainRspBo = this.getAgrMain(reqBO);
        this.checkAgrItem(reqBO, agrGetAgrMainRspBo);
        AgrUocOrderTaskInstBo agrUocOrderTaskInstBo = this.getTaskInst(reqBO);
        if (agrUocOrderTaskInstBo == null || StringUtils.isEmpty((Object)agrUocOrderTaskInstBo.getTaskInstId())) {
            this.startBusiProcess(agrGetAgrMainRspBo, reqBO);
        } else {
            this.flowBusiProcess(reqBO, agrUocOrderTaskInstBo.getTaskInstId());
            this.submitCenterTask(agrUocOrderTaskInstBo, reqBO);
        }
        return rspBO;
    }

    private void checkAgrItem(DycAgrAgrSubmitReqBO reqBO, AgrGetAgrMainRspBo agrGetAgrMainRspBo) {
        if (1 == agrGetAgrMainRspBo.getWhetherHaveItem()) {
            AgrAgrItemSaveCheckReqBO agrAgrItemSaveCheckReqBO = new AgrAgrItemSaveCheckReqBO();
            agrAgrItemSaveCheckReqBO.setAgrId(reqBO.getAgrId());
            AgrAgrItemSaveCheckRspBO agrAgrItemSaveCheckRspBO = this.agrAgrItemSaveCheckService.checkAgrItemSave(agrAgrItemSaveCheckReqBO);
            if (!"0000".equals(agrAgrItemSaveCheckRspBO.getRespCode())) {
                throw new ZTBusinessException("\u5f53\u524d\u7269\u6599\u660e\u7ec6\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff0c\u8bf7\u6838\u5b9e\u5b8c\u5584\u540e\u518d\u63d0\u4ea4\uff01");
            }
        }
    }

    private void submitCenterTask(AgrUocOrderTaskInstBo agrUocOrderTaskInstBo, DycAgrAgrSubmitReqBO reqBO) {
        AgrTaskDealReqBO agrTaskDealReqBO = new AgrTaskDealReqBO();
        agrTaskDealReqBO.setOrderId(agrUocOrderTaskInstBo.getOrderId());
        agrTaskDealReqBO.setUserId(reqBO.getUserId());
        agrTaskDealReqBO.setUsername(reqBO.getUsername());
        ArrayList<AgrTaskInfoBO> agrTaskInfoBOS = new ArrayList<AgrTaskInfoBO>();
        AgrTaskInfoBO agrTaskInfoBO = new AgrTaskInfoBO();
        agrTaskInfoBO.setBusiObjId(agrUocOrderTaskInstBo.getObjId());
        agrTaskInfoBO.setBusiObjType(agrUocOrderTaskInstBo.getObjType());
        agrTaskInfoBO.setDealResult(this.submitFlag);
        agrTaskInfoBO.setTaskId(agrUocOrderTaskInstBo.getTaskInstId());
        agrTaskInfoBOS.add(agrTaskInfoBO);
        agrTaskDealReqBO.setCompleteTaskInfos(agrTaskInfoBOS);
        this.agrTaskDealService.dealTask(agrTaskDealReqBO);
    }

    private void flowBusiProcess(DycAgrAgrSubmitReqBO reqBO, String taskInstId) {
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(taskInstId);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("userId", reqBO.getUserId());
        variables.put("userName", reqBO.getName());
        variables.put("submitFlag", this.submitFlag);
        dycBusiProcessFlowFuncReqBO.setVariables(variables);
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u63d0\u4ea4\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
    }

    private AgrGetAgrMainRspBo getAgrMain(DycAgrAgrSubmitReqBO reqBO) {
        AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
        agrGetAgrMainReqBo.setAgrId(reqBO.getAgrId());
        AgrGetAgrMainRspBo agrGetAgrMainRspBo = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
        if (!"0000".equals(agrGetAgrMainRspBo.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u67e5\u8be2\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + agrGetAgrMainRspBo.getRespCode() + "\u3011," + agrGetAgrMainRspBo.getRespDesc());
        }
        if (agrGetAgrMainRspBo.getAgrId() == null) {
            throw new ZTBusinessException("\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return agrGetAgrMainRspBo;
    }

    private AgrUocOrderTaskInstBo getTaskInst(DycAgrAgrSubmitReqBO reqBO) {
        AgrGetTaskInstReqBo agrGetTaskInstReqBo = new AgrGetTaskInstReqBo();
        agrGetTaskInstReqBo.setOrderId(reqBO.getAgrId());
        agrGetTaskInstReqBo.setObjId(reqBO.getAgrId());
        agrGetTaskInstReqBo.setFinishTag(Integer.valueOf(0));
        AgrGetTaskInstRspBo agrGetTaskInstRspBo = this.agrGetTaskInstService.getTaskInstList(agrGetTaskInstReqBo);
        if (!"0000".equals(agrGetTaskInstRspBo.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4efb\u52a1\u67e5\u8be2\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrGetTaskInstRspBo.getRespCode() + "\u3011," + agrGetTaskInstRspBo.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)agrGetTaskInstRspBo.getRows())) {
            return (AgrUocOrderTaskInstBo)agrGetTaskInstRspBo.getRows().get(0);
        }
        return null;
    }

    private void startBusiProcess(AgrGetAgrMainRspBo agrGetAgrMainRspBo, DycAgrAgrSubmitReqBO reqBO) {
        DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
        if (agrGetAgrMainRspBo.getTradeMode().equals(1)) {
            dycBusiProcessStartFuncReqBO.setProcDefKey("agr_plat_agr_busi_process");
        } else {
            dycBusiProcessStartFuncReqBO.setProcDefKey("agr_danwei_agr_busi_process");
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("agrId", agrGetAgrMainRspBo.getAgrId());
        variables.put("orderId", agrGetAgrMainRspBo.getAgrId());
        variables.put("auditObjId", agrGetAgrMainRspBo.getAgrId());
        variables.put("auditStartFlag", "1");
        variables.put("auditFinishFlag", "1");
        variables.put("orgId", reqBO.getOrgId());
        variables.put("orgName", reqBO.getOrgName());
        variables.put("userId", reqBO.getUserId());
        variables.put("userName", reqBO.getName());
        variables.put("todoOrderNo", agrGetAgrMainRspBo.getAgrCode());
        variables.put("createOperId", reqBO.getUserId());
        variables.put("loginTagIn", reqBO.getLoginTagIn());
        variables.put("agrType", AgrCommConstant.AgrType.AGR);
        dycBusiProcessStartFuncReqBO.setVariables(variables);
        dycBusiProcessStartFuncReqBO.setSysCode(this.SYS_CODE);
        dycBusiProcessStartFuncReqBO.setPartitonKey(String.valueOf(agrGetAgrMainRspBo.getAgrId()));
        DycBusiProcessStartFuncRspBO dycBusiProcessStartFuncRspBO = this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
        if (!"0000".equals(dycBusiProcessStartFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u63d0\u4ea4\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + dycBusiProcessStartFuncRspBO.getRespDesc());
        }
    }
}

