/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.busicommon.user.api.DycAuthUserDataPowerQryFunction;
import com.tydic.dyc.atom.busicommon.user.bo.DycAuthUserDataPowerQryFunctionReqBo;
import com.tydic.dyc.atom.busicommon.user.bo.DycAuthUserDataPowerQryFunctionRspBo;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycGeneralTabsCountQueryFunction;
import com.tydic.dyc.atom.common.bo.DycCommonTabsCountBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncRspBO;
import com.tydic.dyc.base.bo.DycCommonButtonRspBo;
import com.tydic.dyc.base.bo.DycCommonUmcTabButtonConfBo;
import com.tydic.dyc.base.bo.DycCommonUmcTabIdConfBo;
import com.tydic.dyc.base.bo.DycCommonUocTabCountsBO;
import com.tydic.dyc.base.conf.CommonListQueryProperties;
import com.tydic.dyc.zone.agr.api.DycAgrGetAgrListService;
import com.tydic.dyc.zone.agr.bo.DycAgrGetAgrListReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrGetAgrListRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrGetAgrListService"})
public class DycAgrGetAgrListServiceImpl
implements DycAgrGetAgrListService {
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private DycAuthUserDataPowerQryFunction dycAuthUserDataPowerQryFunction;
    private static final String qryCode = "551184533233897563";
    @Autowired
    private DycGeneralTabsCountQueryFunction dycGeneralTabsCountQueryFunction;

    @Override
    @PostMapping(value={"getAgrList"})
    public DycAgrGetAgrListRspBO getAgrList(@RequestBody DycAgrGetAgrListReqBO reqBO) {
        reqBO.setCode(qryCode);
        this.dealAudit(reqBO);
        String dataAuth = this.setDataAuth(reqBO);
        DycAgrGetAgrListRspBO rspBO = this.qryEsData(reqBO, dataAuth);
        this.dealRspBo(rspBO);
        this.dealButton(reqBO, rspBO);
        this.setTabCount(reqBO, rspBO, dataAuth);
        return rspBO;
    }

    private DycAgrGetAgrListRspBO qryEsData(DycAgrGetAgrListReqBO reqBo, String dataAuth) {
        List<DycCommonUmcTabIdConfBo> theTabConfList;
        JSONObject reqBoJsonObj = JSON.parseObject((String)dataAuth);
        reqBoJsonObj.putAll((Map)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo))));
        if (reqBo.getTabId() != null && ObjectUtil.isNotEmpty((Object)(theTabConfList = reqBo.getConfTabList().stream().collect(Collectors.groupingBy(DycCommonUmcTabIdConfBo::getTabId)).get(reqBo.getTabId())).get(0).getParamJson())) {
            reqBoJsonObj.putAll((Map)JSON.parseObject((String)theTabConfList.get(0).getParamJson()));
        }
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        if (reqBoJsonObj.get((Object)"dataType") == null) {
            reqBoJsonObj.put("dataType", (Object)1);
        }
        dycGeneralQueryFuncReqBO.setReqParams(reqBoJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        return (DycAgrGetAgrListRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycAgrGetAgrListRspBO.class));
    }

    private void dealRspBo(DycAgrGetAgrListRspBO rspBO) {
        if (!CollectionUtils.isEmpty(rspBO.getRows())) {
            rspBO.getRows().forEach(dycAgrMainDetailBO -> {
                dycAgrMainDetailBO.setEffDate(this.longToDate(dycAgrMainDetailBO.getEffDate()));
                dycAgrMainDetailBO.setExpDate(this.longToDate(dycAgrMainDetailBO.getExpDate()));
                dycAgrMainDetailBO.setApplyCreateTime(this.longToDate(dycAgrMainDetailBO.getApplyCreateTime()));
            });
        }
    }

    private String setDataAuth(DycAgrGetAgrListReqBO reqBO) {
        if (reqBO.getMenuId() != null) {
            DycAuthUserDataPowerQryFunctionReqBo functionReqBo = (DycAuthUserDataPowerQryFunctionReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycAuthUserDataPowerQryFunctionReqBo.class);
            DycAuthUserDataPowerQryFunctionRspBo functionRspBo = this.dycAuthUserDataPowerQryFunction.qryUserDataPower(functionReqBo);
            if (functionRspBo.getSeflFlag().booleanValue()) {
                reqBO.setCreateLoginId(reqBO.getUserId());
            }
            return JSON.toJSONString((Object)functionRspBo);
        }
        return "{}";
    }

    private void dealAudit(DycAgrGetAgrListReqBO reqBO) {
        if (reqBO.getObjBusiType() != null) {
            ArrayList<String> auditDealResultQryKeys = new ArrayList<String>();
            String auditDealResultQryKey3 = reqBO.getUserId() + "_" + reqBO.getObjBusiType();
            String auditDealResultQryKey1 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 0;
            String auditDealResultQryKey2 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 1;
            if (reqBO.getAuditOrderStatus() != null) {
                String auditDealResultQryKey = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + reqBO.getAuditOrderStatus();
                auditDealResultQryKeys.add(auditDealResultQryKey);
            } else if (reqBO.getTabId().equals(1001) || reqBO.getTabId().equals(1016)) {
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            } else if (reqBO.getTabId().equals(1002) || reqBO.getTabId().equals(1017)) {
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
            } else if (reqBO.getTabId().equals(1003) || reqBO.getTabId().equals(1018)) {
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            }
            reqBO.setAuditDealResultQryKeys(auditDealResultQryKeys);
        }
    }

    private void setTabCount(DycAgrGetAgrListReqBO reqBo, DycAgrGetAgrListRspBO rspBO, String dataAuth) {
        if (reqBo.getTabId() != null) {
            ArrayList<DycGeneralTabsCountQueryBO> countList = new ArrayList<DycGeneralTabsCountQueryBO>();
            List<DycCommonUmcTabIdConfBo> tabIdConfList = reqBo.getConfTabList();
            for (DycCommonUmcTabIdConfBo tab : tabIdConfList) {
                if (!CommonListQueryProperties.QUANTITY_FLAG_YES.equals(tab.getQuantityFlag())) continue;
                DycGeneralTabsCountQueryBO cBo = new DycGeneralTabsCountQueryBO();
                cBo.setTabId(tab.getTabId());
                cBo.setTabName(tab.getTabName());
                if (reqBo.getTabId().equals(tab.getTabId())) {
                    JSONObject reqBoJsonObj = JSONObject.parseObject((String)dataAuth);
                    reqBoJsonObj.putAll((Map)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo))));
                    reqBoJsonObj.putAll((Map)JSONObject.parseObject((String)tab.getParamJson()));
                    cBo.setParamJsonStr(reqBoJsonObj.toJSONString());
                } else {
                    JSONObject reqBoJsonObj1 = JSONObject.parseObject((String)dataAuth);
                    reqBoJsonObj1.putAll((Map)JSONObject.parseObject((String)tab.getParamJson()));
                    if (reqBo.getObjBusiType() != null) {
                        ArrayList<String> auditDealResultQryKeys = new ArrayList<String>();
                        String auditDealResultQryKey3 = reqBo.getUserId() + "_" + reqBo.getObjBusiType();
                        String auditDealResultQryKey1 = reqBo.getUserId() + "_" + reqBo.getObjBusiType() + "_" + 0;
                        String auditDealResultQryKey2 = reqBo.getUserId() + "_" + reqBo.getObjBusiType() + "_" + 1;
                        if (reqBo.getAuditOrderStatus() != null) {
                            String auditDealResultQryKey = reqBo.getUserId() + "_" + reqBo.getObjBusiType() + "_" + reqBo.getAuditOrderStatus();
                            auditDealResultQryKeys.add(auditDealResultQryKey);
                        } else if (tab.getTabId().equals(1001) || tab.getTabId().equals(1016)) {
                            auditDealResultQryKeys.add(auditDealResultQryKey3);
                        } else if (tab.getTabId().equals(1002) || tab.getTabId().equals(1017)) {
                            auditDealResultQryKeys.add(auditDealResultQryKey1);
                            auditDealResultQryKeys.add(auditDealResultQryKey2);
                        } else if (tab.getTabId().equals(1003) || tab.getTabId().equals(1018)) {
                            auditDealResultQryKeys.add(auditDealResultQryKey1);
                            auditDealResultQryKeys.add(auditDealResultQryKey2);
                            auditDealResultQryKeys.add(auditDealResultQryKey3);
                        }
                        reqBoJsonObj1.put("auditDealResultQryKeys", auditDealResultQryKeys);
                    }
                    cBo.setParamJsonStr(reqBoJsonObj1.toJSONString());
                }
                countList.add(cBo);
            }
            DycGeneralTabsCountQueryFuncReqBO countReqBo = new DycGeneralTabsCountQueryFuncReqBO();
            countReqBo.setDycGeneralTabsCountQueryBOS(countList);
            DycGeneralTabsCountQueryFuncRspBO tabsCountRsp = this.dycGeneralTabsCountQueryFunction.getTabsCount(countReqBo);
            if ("0000".equals(tabsCountRsp.getRespCode())) {
                ArrayList<DycCommonUocTabCountsBO> tabCountList = new ArrayList<DycCommonUocTabCountsBO>();
                for (DycCommonTabsCountBO dycCommonTabsCountBO : tabsCountRsp.getTabCountList()) {
                    DycCommonUocTabCountsBO rspCountBo = new DycCommonUocTabCountsBO();
                    rspCountBo.setTabId(Long.valueOf(dycCommonTabsCountBO.getTabId().intValue()));
                    rspCountBo.setTabName(dycCommonTabsCountBO.getTabName());
                    rspCountBo.setTabCount(dycCommonTabsCountBO.getTabCount());
                    rspCountBo.setTabNameCount(dycCommonTabsCountBO.getTabNameCount());
                    if (rspCountBo.getTabName().startsWith("\u5168\u90e8")) {
                        rspCountBo.setTabNameCount(rspCountBo.getTabName() + "(" + rspCountBo.getTabCount() + ")");
                    }
                    tabCountList.add(rspCountBo);
                }
                rspBO.setTabCountList(tabCountList);
            }
        }
    }

    private void dealButton(DycAgrGetAgrListReqBO reqBO, DycAgrGetAgrListRspBO rspBO) {
        Map<Integer, DycCommonUmcTabIdConfBo> tabIdButtonMap;
        DycCommonUmcTabIdConfBo dycCommonUmcTabIdConfBo2;
        if (!CollectionUtils.isEmpty(rspBO.getRows()) && reqBO.getTabId() != null && !CollectionUtils.isEmpty(reqBO.getConfTabList()) && reqBO.getTabId() != null && (dycCommonUmcTabIdConfBo2 = (tabIdButtonMap = reqBO.getConfTabList().stream().collect(Collectors.toMap(DycCommonUmcTabIdConfBo::getTabId, dycCommonUmcTabIdConfBo -> dycCommonUmcTabIdConfBo))).get(reqBO.getTabId())) != null) {
            HashMap statusButtonMap = new HashMap();
            dycCommonUmcTabIdConfBo2.getUmcTacheButtonList().forEach(dycCommonUmcTabButtonConfBo -> {
                ArrayList<DycCommonUmcTabButtonConfBo> dycCommonUmcTabButtonConfBos = (ArrayList<DycCommonUmcTabButtonConfBo>)statusButtonMap.get(dycCommonUmcTabButtonConfBo.getDataStatus());
                if (dycCommonUmcTabButtonConfBos == null) {
                    dycCommonUmcTabButtonConfBos = new ArrayList<DycCommonUmcTabButtonConfBo>();
                    statusButtonMap.put(dycCommonUmcTabButtonConfBo.getDataStatus(), dycCommonUmcTabButtonConfBos);
                }
                dycCommonUmcTabButtonConfBos.add((DycCommonUmcTabButtonConfBo)dycCommonUmcTabButtonConfBo);
            });
            rspBO.getRows().forEach(dycAgrMainDetailBO -> {
                if (dycAgrMainDetailBO.getDataType() == 2) {
                    dycAgrMainDetailBO.setButton(JSONArray.parseArray((String)JSON.toJSONString(statusButtonMap.get(dycAgrMainDetailBO.getChngApplyStatus().toString())), DycCommonButtonRspBo.class));
                } else {
                    dycAgrMainDetailBO.setButton(JSONArray.parseArray((String)JSON.toJSONString(statusButtonMap.get(dycAgrMainDetailBO.getAgrStatus().toString())), DycCommonButtonRspBo.class));
                }
            });
        }
    }

    private String longToDate(String dateStr) {
        if (StringUtils.isEmpty((Object)dateStr)) {
            return null;
        }
        Date date = new Date(Long.valueOf(dateStr));
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        return sd.format(date);
    }
}

