/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrCreateAgrItemService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.zone.agr.api.DycAgrAgrItemSaveService;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrItemSaveReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrAgrItemSaveRspBO;
import com.tydic.dyc.zone.agr.bo.DycAgrItemBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrAgrItemSaveService"})
public class DycAgrAgrItemSaveServiceImpl
implements DycAgrAgrItemSaveService {
    private static final Logger log = LoggerFactory.getLogger(DycAgrAgrItemSaveServiceImpl.class);
    @Autowired
    AgrCreateAgrItemService agrCreateAgrItemService;
    @Autowired
    AgrGetAgrItemListService agrGetAgrItemListService;

    @Override
    @PostMapping(value={"dealAgrItemSave"})
    public DycAgrAgrItemSaveRspBO dealAgrItemSave(@RequestBody DycAgrAgrItemSaveReqBO reqBO) {
        this.validParam(reqBO);
        this.validPuplicate(reqBO);
        AgrCreateAgrItemReqBo agrCreateAgrItemReqBo = (AgrCreateAgrItemReqBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), AgrCreateAgrItemReqBo.class);
        AgrCreateAgrItemRspBo agrItem = this.agrCreateAgrItemService.createAgrItem(agrCreateAgrItemReqBo);
        if (!"0000".equals(agrItem.getRespCode())) {
            throw new ZTBusinessException(agrItem.getRespDesc());
        }
        return (DycAgrAgrItemSaveRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)agrItem), DycAgrAgrItemSaveRspBO.class));
    }

    private void validParam(DycAgrAgrItemSaveReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBO))) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAgrId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(reqBO.getAgrItem())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[agrItem]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAgrItem().size() > 3000) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u4e0d\u80fd\u8d85\u8fc7 3000\u6761\uff01");
        }
    }

    private void validPuplicate(DycAgrAgrItemSaveReqBO reqBO) {
        ArrayList<String> uniqueKeys = new ArrayList<String>();
        HashMap<String, DycAgrItemBO> uniqueKeyMap = new HashMap<String, DycAgrItemBO>();
        for (int i = 0; i < reqBO.getAgrItem().size(); ++i) {
            DycAgrItemBO dycAgrItemBo = reqBO.getAgrItem().get(i);
            String key = dycAgrItemBo.getCommodityTypeName() + "_" + dycAgrItemBo.getMaterialCode();
            if (uniqueKeyMap.get(key) != null) {
                throw new ZTBusinessException("\u5546\u54c1\u7c7b\u578b\u3010" + dycAgrItemBo.getCommodityTypeName() + "\u3011\u7269\u6599\u7f16\u7801\u3010" + dycAgrItemBo.getMaterialCode() + "\u3011\u91cd\u590d");
            }
            uniqueKeyMap.put(key, dycAgrItemBo);
            uniqueKeys.add(key);
        }
        if (uniqueKeys.size() > 0) {
            AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
            agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setAgrId(reqBO.getAgrId());
            agrGetAgrItemListReqBO.setUniqueKeys(uniqueKeys);
            AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
            if ("0000".equals(agrGetAgrItemListRspBO.getRespCode())) {
                if (!CollectionUtils.isEmpty((Collection)agrGetAgrItemListRspBO.getRows())) {
                    agrGetAgrItemListRspBO.getRows().forEach(agrItemDetailBo -> {
                        throw new ZTBusinessException("\u5546\u54c1\u7c7b\u578b\u3010" + agrItemDetailBo.getCommodityTypeName() + "\u3011\u7269\u6599\u7f16\u7801\u3010" + agrItemDetailBo.getMaterialCode() + "\u3011\u91cd\u590d");
                    });
                }
            } else {
                throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u67e5\u8be2\u5931\u8d25:" + agrGetAgrItemListRspBO.getRespDesc());
            }
        }
    }
}

