/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycOnlinePaymentRefundFunction;
import com.tydic.dyc.atom.busicommon.api.DycPingAnQueryOnlinePaymentRefundFunction;
import com.tydic.dyc.atom.busicommon.api.DycPingAnRefundOnlinePaymentFunction;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnQueryOnlinePaymentRefundReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnQueryOnlinePaymentRefundRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnRefundOnlinePaymentReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnRefundOnlinePaymentRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnSubOrderInfo;
import com.tydic.dyc.atom.busicommon.bo.DycUocOnlinePaymentRefundReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocOnlinePaymentRefundRspBO;
import com.tydic.dyc.atom.busicommon.order.api.DycUocOrdeDetailListQryExtFunction;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocOrdeDetailListQryExtFuncRspBo;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocSaleOrderInfoFuncRspBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceExtReqBo;
import com.tydic.fsc.pay.ability.api.FscOnlinePaymentQueryAbilityService;
import com.tydic.fsc.pay.ability.api.FscOnlinePaymentSaveAbilityService;
import com.tydic.fsc.pay.ability.api.FscOnlinePaymentUpdateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscOnlinePaymentAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscOnlinePaymentAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscOnlinePaymentQueryAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscOnlinePaymentQueryAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscPingAnOnlinePaymentInfoBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycOnlinePaymentRefundFunctionImpl
implements DycOnlinePaymentRefundFunction {
    private static final Logger log = LoggerFactory.getLogger(DycOnlinePaymentRefundFunctionImpl.class);
    @Autowired
    private FscOnlinePaymentQueryAbilityService fscOnlinePaymentQueryAbilityService;
    @Autowired
    private FscOnlinePaymentSaveAbilityService fscOnlinePaymentSaveAbilityService;
    @Autowired
    private FscOnlinePaymentUpdateAbilityService fscOnlinePaymentUpdateAbilityService;
    @Value(value="${pingan.trade_no}")
    private String TRADE_NO;
    @Autowired
    private DycPingAnRefundOnlinePaymentFunction dycRefundOnlinePaymentService;
    @Autowired
    private DycPingAnQueryOnlinePaymentRefundFunction dycQueryOnlinePaymentRefundService;
    @Autowired
    private DycUocOrdeDetailListQryExtFunction dycUocOrdeDetailListQryExtFunction;

    @Override
    public DycUocOnlinePaymentRefundRspBO onlinePaymentRefund(DycUocOnlinePaymentRefundReqBO reqBO) {
        DycUocOnlinePaymentRefundRspBO rspBO = new DycUocOnlinePaymentRefundRspBO();
        rspBO.setOrderId(reqBO.getOrderId());
        rspBO.setSaleOrderId(reqBO.getSaleOrderId());
        rspBO.setAfOrderId(reqBO.getAfOrderId());
        rspBO.setRefundAmount(reqBO.getRefundAmount());
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        log.info("\u53d1\u8d77\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        this.checkParam(reqBO);
        FscOnlinePaymentQueryAbilityReqBO fscOnlinePaymentQueryAbilityReqBO = new FscOnlinePaymentQueryAbilityReqBO();
        fscOnlinePaymentQueryAbilityReqBO.setOrderId(reqBO.getOrderId());
        fscOnlinePaymentQueryAbilityReqBO.setIsDel(Integer.valueOf(0));
        FscOnlinePaymentQueryAbilityRspBO queryAbilityRspBO = this.fscOnlinePaymentQueryAbilityService.queryOnlinePaymentInfo(fscOnlinePaymentQueryAbilityReqBO);
        if (queryAbilityRspBO == null || queryAbilityRspBO.getInfoBOList() == null || queryAbilityRspBO.getInfoBOList().isEmpty()) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u8bb0\u5f55");
        }
        List<FscPingAnOnlinePaymentInfoBO> infoBOList = queryAbilityRspBO.getInfoBOList();
        FscOnlinePaymentAbilityReqBO fscOnlinePaymentAbilityReqBO = new FscOnlinePaymentAbilityReqBO();
        Optional<FscPingAnOnlinePaymentInfoBO> any = infoBOList.stream().filter(info -> info.getOrderType() == 2 && info.getAfOrderId().equals(reqBO.getAfOrderId())).findAny();
        if (any.isPresent()) {
            FscPingAnOnlinePaymentInfoBO fscPingAnOnlinePaymentInfoBO = any.get();
            if (fscPingAnOnlinePaymentInfoBO.getOrderStatus() == 1) {
                rspBO.setRefundStatus(true);
                return rspBO;
            }
            DycPingAnQueryOnlinePaymentRefundReqBO refundReqBO = new DycPingAnQueryOnlinePaymentRefundReqBO();
            refundReqBO.setReturnOrderSendTime(fscPingAnOnlinePaymentInfoBO.getOrderSendTime());
            refundReqBO.setTraderNo(fscPingAnOnlinePaymentInfoBO.getTraderNo());
            refundReqBO.setReturnOrderNo(fscPingAnOnlinePaymentInfoBO.getTraderOrderNo());
            refundReqBO.setCnsmrSeqNo(fscPingAnOnlinePaymentInfoBO.getCnsmrSeqNo());
            DycPingAnQueryOnlinePaymentRefundRspBO dycPingAnQueryOnlinePaymentRefundRspBO = this.dycQueryOnlinePaymentRefundService.queryOnlinePaymentRefund(refundReqBO);
            if (dycPingAnQueryOnlinePaymentRefundRspBO != null) {
                if ("T0000".equals(dycPingAnQueryOnlinePaymentRefundRspBO.getTxnReturnCode())) {
                    fscPingAnOnlinePaymentInfoBO.setOrderStatus(Integer.valueOf(Integer.parseInt(dycPingAnQueryOnlinePaymentRefundRspBO.getReturnOrderStatus())));
                    if (dycPingAnQueryOnlinePaymentRefundRspBO.getReturnOrderStatus().equals("1")) {
                        rspBO.setRefundStatus(true);
                    } else {
                        rspBO.setRefundStatus(false);
                        fscPingAnOnlinePaymentInfoBO.setExtend1("\u9000\u6b3e\u5931\u8d25");
                    }
                } else {
                    rspBO.setRefundStatus(false);
                    fscPingAnOnlinePaymentInfoBO.setExtend1(dycPingAnQueryOnlinePaymentRefundRspBO.getTxnReturnMsg());
                    log.error("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)((Object)dycPingAnQueryOnlinePaymentRefundRspBO)));
                }
            } else {
                rspBO.setRefundStatus(false);
                fscPingAnOnlinePaymentInfoBO.setExtend1("\u9000\u6b3e\u5931\u8d25");
            }
            BeanUtils.copyProperties((Object)fscPingAnOnlinePaymentInfoBO, (Object)fscOnlinePaymentAbilityReqBO);
            this.fscOnlinePaymentUpdateAbilityService.onlinePaymentUpdate(fscOnlinePaymentAbilityReqBO);
            return rspBO;
        }
        infoBOList = infoBOList.stream().filter(info -> info.getOrderStatus() == 1).collect(Collectors.toList());
        List<FscPingAnOnlinePaymentInfoBO> refundOrderList = infoBOList.stream().filter(info -> info.getOrderType() == 2).collect(Collectors.toList());
        FscPingAnOnlinePaymentInfoBO fscPingAnOnlinePaymentInfoBO = this.processRefund(refundOrderList, infoBOList, reqBO);
        fscOnlinePaymentAbilityReqBO.setTraderNo(this.TRADE_NO);
        fscOnlinePaymentAbilityReqBO.setOrderId(reqBO.getOrderId());
        fscOnlinePaymentAbilityReqBO.setSaleOrderId(fscPingAnOnlinePaymentInfoBO.getSaleOrderId());
        fscOnlinePaymentAbilityReqBO.setAfOrderId(reqBO.getAfOrderId());
        fscOnlinePaymentAbilityReqBO.setOrderNo(fscPingAnOnlinePaymentInfoBO.getOrderNo());
        fscOnlinePaymentAbilityReqBO.setTranAmt(reqBO.getRefundAmount());
        fscOnlinePaymentAbilityReqBO.setOrderType(Integer.valueOf(2));
        fscOnlinePaymentAbilityReqBO.setOrderSendTime(new Date());
        fscOnlinePaymentAbilityReqBO.setOrderStatus(Integer.valueOf(0));
        fscOnlinePaymentAbilityReqBO.setPayModeNo(fscPingAnOnlinePaymentInfoBO.getPayModeNo());
        fscOnlinePaymentAbilityReqBO.setPayModeCode(fscPingAnOnlinePaymentInfoBO.getPayModeCode());
        fscOnlinePaymentAbilityReqBO.setPayerInfo(fscPingAnOnlinePaymentInfoBO.getPayerInfo());
        fscOnlinePaymentAbilityReqBO.setCreateTime(new Date());
        fscOnlinePaymentAbilityReqBO.setUserId(reqBO.getUserId());
        fscOnlinePaymentAbilityReqBO.setUserName(reqBO.getName());
        fscOnlinePaymentAbilityReqBO.setIsDel(Integer.valueOf(0));
        fscOnlinePaymentAbilityReqBO.setOrderRemark(fscPingAnOnlinePaymentInfoBO.getOrderRemark());
        this.settingRefundSubOrderInfo(fscOnlinePaymentAbilityReqBO, reqBO);
        FscOnlinePaymentAbilityRspBO fscOnlinePaymentAbilityRspBO = this.fscOnlinePaymentSaveAbilityService.onlinePaymentSave(fscOnlinePaymentAbilityReqBO);
        if (!Objects.equals(fscOnlinePaymentAbilityRspBO.getRespCode(), "0000")) {
            throw new ZTBusinessException("\u4fdd\u5b58\u8ba2\u5355\u5f02\u5e38");
        }
        fscOnlinePaymentAbilityReqBO.setId(fscOnlinePaymentAbilityRspBO.getId());
        DycPingAnRefundOnlinePaymentReqBO refundReqBO = new DycPingAnRefundOnlinePaymentReqBO();
        refundReqBO.setOldOrderSendTime(fscPingAnOnlinePaymentInfoBO.getOrderSendTime());
        refundReqBO.setReturnOrderSendTime(fscOnlinePaymentAbilityReqBO.getOrderSendTime());
        refundReqBO.setTraderNo(this.TRADE_NO);
        refundReqBO.setCnsmrSeqNo(fscOnlinePaymentAbilityRspBO.getCnsmrSeqNo());
        refundReqBO.setReturnOrderNo(fscOnlinePaymentAbilityRspBO.getTraderOrderNo());
        refundReqBO.setOrderName(reqBO.getRefundReason());
        refundReqBO.setOldMerOrderNo(fscPingAnOnlinePaymentInfoBO.getTraderOrderNo());
        refundReqBO.setReturnAmt(reqBO.getRefundAmount().toString());
        refundReqBO.setRefundRemark(fscOnlinePaymentAbilityRspBO.getOrderRemark());
        DycPingAnRefundOnlinePaymentRspBO dycPingAnRefundOnlinePaymentRspBO = null;
        try {
            dycPingAnRefundOnlinePaymentRspBO = this.dycRefundOnlinePaymentService.refundOnlinePayment(refundReqBO);
            log.info("\u9000\u6b3e\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)((Object)dycPingAnRefundOnlinePaymentRspBO)));
            if (dycPingAnRefundOnlinePaymentRspBO != null) {
                if ("T0000".equals(dycPingAnRefundOnlinePaymentRspBO.getTxnReturnCode())) {
                    fscOnlinePaymentAbilityReqBO.setOrderStatus(Integer.valueOf(Integer.parseInt(dycPingAnRefundOnlinePaymentRspBO.getReturnOrderStatus())));
                    if (dycPingAnRefundOnlinePaymentRspBO.getReturnOrderStatus().equals("1")) {
                        rspBO.setRefundStatus(true);
                    } else {
                        rspBO.setRefundStatus(false);
                        fscOnlinePaymentAbilityReqBO.setExtend1("\u9000\u6b3e\u5931\u8d25");
                    }
                } else {
                    rspBO.setRefundStatus(false);
                    fscOnlinePaymentAbilityReqBO.setExtend1(dycPingAnRefundOnlinePaymentRspBO.getTxnReturnMsg());
                    log.error("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)((Object)dycPingAnRefundOnlinePaymentRspBO)));
                }
            } else {
                rspBO.setRefundStatus(false);
                fscOnlinePaymentAbilityReqBO.setExtend1("\u9000\u6b3e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            rspBO.setRefundStatus(false);
            fscOnlinePaymentAbilityReqBO.setExtend1("\u9000\u6b3e\u5931\u8d25");
        }
        this.fscOnlinePaymentUpdateAbilityService.onlinePaymentUpdate(fscOnlinePaymentAbilityReqBO);
        return rspBO;
    }

    private void settingRefundSubOrderInfo(FscOnlinePaymentAbilityReqBO fscOnlinePaymentAbilityReqBO, DycUocOnlinePaymentRefundReqBO reqBO) {
        String orderRemark = fscOnlinePaymentAbilityReqBO.getOrderRemark();
        List dycPingAnSubOrderInfos = JSON.parseArray((String)orderRemark, DycPingAnSubOrderInfo.class);
        DycPingAnSubOrderInfo dycPingAnSubOrderInfo = (DycPingAnSubOrderInfo)dycPingAnSubOrderInfos.get(0);
        List<DycPingAnSubOrderInfo.SubOrder> orderList = dycPingAnSubOrderInfo.getOderlist();
        DycPingAnSubOrderInfo.SubOrder subOrder = orderList.stream().filter(o -> o.getSuborderId().equals(fscOnlinePaymentAbilityReqBO.getSaleOrderId().toString())).findAny().orElseThrow(() -> new NoSuchElementException("\u672a\u67e5\u8be2\u5230\u5b50\u8ba2\u5355\u4fe1\u606f"));
        ArrayList<DycPingAnSubOrderInfo.SubOrder> refundSubOrderList = new ArrayList<DycPingAnSubOrderInfo.SubOrder>();
        DycPingAnSubOrderInfo.SubOrder refundSubOrder = new DycPingAnSubOrderInfo.SubOrder();
        refundSubOrder.setSubAccNo(subOrder.getSubAccNo());
        refundSubOrder.setRefundModel("1");
        refundSubOrder.setRefundTranFee("0.00");
        refundSubOrder.setSubrefundamt(new BigDecimal(fscOnlinePaymentAbilityReqBO.getTranAmt().toString()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP).toString());
        refundSubOrder.setSuborderId(subOrder.getSuborderId());
        if (subOrder.getSuborderId().equals(reqBO.getSaleOrderId().toString())) {
            refundSubOrder.setSubrefundId("R" + subOrder.getSuborderId());
        } else {
            refundSubOrder.setSubrefundId("R" + reqBO.getSaleOrderId());
        }
        refundSubOrder.setObject("\u9000\u6b3e");
        refundSubOrderList.add(refundSubOrder);
        dycPingAnSubOrderInfo.setOderlist(refundSubOrderList);
        fscOnlinePaymentAbilityReqBO.setOrderRemark(JSON.toJSONString(Collections.singletonList(dycPingAnSubOrderInfo)));
    }

    private FscPingAnOnlinePaymentInfoBO processRefund(List<FscPingAnOnlinePaymentInfoBO> refundOrderList, List<FscPingAnOnlinePaymentInfoBO> infoBOList, DycUocOnlinePaymentRefundReqBO reqBO) {
        FscPingAnOnlinePaymentInfoBO payInfo;
        Long saleOrderId = reqBO.getSaleOrderId();
        Long orderId = reqBO.getOrderId();
        Long refundAmount = reqBO.getRefundAmount();
        if (!refundOrderList.isEmpty()) {
            Long refundAmountSum = refundOrderList.stream().mapToLong(FscPingAnOnlinePaymentInfoBO::getTranAmt).sum();
            String payId = refundOrderList.get(0).getExtend5();
            payInfo = infoBOList.stream().filter(info -> info.getId().equals(Long.parseLong(payId))).findAny().orElseThrow(() -> new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u8bb0\u5f55"));
            if (payInfo.getTranAmt() < refundAmount + refundAmountSum) {
                throw new ZTBusinessException("\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u652f\u4ed8\u91d1\u989d");
            }
        } else {
            payInfo = infoBOList.get(0);
            if (payInfo.getTranAmt() < refundAmount) {
                throw new ZTBusinessException("\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u652f\u4ed8\u91d1\u989d");
            }
        }
        String orderRemark = payInfo.getOrderRemark();
        List dycPingAnSubOrderInfos = JSON.parseArray((String)orderRemark, DycPingAnSubOrderInfo.class);
        DycPingAnSubOrderInfo dycPingAnSubOrderInfo = (DycPingAnSubOrderInfo)dycPingAnSubOrderInfos.get(0);
        List<DycPingAnSubOrderInfo.SubOrder> oderlist = dycPingAnSubOrderInfo.getOderlist();
        DycPingAnSubOrderInfo.SubOrder subOrder = this.getSubOrderInfo(orderId, saleOrderId, oderlist);
        String subAmountStr = subOrder.getSubamount();
        long subAmount = new BigDecimal(subAmountStr).multiply(new BigDecimal(100)).longValue();
        List<FscPingAnOnlinePaymentInfoBO> relatedRefundOrders = refundOrderList.stream().filter(info -> info.getSaleOrderId().equals(Long.parseLong(subOrder.getSuborderId()))).collect(Collectors.toList());
        this.checkRefundAmount(subAmount, refundAmount, relatedRefundOrders);
        payInfo.setSaleOrderId(Long.valueOf(Long.parseLong(subOrder.getSuborderId())));
        return payInfo;
    }

    private DycPingAnSubOrderInfo.SubOrder getSubOrderInfo(Long orderId, Long saleOrderId, List<DycPingAnSubOrderInfo.SubOrder> oderlist) {
        Optional<DycPingAnSubOrderInfo.SubOrder> any = oderlist.stream().filter(sub -> sub.getSuborderId().equals(saleOrderId.toString())).findAny();
        if (any.isPresent()) {
            return any.get();
        }
        UocGetOrderAllDetailServiceExtReqBo orderQryBo = new UocGetOrderAllDetailServiceExtReqBo();
        orderQryBo.setOrderId(orderId);
        DycUocOrdeDetailListQryExtFuncRspBo orderQryRspBo = this.dycUocOrdeDetailListQryExtFunction.qryOrderDetail(orderQryBo);
        if (orderQryRspBo == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        List<DycUocSaleOrderInfoFuncRspBo> saleOrderBOS = orderQryRspBo.getSaleOrderBOS();
        if (saleOrderBOS.isEmpty()) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5b50\u8ba2\u5355\u4fe1\u606f");
        }
        DycUocSaleOrderInfoFuncRspBo subOrderInfo = this.getSubOrderId(saleOrderId, saleOrderBOS);
        Long saleOrderId1 = subOrderInfo.getSaleOrderId();
        return oderlist.stream().filter(sub -> sub.getSuborderId().equals(saleOrderId1.toString())).findAny().orElseThrow(() -> new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5b50\u8ba2\u5355\u4fe1\u606f"));
    }

    private DycUocSaleOrderInfoFuncRspBo getSubOrderId(Long saleOrderId, List<DycUocSaleOrderInfoFuncRspBo> saleOrderBOS) {
        DycUocSaleOrderInfoFuncRspBo subOrderInfo = saleOrderBOS.stream().filter(saleOrder -> saleOrder.getSaleOrderId().equals(saleOrderId)).findAny().orElseThrow(() -> new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5b50\u8ba2\u5355\u4fe1\u606f"));
        if (null != subOrderInfo.getUpperOrderId()) {
            return this.getSubOrderId(subOrderInfo.getUpperOrderId(), saleOrderBOS);
        }
        return subOrderInfo;
    }

    private void checkRefundAmount(long subAmount, long refundAmount, List<FscPingAnOnlinePaymentInfoBO> collect) {
        long refundAmountSum = 0L;
        if (!collect.isEmpty()) {
            refundAmountSum = collect.stream().mapToLong(FscPingAnOnlinePaymentInfoBO::getTranAmt).sum();
        }
        if (subAmount < refundAmountSum + refundAmount) {
            throw new ZTBusinessException("\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u652f\u4ed8\u91d1\u989d");
        }
    }

    private void checkParam(DycUocOnlinePaymentRefundReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new ZTBusinessException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleOrderId() == null) {
            throw new ZTBusinessException("\u5b50\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getRefundAmount() == null) {
            throw new ZTBusinessException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

