/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycPingAnQueryOnlinePaymentRefundFunction;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnExtendData;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnQueryOnlinePaymentRefundReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnQueryOnlinePaymentRefundRspBO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycPingAnQueryOnlinePaymentRefundFunctionImpl
implements DycPingAnQueryOnlinePaymentRefundFunction {
    private static final Logger log = LoggerFactory.getLogger(DycPingAnQueryOnlinePaymentRefundFunctionImpl.class);
    @Value(value="${ESB_QUERY_PAYMENT_REFUND_ORDER_URL}")
    private String esbQueryPaymentRefundOrderUrl;

    @Override
    public DycPingAnQueryOnlinePaymentRefundRspBO queryOnlinePaymentRefund(DycPingAnQueryOnlinePaymentRefundReqBO reqBO) {
        DycPingAnQueryOnlinePaymentRefundRspBO rspBO = new DycPingAnQueryOnlinePaymentRefundRspBO();
        this.checkParam(reqBO);
        reqBO.setReqKey(System.currentTimeMillis());
        log.info("\u67e5\u8be2\u5355\u7b14\u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqBO));
        String res = HttpUtil.post((String)this.esbQueryPaymentRefundOrderUrl, (String)JSON.toJSONString((Object)reqBO));
        log.info("\u67e5\u8be2\u5355\u7b14\u9000\u6b3e\u8ba2\u5355\u8fd4\u56de:{}", (Object)res);
        if (StringUtils.isBlank((CharSequence)res)) {
            throw new ZTBusinessException("\u9000\u6b3e\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        JSONObject jsonObject = JSON.parseObject((String)res);
        Object dataObj = jsonObject.get((Object)"Data");
        if (dataObj != null) {
            rspBO = (DycPingAnQueryOnlinePaymentRefundRspBO)((Object)JSON.parseObject((String)dataObj.toString(), (TypeReference)new TypeReference<DycPingAnQueryOnlinePaymentRefundRspBO>(){}, (Feature[])new Feature[0]));
            String txnReturnCode = rspBO.getTxnReturnCode();
            if (!"T0000".equals(txnReturnCode)) {
                throw new ZTBusinessException(rspBO.getTxnReturnMsg());
            }
        } else {
            dataObj = jsonObject.get((Object)"ExtendData");
            if (dataObj == null) {
                log.error("\u67e5\u8be2\u5355\u7b14\u9000\u6b3e\u8ba2\u5355\u5931\u8d25:{}", (Object)res);
                throw new ZTBusinessException("\u67e5\u8be2\u5355\u7b14\u9000\u6b3e\u8ba2\u5355\u5931\u8d25");
            }
            DycPingAnExtendData data = (DycPingAnExtendData)JSON.parseObject((String)dataObj.toString(), (TypeReference)new TypeReference<DycPingAnExtendData>(){}, (Feature[])new Feature[0]);
            rspBO.setTxnReturnMsg(data.getTxnReturnMsg());
            rspBO.setTxnReturnCode(data.getTxnReturnCode());
        }
        return rspBO;
    }

    private void checkParam(DycPingAnQueryOnlinePaymentRefundReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTraderNo())) {
            throw new ZTBusinessException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getReturnOrderNo())) {
            throw new ZTBusinessException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getReturnOrderSendTime())) {
            throw new ZTBusinessException("\u8ba2\u5355\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

