/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.estore.order.api.DycUocOaAuditOrderSyncFunction;
import com.tydic.dyc.atom.estore.order.bo.DycUocOaAuditOrderSyncFuncReqBO;
import com.tydic.dyc.atom.estore.order.bo.DycUocOaAuditOrderSyncFuncRspBO;
import com.tydic.dyc.oc.service.order.UocGetPurchaseSyncOrderListService;
import com.tydic.dyc.oc.service.order.bo.UocGetPurchaseSyncOrderListReqBo;
import com.tydic.dyc.oc.service.order.bo.UocGetPurchaseSyncOrderListRspBo;
import com.tydic.dyc.oc.service.order.bo.UocPurchaseSyncOrderBo;
import com.tydic.dyc.oc.service.order.bo.UocSyncOrderBo;
import com.tydic.umc.general.ability.api.UmcDycEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityRspBO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUocOaAuditOrderSyncFunctionImpl
implements DycUocOaAuditOrderSyncFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocOaAuditOrderSyncFunctionImpl.class);
    @Autowired
    private UocGetPurchaseSyncOrderListService uocGetPurchaseSyncOrderListService;
    @Autowired
    private UmcDycEnterpriseOrgQryDetailAbilityService umcDycEnterpriseOrgQryDetailAbilityService;
    @Value(value="${caigouyun.apiId}")
    private String apiId;
    @Value(value="${caigouyun.szPro.apiId}")
    private String szProApiId;
    @Value(value="${caigouyun.apiVersion}")
    private String apiVersion;
    @Value(value="${caigouyun.appSubId}")
    private String appSubId;
    @Value(value="${caigouyun.appToken}")
    private String appToken;
    @Value(value="${caigouyun.env}")
    private String env;
    @Value(value="${caigouyun.partnerId}")
    private String partnerId;
    @Value(value="${caigouyun.sign}")
    private String sign;
    @Value(value="${caigouyun.sysId}")
    private String sysId;
    @Value(value="${caigouyun.timeStamp}")
    private String timeStamp;
    @Value(value="${caigouyun.userToken}")
    private String userToken;
    @Value(value="${ESB_SYNC_SZ_ORDER_URL}")
    private String ESB_SYNC_SZ_ORDER_URL;
    @Value(value="${ESB_SYNC_SZ_PRO_URL}")
    private String ESB_SYNC_SZ_PRO_URL;
    @Value(value="${pcApproveUrl:http://10.200.199.100/lowCodeRelease/#/62c3b162f1efb866c492d049?orderId=}")
    private String pcApproveUrl;

    @Override
    public DycUocOaAuditOrderSyncFuncRspBO syncOaAuditOrder(DycUocOaAuditOrderSyncFuncReqBO reqBo) {
        int i;
        DycUocOaAuditOrderSyncFuncRspBO rspBO = new DycUocOaAuditOrderSyncFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocGetPurchaseSyncOrderListReqBo purSyncOrderListReqBo = new UocGetPurchaseSyncOrderListReqBo();
        UocGetPurchaseSyncOrderListRspBo purSyncOrderListRspBo = this.uocGetPurchaseSyncOrderListService.getPurchaseSyncOrderList(purSyncOrderListReqBo);
        if (purSyncOrderListRspBo.getPageTotal() >= 1) {
            for (i = 1; i <= purSyncOrderListRspBo.getPageTotal(); ++i) {
                List purchaseSyncOrderBoList = (List)purSyncOrderListRspBo.getPagePurchaseSyncOrderBoMap().get(i);
                purchaseSyncOrderBoList.forEach(each -> {
                    each.setUrl(this.pcApproveUrl + each.getOrderId());
                    this.setRegionCode((UocPurchaseSyncOrderBo)each, null);
                });
                this.sendPurchaseHttpRequest(purchaseSyncOrderBoList, rspBO);
            }
        }
        if (purSyncOrderListRspBo.getTotal() >= 1) {
            for (i = 1; i <= purSyncOrderListRspBo.getTotal(); ++i) {
                List syncOrderBoList = (List)purSyncOrderListRspBo.getPageSyncOrderBoMap().get(i);
                syncOrderBoList.forEach(each -> {
                    each.setUrl(this.pcApproveUrl + each.getId());
                    this.setRegionCode(null, (UocSyncOrderBo)each);
                });
                this.sendOrderHttpRequest(syncOrderBoList, rspBO);
            }
        }
        return rspBO;
    }

    private void setRegionCode(UocPurchaseSyncOrderBo purchaseSyncOrderBo, UocSyncOrderBo syncOrderBo) {
        try {
            UmcDycEnterpriseOrgQryDetailAbilityReqBO orgQryDetailAbilityReqBO = new UmcDycEnterpriseOrgQryDetailAbilityReqBO();
            orgQryDetailAbilityReqBO.setOrgIdWeb(null != purchaseSyncOrderBo ? Long.valueOf(purchaseSyncOrderBo.getDemandUnitId()) : Long.valueOf(syncOrderBo.getPurchaseOrgId()));
            UmcDycEnterpriseOrgQryDetailAbilityRspBO orgQryDetailAbilityRspBO = this.umcDycEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(orgQryDetailAbilityReqBO);
            log.info("\u67e5\u8be2\u4f1a\u5458\u673a\u6784\u8be6\u60c5\u51fa\u53c2\u62a5\u6587: {}", (Object)JSON.toJSONString((Object)orgQryDetailAbilityRspBO));
            if (null != orgQryDetailAbilityRspBO && null != orgQryDetailAbilityRspBO.getEnterpriseOrgBO()) {
                if (null != purchaseSyncOrderBo) {
                    purchaseSyncOrderBo.setRegionCode(orgQryDetailAbilityRspBO.getEnterpriseOrgBO().getOrgCode());
                }
                if (null != syncOrderBo) {
                    syncOrderBo.setRegionCode(orgQryDetailAbilityRspBO.getEnterpriseOrgBO().getOrgCode());
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f1a\u5458\u673a\u6784\u8be6\u60c5\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }

    private void sendPurchaseHttpRequest(List<UocPurchaseSyncOrderBo> rows, DycUocOaAuditOrderSyncFuncRspBO rspBO) {
        String sendUrl = this.ESB_SYNC_SZ_ORDER_URL;
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString(rows));
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u540c\u6b65\u8bf7\u6c42\u5730\u5740:{}", (Object)sendUrl);
        String result = "";
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject request = new JSONObject();
            this.putApiAttrs(request, false);
            request.put("REQUEST_DATA", rows);
            jsonObject.put("REQUEST", (Object)request);
            log.info("\u91c7\u8d2d\u5355\u540c\u6b65\u8bf7\u6c42ESB\u62a5\u6587: {}", (Object)jsonObject.toJSONString());
            result = DycEsbUtil.doPostReuest((String)sendUrl, (String)jsonObject.toJSONString());
            log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u540c\u6b65\u51fa\u53c2: " + result);
        }
        catch (RuntimeException e) {
            log.error("\u91c7\u8d2d\u7533\u8bf7\u5355\u540c\u6b65\u5931\u8d25:{}", (Object)e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
    }

    private void sendOrderHttpRequest(List<UocSyncOrderBo> rows, DycUocOaAuditOrderSyncFuncRspBO rspBO) {
        String sendUrl = this.ESB_SYNC_SZ_PRO_URL;
        log.info("\u8ba2\u5355\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString(rows));
        log.info("\u8ba2\u5355\u540c\u6b65\u8bf7\u6c42\u5730\u5740:{}", (Object)sendUrl);
        String result = "";
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject request = new JSONObject();
            this.putApiAttrs(request, true);
            request.put("REQUEST_DATA", rows);
            jsonObject.put("REQUEST", (Object)request);
            log.info("\u8ba2\u5355\u540c\u6b65\u8bf7\u6c42ESB\u62a5\u6587: {}", (Object)jsonObject.toJSONString());
            result = DycEsbUtil.doPostReuest((String)sendUrl, (String)jsonObject.toJSONString());
            log.info("\u8ba2\u5355\u540c\u6b65\u51fa\u53c2: " + result);
        }
        catch (RuntimeException e) {
            log.error("\u8ba2\u5355\u540c\u6b65\u5931\u8d25:{}", (Object)e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
    }

    private void putApiAttrs(JSONObject request, Boolean isOrder) {
        JSONObject apiAttrs = new JSONObject();
        if (isOrder.booleanValue()) {
            apiAttrs.put("Api_ID", (Object)this.apiId);
        } else {
            apiAttrs.put("Api_ID", (Object)this.szProApiId);
        }
        apiAttrs.put("Api_Version", (Object)this.apiVersion);
        apiAttrs.put("App_Sub_ID", (Object)this.appSubId);
        apiAttrs.put("App_Token", (Object)this.appToken);
        apiAttrs.put("ENV", (Object)this.env);
        apiAttrs.put("Partner_ID", (Object)this.partnerId);
        apiAttrs.put("Sign", (Object)this.sign);
        apiAttrs.put("Sys_ID", (Object)this.sysId);
        apiAttrs.put("Time_Stamp", (Object)new Date());
        apiAttrs.put("User_Token", (Object)this.userToken);
        request.put("API_ATTRS", (Object)apiAttrs);
    }
}

