/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.order.impl;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.atom.base.constants.UocConstant;
import com.tydic.dyc.atom.estore.order.api.DycUocAuditApplySyncOaFunction;
import com.tydic.dyc.atom.estore.order.bo.DycApiAttrs;
import com.tydic.dyc.atom.estore.order.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.estore.order.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.estore.order.bo.DycIvInput;
import com.tydic.dyc.atom.estore.order.bo.DycOARelSend;
import com.tydic.dyc.atom.estore.order.bo.DycRanqiSendBO;
import com.tydic.dyc.atom.estore.order.bo.DycRequest;
import com.tydic.dyc.atom.estore.order.bo.DycRequestData;
import com.tydic.dyc.atom.estore.order.bo.DycUocAuditApplySyncOaFuncReqBO;
import com.tydic.dyc.atom.estore.order.bo.DycUocAuditApplySyncOaFuncRspBO;
import com.tydic.dyc.atom.estore.order.bo.DycUocAuditApplySyncOaSendBO;
import com.tydic.dyc.atom.estore.order.bo.DycUocAuditApplySyncOaSendRspBO;
import com.tydic.dyc.atom.estore.order.bo.DycUocOrdeDetailQryFuncReqBO;
import com.tydic.dyc.atom.estore.order.bo.DycUocOrdeDetailQryFuncRspBO;
import com.tydic.dyc.atom.estore.order.bo.DycUocOrderCommodityInfoFuncBO;
import com.tydic.dyc.atom.estore.order.bo.zhidi.DycZhidiFlag;
import com.tydic.dyc.atom.estore.order.bo.zhidi.DycZhidiKeyTask;
import com.tydic.dyc.atom.estore.order.bo.zhidi.DycZhidiOaAttachment;
import com.tydic.dyc.atom.estore.order.bo.zhidi.DycZhidiSendBO;
import com.tydic.dyc.atom.estore.order.bo.zhidi.DycZhidiValue;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.service.domainservice.UocApproveCreateService;
import com.tydic.dyc.oc.service.domainservice.UocApproveQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveQryServiceInfo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveQryServiceRspBo;
import com.tydic.dyc.oc.service.order.UocGetOrderAllDetailService;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspOrderCommInfoBo;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocAuditApplySyncOaFunctionImpl
implements DycUocAuditApplySyncOaFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocAuditApplySyncOaFunctionImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;
    @Autowired
    private UocApproveCreateService uocApproveCreateService;
    @Autowired
    private UocApproveQryService uocApproveQryService;
    @Value(value="${qry.url}")
    private String generalQueryUrl;
    @Autowired
    private UocGetOrderAllDetailService uocGetOrderAllDetailService;
    @Value(value="${pcApproveUrl:http://10.200.199.100/lowCodeRelease/#/62c3b162f1efb866c492d049?orderId=}")
    private String pcApproveUrl;
    @Value(value="${mobileApproveUrl:http://10.200.199.100/lowCodeRelease/#/62c3b162f1efb866c492d049?orderId=}")
    private String mobileApproveUrl;
    @Value(value="${yibaoOaAbilityUrl:http://10.200.195.105:8001/OSN/api/synchronization/v1}")
    private String yibaoOaAbilityUrl;
    @Value(value="${ranqiOaAbilityUrl:http://10.200.195.105:8001/OSN/api/gasOaSync/v1}")
    private String ranqiOaAbilityUrl;
    @Value(value="${zhidiOaAbilityUrl:http://10.200.195.105:8001/OSN/api/gasOaSync/v1}")
    private String zhidiOaAbilityUrl;
    @Value(value="${yibao.OrgName:\u91c7\u8d2d\u673a\u6784}")
    private String yibaoOrgName;
    @Value(value="${yibao.apiId:Cestbon.OA.OA.forSZSC}")
    private String yibaoApiId;
    @Value(value="${ranqi.OrgName:\u71c3\u6c14}")
    private String ranqiOrgName;
    @Value(value="${ranqi.apiId:crgas.gasoa.gasoauat.srmtooa}")
    private String ranqiApiId;
    @Value(value="${zhidi.OrgName:\u7f6e\u5730}")
    private String zhidiOrgName;
    @Value(value="${zhidi.apiId:crl.oa.oaszjh.websvcdoszlxcg}")
    private String zhidiApiId;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossFileUrl;
    private static final String PATH = "uoc";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @Override
    public DycUocAuditApplySyncOaFuncRspBO dealAuditSync(DycUocAuditApplySyncOaFuncReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getOaOperType()) || "null".equals(reqBO.getOaOperType())) {
            reqBO.setOaOperType("NEW");
        }
        reqBO.setSubject("\u96f6\u661f\u91c7\u8d2d\u7533\u8bf7\u5355");
        DycUocAuditApplySyncOaSendBO sendBO = new DycUocAuditApplySyncOaSendBO();
        this.buildLotNum(reqBO, sendBO);
        sendBO.setSubject(reqBO.getSubject());
        sendBO.setModule("CRC_ORDER");
        sendBO.setOperateType(reqBO.getOaOperType());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sendBO.setCreationDate(dateFormat.format(new Date()));
        sendBO.setPcApproveUrl(this.pcApproveUrl + reqBO.getOrderId());
        sendBO.setMobileApproveUrl(this.mobileApproveUrl + reqBO.getOrderId());
        this.buildPro(reqBO, sendBO);
        String twoOrgName = this.buildWithUmc(reqBO, sendBO);
        if (this.yibaoOrgName.equals(twoOrgName)) {
            DycOARelSend oaSend = this.getDycOARelSend(sendBO);
            log.info("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6021\u5b9d\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)oaSend));
            String res = HttpUtil.post((String)this.yibaoOaAbilityUrl, (String)JSON.toJSONString((Object)oaSend));
            log.info("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6021\u5b9d\u51fa\u53c2\uff1a{}", (Object)res);
            DycUocAuditApplySyncOaSendRspBO dycUocAuditApplySyncOaSendRspBO = (DycUocAuditApplySyncOaSendRspBO)JSON.parseObject((String)res, DycUocAuditApplySyncOaSendRspBO.class);
            if (!"0000".equals(dycUocAuditApplySyncOaSendRspBO.getReturnCode())) {
                throw new ZTBusinessException("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u6021\u5b9d\u5f02\u5e38\uff1a" + dycUocAuditApplySyncOaSendRspBO.getReturnDesc());
            }
        } else if (this.ranqiOrgName.equals(twoOrgName)) {
            DycRanqiSendBO dycRanqiSendBO = (DycRanqiSendBO)JUtil.js((Object)sendBO, DycRanqiSendBO.class);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            dycRanqiSendBO.setTimeStamp(sdf.format(new Date()));
            log.info("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u71c3\u6c14\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dycRanqiSendBO));
            String res = HttpUtil.post((String)this.ranqiOaAbilityUrl, (String)JSON.toJSONString((Object)dycRanqiSendBO));
            log.info("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u71c3\u6c14\u51fa\u53c2\uff1a{}", (Object)res);
            DycUocAuditApplySyncOaSendRspBO dycUocAuditApplySyncOaSendRspBO = (DycUocAuditApplySyncOaSendRspBO)JSON.parseObject((String)res, DycUocAuditApplySyncOaSendRspBO.class);
            if (!"0000".equals(dycUocAuditApplySyncOaSendRspBO.getReturnCode())) {
                throw new ZTBusinessException("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u71c3\u6c14\u5f02\u5e38\uff1a" + dycUocAuditApplySyncOaSendRspBO.getReturnDesc());
            }
        } else if (this.zhidiOrgName.equals(twoOrgName)) {
            DycZhidiSendBO dycZhidiSendBO = new DycZhidiSendBO();
            dycZhidiSendBO.setTimeStamp(sendBO.getTimeStamp());
            this.buildFlag(reqBO, sendBO, dycZhidiSendBO);
            DycZhidiValue dycZhidiValue = (DycZhidiValue)JUtil.js((Object)sendBO, DycZhidiValue.class);
            dycZhidiSendBO.setValue(dycZhidiValue);
            DycUocOrdeDetailQryFuncRspBO dycUocOrdeDetailQryFuncRspBO = this.buildKeyTask(reqBO, dycZhidiSendBO);
            DycZhidiOaAttachment dycZhidiOaAttachment = this.genAcceptPdf(dycUocOrdeDetailQryFuncRspBO);
            dycZhidiOaAttachment.setCreatedBy(sendBO.getCreatorName());
            dycZhidiOaAttachment.setCreationDate(sendBO.getCreationDate());
            ArrayList<DycZhidiOaAttachment> dycZhidiOaAttachments = new ArrayList<DycZhidiOaAttachment>();
            dycZhidiOaAttachments.add(dycZhidiOaAttachment);
            dycZhidiSendBO.setAttachments(dycZhidiOaAttachments);
            log.info("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u7f6e\u5730\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dycZhidiSendBO));
            String res = HttpUtil.post((String)this.zhidiOaAbilityUrl, (String)JSON.toJSONString((Object)dycZhidiSendBO));
            log.info("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u7f6e\u5730\u51fa\u53c2\uff1a{}", (Object)res);
            DycUocAuditApplySyncOaSendRspBO dycUocAuditApplySyncOaSendRspBO = (DycUocAuditApplySyncOaSendRspBO)JSON.parseObject((String)res, DycUocAuditApplySyncOaSendRspBO.class);
            if (!"0000".equals(dycUocAuditApplySyncOaSendRspBO.getReturnCode())) {
                throw new ZTBusinessException("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u7f6e\u5730\u5f02\u5e38\uff1a" + dycUocAuditApplySyncOaSendRspBO.getReturnDesc());
            }
        } else {
            throw new ZTBusinessException("\u8be5\u7528\u6237\u4e8c\u7ea7\u673a\u6784\u4e0d\u5c5e\u4e8e\u3010\u6021\u5b9d\u3001\u71c3\u6c14\u6216\u7f6e\u5730\u3011\uff0c\u6216apollo\u914d\u7f6eorgName\u9519\u8bef");
        }
        DycUocAuditApplySyncOaFuncRspBO rspBO = new DycUocAuditApplySyncOaFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private DycUocOrdeDetailQryFuncRspBO buildKeyTask(DycUocAuditApplySyncOaFuncReqBO reqBO, DycZhidiSendBO dycZhidiSendBO) {
        DycUocOrdeDetailQryFuncReqBO dycUocOrdeDetailQryFuncReqBO = new DycUocOrdeDetailQryFuncReqBO();
        dycUocOrdeDetailQryFuncReqBO.setOrderId(reqBO.getOrderId().toString());
        DycUocOrdeDetailQryFuncRspBO dycUocOrdeDetailQryFuncRspBO = this.qryOrderDetail(dycUocOrdeDetailQryFuncReqBO);
        ArrayList<DycZhidiKeyTask> dycZhidiKeyTasks = new ArrayList<DycZhidiKeyTask>(dycUocOrdeDetailQryFuncRspBO.getCommInfoBos().size());
        for (DycUocOrderCommodityInfoFuncBO commInfoBo : dycUocOrdeDetailQryFuncRspBO.getCommInfoBos()) {
            DycZhidiKeyTask dycZhidiKeyTask = new DycZhidiKeyTask();
            dycZhidiKeyTask.setSkuName(commInfoBo.getSkuName());
            dycZhidiKeyTask.setSkuId(commInfoBo.getSkuId());
            dycZhidiKeyTask.setSkuExtSkuId(commInfoBo.getSkuExtSkuId());
            dycZhidiKeyTask.setSalePrice(commInfoBo.getSalePrice());
            dycZhidiKeyTask.setPurchaseCount(commInfoBo.getPurchaseCount());
            dycZhidiKeyTask.setSettleUnit(commInfoBo.getSettleUnit());
            dycZhidiKeyTask.setSaleFee(commInfoBo.getSaleFee());
            dycZhidiKeyTask.setCmpOrderNo(commInfoBo.getCmpOrderNo());
            dycZhidiKeyTasks.add(dycZhidiKeyTask);
        }
        dycZhidiSendBO.setKeyTasks(dycZhidiKeyTasks);
        return dycUocOrdeDetailQryFuncRspBO;
    }

    private void buildFlag(DycUocAuditApplySyncOaFuncReqBO reqBO, DycUocAuditApplySyncOaSendBO sendBO, DycZhidiSendBO dycZhidiSendBO) {
        DycZhidiFlag dycZhidiFlag = new DycZhidiFlag();
        dycZhidiFlag.setSubject(sendBO.getSubject());
        dycZhidiFlag.setProcessBranch(sendBO.getProcessBranch());
        dycZhidiFlag.setModule(sendBO.getModule());
        switch (reqBO.getOaOperType()) {
            case "NEW": {
                dycZhidiFlag.setMessageType("ADD");
                break;
            }
            case "RESUBMIT": {
                dycZhidiFlag.setMessageType("UPDATE");
                break;
            }
            case "CANCEL": {
                dycZhidiFlag.setMessageType("DELETE");
                break;
            }
            default: {
                throw new ZTBusinessException("[OaOperType] \u5f02\u5e38");
            }
        }
        dycZhidiFlag.setTitle("");
        dycZhidiFlag.setCreatorLdap(sendBO.getCreatorLdap());
        dycZhidiSendBO.setFlag(dycZhidiFlag);
    }

    private DycOARelSend getDycOARelSend(DycUocAuditApplySyncOaSendBO sendBO) {
        DycIvInput ivInput = (DycIvInput)JUtil.js((Object)sendBO, DycIvInput.class);
        DycApiAttrs apiAttrs = (DycApiAttrs)JUtil.js((Object)sendBO, DycApiAttrs.class);
        DycOARelSend oaSend = new DycOARelSend();
        DycRequest dycRequest = new DycRequest();
        DycRequestData dycRequestData = new DycRequestData();
        dycRequestData.setIvInput(ivInput);
        dycRequest.setApiAttrs(apiAttrs);
        dycRequest.setRequestData(dycRequestData);
        oaSend.setRequest(dycRequest);
        return oaSend;
    }

    private String buildWithUmc(DycUocAuditApplySyncOaFuncReqBO reqBO, DycUocAuditApplySyncOaSendBO sendBO) {
        UmcQryMemLegalOrgInfoAbilityServiceReqBO umcQryMemLegalOrgInfoAbilityServiceReqBO = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
        umcQryMemLegalOrgInfoAbilityServiceReqBO.setMemId(reqBO.getUserId());
        log.info("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u4f1a\u5458\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceReqBO));
        UmcQryMemLegalOrgInfoAbilityServiceRspBO umcQryMemLegalOrgInfoAbilityServiceRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(umcQryMemLegalOrgInfoAbilityServiceReqBO);
        log.info("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u4f1a\u5458\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcQryMemLegalOrgInfoAbilityServiceRspBO));
        if (!"0000".equals(umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespCode())) {
            throw new ZTBusinessException("OA\u5ba1\u6279\u540c\u6b65\u8c03\u7528\u4f1a\u5458\u5f02\u5e38\uff1a" + umcQryMemLegalOrgInfoAbilityServiceRspBO.getRespDesc());
        }
        Long orgId = umcQryMemLegalOrgInfoAbilityServiceRspBO.getLegalOrgInfo().getOrgId();
        String orgName = umcQryMemLegalOrgInfoAbilityServiceRspBO.getLegalOrgInfo().getOrgName();
        sendBO.setLegalPersonUnit(orgId.toString());
        sendBO.setLegalPersonUnitName(orgName);
        String ldap = umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getRegAccount();
        sendBO.setCreatorLdap(ldap);
        String creatorName = umcQryMemLegalOrgInfoAbilityServiceRspBO.getMemInformation().getMemName2();
        sendBO.setCreatorName(creatorName);
        UmcEnterpriseOrgBO twoLevelOrgInfo = umcQryMemLegalOrgInfoAbilityServiceRspBO.getTwoLevelOrgInfo();
        String twoOrgName = twoLevelOrgInfo.getOrgName();
        if (this.yibaoOrgName.equals(twoOrgName)) {
            sendBO.setAppSubId("000000620002");
            sendBO.setAppToken("26cdbd321b084dedb991bbb72842489c");
            sendBO.setApiId(this.yibaoApiId);
            sendBO.setApiVersion("1.0");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            sendBO.setTimeStamp(sdf.format(new Date()));
            sendBO.setUserToken("");
            sendBO.setSign("NO_SIGN");
            sendBO.setPartnerId("00000000");
            sendBO.setSysId("00000062");
        } else if (this.ranqiOrgName.equals(twoOrgName)) {
            sendBO.setAppSubId("000000620002");
            sendBO.setAppToken("26cdbd321b084dedb991bbb72842489c");
            sendBO.setApiId(this.ranqiApiId);
            sendBO.setApiVersion("1.0");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            sendBO.setTimeStamp(sdf.format(new Date()));
            sendBO.setUserToken("");
            sendBO.setSign("NO_SIGN");
            sendBO.setPartnerId("00000000");
            sendBO.setSysId("00000062");
            String subject = creatorName + "\u96f6\u661f\u91c7\u8d2d\u7533\u8bf7" + sendBO.getLotNum() + "(" + orgName + ")";
            sendBO.setSubject(subject);
        } else if (this.zhidiOrgName.equals(twoOrgName)) {
            sendBO.setAppSubId("000000620002");
            sendBO.setAppToken("26cdbd321b084dedb991bbb72842489c");
            sendBO.setApiId(this.zhidiApiId);
            sendBO.setApiVersion("1.0");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            sendBO.setTimeStamp(sdf.format(new Date()));
            sendBO.setUserToken("");
            sendBO.setSign("NO_SIGN");
            sendBO.setPartnerId("00000000");
            sendBO.setSysId("00000062");
        }
        return twoOrgName;
    }

    private void buildPro(DycUocAuditApplySyncOaFuncReqBO reqBO, DycUocAuditApplySyncOaSendBO sendBO) {
        DycUocOrdeDetailQryFuncReqBO dycUocOrdeDetailQryFuncReqBO = new DycUocOrdeDetailQryFuncReqBO();
        dycUocOrdeDetailQryFuncReqBO.setOrderId(reqBO.getOrderId().toString());
        DycUocOrdeDetailQryFuncRspBO rspBO = this.qryOrderDetail(dycUocOrdeDetailQryFuncReqBO);
        sendBO.setProcessParameters(rspBO.getSaleStakeBos().get(0).getSupId());
        sendBO.setTotalNum(rspBO.getTotalSaleFee().setScale(2, RoundingMode.HALF_UP).toPlainString());
    }

    private void buildLotNum(DycUocAuditApplySyncOaFuncReqBO reqBO, DycUocAuditApplySyncOaSendBO sendBO) {
        if ("NEW".equals(reqBO.getOaOperType())) {
            String auditId = this.createAudit(reqBO);
            sendBO.setLotNum(auditId);
        } else if ("RESUBMIT".equals(reqBO.getOaOperType())) {
            this.buildOldeLotNum(reqBO, sendBO);
            String auditId = this.createAudit(reqBO);
            sendBO.setLotNum(auditId);
        } else if ("CANCEL".equals(reqBO.getOaOperType())) {
            this.buildOldeLotNum(reqBO, sendBO);
            Snowflake snowflake = new Snowflake((long)((int)(Math.random() * 10.0)), 0L);
            sendBO.setLotNum(snowflake.nextIdStr());
        } else {
            throw new ZTBusinessException("OA\u540c\u6b65\u6ca1\u6709\u5b9a\u4e49\u7684\u63d0\u4ea4\u7c7b\u578b\uff08\u4e0d\u5728NEW/\u9996\u6b21\u63d0\u4ea4 RESUBMIT/\u9a73\u56de\u518d\u6b21\u63d0\u4ea4  CANCEL/\u4f5c\u5e9f\u53d6\u6d88\u4e2d\uff09");
        }
    }

    private void buildOldeLotNum(DycUocAuditApplySyncOaFuncReqBO reqBO, DycUocAuditApplySyncOaSendBO sendBO) {
        UocApproveQryServiceReqBo uocApproveQryServiceReqBo = new UocApproveQryServiceReqBo();
        uocApproveQryServiceReqBo.setOrderId(reqBO.getOrderId());
        uocApproveQryServiceReqBo.setObjId(reqBO.getOrderId().toString());
        uocApproveQryServiceReqBo.setObjBusiType(UocConstant.OBJ_BUSI_TYPE.W_ORDER);
        uocApproveQryServiceReqBo.setObjType(UocConstant.OBJ_TYPE.ORDER);
        uocApproveQryServiceReqBo.setOrderBy("audit_order_id desc");
        UocApproveQryServiceRspBo rspBo = this.uocApproveQryService.qryApprove(uocApproveQryServiceReqBo);
        if (CollectionUtils.isEmpty((Collection)rspBo.getRows()) || rspBo.getRows().get(0) == null) {
            throw new ZTBusinessException("OA\u540c\u6b65\u5f02\u5e38\uff0c\u6ca1\u6709\u65e7\u7684\u5ba1\u6279\u5355");
        }
        Long oldAuditId = ((UocApproveQryServiceInfo)rspBo.getRows().get(0)).getAuditOrderId();
        sendBO.setOldLotNum(oldAuditId.toString());
    }

    private String createAudit(DycUocAuditApplySyncOaFuncReqBO reqBO) {
        UocApproveCreateServiceReqBo uocApproveCreateServiceReqBo = (UocApproveCreateServiceReqBo)JUtil.js((Object)((Object)reqBO), UocApproveCreateServiceReqBo.class);
        uocApproveCreateServiceReqBo.setOrderId(reqBO.getOrderId());
        uocApproveCreateServiceReqBo.setObjId(reqBO.getOrderId());
        uocApproveCreateServiceReqBo.setObjBusiType(UocConstant.OBJ_BUSI_TYPE.W_ORDER);
        uocApproveCreateServiceReqBo.setObjType(UocConstant.OBJ_TYPE.ORDER);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)uocApproveCreateServiceReqBo));
        UocApproveCreateServiceRspBo uocApproveCreateServiceRspBo = this.uocApproveCreateService.createApprove(uocApproveCreateServiceReqBo);
        if (!"0000".equals(uocApproveCreateServiceRspBo.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u521b\u5efa\u5ba1\u6279\u9519\u8bef\uff01\u5f02\u5e38\u7f16\u7801\u3010" + uocApproveCreateServiceRspBo.getRespCode() + "\u3011," + uocApproveCreateServiceRspBo.getRespDesc());
        }
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)uocApproveCreateServiceRspBo));
        return uocApproveCreateServiceRspBo.getAuditOrderId().toString();
    }

    private DycGeneralQueryFuncRspBO generalQuery(DycGeneralQueryFuncReqBO reqBO) {
        DycGeneralQueryFuncRspBO rspBO = new DycGeneralQueryFuncRspBO();
        log.info("\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        String responseStr = HttpUtil.post((String)this.generalQueryUrl, (String)JSON.toJSONString((Object)reqBO), (int)4000);
        log.info("\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u51fa\u53c2:{}", (Object)responseStr);
        rspBO.setRspJsonStr(responseStr);
        return rspBO;
    }

    public DycUocOrdeDetailQryFuncRspBO qryOrderDetail(DycUocOrdeDetailQryFuncReqBO reqBo) {
        UocGetOrderAllDetailServiceReqBo getOrderAllDetailServiceReqBo = (UocGetOrderAllDetailServiceReqBo)JUtil.js((Object)((Object)reqBo), UocGetOrderAllDetailServiceReqBo.class);
        log.info("\u6574\u5355\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\uff1a" + JSON.toJSONString((Object)getOrderAllDetailServiceReqBo));
        UocGetOrderAllDetailServiceRspBo orderAllDetail = this.uocGetOrderAllDetailService.getOrderAllDetail(getOrderAllDetailServiceReqBo);
        log.info("\u6574\u5355\u8be6\u60c5\u67e5\u8be2\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)orderAllDetail));
        this.transelate(orderAllDetail);
        if ("0000".equals(orderAllDetail.getRespCode())) {
            return (DycUocOrdeDetailQryFuncRspBO)((Object)JUtil.js((Object)orderAllDetail, DycUocOrdeDetailQryFuncRspBO.class));
        }
        throw new ZTBusinessException("\u6574\u5355\u8be6\u60c5\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u7f16\u7801\u3010" + orderAllDetail.getRespCode() + "\u3011," + orderAllDetail.getRespDesc());
    }

    private void transelate(UocGetOrderAllDetailServiceRspBo orderAllDetail) {
        List commInfoBos = orderAllDetail.getCommInfoBos();
        for (UocGetOrderAllDetailServiceRspOrderCommInfoBo commInfoBo : commInfoBos) {
            String salePrice = commInfoBo.getSalePrice();
            DecimalFormat format = new DecimalFormat("0.00");
            commInfoBo.setSalePrice(format.format(new BigDecimal(salePrice)));
            String tax = commInfoBo.getTax();
            commInfoBo.setTax(tax);
        }
        if (orderAllDetail.getTotalTransFee() == null) {
            orderAllDetail.setTotalTransFee(new BigDecimal("0"));
        }
    }

    private DycZhidiOaAttachment genAcceptPdf(DycUocOrdeDetailQryFuncRspBO orderDetail) {
        String fileUrl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\uff1a" + e);
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font footerFont = new Font(baseFont, 10.0f, 1);
        int COLUMNS = 10;
        document.open();
        PdfPTable titleTable = new PdfPTable(1);
        PdfPCell titleCell = new PdfPCell(new Phrase("\u534e\u6da6e\u8d2d\u7535\u5b50\u5546\u57ce\u8ba2\u5355\u5ba1\u6279", titleFont));
        titleCell.setColspan(1);
        titleCell.setBorder(0);
        titleCell.setFixedHeight(30.0f);
        titleCell.setHorizontalAlignment(1);
        titleCell.setVerticalAlignment(5);
        titleTable.addCell(titleCell);
        try {
            document.add((Element)titleTable);
        }
        catch (DocumentException e) {
            throw new ZTBusinessException("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        PdfPTable pdfPTable1 = new PdfPTable(10);
        PdfPCell pdfPCell1 = new PdfPCell(new Phrase("\u8ba2\u5355\u7f16\u53f7-\u6574\u5355", contentFont));
        pdfPCell1.setHorizontalAlignment(2);
        pdfPCell1.setVerticalAlignment(5);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(orderDetail.getOrderNo(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u6536\u8d27\u4eba", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(orderDetail.getLogisticsBo().getContactName(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u91c7\u8d2d\u5355\u4f4d", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(orderDetail.getLogisticsBo().getContactCompany(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        try {
            document.add((Element)pdfPTable1);
        }
        catch (DocumentException e) {
            throw new ZTBusinessException("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        PdfPTable pdfPTable2 = new PdfPTable(10);
        PdfPCell pdfPCell2 = new PdfPCell(new Phrase("\u5730\u5740", contentFont));
        pdfPCell2.setHorizontalAlignment(2);
        pdfPCell2.setVerticalAlignment(5);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(orderDetail.getLogisticsBo().getContactAddress(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase("\u624b\u673a\u53f7", contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(orderDetail.getLogisticsBo().getContactMobile(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        try {
            document.add((Element)pdfPTable2);
        }
        catch (DocumentException e) {
            throw new ZTBusinessException("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        PdfPTable headTable = new PdfPTable(10);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5546\u54c1\u7f16\u7801", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5546\u54c1\u540d\u79f0", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7535\u5546\u5546\u54c1\u7801", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u4f9b\u5e94\u5546", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u542b\u7a0e\u5355\u4ef7(\u5143)", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u9500\u552e\u5355\u4f4d", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5546\u54c1\u91d1\u989d(\u5143)", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u6bd4\u9009\u5355\u53f7", contentFont));
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e) {
            throw new ZTBusinessException("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        int count = 1;
        for (DycUocOrderCommodityInfoFuncBO uocOrderItem : orderDetail.getCommInfoBos()) {
            PdfPTable detailTable = new PdfPTable(10);
            PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocOrderItem.getSkuId(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocOrderItem.getSkuName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocOrderItem.getSkuExtSkuId(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocOrderItem.getSupplierName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocOrderItem.getSalePrice(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocOrderItem.getPurchaseCount().setScale(2, RoundingMode.HALF_UP).toPlainString(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocOrderItem.getSettleUnit(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocOrderItem.getSaleFee().setScale(2, RoundingMode.HALF_UP).toPlainString(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(uocOrderItem.getCmpOrderNo(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            try {
                document.add((Element)detailTable);
            }
            catch (DocumentException e) {
                throw new ZTBusinessException("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
            }
        }
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            fileUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            int i = fastdfsFileInfo.getFileName().lastIndexOf("/");
            fileName = i != -1 ? fastdfsFileInfo.getFileName().substring(i + 1) : fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        DycZhidiOaAttachment dycZhidiOaAttachment = new DycZhidiOaAttachment();
        dycZhidiOaAttachment.setFileName(fileName);
        dycZhidiOaAttachment.setFileId(UUID.randomUUID().toString());
        dycZhidiOaAttachment.setFileType("pdf");
        dycZhidiOaAttachment.setFileSize(this.getFormatSize(pdfBytes.length));
        dycZhidiOaAttachment.setDownloadPath(fileUrl);
        dycZhidiOaAttachment.setPreviewPath(fileUrl);
        return dycZhidiOaAttachment;
    }

    public String getFormatSize(double size) {
        double kiloByte = size / 1024.0;
        if (kiloByte < 1.0) {
            return size + "Byte(s)";
        }
        double megaByte = kiloByte / 1024.0;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(kiloByte));
            return result1.setScale(2, 4).toPlainString() + "KB";
        }
        double gigaByte = megaByte / 1024.0;
        if (gigaByte < 1.0) {
            BigDecimal result2 = new BigDecimal(Double.toString(megaByte));
            return result2.setScale(2, 4).toPlainString() + "MB";
        }
        double teraBytes = gigaByte / 1024.0;
        if (teraBytes < 1.0) {
            BigDecimal result3 = new BigDecimal(Double.toString(gigaByte));
            return result3.setScale(2, 4).toPlainString() + "GB";
        }
        BigDecimal result4 = new BigDecimal(teraBytes);
        return result4.setScale(2, 4).toPlainString() + "TB";
    }
}

