package com.tydic.dyc.ssc.constant;

import lombok.Getter;

import java.util.Arrays;

/**
 * 标题:SscCommConstant
 * 说明:通用常量
 * 时间:2022/11/10 10:23
 * 作者:罗有
 */

public class SscCommConstant {

	/**
	 * 共用响应码 - 入参必填字段为空
	 */
	public static final String RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR = "0001";

    public static final String SSC = "SSC";

    public static final String CODE_ORG_TYPE = "-1";

	/**
	 * 附件对象类型 1采购方案
	 */
	public static final class ACCESSORY_OBJ_TYPE {
		/**
		 * 1采购方案
		 */
		public static final Integer SCHEME = 1;
	}

	/**
	 * 附件类型
	 */
	public static final class ACCESSORY_ATTACHMENT_TYPE {
		/**
		 * 1委托合同附件
		 */
		public static final Integer CONTRACT = 1;
		/**
		 * 2委托合同其他附件
		 */
		public static final Integer CONTRACT_OTHER = 2;
	}

	/**
	 * 方案状态
	 */
	public enum SchemeStatus {
		/**
		 * 0：已完成
		 */
		COMPLETED("0", "已完成"),

		/**
		 * 1：委托中
		 */
		FORWARDING("1", "委托中"),

		/**
		 * 2：已受理
		 */
		ACCEPTED("2", "已受理"),

		/**
		 * 3：委托退回
		 */
		BACK("3", "委托退回"),

		/**
		 * 4：已变更
		 */
		CHANGE("4", "已变更"),

		/**
		 * 5、已挂起
		 */
		PUT_UP("5", "已挂起"),

		/**
		 * 6、已终止
		 */
		END("6", "已终止"),

		/**
		 * 7、企业核实
		 */
		CHECK("7", "企业核实"),

		/**
		 * 8、变更中
		 */
		CHANGING("8", "变更中"),
		;

		private final String code;
		private final String desc;

		SchemeStatus(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeStatus getInstance(String code) {
			for (SchemeStatus o : SchemeStatus.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public String getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 * 审批状态(0:草稿 1:审批中 2:审批通过 3:审批驳回 4:待批复 5:已批复 6:已撤回)
	 *
	 * @author xiahualing
	 * @date 2023/01/13
	 */
	@Getter
	public enum SchemeAuditStatus {

		/**
		 * 草稿
		 */
		DRAW("0", "草稿"),

		/**
		 * 审批中
		 */
		APPROVING("1", "审批中"),

		/**
		 * 审批通过
		 */
		APPROVE("2", "审批通过"),

		/**
		 * 审批驳回
		 */
		REJECT("3", "审批驳回"),

		/**
		 * 待批复
		 */
		WAIT_APPROVE("4", "待批复"),

		/**
		 * 已批复
		 */
		ALREADY_APPROVE("5", "已批复"),

		/**
		 * 已撤回
		 */
		WITHDRAW("6", "已撤回"),
		;

		private final String code;
		private final String desc;

		SchemeAuditStatus(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeAuditStatus findDescByCode(String code) {
			return Arrays.stream(SchemeAuditStatus.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}


	/**
	 * 0-公开招标，1-邀请招标，2-公开竞争性谈判，3-邀请竞争性谈判，4-公开询价，5-邀请询价，6-单一来源 7-公开询比 8-邀请询比 9-直接采购(定商定价) 10-直接采购(执行协议)，11-公开竞谈，12-邀请竞谈，13-公开竞价，14-邀请竞价
	 */
	public enum SchemePurchaseType {
		/**
		 * 0-公开招标
		 */
		PUBLIC_BIDDING(0, "公开招标"),

		/**
		 * 1-邀请招标
		 */
		INQUIRY_PURCHASING(1, "邀请招标"),

		/**
		 * 2-公开竞争性谈判
		 */
		OTHER_PURCHASING(2, "公开竞争性谈判"),

		/**
		 * 3-邀请竞争性谈判
		 */
		SELECTED_BIDDING(3, "邀请竞争性谈判"),

		/**
		 * 4-公开询价
		 */
		COMPETITIVE_NEGOTIATION(4, "公开询价"),

		/**
		 * 5-邀请询价
		 */
		INVITED_BIDDING(5, "邀请询价"),

		/**
		 * 6-单一来源
		 */
		ARG_PUBLIC_BIDDING(6, "单一来源"),

		/**
		 * 7-公开询比
		 */
		PUBLIC_COMPARE(7, "公开询比"),

		/**
		 * 8-邀请询比
		 */
		INVITE_COMPARE(8, "邀请询比"),

		/**
		 * 9-直接采购(定商定价)
		 */
		DIRECT_PRICE(9, "直接采购(定商定价)"),

		/**
		 * 10-直接采购(执行协议)
		 */
		DIRECT_ARG(10, "直接采购(执行协议)"),

		/**
		 * 11-公开竞谈
		 */
		PUBLIC_COMPETITION(11, "公开竞谈"),

		/**
		 * 12-邀请竞谈
		 */
		INVITE_COMPETITION(12, "邀请竞谈"),
		/**
		 * 13-公开竞价
		 */
		PUBLIC_PRICE(13, "公开竞价"),

		/**
		 * 14-邀请竞价
		 */
		INVITE_PRICE(14, "邀请竞价"),
		;

		private Integer code;
		private String desc;

		SchemePurchaseType(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemePurchaseType getInstance(Integer code) {
			for (SchemePurchaseType o : SchemePurchaseType.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}


	/**
	 * 方案类别 (0:工程 1:货物 2:服务 3:金属 4:非金属 5:设备 6:配件)
	 */
	public enum SchemeClass {
		/**
		 * 0工程
		 */
		PUBLIC_BIDDING(0, "工程"),

		/**
		 * 1货物
		 */
		INQUIRY_PURCHASING(1, "货物"),

		/**
		 * 2服务
		 */
		OTHER_PURCHASING(2, "服务"),

		/**
		 * 3金属
		 */
		METAL(3, "金属"),

		/**
		 * 4非金属
		 */
		NON_METAL(4, "非金属"),

		/**
		 * 5设备
		 */
		EQUIPMENT(5, "设备"),

		/**
		 * 5配件
		 */
		PARTS(6, "设备"),

		;

		private final Integer code;
		private final String desc;

		SchemeClass(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeClass getInstance(Integer code) {
			for (SchemeClass o : SchemeClass.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 * 资格审查方式 0资格预审 1资格后审
	 */
	public enum SchemeCheckType {
		/**
		 * 0资格预审
		 */
		PRE_QUALIFICATION(0, "资格预审"),

		/**
		 * 1资格后审
		 */
		POST_QUALIFICATION(1, "资格后审"),

		;

		private Integer code;
		private String desc;

		SchemeCheckType(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeCheckType getInstance(Integer code) {
			for (SchemeCheckType o : SchemeCheckType.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}
	/**
	 * 审批单状态
	 */
	public static final class AUDIT_ORDER_STATUS {
		/**
		 * 驳回
		 */
		public static final String REJECT = "0";
		/**
		 * 通过
		 */
		public static final String PASS = "1";
		/**
		 * 待审批
		 */
		public static final String WAIT_AUDIT = "2";
	}
	/**
	 * 单据类型
	 */
	public static final class ObjType {

		/**
		 * 订单
		 */
		public static final Integer ORDER = 1;
		/**
		 * 审批单
		 */
		public static final Integer  APPROVE = 9;

	}
	public static final class OBJ_BUSI_TYPE {

		/**
		 * 方案
		 */
		public static final Integer SCHEME = 1;

	}
	public static final class PROC_TASK_FINISHED {
		public static final Integer FINISHED = 1;
		public static final Integer NO_FINISHED = 0;
		public static final Integer END_TASK = 2;

	}
	public static final class TASK_DEAL_RESULT {
		public static final Integer APPROVING = 2;
		public static final Integer AUDIT_PASS = 1;
		public static final Integer AUDIT_REJECT = 0;

	}
	/**
	 * 处理分类，1处理人，2候选人
	 */
	public static final class TASK_DEAL_CLASS {
		public static final String ASSIGNEE = "1";
		public static final String CANDIDATE = "2";

	}
	/**
	 * 加签标识  0 ：环节任务   1：前加签任务  2：后加签任务  3：存在后加签任务
	 */
	public static final class TASK_SING_TAG {
		public static final Integer TACHE_TASK = 0;
		public static final Integer PRE_TASK = 1;
		public static final Integer AF_TASK = 2;
		public static final Integer EXIST_AF_TASK = 3;

	}


	/**
	 * 投标报价方式 0线上报价 1线下报价
	 */
	public enum SchemeOfferType {
		/**
		 * 0线上报价
		 */
		ONLINE_OFFER(0, "线上报价"),

		/**
		 * 1线下报价
		 */
		OFFLINE_OFFER(1, "线下报价"),

		;

		private Integer code;
		private String desc;

		SchemeOfferType(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeOfferType getInstance(Integer code) {
			for (SchemeOfferType o : SchemeOfferType.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 * 是否必须招标 0否 1是
	 */
	public enum SchemeBiddingFlag {
		/**
		 * 0否
		 */
		NO(0, "否"),

		/**
		 * 1是
		 */
		YES(1, "是"),

		;

		private Integer code;
		private String desc;

		SchemeBiddingFlag(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeBiddingFlag getInstance(Integer code) {
			for (SchemeBiddingFlag o : SchemeBiddingFlag.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 * 是否唱标前显示供应商名称 0否 1是
	 */
	public enum SchemeSupplierNameDisplayFlag {
		/**
		 * 0否
		 */
		NO(0, "否"),

		/**
		 * 1是
		 */
		YES(1, "是"),

		;

		private Integer code;
		private String desc;

		SchemeSupplierNameDisplayFlag(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeSupplierNameDisplayFlag getInstance(Integer code) {
			for (SchemeSupplierNameDisplayFlag o : SchemeSupplierNameDisplayFlag.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 * 采购组织形式 0:自行 1：委托
	 */
	public enum SchemeOrganizationForm {
		/**
		 * 0自行
		 */
		VOLUNTARILY(0, "自行采购"),

		/**
		 * 1委托
		 */
		DELEGATION(1, "委托采购");

		private Integer code;
		private String desc;

		SchemeOrganizationForm(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeOrganizationForm getInstance(Integer code) {
			for (SchemeOrganizationForm o : SchemeOrganizationForm.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *是否分包(标段) 0否 1是
	 */
	public enum SchemeSubpackageFlag {
		/**
		 * 0否
		 */
		NO(0, "否"),

		/**
		 * 1是
		 */
		YES(1, "是"),

		;

		private Integer code;
		private String desc;

		SchemeSubpackageFlag(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeSubpackageFlag getInstance(Integer code) {
			for (SchemeSubpackageFlag o : SchemeSubpackageFlag.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *是否标书收费 0否 1是
	 */
	public enum SchemeTenderChargeFlag {
		/**
		 * 0否
		 */
		NO(0, "否"),

		/**
		 * 1是
		 */
		YES(1, "是"),

		;

		private Integer code;
		private String desc;

		SchemeTenderChargeFlag(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeTenderChargeFlag getInstance(Integer code) {
			for (SchemeTenderChargeFlag o : SchemeTenderChargeFlag.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *标书收费形式 0整包 1分包
	 */
	public enum SchemeTenderSaleForm {
		/**
		 * 0整包
		 */
		WHOLE_PACKAGE(0, "整包"),

		/**
		 * 1是
		 */
		SUB_PACKAGE(1, "分包"),

		;

		private Integer code;
		private String desc;

		SchemeTenderSaleForm(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeTenderSaleForm getInstance(Integer code) {
			for (SchemeTenderSaleForm o : SchemeTenderSaleForm.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *是否收取投标保证金 0否 1是
	 */
	public enum SchemeBidMarginFlag {
		/**
		 * 0否
		 */
		NO(0, "否"),

		/**
		 * 1是
		 */
		YES(1, "是"),

		;

		private Integer code;
		private String desc;

		SchemeBidMarginFlag(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeBidMarginFlag getInstance(Integer code) {
			for (SchemeBidMarginFlag o : SchemeBidMarginFlag.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *投标保证金收取形式 0整包 1分包
	 */
	public enum SchemeBidMarginForm {
		/**
		 * 0整包
		 */
		WHOLE_PACKAGE(0, "整包"),

		/**
		 * 1是
		 */
		SUB_PACKAGE(1, "分包"),

		;

		private Integer code;
		private String desc;

		SchemeBidMarginForm(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeBidMarginForm getInstance(Integer code) {
			for (SchemeBidMarginForm o : SchemeBidMarginForm.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *投标保证金缴纳形式 1线下支付 2在线支付 3电子保函 4其他
	 */
	public enum SchemeBidMarginPayForm {
		/**
		 * 1线下支付
		 */
		OFFLINE_PAYMENT(1, "线下支付"),

		/**
		 * 2在线支付
		 */
		ONLINE_PAYMENT(2, "在线支付"),

		/**
		 * 3电子保函
		 */
		ELECTRONIC_LETTER_OF_GUARANTEE(3, "电子保函"),

		/**
		 * 4其他
		 */
		OTHER(4, "其他"),

		;

		private Integer code;
		private String desc;

		SchemeBidMarginPayForm(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeBidMarginPayForm getInstance(Integer code) {
			for (SchemeBidMarginPayForm o : SchemeBidMarginPayForm.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *是否提交履约保证金 0否 1是
	 */
	public enum SchemePrefMarginFlag {
		/**
		 * 0否
		 */
		NO(0, "否"),

		/**
		 * 1是
		 */
		YES(1, "是"),

		;

		private Integer code;
		private String desc;

		SchemePrefMarginFlag(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemePrefMarginFlag getInstance(Integer code) {
			for (SchemePrefMarginFlag o : SchemePrefMarginFlag.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *是否进口 0国产 1进口
	 */
	public enum SchemeImportFlag {
		/**
		 * 0国产
		 */
		DOMESTIC(0, "国产"),

		/**
		 * 1进口
		 */
		IMPORT(1, "进口"),

		;

		private Integer code;
		private String desc;

		SchemeImportFlag(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeImportFlag getInstance(Integer code) {
			for (SchemeImportFlag o : SchemeImportFlag.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *是否紧急采购 0否 1是
	 */
	public enum SchemeEmergencyFlag {
		/**
		 * 0否
		 */
		NO(0, "否"),

		/**
		 * 1是
		 */
		YES(1, "是"),

		;

		private Integer code;
		private String desc;

		SchemeEmergencyFlag(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeEmergencyFlag getInstance(Integer code) {
			for (SchemeEmergencyFlag o : SchemeEmergencyFlag.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *合同签订方式 0统谈统签 1统谈分签
	 */
	public enum SchemeContractSignFlag {
		/**
		 * 0统谈统签
		 */
		TALK_ABOUT_THE_DATABANK(0, "统谈统签"),

		/**
		 * 1统谈分签
		 */
		TALK_ABOUT_THE_SIGNATURES(1, "统谈分签"),

		;

		private Integer code;
		private String desc;

		SchemeContractSignFlag(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeContractSignFlag getInstance(Integer code) {
			for (SchemeContractSignFlag o : SchemeContractSignFlag.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *寻源状态 0未开始 1进行中 2已完成 3已流标
	 */
	public enum SchemeSourcingStatus {
		/**
		 * 0未开始
		 */
		NOT_BEGINNING(0, "未开始"),

		/**
		 * 1进行中
		 */
		IN_PROGRESS(1, "进行中"),

		/**
		 * 2已完成
		 */
		COMPLETED(2, "已完成"),

		/**
		 * 3已流标
		 */
		LOST_MARK(3, "已流标"),

		;

		private Integer code;
		private String desc;

		SchemeSourcingStatus(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeSourcingStatus getInstance(Integer code) {
			for (SchemeSourcingStatus o : SchemeSourcingStatus.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 *方案受理记录状态 0已指派 1接受 2不接受
	 */
	public enum SchemeAcceptRecordStatus {
		/**
		 * 0已指派
		 */
		NOT_BEGINNING(0, "已指派"),

		/**
		 * 1接受
		 */
		ACCEPT(1, "接受"),

		/**
		 * 2不接受
		 */
		DO_NOT_ACCEPT(2, "不接受"),

		;

		private Integer code;
		private String desc;

		SchemeAcceptRecordStatus(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeAcceptRecordStatus getInstance(Integer code) {
			for (SchemeAcceptRecordStatus o : SchemeAcceptRecordStatus.values()) {
				if (o.getCode().equals(code)) {
					return o;
				}
			}
			return null;
		}
		public Integer getCode() {
			return code;
		}
		public String getDesc() {
			return desc;
		}
	}

	/**
	 * 公告类型枚举类
	 *
	 * @author xiahualing
	 * @date 2022/12/28
	 */
	@Getter
	public enum NoticeTypeEnum {

		// 0:邀请函
		INVITATION(0, "邀请函"),

		// 1:招标公告
		BID_NOTICE(1, "招标公告"),

		// 2:澄清公告
		CLARIFY_NOTICE(2, "澄清公告"),

		// 3:变更公告
		CHANGE_NOTICE(3, "变更公告"),

		// 4:中标候选人公告
		CANDIDATE_NOTICE(4, "中标候选人公告"),

		// 5:中标结果公告
		RESULT_NOTICE(5, "中标结果公告");

		private final Integer code;
		private final String desc;

		NoticeTypeEnum(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static NoticeTypeEnum findDescByCode(Integer code) {
			return Arrays.stream(NoticeTypeEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 评标方法枚举类
	 *
	 * @author xiahualing
	 * @date 2022/12/28
	 */
	@Getter
	public enum BidEvalMethodEnum {

		// 0:综合评估法
		SYNTHESIZE_EVAL(0, "综合评估法"),

		// 1:经评审的最低投标价法
		LOW_BID(1, "经评审的最低投标价法");

		private final Integer code;
		private final String desc;

		BidEvalMethodEnum(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static BidEvalMethodEnum findDescByCode(Integer code) {
			return Arrays.stream(BidEvalMethodEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 受理状态枚举
	 *
	 * @author xiahualing
	 * @date 2023/02/09
	 */
	@Getter
	public enum AcceptStatusEnum {

		// 0:已指派
		ASSIGNED(0, "已指派"),

		// 1:接收
		ACCEPT(1, "接受"),

		NO_ACCEPT(2, "不接受");

		private final Integer code;
		private final String desc;

		AcceptStatusEnum(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static AcceptStatusEnum findDescByCode(Integer code) {
			return Arrays.stream(AcceptStatusEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 方案类型(0:一事一招 1:框架协议 2:简易方案 3:采购方案 4:集采方案)
	 *
	 * @author xiahualing
	 * @date 2023/02/16
	 */
	@Getter
	public enum SchemeTypeEnum {

		// 0:一事一招
		ONE_THING("0", "一事一招"),

		// 1:框架协议
		FRAME_AGR("1", "框架协议"),

		// 2:简易方案
		SIMPLE("2", "简易方案"),

		// 3:采购方案
		PURCHASE("3", "采购方案"),

		// 4:集采方案
		FOCUS("4", "集采方案"),
		;

		private final String code;
		private final String desc;

		SchemeTypeEnum(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SchemeTypeEnum findDescByCode(String code) {
			return Arrays.stream(SchemeTypeEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 寻源方式枚举
	 *
	 * @author xiahualing
	 * @date 2023/02/16
	 */
	@Getter
	public enum SourcingWayEnum {

		// 0:方案寻源
		SCHEME_SOURCE("0", "方案寻源"),

		// 1:标段寻源
		PACK_SOURCE("1", "标段寻源");

		private final String code;
		private final String desc;

		SourcingWayEnum(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SourcingWayEnum findDescByCode(String code) {
			return Arrays.stream(SourcingWayEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 是或否枚举
	 *
	 * @author xiahualing
	 * @date 2023/02/16
	 */
	@Getter
	public enum YesOrNoEnum {

		// 0:方案寻源
		NO(0, "否"),

		// 1:标段寻源
		YES(1, "是");

		private final Integer code;
		private final String desc;

		YesOrNoEnum(Integer code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static YesOrNoEnum findDescByCode(Integer code) {
			return Arrays.stream(YesOrNoEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 操作类型枚举类
	 *
	 * @author xiahualing
	 * @date 2023/03/13
	 */
	@Getter
	public enum OperTypeEnum {

		// 0:挂起
		PUT_UP("0", "挂起"),

		// 1:终止
		END("1", "终止"),

		// 2:审批采购方式
		AUDIT_PURCHASE_TYPE("2", "审批采购方式"),

		// 3:企业核实
		CHECK("3", "企业核实"),
		;

		private final String code;
		private final String desc;

		OperTypeEnum(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static OperTypeEnum findDescByCode(String code) {
			return Arrays.stream(OperTypeEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 项目类别(0:基建工程 1:生产服务 2:生产技术 3:科技环保 4:技术改造)
	 *
	 * @author xiahualing
	 * @date 2023/03/13
	 */
	@Getter
	public enum projectCategoryEnum {

		// 0:基建工程
		BASE("0", "基建工程"),

		// 1:生产服务
		PRODUCT_SERVICE("1", "生产服务"),

		// 2:生产技术
		PRODUCT_TECH("2", "生产技术"),

		// 3:科技环保
		ENVIRONMENT("3", "科技环保"),

		// 3:技术改造
		TRANSFORM("4", "技术改造"),
		;

		private final String code;
		private final String desc;

		projectCategoryEnum(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static projectCategoryEnum findDescByCode(String code) {
			return Arrays.stream(projectCategoryEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 合同类型(0:采购现货合同 1:采购框架协议(定价) 2:采购框架协议(寄售))
	 *
	 * @author xiahualing
	 * @date 2023/03/13
	 */
	@Getter
	public enum ContractTypeEnum {

		// 0:采购现货合同
		NOW("0", "采购现货合同"),

		// 1:采购框架协议(定价)
		ARG_DIRECT("1", "采购框架协议(定价)"),

		// 2:采购框架协议(寄售)
		ARG_SEND("2", "采购框架协议(寄售)"),
		;

		private final String code;
		private final String desc;

		ContractTypeEnum(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static ContractTypeEnum findDescByCode(String code) {
			return Arrays.stream(ContractTypeEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 选商方式(0:公开邀请 1:定向邀请)
	 *
	 * @author xiahualing
	 * @date 2023/03/13
	 */
	@Getter
	public enum SelectSupWayEnum {

		// 0:公开邀请
		PUBLIC("0", "公开邀请"),

		// 1:定向邀请
		DIRECT("1", "定向邀请"),

		;

		private final String code;
		private final String desc;

		SelectSupWayEnum(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SelectSupWayEnum findDescByCode(String code) {
			return Arrays.stream(SelectSupWayEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 是否抽取供应商(0:不抽取 1:抽取)
	 *
	 * @author xiahualing
	 * @date 2023/03/13
	 */
	@Getter
	public enum SelectSupFlagEnum {

		// 0:不抽取
		NO("0", "不抽取"),

		// 1:抽取
		YES("1", "抽取"),

		;

		private final String code;
		private final String desc;

		SelectSupFlagEnum(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SelectSupFlagEnum findDescByCode(String code) {
			return Arrays.stream(SelectSupFlagEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 方案分交方式(0:集采实施-自营 1:集采实施-代理采购 2:企业自营)
	 *
	 * @author xiahualing
	 * @date 2023/03/13
	 */
	@Getter
	public enum SubmitTypeEnum {

		// 0:集采实施-自营
		FOCUS_SELF("0", "集采实施-自营"),

		// 1:集采实施-代理采购
		FOCUS_AGENCY("1", "集采实施-代理采购"),

		// 2:企业自营
		COMPANY_SELF("2", "企业自营"),
		;

		private final String code;
		private final String desc;

		SubmitTypeEnum(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static SubmitTypeEnum findDescByCode(String code) {
			return Arrays.stream(SubmitTypeEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}

	/**
	 * 分配状态(0:待分配 1:已分配)
	 *
	 * @author xiahualing
	 * @date 2023/03/13
	 */
	@Getter
	public enum AssignStatusEnum {

		// 0:待分配
		WAIT("0", "待分配"),

		// 1:已分配
		ALREADY("1", "已分配"),

		;

		private final String code;
		private final String desc;

		AssignStatusEnum(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

		public static AssignStatusEnum findDescByCode(String code) {
			return Arrays.stream(AssignStatusEnum.values()).filter(e -> e.getCode().equals(code)).findAny().orElse(null);
		}
	}
	/**
	 * 更新类型： 1.应用到全部物料行 2.应用到未填写物料行 3.应用到选中物料行
	 */
	public static final class SCHEME_MAT_UPDATE_TYPE {
		public static final Integer APPLY_ALL_MAT = 1;
		public static final Integer APPLY_NO_WRITE = 2;
		public static final Integer APPLY_CHECKED = 3;

	}
    /**
     * 扩展对象类型
     */
    public static final class EXT_OBJ_TYPE {
        /**
         *  方案扩展
         */
        public static final String SSC_SCHEME_EXT = "ssc_scheme_ext";
		/**
		 * 方案历史扩展
		 */
		public static final String SSC_SCHEME_HIS_EXT = "ssc_scheme_his_ext";
        /**
         *  方案标段扩展
         */
        public static final String SSC_SCHEME_PACK_EXT = "ssc_scheme_pack_ext";
		/**
		 *  方案标段历史扩展
		 */
		public static final String SSC_SCHEME_PACK_HIS_EXT = "ssc_scheme_pack_his_ext";
        /**
         *  方案物资扩展
         */
        public static final String SSC_SCHEME_MAT_EXT = "ssc_scheme_mat_ext";
		/**
		 *  方案物资历史扩展
		 */
		public static final String SSC_SCHEME_MAT_HIS_EXT = "ssc_scheme_mat_his_ext";
		/**
		 *  方案物资扩展
		 */
		public static final String SSC_SCHEME_MAT_EXT_DRAFT = "ssc_scheme_mat_ext_draft";

        /**
         * 方案邀请供应商扩展
         */
        public static final String SSC_SCHEME_INVITE_SUP_EXT = "ssc_scheme_invite_sup_ext";
		/**
		 * 方案邀请供应商扩展
		 */
		public static final String SSC_SCHEME_INVITE_SUP_EXT_DRAFT = "ssc_scheme_invite_sup_ext_draft";
		/**
		 * 方案邀请供应商扩展
		 */
		public static final String SSC_SCHEME_INVITE_SUP_HIS_EXT = "ssc_scheme_invite_sup_his_ext";
    }

}
