package com.tydic.dyc.ssc.constant;

import com.tydic.dyc.base.constants.BaseRspConstant;

/**
 * 标题:SscRspConstant
 * 说明:返回编码常量
 * 时间:2022/11/10 10:26
 * 作者:罗有
 */

public class SscRspConstant extends BaseRspConstant {

    /*
    编码生成规则：寻源中心编码开头：29开头的6位编码
	调用成功的编码无需再自行定义，统一使用：RSP_CODE_SUCCESS
	每个接口调用失败的编码需自行定义，规则如下：
	编码key：以RSP_CODE开头，以ERROR结束，中间为自定义部分，
	自定义原则为具有可读性的英文单词（可简写），多个单词以“_”分隔
	编码值：领域服务层1开头，如：1001；领域方法以2开头，如：2001；基建层以3开头，如3001；编码值长度为4位
	*/
	public static final String RESP_CODE_SUCCESS = "0000";

	/**
	 * 参数为空 领域服务
	 */
	public static final String RSP_CODE_SERVICE_EMPTY_ERROR = "291001";

	/**
	 * 参数为空 领域方法
	 */
	public static final String RSP_CODE_FUNCTION_EMPTY_ERROR = "292001";

	/**
	 * 参数为空 基建层
	 */
	public static final String RSP_CODE_REPOSITORY_EMPTY_ERROR = "293001";

	/**
	 * 方案详情查询错误
	 */
	public static final String RSP_CODE_QUERY_SCHEME_ERROR = "291002";

	/**
	 * 委托记录列表查询错误
	 */
	public static final String RSP_CODE_QUERY_SCHEME_ENTRUST_RECORD_ERROR = "291003";

	/**
	 * 方案受理记录列表查询错误
	 */
	public static final String RSP_CODE_QUERY_SCHEME_ACCEPT_RECORD_ERROR = "291004";
}
