/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.service.scheme.SscCreateCodeService;
import com.tydic.dyc.ssc.service.scheme.bo.SscCreateCodeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscCreateCodeRspBO;
import com.tydic.dyc.ssc.utils.IdUtil;
import com.tydic.dyc.ssc.utils.SscRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialServiceRspBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscCreateCodeService"})
public class SscCreateCodeServiceImpl
implements SscCreateCodeService {
    private static final Logger log = LoggerFactory.getLogger(SscCreateCodeServiceImpl.class);
    @Autowired
    private CfcEncodedSerialGetService cfcRedisSerialService;

    @PostMapping(value={"createCode"})
    public SscCreateCodeRspBO createCode(@RequestBody SscCreateCodeReqBO sscCreateCodeReqBO) {
        SscCreateCodeRspBO sscCreateCodeRspBO = SscRu.success(SscCreateCodeRspBO.class);
        this.validateParam(sscCreateCodeReqBO);
        CfcEncodedSerialGetServiceReqBO cfcEncodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        cfcEncodedSerialGetServiceReqBO.setEncodedRuleCode(sscCreateCodeReqBO.getCode());
        cfcEncodedSerialGetServiceReqBO.setCenter("SSC");
        cfcEncodedSerialGetServiceReqBO.setOrgType("-1");
        if (StrUtil.isNotEmpty((CharSequence)sscCreateCodeReqBO.getUpperCode())) {
            ArrayList<String> replaceValue = new ArrayList<String>();
            replaceValue.add(sscCreateCodeReqBO.getUpperCode());
            cfcEncodedSerialGetServiceReqBO.setReplaceValue(replaceValue);
        }
        CfcEncodedSerialServiceRspBO cfcEncodedSerialGetServiceRspBO = this.cfcRedisSerialService.getSerial(cfcEncodedSerialGetServiceReqBO);
        List serialNoList = cfcEncodedSerialGetServiceRspBO.getSerialNoList();
        String codeNo = (String)serialNoList.get(0);
        long codeId = IdUtil.nextId();
        sscCreateCodeRspBO.setCodeId(Long.valueOf(codeId));
        sscCreateCodeRspBO.setCodeNo(codeNo);
        return sscCreateCodeRspBO;
    }

    private void validateParam(SscCreateCodeReqBO sscCreateCodeReqBO) {
        if (null == sscCreateCodeReqBO) {
            throw new BaseBusinessException("291001", "SSCS0001-\u7f16\u53f7\u751f\u6210\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == sscCreateCodeReqBO.getCode()) {
            throw new BaseBusinessException("291001", "SSCS0001-\u7f16\u53f7\u751f\u6210\u670d\u52a1\u5165\u53c2\u3010code\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

