/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SchemeAcceptRecordQryBo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeAcceptRecord;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeAcceptRecordListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeAcceptRecordBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeAcceptRecordListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeAcceptRecordListRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscQrySchemeAcceptRecordListService"})
public class SscQrySchemeAcceptRecordListServiceImpl
implements SscQrySchemeAcceptRecordListService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"qrySchemeAcceptRecordList"})
    public SscQrySchemeAcceptRecordListRspBO qrySchemeAcceptRecordList(@RequestBody SscQrySchemeAcceptRecordListReqBO sscQrySchemeAcceptRecordListReqBO) {
        SscQrySchemeAcceptRecordListRspBO rspBo = SscRu.success(SscQrySchemeAcceptRecordListRspBO.class);
        this.validateArg(sscQrySchemeAcceptRecordListReqBO);
        SchemeAcceptRecordQryBo qryBo = SscRu.js(sscQrySchemeAcceptRecordListReqBO, SchemeAcceptRecordQryBo.class);
        SscSchemeDo sscSchemeDo = this.iSscSchemeModel.qrySchemeAcceptRecordList(qryBo);
        if (sscSchemeDo == null) {
            throw new BaseBusinessException("291004", "\u65b9\u6848\u53d7\u7406\u8bb0\u5f55\u5217\u8868\u67e5\u8be2\u4e3a\u7a7a");
        }
        List<SscSchemeAcceptRecord> list = sscSchemeDo.getSscSchemeAcceptRecord();
        ArrayList<SscQrySchemeAcceptRecordBO> recordBOList = new ArrayList<SscQrySchemeAcceptRecordBO>();
        for (SscSchemeAcceptRecord sscSchemeAcceptRecord : list) {
            SscQrySchemeAcceptRecordBO detailBO = SscRu.js(sscSchemeAcceptRecord, SscQrySchemeAcceptRecordBO.class);
            if (sscSchemeAcceptRecord.getStatus() != null) {
                detailBO.setStatusStr(Objects.requireNonNull(SscCommConstant.SchemeAcceptRecordStatus.getInstance((Integer)sscSchemeAcceptRecord.getStatus())).getDesc());
            }
            recordBOList.add(detailBO);
        }
        rspBo.setRows(recordBOList);
        return rspBo;
    }

    private void validateArg(SscQrySchemeAcceptRecordListReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[SscQrySchemeAcceptRecordListReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSchemeId() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[\u65b9\u6848ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

