/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeChangeListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeChangeListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeChangeListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscQrySchemeChangeListService"})
public class SscQrySchemeChangeListServiceImpl
implements SscQrySchemeChangeListService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"qrySchemeChangeList"})
    public SscQrySchemeChangeListRspBO qrySchemeChangeList(@RequestBody SscQrySchemeChangeListReqBO sscQrySchemeChangeListReqBO) {
        this.check(sscQrySchemeChangeListReqBO);
        SscQrySchemeChangeListRspBO rspBO = SscRu.success(SscQrySchemeChangeListRspBO.class);
        SscSchemeDo sscSchemeDo = this.iSscSchemeModel.qrySchemeChangeList(SscRu.js(sscQrySchemeChangeListReqBO, SscSchemeQryBo.class));
        List<SscSchemeChangeBO> changeBOList = sscSchemeDo.getSscSchemeChange();
        if (CollectionUtil.isNotEmpty(changeBOList)) {
            changeBOList.forEach(e -> {
                e.setOldSchemeStatusStr(SscCommConstant.SchemeStatus.getInstance((String)e.getOldSchemeStatus()).getDesc());
                e.setNewSchemeStatusStr(SscCommConstant.SchemeStatus.getInstance((String)e.getNewSchemeStatus()).getDesc());
            });
        }
        rspBO.setSscSchemeChange(changeBOList);
        return rspBO;
    }

    private void check(SscQrySchemeChangeListReqBO reqBO) {
        if (reqBO.getSchemeId() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[schemeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

