/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeDetailService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscQrySchemeDetailService"})
public class SscQrySchemeDetailServiceImpl
implements SscQrySchemeDetailService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"qrySchemeDetail"})
    public SscQrySchemeDetailRspBO qrySchemeDetail(@RequestBody SscQrySchemeDetailReqBO sscQrySchemeDetailReqBO0) {
        SscQrySchemeDetailRspBO rspBo = SscRu.success(SscQrySchemeDetailRspBO.class);
        this.validateArg(sscQrySchemeDetailReqBO0);
        SscSchemeQryBo qryBo = new SscSchemeQryBo();
        qryBo.setSchemeId(sscQrySchemeDetailReqBO0.getSchemeId());
        qryBo.setEnableDraft(sscQrySchemeDetailReqBO0.getEnableDraft());
        qryBo.setSchemeHisId(sscQrySchemeDetailReqBO0.getSchemeHisId());
        SscSchemeDo sscSchemeDo = this.iSscSchemeModel.qrySchemeDetail(qryBo);
        if (sscSchemeDo == null) {
            throw new BaseBusinessException("291002", "\u65b9\u6848\u8be6\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        SscQrySchemeDetailBO detailBO = SscRu.js(sscSchemeDo, SscQrySchemeDetailBO.class);
        if (sscSchemeDo.getSchemeClass() != null) {
            detailBO.setSchemeClassStr(Objects.requireNonNull(SscCommConstant.SchemeClass.getInstance((Integer)sscSchemeDo.getSchemeClass())).getDesc());
        }
        if (sscSchemeDo.getSchemeStatus() != null) {
            detailBO.setSchemeStatusStr(Objects.requireNonNull(SscCommConstant.SchemeStatus.getInstance((String)sscSchemeDo.getSchemeStatus())).getDesc());
        }
        if (sscSchemeDo.getPurchaseType() != null) {
            detailBO.setPurchaseTypeStr(Objects.requireNonNull(SscCommConstant.SchemePurchaseType.getInstance((Integer)sscSchemeDo.getPurchaseType())).getDesc());
        }
        if (sscSchemeDo.getCheckType() != null) {
            detailBO.setCheckTypeStr(Objects.requireNonNull(SscCommConstant.SchemeCheckType.getInstance((Integer)sscSchemeDo.getCheckType())).getDesc());
        }
        if (sscSchemeDo.getOfferType() != null) {
            detailBO.setOfferTypeStr(Objects.requireNonNull(SscCommConstant.SchemeOfferType.getInstance((Integer)sscSchemeDo.getOfferType())).getDesc());
        }
        if (sscSchemeDo.getBiddingFlag() != null) {
            detailBO.setBiddingFlagStr(Objects.requireNonNull(SscCommConstant.SchemeBiddingFlag.getInstance((Integer)sscSchemeDo.getBiddingFlag())).getDesc());
        }
        if (sscSchemeDo.getSupplierNameDisplayFlag() != null) {
            detailBO.setSupplierNameDisplayFlagStr(Objects.requireNonNull(SscCommConstant.SchemeSupplierNameDisplayFlag.getInstance((Integer)sscSchemeDo.getSupplierNameDisplayFlag())).getDesc());
        }
        if (sscSchemeDo.getOrganizationForm() != null) {
            detailBO.setOrganizationFormStr(Objects.requireNonNull(SscCommConstant.SchemeOrganizationForm.getInstance((Integer)Integer.parseInt(sscSchemeDo.getOrganizationForm()))).getDesc());
        }
        if (sscSchemeDo.getSubpackageFlag() != null) {
            detailBO.setSubpackageFlagStr(Objects.requireNonNull(SscCommConstant.SchemeSubpackageFlag.getInstance((Integer)sscSchemeDo.getSubpackageFlag())).getDesc());
        }
        if (sscSchemeDo.getTenderChargeFlag() != null) {
            detailBO.setTenderChargeFlagStr(Objects.requireNonNull(SscCommConstant.SchemeTenderChargeFlag.getInstance((Integer)sscSchemeDo.getTenderChargeFlag())).getDesc());
        }
        if (sscSchemeDo.getTenderSaleForm() != null) {
            detailBO.setTenderSaleFormStr(Objects.requireNonNull(SscCommConstant.SchemeTenderSaleForm.getInstance((Integer)sscSchemeDo.getTenderSaleForm())).getDesc());
        }
        if (sscSchemeDo.getBidMarginFlag() != null) {
            detailBO.setBidMarginFlagStr(Objects.requireNonNull(SscCommConstant.SchemeBidMarginFlag.getInstance((Integer)sscSchemeDo.getBidMarginFlag())).getDesc());
        }
        if (sscSchemeDo.getBidMarginForm() != null) {
            detailBO.setBidMarginFormStr(Objects.requireNonNull(SscCommConstant.SchemeBidMarginForm.getInstance((Integer)sscSchemeDo.getBidMarginForm())).getDesc());
        }
        if (sscSchemeDo.getBidMarginPayForm() != null) {
            String bidMarginPayFormStr = Arrays.stream(sscSchemeDo.getBidMarginPayForm().split(",")).map(e -> SscCommConstant.SchemeBidMarginPayForm.getInstance((Integer)Integer.valueOf(e)).getDesc()).collect(Collectors.joining(","));
            detailBO.setBidMarginPayFormStr(bidMarginPayFormStr);
        }
        if (sscSchemeDo.getPrefMarginFlag() != null) {
            detailBO.setPrefMarginFlagStr(Objects.requireNonNull(SscCommConstant.SchemePrefMarginFlag.getInstance((Integer)sscSchemeDo.getPrefMarginFlag())).getDesc());
        }
        if (sscSchemeDo.getImportFlag() != null) {
            detailBO.setImportFlagStr(Objects.requireNonNull(SscCommConstant.SchemeImportFlag.getInstance((Integer)sscSchemeDo.getImportFlag())).getDesc());
        }
        if (sscSchemeDo.getEmergencyFlag() != null) {
            detailBO.setEmergencyFlagStr(Objects.requireNonNull(SscCommConstant.SchemeEmergencyFlag.getInstance((Integer)sscSchemeDo.getEmergencyFlag())).getDesc());
        }
        if (sscSchemeDo.getContractSignFlag() != null) {
            detailBO.setContractSignFlagStr(Objects.requireNonNull(SscCommConstant.SchemeContractSignFlag.getInstance((Integer)sscSchemeDo.getContractSignFlag())).getDesc());
        }
        if (sscSchemeDo.getSourcingStatus() != null) {
            detailBO.setSourcingStatusStr(SscCommConstant.SchemeSourcingStatus.getInstance((Integer)Integer.parseInt(sscSchemeDo.getSourcingStatus())).getDesc());
        }
        Optional.ofNullable(sscSchemeDo.getSchemeType()).ifPresent(e -> {
            SscCommConstant.SchemeTypeEnum schemeTypeEnum = SscCommConstant.SchemeTypeEnum.findDescByCode((String)e);
            detailBO.setSchemeTypeStr(ObjectUtil.isNull((Object)schemeTypeEnum) ? null : schemeTypeEnum.getDesc());
        });
        Optional.ofNullable(sscSchemeDo.getSourcingWay()).ifPresent(e -> detailBO.setSourcingWayStr(SscCommConstant.SourcingWayEnum.findDescByCode((String)e).getDesc()));
        Optional.ofNullable(sscSchemeDo.getMultipleAwardsForOneBid()).ifPresent(e -> detailBO.setMultipleAwardsForOneBidStr(SscCommConstant.YesOrNoEnum.findDescByCode((Integer)e).getDesc()));
        rspBo.setSscQrySchemeDetailBO(detailBO);
        return rspBo;
    }

    private void validateArg(SscQrySchemeDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[SscQrySchemeDetailReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSchemeId() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[schemeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getEnableDraft() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[enableDraft]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

