/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeVersion;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeVersionListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeVersionListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeVersionListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeVersionBo;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscQrySchemeVersionListService"})
public class SscQrySchemeVersionListServiceImpl
implements SscQrySchemeVersionListService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"qrySchemeVersionList"})
    public SscQrySchemeVersionListRspBO qrySchemeVersionList(@RequestBody SscQrySchemeVersionListReqBO sscQrySchemeVersionListReqBO) {
        SscQrySchemeVersionListRspBO rspBO = SscRu.success(SscQrySchemeVersionListRspBO.class);
        this.check(sscQrySchemeVersionListReqBO);
        SscSchemeDo schemeVersion = this.iSscSchemeModel.qrySchemeVersionList((SscSchemeQryBo)JUtil.js((Object)sscQrySchemeVersionListReqBO, SscSchemeQryBo.class));
        List<SscSchemeVersion> versionList = schemeVersion.getSscSchemeVersion();
        if (CollectionUtil.isNotEmpty(versionList)) {
            List boList = versionList.stream().map(e -> {
                SscSchemeVersionBo bo = (SscSchemeVersionBo)JUtil.js((Object)e, SscSchemeVersionBo.class);
                if (ObjectUtil.isNotNull((Object)bo.getSchemeClass())) {
                    bo.setSchemeClassStr(SscCommConstant.SchemeClass.getInstance((Integer)bo.getSchemeClass()).getDesc());
                }
                if (StrUtil.isNotEmpty((CharSequence)bo.getOrganizationForm())) {
                    bo.setOrganizationFormStr(SscCommConstant.SchemeOrganizationForm.getInstance((Integer)Integer.valueOf(bo.getOrganizationForm())).getDesc());
                }
                if (ObjectUtil.isNotEmpty((Object)bo.getPurchaseType())) {
                    bo.setPurchaseTypeStr(SscCommConstant.SchemePurchaseType.getInstance((Integer)bo.getPurchaseType()).getDesc());
                }
                return bo;
            }).collect(Collectors.toList());
            rspBO.setSscSchemeVersion(boList);
        }
        return rspBO;
    }

    private void check(SscQrySchemeVersionListReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getSchemeId())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[schemeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

