package com.tydic.dyc.ssc.service.auditorder;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.auditorder.SscAuditOrderDo;
import com.tydic.dyc.ssc.model.auditorder.ISscAuditOrderModel;
import com.tydic.dyc.ssc.service.auditorder.bo.SscCreateAuditOrderReqBO;
import com.tydic.dyc.ssc.service.auditorder.bo.SscCreateAuditOrderRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author hcl
 * @date 2022年9月2日
 */
@HTServiceImpl
public class SscCreateAuditOrderServiceImpl implements SscCreateAuditOrderService {

    @Autowired
    private ISscAuditOrderModel iSscAuditOrderModel;

    @Override
    public SscCreateAuditOrderRspBO createAuditOrder(SscCreateAuditOrderReqBO auditOrderReqBO) {
        //1 参数校验
        this.validateAuditOrder(auditOrderReqBO);
        //2 组装数据
        SscAuditOrderDo sscAuditOrderDo = JSONObject.parseObject(JSONObject.toJSONString(auditOrderReqBO), SscAuditOrderDo.class);
        //3 保存数据
        this.iSscAuditOrderModel.createAuditOrder(sscAuditOrderDo);
        SscCreateAuditOrderRspBO rspBO = SscRu.success(SscCreateAuditOrderRspBO.class);
        rspBO.setAuditOrderId(sscAuditOrderDo.getAuditOrderId());
        return rspBO;
    }

    private void validateAuditOrder(SscCreateAuditOrderReqBO auditOrderReqBO) {
        if (ObjectUtil.isEmpty(auditOrderReqBO)) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(auditOrderReqBO.getOrderId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[审批单id]不能为空");
        }
        if (ObjectUtil.isEmpty(auditOrderReqBO.getUocApprovalObj())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象不能为空");
        }
        auditOrderReqBO.getUocApprovalObj().forEach(
                (sscUocApprovalObjBo) -> {
                    if (ObjectUtil.isEmpty(sscUocApprovalObjBo.getObjBusiType())) {
                        throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[审批对象业务类型]不能为空");
                    }
                    if (ObjectUtil.isEmpty(sscUocApprovalObjBo.getObjType())) {
                        throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[审批对象类型]不能为空");
                    }
                    if (ObjectUtil.isEmpty(sscUocApprovalObjBo.getObjId())) {
                        throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[对象id]不能为空");
                    }
                }
        );

    }
}
