package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscAccessory;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeChangeInfoReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeChangeInfoRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;

/**
 * @Description: SscAddSchemeChangeInfoServiceImpl
 * @Author: the_xhl
 * @Date: 2023-03-16
 */
@HTServiceImpl
public class SscAddSchemeChangeInfoServiceImpl implements SscAddSchemeChangeInfoService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscAddSchemeChangeInfoRspBO addSchemeChangeInfo(SscAddSchemeChangeInfoReqBO sscAddSchemeChangeInfoReqBO) {
        check(sscAddSchemeChangeInfoReqBO);
        SscAddSchemeChangeInfoRspBO rspBO = SscRu.success(SscAddSchemeChangeInfoRspBO.class);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        SscSchemeChangeBO sscSchemeChangeBO = new SscSchemeChangeBO();
        sscSchemeChangeBO.setSchemeId(sscAddSchemeChangeInfoReqBO.getSchemeId());
        sscSchemeChangeBO.setOperType(sscAddSchemeChangeInfoReqBO.getOperType());
        sscSchemeChangeBO.setNewSchemeStatus(sscAddSchemeChangeInfoReqBO.getChangeStatus());
        sscSchemeChangeBO.setReason(sscAddSchemeChangeInfoReqBO.getReason());
        sscSchemeDo.setCreateUsername(sscAddSchemeChangeInfoReqBO.getUsername());
        sscSchemeDo.setCreateLoginId(sscAddSchemeChangeInfoReqBO.getUserId());
        sscSchemeDo.setCreateName(sscAddSchemeChangeInfoReqBO.getName());
        sscSchemeChangeBO.setSscAccessory(SscRu.jsl(sscAddSchemeChangeInfoReqBO.getSscAccessoryBO(), SscAccessory.class));
        sscSchemeDo.setSchemeId(sscAddSchemeChangeInfoReqBO.getSchemeId());
        sscSchemeDo.setSscSchemeChange(Collections.singletonList(sscSchemeChangeBO));
        iSscSchemeModel.addSchemeChangeInfo(sscSchemeDo);
        return rspBO;
    }

    private void check(SscAddSchemeChangeInfoReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空");
        }
        if (ObjectUtil.isNull(reqBO.getUserId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[userId]不能为空");
        }
        if (StrUtil.isEmpty(reqBO.getName())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空");
        }
        if (StrUtil.isEmpty(reqBO.getOperType())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[operType]不能为空");
        }
        if (StrUtil.isEmpty(reqBO.getChangeStatus())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[changeStatus]不能为空");
        }
        if (StrUtil.isEmpty(reqBO.getUsername())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[username]不能为空");
        }
    }
}
