package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeMat;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: dmc
 * @Date: 2022/11/11 11:24
 * @Description: SscAddSchemeMatBatchServiceImpl
 */
@HTServiceImpl
public class SscAddSchemeMatBatchServiceImpl implements SscAddSchemeMatBatchService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscAddSchemeMatBatchRspBO addSchemeMatBatch(SscAddSchemeMatBatchReqBO sscAddSchemeMatBatchReqBO) {
        SscAddSchemeMatBatchRspBO rspBO = SscRu.success(SscAddSchemeMatBatchRspBO.class);
        //1 参数校验
        validataParam(sscAddSchemeMatBatchReqBO);
        //2 封装入参
        SscSchemeDo sscSchemeDo = SscRu.js(sscAddSchemeMatBatchReqBO, SscSchemeDo.class);
        List<SscSchemeMat> SscSchemeMats = SscRu.jsl(sscAddSchemeMatBatchReqBO.getSscSchemeMat(), SscSchemeMat.class);
        sscSchemeDo.setSscSchemeMat(SscSchemeMats);

        //3 调用
        this.iSscSchemeModel.addSchemeMatBatch(sscSchemeDo);

        // 新增扩展字段信息
        this.addExtInfo(sscAddSchemeMatBatchReqBO, sscSchemeDo);
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO sscAddSchemeMatBatchReqBO
     */
    private void validataParam(SscAddSchemeMatBatchReqBO reqBO) {
        if (reqBO == null){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[sscAddSchemeMatBatchReqBO不能为空");
        }
//        if(ObjectUtil.isEmpty(reqBO.getName())){
//            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[name]不能为空");
//        }
//        if(ObjectUtil.isEmpty(reqBO.getSchemeId())){
//            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[schemeId]不能为空");
//        }
//        if(ObjectUtil.isEmpty(reqBO.getUserId())){
//            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[userId]不能为空");
//        }
//        if(ObjectUtil.isEmpty(reqBO.getUsername())){
//            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[username]不能为空");
//        }
//        if(ObjectUtil.isEmpty(reqBO.getOrgId())){
//            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[orgId]不能为空");
//        }
//        if(ObjectUtil.isEmpty(reqBO.getOrgName())){
//            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[orgName]不能为空");
//        }
        if(ObjectUtil.isEmpty(reqBO.getEnableDraft())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[enableDraft]不能为空");
        }
        if(!CollectionUtils.isEmpty(reqBO.getSscSchemeMat())){
//            for (int i = 0; i < reqBO.getSscSchemeMat().size(); i++) {
//                List<SscSchemeMatBO> sscSchemeMat = reqBO.getSscSchemeMat();
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getPackId())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[packId]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getPackName())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[packName]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getPlanId())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[planId]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getPlanCode())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[planCode]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getPlanName())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[planName]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getPlanMatDetailId())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[planMatDetailId]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getMatCodeId())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[matCodeId]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getMatCode())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[matCode]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getMatName())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[matName]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getMatSpec())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[matSpec]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getMatModel())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[matModel]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getPurchaseNum())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[purchaseNum]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getMeasureUnitName())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[measureUnitName]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getExpectPrice())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[expectPrice]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getExpectMoney())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[expectMoney]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getRemark())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[remark]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getDeliveryDate())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[deliveryDate]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getLocation())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[location]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getProvince())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[province]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getCity())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[city]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getCounty())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[county]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getPlace())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[place]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getTaxRate())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[taxRate]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getReqUnitId())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[reqUnitId]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getReqUnitCode())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[reqUnitCode]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getReqUnitName())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[reqUnitName]不能为空");
//                }
//                if(ObjectUtil.isEmpty(sscSchemeMat.get(i).getSchemeMatId())){
//                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat["+i+"]->[schemeMatId]不能为空");
//                }
//            }

        }else{
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象sscSchemeMat不能为空");
        }
    }

    private void addExtInfo(SscAddSchemeMatBatchReqBO reqBO, SscSchemeDo sscSchemeDo) {
        List<SscSchemeMat> sscSchemeMat = sscSchemeDo.getSscSchemeMat();
        Boolean enableDraft = reqBO.getEnableDraft();
        SscCommonDo sscCommonDo = new SscCommonDo();
        List<SscExtObjInfo> matObjInfoList = sscSchemeMat
                .stream()
                .filter(e -> CollectionUtil.isNotEmpty(e.getExtFields()))
                .map(e -> {
                    SscExtObjInfo objInfo = new SscExtObjInfo();
                    objInfo.setOrderId(e.getSchemeId());
                    objInfo.setObjId(e.getSchemeMatId());
                    objInfo.setObjType(enableDraft ? SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT_DRAFT : SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_MAT_EXT);
                    objInfo.setExtInfo(SscRu.jsl(e.getExtFields(), SscExtInfo.class));
                    return objInfo;
                }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(matObjInfoList)) {
            sscCommonDo.setExtObjInfos(matObjInfoList);
            iSscCommonModel.addExtInfo(sscCommonDo);
        }
    }
}
