package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.SscCopySchemeToDraftReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscCopySchemeToDraftRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Author: dmc
 * @Date: 2022/11/15 15:30
 * @Description: 方案主表到草稿复制服务实现
 */
@HTServiceImpl
public class SscCopySchemeToDraftServiceImpl implements SscCopySchemeToDraftService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscCopySchemeToDraftRspBO copySchemeToDraft(SscCopySchemeToDraftReqBO reqBO) {
        //1 必填校验
        this.validationParam(reqBO);

        SscCopySchemeToDraftRspBO rspBO = SscRu.success(SscCopySchemeToDraftRspBO.class);

        //2 入参转换
        SscSchemeDo sscSchemeDo = SscRu.js(reqBO, SscSchemeDo.class);

        //3 调用方案主表到草稿复制方法
        this.iSscSchemeModel.copySchemeToDraft(sscSchemeDo);

        return rspBO;
    }

    /**
     * 必填校验
     * @param reqBO reqBO
     */
    private void validationParam(SscCopySchemeToDraftReqBO reqBO) {
        if(null == reqBO){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR,"入参对象为空");
        }
        if(ObjectUtil.isEmpty(reqBO.getSchemeId())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR,"入参对象[schemeId 方案id]为空");
        }
        if(ObjectUtil.isEmpty(reqBO.getToken())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR,"入参对象[token 令牌]为空");
        }
        if(ObjectUtil.isEmpty(reqBO.getEnableDraft())){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR,"入参对象[enableDraft 是否草稿]为空");
        }
    }
}
